/*
CryptoJS v3.1.2
code.google.com/p/crypto-js
(c) 2009-2013 by Jeff Mott. All rights reserved.
code.google.com/p/crypto-js/wiki/License
*/
/**

 * Output Feedback block mode.

 */

CryptoJS.mode.OFB = (function () {

    var OFB = CryptoJS.lib.BlockCipherMode.extend();



    var Encryptor = OFB.Encryptor = OFB.extend({

        processBlock: function (words, offset) {

            // Shortcuts

            var cipher = this._cipher

            var blockSize = cipher.blockSize;

            var iv = this._iv;

            var keystream = this._keystream;



            // Generate keystream

            if (iv) {

                keystream = this._keystream = iv.slice(0);



                // Remove IV for subsequent blocks

                this._iv = undefined;

            }

            cipher.encryptBlock(keystream, 0);



            // Encrypt

            for (var i = 0; i < blockSize; i++) {

                words[offset + i] ^= keystream[i];

            }

        }

    });



    OFB.Decryptor = Encryptor;



    return OFB;

}());

