
/*********************************************************************
 **
 **   public/js/appx-client-startup.js - Client entry point code
 **
 **   This module is the main entry point into the client.  It also
 **   has some initial startup helper code.
 **
 *********************************************************************/

// what_str =  "@(#)Appx $Header: /src/cvs/appxHtml5/public/js/appx-client-startup.js,v 1.29 2015/06/26 15:48:57 pete Exp $";

    var appxLoginFormHost = $('meta[name=appx-login-host]').attr("content");
    var appxLoginFormPort = $('meta[name=appx-login-port]').attr("content");
    var appxLoginFormUser = $('meta[name=appx-login-user]').attr("content");
    var appxLoginFormPswd = $('meta[name=appx-login-pswd]').attr("content");
    var appxLoginFormRows = $('meta[name=appx-login-rows]').attr("content");
    var appxLoginFormCols = $('meta[name=appx-login-cols]').attr("content");

    var appxLoginFormHostHide = ($('meta[name=appx-login-host]').attr("hide") == "true");
    var appxLoginFormPortHide = ($('meta[name=appx-login-port]').attr("hide") == "true");
    var appxLoginFormUserHide = ($('meta[name=appx-login-user]').attr("hide") == "true");
    var appxLoginFormPswdHide = ($('meta[name=appx-login-pswd]').attr("hide") == "true");
    var appxLoginFormRowsHide = ($('meta[name=appx-login-rows]').attr("hide") == "true");
    var appxLoginFormColsHide = ($('meta[name=appx-login-cols]').attr("hide") == "true");

    var appxConnectorHost = $('meta[name=appx-proxy-host]').attr("content");
    var appxConnectorPort = $('meta[name=appx-proxy-port]').attr("content");
    var appxConnectorPath = $('meta[name=appx-proxy-path]').attr("content");

    var appxClientRoot = $('meta[name=appx-client-root]').attr("content");

    var appxUseSoftkeys      = $('meta[name=appx-use-softkeys]'  ).attr("content") == "true";
    var appxLoginAutoConnect = $('meta[name=appx-auto-connect]'  ).attr("content") == "true";
    var appxLocalRequired    = $('meta[name=appx-local-required]').attr("content");
    var appxStaticTools      = $('meta[name=appx-static-tools]'  ).attr("content");
    var appxNoReconPopup     = $('meta[name=appx-no-recon-popup]').attr("content");
    var appxFillWindow       = $('meta[name=appx-fill-window]'   ).attr("content");
    var appxCloseOnExit      = $('meta[name=appx-close-on-exit]' ).attr("content");

    var appxNewSession = false;

    var appxEncryption = $('meta[name=appx-encryption]').attr("content");

    if (appxLoginFormUser.length > 0)
        $("#appx_username").val(appxLoginFormUser);

    if (appxLoginFormPswd.length > 0)
        $("#appx_password").val(appxLoginFormPswd);

    if (appxLoginFormHost.length > 0)
        $("#appx_server").val(appxLoginFormHost);

    if (appxLoginFormPort.length > 0)
        $("#appx_port").val(appxLoginFormPort);

    if (appxLoginFormRows.length > 0)
        $("#appx_rows").val(appxLoginFormRows);

    if (appxLoginFormCols.length > 0)
        $("#appx_cols").val(appxLoginFormCols);

    var focusElem = null;

    if (appxLoginFormColsHide)
        $("#appxLoginFormCols").attr("style", "display: none;");
    else
        focusElem = $("#appx_cols");

    if (appxLoginFormRowsHide)
        $("#appxLoginFormRows").attr("style", "display: none;");
    else
        focusElem = $("#appx_rows");

    if (appxLoginFormPortHide)
        $("#appxLoginFormPort").attr("style", "display: none;");
    else
        focusElem = $("#appx_port");

    if (appxLoginFormHostHide)
        $("#appxLoginFormHost").attr("style", "display: none;");
    else
        focusElem = $("#appx_host");

    if (appxLoginFormPswdHide)
        $("#appxLoginFormPswd").attr("style", "display: none;");
    else
        focusElem = $("#appx_password");

    if (appxLoginFormUserHide)
        $("#appxLoginFormUser").attr("style", "display: none;");
    else
        focusElem = $("#appx_username");

    if (focusElem)
        focusElem.attr("autofocus", "true");

    var appxZoom = 1.0;

    function adjustZoom(scale) {
        var newCss = {
            "zoom": scale,
            "-moz-transform": "scale(" + scale + ")",
            "-moz-transform-origin": "left top"
        };
        //$("#appx_main_container").css(newCss);
        //$("#screenBuf").css(newCss);
	$("#appx_main_container_wrapper").css(newCss);
	//$("#appx_main_container").css(newCss);
    }

    $("#appx_zoom_in").click(function () {
        appxZoomAuto = false;
        $("#appx_zoom_auto").css({
            "color": "initial"
        });
        appxZoom += .1;
        adjustZoom(appxZoom);
    });

    $("#appx_zoom_out").click(function () {
        appxZoomAuto = false;
        $("#appx_zoom_auto").css({
            "color": "initial"
        });
        appxZoom -= .1;
        adjustZoom(appxZoom);
    });

    $("#appx_zoom_dflt").click(function () {
        appxZoomAuto = false;
        $("#appx_zoom_auto").css({
            "color": "initial"
        });
        appxZoom = 1.0;
        adjustZoom(appxZoom);
    });

    $("#appx_zoom_max").click(function () {
        appxZoomAuto = false;
        $("#appx_zoom_auto").css({
            "color": "initial"
        });
        zoomMax();
    });

    $("#appx_zoom_full").click(function () {
	    if (appxFullscreen) {
		appxFullscreen = false;
		exitFullscreen();
	    }
	    else {
		appxFullscreen = true;
		launchIntoFullscreen(document.documentElement);
	    }
    });

    $("#appx_zoom_auto").click(function () {
        if (appxZoomAuto) {
            appxZoomAuto = false;
            appxZoom = appxZoomSave;
            $("#appx_zoom_auto").css({
                "color": "initial"
            });
        }
        else {
            appxZoomAuto = true;
            appxZoomSave = appxZoom;
            $("#appx_zoom_auto").css({
                "color": "red"
            });
        }
        zoomAuto();
        adjustZoom(appxZoom);
    });

    function zoomMax() {
        if (!appx_session)
            return;
        var appxZoomW = $("#appx_main_container_wrapper").width() / (appx_session.colwidthpx * appx_session.screencols + 18);
        var appxZoomH = getVisible("appx_main_container_wrapper") / (appx_session.rowheightpx * appx_session.screenrows);
        appxZoom = Math.min(appxZoomW, appxZoomH);
        adjustZoom(appxZoom);
    }

    function zoomAuto() {
        if (!appxZoomAuto)
            return;
        if (!appx_session)
            return;
        var appxZoomW = $("#appx_main_container_wrapper").width() / (appx_session.colwidthpx * appx_session.screencols + 18);
        var appxZoomH = getVisible("appx_main_container_wrapper") / (appx_session.rowheightpx * appx_session.screenrows);
        appxZoom = Math.min(appxZoomW, appxZoomH);
        adjustZoom(appxZoom);
    }

    var appxFullscreen = false;
    var appxZoomAuto = false;
    var appxZoomSave = 1.0;

    $(window).on('scroll resize', zoomAuto);

    function getVisibleOld(id) {
        var $el = $('#' + id),
            scrollTop = $(this).scrollTop(),
            scrollBot = scrollTop + $(this).height(),
            elTop = $el.offset().top,
            elBottom = elTop + $el.outerHeight(),
            visibleTop = elTop < scrollTop ? scrollTop : elTop,
            visibleBottom = elBottom > scrollBot ? scrollBot : elBottom;
        return visibleBottom - visibleTop;
    }

    function getVisible(id) {
        var $el = $('#' + id),
            elTop = $el.offset().top,
            elBottom = elTop + $("#status_bar").height(),
	    winHeight = $(window).height();
        return winHeight - elBottom - elTop;
    }

    //Global setup variables
    var debug = false;
    var loggedin = false;
    var appxclientversion = [03, 04];
    var appxserverversion = null;
    var client_init_sent = false;
    var appx_session;
    var localos_session;
    var localos_access = false;
    var appx_access = false;

    // for handling Function keys and Option Codes
    var xTriggered = 0;
    var optionTriggered = 0;
    var digits = [];
    var basefontsize = 14.0;

    // Allow page to load before calling any functions that depend on the DOM
    $(document).ready(function () {

        // show/hide logging
        if (debug) {
            $("#log").show();
        }
        else {
            $("#log").hide();
        }

        $(document.body).append(
            $('<span>').attr("id", "fontcheck")
            .css({
                "display": "none",
                "font-family": "courier",
                "font-size": "14px",
                "padding": "0px",
                "margin": "0px",
                "box-sizing": "border-box"
            })
            .text("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
        );

        if ($("#fontcheck").width() > 800) {
            basefontsize = (1.0 - (($("#fontcheck").width() - 800) / $("#fontcheck").width())) * 14.0;
        }

        $("#fontcheck").remove();
	/*
	$("#appx_main_container").height( ($("#appx_rows").val() * 21) + 42 );
	*/
        // check websocket support
        var support = "MozWebSocket" in window ? 'MozWebSocket' : ("WebSocket" in window ? 'WebSocket' : null);

        // start session if websockets are supported, log support
        if (support != null) {
            appendMessage("WebSockets --  are fully supported in this browser.");

            // creates a global APPX Session object
            // NOTE: this object is destroyed on refresh, may need a work-around to prevent user to accidentally restarting a session
            if (localStorage["newsession"]) {
		appxNewSession = true;
                var si = JSON.parse(localStorage["newsession"]);
                delete(localStorage["newsession"]);

                appx_session = new APPX(appxConnectorHost, appxConnectorPort, appxConnectorPath, appxEncryption, basefontsize);
                appx_session.startupinfo = si;
                setTimeout(function () {
                    sendappxnewsessionlogin(si.remoteHost, si.remotePort, si.remoteUser, si.remotePassword, si);
                }, 1500);
            }
            else {
                appx_session = new APPX(appxConnectorHost, appxConnectorPort, appxConnectorPath, appxEncryption, basefontsize);
            }
        }
        else {
            appendMessage("ALERT! WebSockets -- are NOT fully supported in this browser.");
        }
    });

    $(function () {

        window.onbeforeunload = function () {
            if (appx_session.connected)
                return 'This will end your Appx session!';
        }
    });

function launchIntoFullscreen(element) {
    if(element.requestFullscreen) {
	element.requestFullscreen();
    } else if(element.mozRequestFullscreen) {
	element.mozRequestFullscreen();
    } else if(element.webkitRequestFullscreen) {
	element.webkitRequestFullscreen();
    } else if(element.msRequestFullscreen) {
	element.msRequestFullscreen();
    }
}

function exitFullscreen() {
    if(document.exitFullscreen) {
	document.exitFullscreen();
    } else if(document.mozCancelFullscreen) {
	document.mozCancelFullscreen();
    } else if(document.webkitExitFullscreen) {
	document.webkitExitFullscreen();
    }
}
