﻿
/*********************************************************************
 **
 **   public/js/appx-client-local.js - Client Local connection code
 **
 **   This module handles the connection and data traffic between the
 **   Appx Client running in the browser and the appx connector code
 **   running on the desktop.  The local connector is our proxy into
 **   the desktop OS.
 **
 *********************************************************************/

// what_str =  "@(#)Appx $Header: /src/cvs/appxHtml5/public/js/appx-client-local.js,v 1.21 2015/05/27 18:14:43 pete Exp $";

/*********************************************************************
 ** showLocalMissing() displays a popup to install the local connector
 *********************************************************************/

function showLocalMissing() {
    var localInstaller = "";

    switch (appx_session.globals.os) {
        case "Win32":
            localInstaller = "localConnector_win.exe";
            break;
        case "MacIntel":
            localInstaller = "localConnector_osx.dmg";
            break;
        case "Linux x86_64":
            localInstaller = "localConnector_linux64.sh";
            break;
        case "Linux i686":
            localInstaller = "localConnector_linux32.sh";
            break;
        default:
            return;
    }

    var prefs =
        "<h1>Local Desktop Access</h1>" +
        "<p>This application requires local access to your desktop to perform certain functions.  This is a one time activity that does not require any Administrator privileges.</p>" +
        "<p>To allow this access please perform the following steps:" +
        "<ol>" +
        "<li>Click this link to download the local connector. (<a href='" + appxClientRoot + "/" + localInstaller + "'>Download Local Connector</a>)</li>" +
        "<li>Run the downloaded file and follow the prompts.</li>" +
        "<li>Close this popup window to retry local desktop access.</li>" +
        "</p>";

    var d = $("<div id='appx_prefs'>")
        .css({
            "background": "rgba(50, 50, 50, 0.7)",
            "width": "100%",
            "height": "100%",
            "min-height": "220px",
            "z-index": "10000000",
            "display": "none",
            "position": "absolute",
            "top": "0px",
            "left": "0px",
            "font-family": "verdana",
            "font-size": "11px"
        })
        .appendTo("body");

    var prefwrap = $("<div style='border: 10px solid #333;'>")
        .css({
            "width": "550px",
            "height": "220px",
            "background": "#fff"
        })
        .appendTo("#appx_prefs")
        .position({
            "my": "center",
            "at": "center",
            "of": window
        })
        .draggable();

    var prefsdiv = $("<div>")
        .css({
            "margin": "0px 10px",
            "width": "550px",
            "height": "220px"
        });

    var closer = $("<div>")
        .css({
            "background": "#333",
            "text-align": "right",
            "padding": "5px",
            "color": "#F5F539",
            "font-weight": "bold",
            "padding-bottom": "10px"
        })
        .append($("<span>close(X)</span>")
            .click(function () {
                $("#appx_prefs").hide();
                $("#appx_prefs").remove();
                localos_session = new LOCALOS();
            }));

    $(prefwrap).prepend($("<div>").append(closer));

    $(prefsdiv).append($("<div>").append(prefs));

    $(prefsdiv).appendTo(prefwrap);

    $("#appx_prefs").show();

    $(prefs).find("input").change(function () {
        appx_session.setProp($(this).attr("id"), $(this).val());
        if (appx_session.getRawProp($(this).attr("id")) != null)
            $(this).css({
                "background": "#ff0"
            });
        else
            $(this).css({
                "background": "#fff"
            });
    });
}

/*********************************************************************
 ** LOCALOS() function to interact with local connector
 *********************************************************************/

// Local OS session object
// Contain websocket setup fuctions, and handler mapping
function LOCALOS() {
    this.message = new message();
    this.ws = connectToServer(this.message);
    this.current_msg = {
        "header": []
    };

    function connectToServer(ms) {
        // create a new websocket and connect
        // run this client against appx-connector-server-3015-4.js
        try {
            var ws = new WebSocket('ws://127.0.0.1:3013/');

            // when data is comming from the server, this metod is called
            ws.onmessage = function (evt) {

                if (debug) {
                    logactivity("svr message:  ");
                    logactivity(evt.data);
                    appendMessage(evt.data + "\n\n");
                }
                ms.handler(evt);
                //this.message.handler = new message.handler(evt);

            };

            // when the connection is established, this method is called
            ws.onopen = function (evt) {
                localos_access = true;

		$("#localos_access").html("Local+").css({
			"color": "lime",
			"font-weight": "bold"
	        });
		
                appendMessage('* Connection to local server(localhost:3012)  open<br/>');
                $("#functions").toggleClass("functions_on");

                initialize_localos_session();
            };

            // when the connection is closed, this method is called
            ws.onclose = function (evt) {
                localos_access = false;

                $("#localos_access").html("Local").css({
                    "color": "#F77",
                    "font-weight": "bold"
                });

                if (appxLocalRequired == "true" && (!localos_access) && (!localos_session.isUpdating)) {
                    showLocalMissing(true);
                    appxLocalRequired = false;
                }

                appendMessage('* Connection to local server(localhost:3015) closed<br/>');
                $("#functions").toggleClass("functions_on");
            };

            // when the connection is closed, this method is called
            ws.onerror = function (evt) {
                appendMessage('* Local server(localhost:3015) Error<br/>');
            };

        }
        catch (ex) {
            alert(ex);
        }

        return ws;
    }

    function message() {
        this.handler = handler;

        function handler(msg) {
            if (debug) logactivity("main handler: " + msg);
            try {
                var rtnobj = JSON.parse(msg.data);
                logactivity("data:  " + rtnobj.data);
                switch (rtnobj.type) {
                    case "LOCALOS-RELOAD":
			setTimeout(function() {
				localos_session = new LOCALOS();
				localos_session.isUpdating = false;
			    }, 500);
                        break;
                    case "LOCALOS-DND":
                        appx_session.dndData = rtnobj.data;
                        appxwidgetcallback(OPT_DROP);
                        break;
                    case "LOCALOS-HTML":
                        $("#appx-frame").append(rtnobj.data);
                        break;
                    case "LOCALOS-STYLE":
                        localos_style_handler(rtnobj.data);
                        break;
                    case "LOCALOS-SCRIPT":
                        inject_script(rtnobj.data);
                        break;
                    case "LOCALOS-OPENFILE":
                        localos_file_handler(rtnobj.data);
                        break;
                    case "LOCALOS-OPENIMAGE":
                        localos_image_handler(rtnobj.data);
                        break;
                    case "LOCALOS-RUNCOMMAND":
                        localos_cmd_handler(rtnobj.data);
                        break;
                    case "LOCALOS-EXECOMMAND":
                        localos_exec_handler(rtnobj.data);
                        break;
                    case "LOCALOS-ENVIRONMENT":
                        localos_enviro_handler(rtnobj.data);
                        break;
                    case "LOCALOS-SETCLIPBOARD":
                        localos_setclipboard_handler(rtnobj.data);
                        break;
                    case "LOCALOS-GETCLIPBOARD":
                        localos_getclipboard_handler(rtnobj.data);
                        break;
                    case "LOCALOS-FILE-DIALOG":
                        localos_file_dialog_handler(rtnobj.data);
                        break;
                    case "LOCALOS-ERROR":
                        localos_error_handler(rtnobj.data);
                        break;
                    case "LOCALOS-CREATEFILE":
                        localos_create_file_handler(rtnobj.data);
                        break;
                    case "LOCALOS-APPENDFILE":
                        localos_append_file_handler(rtnobj.data);
                        break;
                    default:
                        logactivity("No handler for LOCAL OS Data Message:  " + msg.data);
                }
            }
            catch (e) {
                logactivity(e);
            }
        }
    }
};

/*********************************************************************
 ** function handlers
 *********************************************************************/

function localos_file_dialog_handler(data) {
    var el = $(".awaiting_filepath");
    $(el).val(data);
    $(el).removeClass("awaiting_filepath");
    $(el).addClass("dirty");
}

function localos_setclipboard_handler(data) {
    // FIXME: WHERE: public/js/appx-client-local.js localos_setclipboard_handler()
    // FIXME: ISSUE: function is not implemented.  It only logs that it happened.
    logactivity("localos_setclipboard_handler() called...");
    console.log("clipboard data set in localos:  " + data);
}

function localos_getclipboard_handler(data) {
    logactivity("localos_setclipboard_handler() called...");
    console.log("clipboard data got in localos:  " + data);
    var clip = data;
    var ms = {
        cmd: 'appxclipboard',
        args: [clip],
        handler: 'appxsendfilehandler',
        data: null
    };
    appx_session.ws.send(JSON.stringify(ms));
}

function localos_error_handler(data) {
    logactivity("localos_error_handler() called...");
    console.log("an error occurred on localos connector:  " + data);
}

function localos_file_handler(data) {
    var file = {};
    file.name = appx_session.currrecfile.filename;

    logactivity("localos_file_handler() called...");

    try {
        //send status
        appxClearStatusMsgText();
        appxSetStatusText("Uploading File...");
        var ms = {
            cmd: 'appxmessage',
            args: [3, 1],
            handler: 'appxreceivefilehandler',
            data: null
        };
        appx_session.ws.send(JSON.stringify(ms));

        var argarry = [];
        // fixme: WHERE: public/js/appx-client-local.js localos_file_handler()
        // fixme: ISSUE: Hack to convert int32 to int8 array needs to be replaced by a cleaner function call.
        //send length of file Uint32
        filelength = new Uint32Array(1);
        filelength[0] = parseInt(data.length);

        var bitarry = new Uint8Array(filelength.buffer);
        var ai = bitarry.length - 1;
        for (var i = 0; i < bitarry.length; i++) {
            argarry[ai] = bitarry[i];
            ai--;
        }

        var ms = {
            cmd: 'appxmessage',
            args: argarry,
            handler: 'appxreceivefilehandler',
            data: null
        };
        appx_session.ws.send(JSON.stringify(ms));

        var filebytearray = new Uint8Array(data instanceof Array ? data : data.data);

        argarry = [];
        bitarry = new Uint8Array(filebytearray.buffer);

        for (var i = 0; i < bitarry.length; i++) {
            argarry[i] = bitarry[i];
        }

        //send bytes 2048 at a time
        for (var i = 0; i * 2048 < argarry.length; i++) {
            var chunk = argarry.slice(i * 2048, i * 2048 + 2048);
            //send chunk length

            //send length of file Uint32
            chunklength = new Uint32Array(1);
            chunklength[0] = chunk.length;

            var chunklenarry = [];
            bitarry = new Uint8Array(chunklength.buffer);
            ai = bitarry.length - 1;
            for (var c = 0; c < bitarry.length; c++) {
                chunklenarry[ai] = bitarry[c];
                ai--;
            }

            var ms = {
                cmd: 'appxmessage',
                args: chunklenarry,
                handler: 'appxreceivefilehandler',
                data: null
            };
            appx_session.ws.send(JSON.stringify(ms));

            //send chunk
            var ms = {
                cmd: 'appxfileuploadmessage',
                args: chunk,
                handler: 'appxreceivefilehandler',
                data: {
                    "i": i * 2048,
                    "length": argarry.length
                }
            };
            appx_session.ws.send(JSON.stringify(ms));

            appxClearStatusMsgText();
            appxSetStatusText("Uploading File...  Bytes Sent:  " + (i * 2048).toString());
        }

        //send null for EOF
        var ms = {
            cmd: 'appxmessage',
            args: [0, 0, 0, 0],
            handler: 'appxreceivefilehandler',
            data: null
        };
        appx_session.ws.send(JSON.stringify(ms));

        //send Filename Length
        // FIXME: WHERE: public/js/appx-client-local.js localos_file_handler()
        // FIXME: ISSUE: Hack to convert int32 to int8 array needs to be replaced by a cleaner function call.
        var ms = {
            cmd: 'appxmessage',
            args: [0, 0, 0, file.name.length],
            handler: 'appxreceivefilehandler',
            data: null
        };
        appx_session.ws.send(JSON.stringify(ms));

        //send File Name
        var lfn = [];
        for (var fna = 0; fna < file.name.length; fna++) {
            lfn.push(file.name.charCodeAt(fna));
        }
        var ms = {
            cmd: 'appxmessage',
            args: lfn,
            handler: 'appxreceivefilehandler',
            data: null
        };
        appx_session.ws.send(JSON.stringify(ms));

        //send client status
        var ms = {
            cmd: 'appxmessage',
            args: [3, 1],
            handler: 'appxreceivefilehandler',
            data: null
        };
        appx_session.ws.send(JSON.stringify(ms));
    }
    catch (e) {
        console.log(e);
    }
}