/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    int jniRef;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int HOT = 32;
    static final int MOVED = 64;
    static final int RESIZED = 128;
    static final int EXPANDING = 256;
    static final int IGNORE_WHEEL = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int THEME_BACKGROUND = 2048;
    static final int LAYOUT_NEEDED = 4096;
    static final int LAYOUT_CHANGED = 8192;
    static final int LAYOUT_CHILD = 16384;
    static final int RELEASED = 32768;
    static final int DISPOSE_SENT = 65536;
    static final int FOREIGN_HANDLE = 131072;
    static final int DRAG_DETECT = 262144;
    static final int WEBKIT_EVENTS_FIX = 524288;
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";
    static final int SKIN_NEEDED = 0x100000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
        this.reskinWidget();
    }

    int accessibleHandle() {
        return 0;
    }

    int accessibilityActionDescription(int n, int n2, int n3) {
        return this.callSuperObject(n, n2, n3);
    }

    int accessibilityActionNames(int n, int n2) {
        return this.callSuperObject(n, n2);
    }

    int accessibilityAttributeNames(int n, int n2) {
        return this.callSuperObject(n, n2);
    }

    int accessibilityAttributeValue(int n, int n2, int n3) {
        return this.callSuperObject(n, n2, n3);
    }

    int accessibilityAttributeValue_forParameter(int n, int n2, int n3, int n4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3, n4);
    }

    int accessibilityFocusedUIElement(int n, int n2) {
        return this.callSuperObject(n, n2);
    }

    int accessibilityHitTest(int n, int n2, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, nSPoint);
    }

    boolean accessibilityIsAttributeSettable(int n, int n2, int n3) {
        return this.callSuperBoolean(n, n2, n3);
    }

    boolean accessibilityIsIgnored(int n, int n2) {
        return this.callSuperBoolean(n, n2);
    }

    int accessibilityParameterizedAttributeNames(int n, int n2) {
        return this.callSuperObject(n, n2);
    }

    void accessibilityPerformAction(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void accessibilitySetValue_forAttribute(int n, int n2, int n3, int n4) {
        this.callSuper(n, n2, n3, n4);
    }

    String getClipboardText() {
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return "";
        }
        NSString nSString = nSPasteboard.stringForType(OS.NSStringPboardType);
        return nSString != null ? nSString.getString() : null;
    }

    void setClipRegion(NSView nSView) {
    }

    int attributedSubstringFromRange(int n, int n2, int n3) {
        return 0;
    }

    void callSuper(int n, int n2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2);
    }

    void callSuper(int n, int n2, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3);
    }

    void callSuper(int n, int n2, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, nSRect);
    }

    void callSuper(int n, int n2, int n3, int n4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3, n4);
    }

    void callSuper(int n, int n2, NSRect nSRect, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, nSRect, n3);
    }

    int callSuper(int n, int n2, int n3, NSRect nSRect, int n4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3, nSRect, n4);
    }

    boolean callSuperBoolean(int n, int n2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2) != 0;
    }

    boolean canBecomeKeyWindow(int n, int n2) {
        return this.callSuperBoolean(n, n2);
    }

    void cancelOperation(int n, int n2, int n3) {
    }

    NSSize cellSize(int n, int n2) {
        NSSize nSSize = new NSSize();
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, n2);
        return nSSize;
    }

    NSSize cellSizeForBounds(int n, int n2, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, n2, nSRect);
        return nSSize;
    }

    boolean callSuperBoolean(int n, int n2, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3) != 0;
    }

    boolean callSuperBoolean(int n, int n2, NSRange nSRange, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(objc_super2, n2, nSRange, n3);
    }

    int callSuperObject(int n, int n2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2);
    }

    int callSuperObject(int n, int n2, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3);
    }

    int callSuperObject(int n, int n2, int n3, int n4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3, n4);
    }

    NSRect callSuperRect(int n, int n2, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        NSRect nSRect = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect, objc_super2, n2, n3);
        return nSRect;
    }

    boolean canDragRowsWithIndexes_atPoint(int n, int n2, int n3, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(objc_super2, n2, n3, nSPoint);
    }

    int characterIndexForPoint(int n, int n2, int n3) {
        return Integer.MAX_VALUE;
    }

    int columnAtPoint(int n, int n2, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, nSPoint);
    }

    boolean acceptsFirstMouse(int n, int n2, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3) != 0;
    }

    boolean acceptsFirstResponder(int n, int n2) {
        return this.callSuperBoolean(n, n2);
    }

    boolean becomeFirstResponder(int n, int n2) {
        return this.callSuperBoolean(n, n2);
    }

    void becomeKeyWindow(int n, int n2) {
        this.callSuper(n, n2);
    }

    public void reskin(int n) {
        this.checkWidget();
        this.reskinWidget();
        if ((n & 1) != 0) {
            this.reskinChildren(n);
        }
    }

    void reskinChildren(int n) {
    }

    void reskinWidget() {
        if ((this.state & 0x100000) != 0x100000) {
            this.state |= 0x100000;
            this.display.addSkinnableWidget(this);
        }
    }

    boolean resignFirstResponder(int n, int n2) {
        return this.callSuperBoolean(n, n2);
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    boolean canBecomeKeyView(int n, int n2) {
        return true;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void clearDeferFlushing(int n, int n2) {
    }

    boolean textView_clickOnLink_atIndex(int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    void collapseItem_collapseChildren(int n, int n2, int n3, boolean bl) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3, bl);
    }

    void copyToClipboard(char[] cArray) {
        if (cArray.length == 0) {
            return;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return;
        }
        nSPasteboard.declareTypes(NSArray.arrayWithObject(OS.NSStringPboardType), null);
        nSPasteboard.setString(NSString.stringWithCharacters(cArray, cArray.length), OS.NSStringPboardType);
    }

    void createHandle() {
    }

    void createJNIRef() {
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            this.error(2);
        }
    }

    void createWidget() {
        this.createJNIRef();
        this.createHandle();
        this.setOrientation();
        this.register();
    }

    void comboBoxSelectionDidChange(int n, int n2, int n3) {
    }

    void comboBoxWillDismiss(int n, int n2, int n3) {
    }

    void comboBoxWillPopUp(int n, int n2, int n3) {
    }

    void deregister() {
    }

    void destroyJNIRef() {
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0;
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void deselectAll(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void deselectRow(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void doCommandBySelector(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    boolean dragSelectionWithEvent(int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    void drawBackground(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
    }

    void drawBackgroundInClipRect(int n, int n2, NSRect nSRect) {
        this.callSuper(n, n2, nSRect);
    }

    void drawImageWithFrameInView(int n, int n2, int n3, NSRect nSRect, int n4) {
        this.callSuper(n, n2, n3, nSRect, n4);
    }

    NSRect drawTitleWithFrameInView(int n, int n2, int n3, NSRect nSRect, int n4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, n2, n3, nSRect, n4);
        return nSRect2;
    }

    void drawInteriorWithFrame_inView(int n, int n2, NSRect nSRect, int n3) {
        this.callSuper(n, n2, nSRect, n3);
    }

    void drawLabelInRect(int n, int n2, boolean bl, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, bl, nSRect);
    }

    void drawViewBackgroundInRect(int n, int n2, NSRect nSRect) {
        this.callSuper(n, n2, nSRect);
    }

    void drawWithExpansionFrame_inView(int n, int n2, NSRect nSRect, int n3) {
        this.callSuper(n, n2, nSRect, n3);
    }

    void drawRect(int n, int n2, NSRect nSRect) {
        if (!this.isDrawing()) {
            return;
        }
        Display display = this.display;
        NSView nSView = new NSView(n);
        display.isPainting.addObject(nSView);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        nSGraphicsContext.saveGraphicsState();
        this.setClipRegion(nSView);
        this.drawBackground(n, nSGraphicsContext, nSRect);
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, nSRect);
        if (!this.isDisposed()) {
            this.drawWidget(n, nSGraphicsContext, nSRect);
        }
        nSGraphicsContext.restoreGraphicsState();
        display.isPainting.removeObjectIdenticalTo(nSView);
    }

    void _drawThemeProgressArea(int n, int n2, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3);
    }

    void drawWidget(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
    }

    int imageView() {
        return 0;
    }

    void redrawWidget(NSView nSView, boolean bl) {
        nSView.setNeedsDisplay(true);
    }

    void redrawWidget(NSView nSView, int n, int n2, int n3, int n4, boolean bl) {
        NSRect nSRect = new NSRect();
        nSRect.x = n;
        nSRect.y = n2;
        nSRect.width = n3;
        nSRect.height = n4;
        nSView.setNeedsDisplayInRect(nSRect);
    }

    void error(int n) {
        SWT.error(n);
    }

    void expandItem_expandChildren(int n, int n2, int n3, boolean bl) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3, bl);
    }

    NSRect expansionFrameWithFrame_inView(int n, int n2, NSRect nSRect, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, n2, nSRect, n3);
        return nSRect2;
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    NSRect firstRectForCharacterRange(int n, int n2, int n3) {
        return new NSRect();
    }

    int fixMnemonic(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            --n2;
        }
        return n2;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(IS_ACTIVE)) {
            return new Boolean(this.isActive());
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            int n = 1;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) {
                    return objectArray[n + 1];
                }
                n += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    boolean getDrawing() {
        return true;
    }

    public Listener[] getListeners(int n) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(n);
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hasMarkedText(int n, int n2) {
        return false;
    }

    NSRect headerRectOfColumn(int n, int n2, int n3) {
        return this.callSuperRect(n, n2, n3);
    }

    void helpRequested(int n, int n2, int n3) {
    }

    void highlightSelectionInClipRect(int n, int n2, int n3) {
    }

    int hitTest(int n, int n2, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, nSPoint);
    }

    int hitTestForEvent(int n, int n2, int n3, NSRect nSRect, int n4) {
        return 0;
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    int image(int n, int n2) {
        return 0;
    }

    NSRect imageRectForBounds(int n, int n2, NSRect nSRect) {
        return new NSRect();
    }

    boolean insertText(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
        return true;
    }

    boolean isActive() {
        return true;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isDrawing() {
        return true;
    }

    boolean isFlipped(int n, int n2) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2) != 0;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isOpaque(int n, int n2) {
        return false;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void flagsChanged(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void keyDown(int n, int n2, int n3) {
        this.superKeyDown(n, n2, n3);
    }

    void keyUp(int n, int n2, int n3) {
        this.superKeyUp(n, n2, n3);
    }

    void mouseDown(int n, int n2, int n3) {
        this.mouseDownSuper(n, n2, n3);
    }

    boolean mouseDownCanMoveWindow(int n, int n2) {
        return this.callSuperBoolean(n, n2);
    }

    void mouseDownSuper(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void mouseUp(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void mouseMoved(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void mouseDragged(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void mouseEntered(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void mouseExited(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void cursorUpdate(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void rightMouseDown(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void rightMouseUp(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void rightMouseDragged(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void otherMouseDown(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void otherMouseUp(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void otherMouseDragged(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    boolean shouldDelayWindowOrderingForEvent(int n, int n2, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3) != 0;
    }

    boolean menuHasKeyEquivalent_forEvent_target_action(int n, int n2, int n3, int n4, int n5, int n6) {
        return true;
    }

    int menuForEvent(int n, int n2, int n3) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3);
    }

    void menuNeedsUpdate(int n, int n2, int n3) {
    }

    boolean makeFirstResponder(int n, int n2, int n3) {
        return this.callSuperBoolean(n, n2, n3);
    }

    NSRange markedRange(int n, int n2) {
        return new NSRange();
    }

    void menu_willHighlightItem(int n, int n2, int n3, int n4) {
    }

    void menuDidClose(int n, int n2, int n3) {
    }

    void menuWillOpen(int n, int n2, int n3) {
    }

    void noResponderFor(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    int numberOfRowsInTableView(int n, int n2, int n3) {
        return 0;
    }

    int outlineView_child_ofItem(int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    void outlineView_didClickTableColumn(int n, int n2, int n3, int n4) {
    }

    int outlineView_objectValueForTableColumn_byItem(int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    boolean outlineView_isItemExpandable(int n, int n2, int n3, int n4) {
        return false;
    }

    int outlineView_numberOfChildrenOfItem(int n, int n2, int n3, int n4) {
        return 0;
    }

    boolean outlineView_shouldExpandItem_item(int n, int n2, int n3, int n4) {
        return true;
    }

    boolean outlineView_shouldReorderColumn_toColumn(int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    boolean outlineView_shouldEditTableColumn_row(int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    boolean outlineView_shouldTrackCell_forTableColumn_item(int n, int n2, int n3, int n4, int n5, int n6) {
        return true;
    }

    void outlineView_willDisplayCell_forTableColumn_item(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    void outlineViewColumnDidMove(int n, int n2, int n3) {
    }

    void outlineViewColumnDidResize(int n, int n2, int n3) {
    }

    void outlineViewSelectionDidChange(int n, int n2, int n3) {
    }

    void outlineViewSelectionIsChanging(int n, int n2, int n3) {
    }

    void outlineView_setObjectValue_forTableColumn_byItem(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    boolean outlineView_writeItems_toPasteboard(int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void pageDown(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void pageUp(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void reflectScrolledClipView(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void register() {
    }

    void release(boolean bl) {
        if ((this.state & 0x10000) == 0) {
            this.state |= 0x10000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x8000) == 0) {
            this.state |= 0x8000;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
        this.destroyJNIRef();
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        if (this.display.tooltipTarget == this) {
            this.display.tooltipTarget = null;
        }
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    void scrollClipViewToPoint(int n, int n2, int n3, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3, nSPoint);
    }

    void selectRowIndexes_byExtendingSelection(int n, int n2, int n3, boolean bl) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3, bl);
    }

    void scrollWheel(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    NSRange selectedRange(int n, int n2) {
        return new NSRange();
    }

    int nextValidKeyView(int n, int n2) {
        return this.callSuperObject(n, n2);
    }

    int previousValidKeyView(int n, int n2) {
        return this.callSuperObject(n, n2);
    }

    void sendDoubleSelection() {
    }

    void sendEvent(Event event) {
        this.display.sendEvent(this.eventTable, event);
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        if ((this.state & 0x80000) != 0) {
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, n, nSEvent)) {
            return true;
        }
        return this.sendKeyEvent(n, event);
    }

    boolean sendKeyEvent(int n, Event event) {
        this.sendEvent(n, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendHorizontalSelection() {
    }

    void sendCancelSelection() {
    }

    void sendSearchSelection() {
    }

    void sendSelection() {
    }

    void sendSelectionEvent(int n) {
        this.sendSelectionEvent(n, null, false);
    }

    void sendSelectionEvent(int n, Event event, boolean bl) {
        NSEvent nSEvent;
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        if ((nSEvent = NSApplication.sharedApplication().currentEvent()) != null) {
            this.setInputState(event, nSEvent, 0);
        }
        this.sendEvent(n, event, bl);
    }

    void sendVerticalSelection() {
    }

    public void setData(Object object) {
        this.checkWidget();
        if (WEBKIT_EVENTS_FIX_KEY.equals(object)) {
            this.state |= 0x80000;
            return;
        }
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (GLCONTEXT_KEY.equals(string)) {
            this.setOpenGLContext(object);
            return;
        }
        int n = 1;
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) break;
                n += 2;
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
        if (string.equals("org.eclipse.swt.skin.class") || string.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    void setOpenGLContext(Object object) {
    }

    void setOrientation() {
    }

    void setFrameOrigin(int n, int n2, NSPoint nSPoint) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, nSPoint);
    }

    void setFrameSize(int n, int n2, NSSize nSSize) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, nSSize);
    }

    void setImage(int n, int n2, int n3) {
    }

    boolean setInputState(Event event, NSEvent nSEvent, int n) {
        int n2;
        if (nSEvent == null && (nSEvent = NSApplication.sharedApplication().currentEvent()) == null) {
            return true;
        }
        int n3 = nSEvent.modifierFlags();
        if ((n3 & 0x80000) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((n3 & 0x20000) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((n3 & 0x40000) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((n3 & 0x100000) != 0) {
            event.stateMask |= 0x400000;
        }
        if (((n2 = OS.GetCurrentEventButtonState()) & 1) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((n2 & 2) != 0) {
            event.stateMask |= 0x200000;
        }
        if ((n2 & 4) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((n2 & 8) != 0) {
            event.stateMask |= 0x800000;
        }
        if ((n2 & 0x10) != 0) {
            event.stateMask |= 0x2000000;
        }
        switch (n) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode == 262144) {
                    event.stateMask &= 0xFFFBFFFF;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask &= 0xFFBFFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode == 262144) {
                    event.stateMask |= 0x40000;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask |= 0x400000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int n, NSEvent nSEvent) {
        boolean bl = false;
        short s = nSEvent.keyCode();
        event.keyCode = Display.translateKey(s);
        switch (event.keyCode) {
            case 10: {
                event.keyCode = 0x1000050;
                event.character = (char)13;
                break;
            }
            case 8: {
                event.character = (char)8;
                break;
            }
            case 13: {
                event.character = (char)13;
                break;
            }
            case 127: {
                event.character = (char)127;
                break;
            }
            case 27: {
                event.character = (char)27;
                break;
            }
            case 9: {
                event.character = (char)9;
                break;
            }
            default: {
                NSString nSString;
                if ((event.keyCode == 0 || 16777258 <= event.keyCode && event.keyCode <= 0x1000050) && (nSString = nSEvent.characters()) != null && nSString.length() > 0) {
                    event.character = (char)nSString.characterAtIndex(0);
                }
                if (event.keyCode != 0) break;
                int n2 = 0;
                int n3 = OS.TISCopyCurrentKeyboardInputSource();
                int n4 = OS.TISGetInputSourceProperty(n3, OS.kTISPropertyUnicodeKeyLayoutData());
                if (n4 != 0) {
                    n2 = OS.CFDataGetBytePtr(n4);
                    if (n2 != 0 && OS.CFDataGetLength(n4) > 0) {
                        int n5 = nSEvent.CGEvent();
                        long l = OS.CGEventGetIntegerValueField(n5, 10);
                        int n6 = 256;
                        char[] cArray = new char[n6];
                        int[] nArray = new int[1];
                        int[] nArray2 = new int[1];
                        OS.UCKeyTranslate(n2, s, (short)(event.type != 1 ? 1 : 0), 0, (int)l, 0, nArray2, n6, nArray, cArray);
                        event.keyCode = nArray[0] < 1 ? 0 : cArray[0];
                    }
                } else {
                    NSString nSString2 = nSEvent.charactersIgnoringModifiers().lowercaseString();
                    if (nSString2.length() > 0) {
                        event.keyCode = (char)nSString2.characterAtIndex(0);
                    }
                }
                if (n3 == 0) break;
                OS.CFRelease(n3);
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !bl) {
            return false;
        }
        this.setLocationMask(event, nSEvent);
        this.setInputState(event, nSEvent, n);
        return true;
    }

    void setLocationMask(Event event, NSEvent nSEvent) {
        switch (nSEvent.keyCode()) {
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                event.keyLocation = 16384;
                break;
            }
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                event.keyLocation = 131072;
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 76: 
            case 78: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                event.keyLocation = 2;
            }
        }
    }

    boolean setMarkedText_selectedRange(int n, int n2, int n3, int n4) {
        return true;
    }

    void setNeedsDisplay(int n, int n2, boolean bl) {
        if (bl && !this.isDrawing()) {
            return;
        }
        NSView nSView = new NSView(n);
        if (bl && this.display.isPainting.containsObject(nSView)) {
            NSMutableArray nSMutableArray = this.display.needsDisplay;
            if (nSMutableArray == null) {
                nSMutableArray = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplay = nSMutableArray = nSMutableArray.initWithCapacity(12);
            }
            nSMutableArray.addObject(nSView);
            return;
        }
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, bl);
    }

    void setNeedsDisplayInRect(int n, int n2, int n3) {
        if (!this.isDrawing()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, n3, NSRect.sizeof);
        NSView nSView = new NSView(n);
        if (this.display.isPainting.containsObject(nSView)) {
            NSMutableArray nSMutableArray = this.display.needsDisplayInRect;
            if (nSMutableArray == null) {
                nSMutableArray = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplayInRect = nSMutableArray = nSMutableArray.initWithCapacity(12);
            }
            nSMutableArray.addObject(nSView);
            nSMutableArray.addObject(NSValue.valueWithRect(nSRect));
            return;
        }
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, nSRect);
    }

    void setObjectValue(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void setShouldExpandItem(int n, int n2, boolean bl) {
    }

    void setShouldScrollClipView(int n, int n2, boolean bl) {
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        return false;
    }

    boolean shouldChangeTextInRange_replacementString(int n, int n2, int n3, int n4) {
        return true;
    }

    NSSize sizeOfLabel(int n, int n2, boolean bl) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, objc_super2, n2, bl);
        return nSSize;
    }

    void superKeyDown(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void superKeyUp(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void tableViewColumnDidMove(int n, int n2, int n3) {
    }

    void tableViewColumnDidResize(int n, int n2, int n3) {
    }

    void tableViewSelectionDidChange(int n, int n2, int n3) {
    }

    void tableViewSelectionIsChanging(int n, int n2, int n3) {
    }

    void tableView_didClickTableColumn(int n, int n2, int n3, int n4) {
    }

    int tableView_objectValueForTableColumn_row(int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    boolean tableView_shouldSelectRow(int n, int n2, int n3, int n4) {
        return true;
    }

    void tableView_setObjectValue_forTableColumn_row(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    boolean tableView_shouldReorderColumn_toColumn(int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    boolean tableView_shouldEditTableColumn_row(int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    boolean tableView_shouldTrackCell_forTableColumn_row(int n, int n2, int n3, int n4, int n5, int n6) {
        return true;
    }

    void tableView_willDisplayCell_forTableColumn_row(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    void textViewDidChangeSelection(int n, int n2, int n3) {
    }

    void textDidChange(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void textDidEndEditing(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(int n, int n2, int n3, int n4, int n5) {
        return new NSRange();
    }

    NSRect titleRectForBounds(int n, int n2, NSRect nSRect) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        NSRect nSRect2 = new NSRect();
        OS.objc_msgSendSuper_stret(nSRect2, objc_super2, n2, nSRect);
        return nSRect2;
    }

    int toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(int n, int n2, int n3, int n4, boolean bl) {
        return 0;
    }

    int toolbarAllowedItemIdentifiers(int n, int n2, int n3) {
        return 0;
    }

    int toolbarDefaultItemIdentifiers(int n, int n2, int n3) {
        return 0;
    }

    int toolbarSelectableItemIdentifiers(int n, int n2, int n3) {
        return 0;
    }

    String tooltipText() {
        return null;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    void touchesBeganWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void touchesCancelledWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void touchesEndedWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void touchesMovedWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void beginGestureWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void endGestureWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void magnifyWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void rotateWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void swipeWithEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    void resetCursorRects(int n, int n2) {
        this.callSuper(n, n2);
    }

    void updateTrackingAreas(int n, int n2) {
        this.callSuper(n, n2);
    }

    int validAttributesForMarkedText(int n, int n2) {
        return 0;
    }

    void tabView_didSelectTabViewItem(int n, int n2, int n3, int n4) {
    }

    void tabView_willSelectTabViewItem(int n, int n2, int n3, int n4) {
    }

    boolean tableView_writeRowsWithIndexes_toPasteboard(int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    boolean validateMenuItem(int n, int n2, int n3) {
        return true;
    }

    int view_stringForToolTip_point_userData(int n, int n2, int n3, int n4, int n5, int n6) {
        return 0;
    }

    void viewDidMoveToWindow(int n, int n2) {
    }

    void viewWillMoveToWindow(int n, int n2, int n3) {
    }

    void windowDidMove(int n, int n2, int n3) {
    }

    void windowDidResize(int n, int n2, int n3) {
    }

    void windowDidResignKey(int n, int n2, int n3) {
    }

    void windowDidBecomeKey(int n, int n2, int n3) {
    }

    void windowDidMiniturize(int n, int n2, int n3) {
    }

    void windowDidDeminiturize(int n, int n2, int n3) {
    }

    void windowSendEvent(int n, int n2, int n3) {
        this.callSuper(n, n2, n3);
    }

    boolean windowShouldClose(int n, int n2, int n3) {
        return false;
    }

    void windowWillClose(int n, int n2, int n3) {
    }

    int nextState(int n, int n2) {
        return this.callSuperObject(n, n2);
    }

    void updateOpenGLContext(int n, int n2, int n3) {
    }

    boolean shouldDrawInsertionPoint(int n, int n2) {
        return this.callSuperBoolean(n, n2);
    }

    boolean readSelectionFromPasteboard(int n, int n2, int n3) {
        return false;
    }

    int validRequestorForSendType(int n, int n2, int n3, int n4) {
        return this.callSuperObject(n, n2, n3, n4);
    }

    boolean writeSelectionToPasteboard(int n, int n2, int n3, int n4) {
        return false;
    }
}

