/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Shell;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;
    NSOpenGLContext glcontext;
    NSBezierPath visiblePath;
    static NSMutableArray supportedPboardTypes = NSMutableArray.arrayWithCapacity(1);

    static {
        supportedPboardTypes.retain();
        supportedPboardTypes.addObject(OS.NSStringPboardType);
    }

    Canvas() {
    }

    int attributedSubstringFromRange(int n, int n2, int n3) {
        if (this.ime != null) {
            return this.ime.attributedSubstringFromRange(n, n2, n3);
        }
        return super.attributedSubstringFromRange(n, n2, n3);
    }

    void sendFocusEvent(int n) {
        if (this.caret != null) {
            if (n == 15) {
                this.caret.setFocus();
            } else {
                this.caret.killFocus();
            }
        }
        super.sendFocusEvent(n);
    }

    public Canvas(Composite composite, int n) {
        super(composite, n);
    }

    int characterIndexForPoint(int n, int n2, int n3) {
        if (this.ime != null) {
            return this.ime.characterIndexForPoint(n, n2, n3);
        }
        return super.characterIndexForPoint(n, n2, n3);
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.drawBackground(gC, n, n2, n3, n4, 0, 0);
    }

    void drawBackground(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        super.drawBackground(n, nSGraphicsContext, nSRect);
        if (this.glcontext != null) {
            nSGraphicsContext.saveGraphicsState();
            nSGraphicsContext.setCompositingOperation(0);
            if (this.visiblePath == null) {
                int n2 = this.getVisibleRegion();
                this.visiblePath = this.getPath(n2);
                OS.DisposeRgn(n2);
            }
            this.visiblePath.addClip();
            NSBezierPath.fillRect(nSRect);
            nSGraphicsContext.restoreGraphicsState();
            return;
        }
    }

    void drawRect(int n, int n2, NSRect nSRect) {
        if (this.glcontext != null && this.glcontext.view() == null) {
            this.glcontext.setView(this.view);
        }
        super.drawRect(n, n2, nSRect);
    }

    void drawWidget(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (n != this.view.id) {
            return;
        }
        super.drawWidget(n, nSGraphicsContext, nSRect);
        if (this.caret == null) {
            return;
        }
        if (this.caret.isShowing) {
            int n2 = nSGraphicsContext.graphicsPort();
            OS.CGContextSaveGState(n2);
            OS.CGContextSetBlendMode(n2, 10);
            Image image = this.caret.image;
            if (image != null) {
                NSImage nSImage = image.handle;
                NSImageRep nSImageRep = nSImage.bestRepresentationForDevice(null);
                if (!nSImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                    return;
                }
                NSBitmapImageRep nSBitmapImageRep = new NSBitmapImageRep(nSImageRep);
                CGRect cGRect = new CGRect();
                cGRect.origin.x = this.caret.x;
                cGRect.origin.y = this.caret.y;
                NSSize nSSize = nSImage.size();
                cGRect.size.width = nSSize.width;
                cGRect.size.height = nSSize.height;
                int n3 = nSBitmapImageRep.bitmapData();
                int n4 = nSBitmapImageRep.bitmapFormat();
                int n5 = nSBitmapImageRep.bytesPerRow();
                int n6 = nSBitmapImageRep.hasAlpha() ? ((n4 & 1) != 0 ? 4 : 3) : ((n4 & 1) != 0 ? 6 : 5);
                int n7 = OS.CGDataProviderCreateWithData(0, n3, n5 * (int)nSSize.height, 0);
                int n8 = OS.CGColorSpaceCreateDeviceRGB();
                int n9 = OS.CGImageCreate((int)nSSize.width, (int)nSSize.height, nSBitmapImageRep.bitsPerSample(), nSBitmapImageRep.bitsPerPixel(), n5, n8, n6, n7, 0, true, 0);
                OS.CGColorSpaceRelease(n8);
                OS.CGDataProviderRelease(n7);
                OS.CGContextScaleCTM(n2, 1.0f, -1.0f);
                OS.CGContextTranslateCTM(n2, 0.0f, -(nSSize.height + 2.0f * cGRect.origin.y));
                OS.CGContextSetBlendMode(n2, 10);
                OS.CGContextDrawImage(n2, cGRect, n9);
                OS.CGImageRelease(n9);
            } else {
                CGRect cGRect = new CGRect();
                cGRect.origin.x = this.caret.x;
                cGRect.origin.y = this.caret.y;
                cGRect.size.width = this.caret.width != 0 ? this.caret.width : 1;
                cGRect.size.height = this.caret.height;
                int n10 = OS.CGColorSpaceCreateDeviceRGB();
                OS.CGContextSetFillColorSpace(n2, n10);
                OS.CGColorSpaceRelease(n10);
                OS.CGContextSetFillColor(n2, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                OS.CGContextFillRect(n2, cGRect);
            }
            OS.CGContextRestoreGState(n2);
        }
    }

    NSRect firstRectForCharacterRange(int n, int n2, int n3) {
        if (this.ime != null) {
            return this.ime.firstRectForCharacterRange(n, n2, n3);
        }
        return super.firstRectForCharacterRange(n, n2, n3);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    boolean hasMarkedText(int n, int n2) {
        if (this.ime != null) {
            return this.ime.hasMarkedText(n, n2);
        }
        return super.hasMarkedText(n, n2);
    }

    boolean imeInComposition() {
        return this.ime != null && this.ime.isInlineEnabled() && this.ime.startOffset != -1;
    }

    boolean insertText(int n, int n2, int n3) {
        if (this.ime != null && !this.ime.insertText(n, n2, n3)) {
            return false;
        }
        return super.insertText(n, n2, n3);
    }

    boolean isOpaque(int n, int n2) {
        if (this.glcontext != null) {
            return true;
        }
        return super.isOpaque(n, n2);
    }

    NSRange markedRange(int n, int n2) {
        if (this.ime != null) {
            return this.ime.markedRange(n, n2);
        }
        return super.markedRange(n, n2);
    }

    boolean readSelectionFromPasteboard(int n, int n2, int n3) {
        boolean bl = false;
        NSPasteboard nSPasteboard = new NSPasteboard(n3);
        NSArray nSArray = nSPasteboard.types();
        int n4 = 0;
        while (n4 < supportedPboardTypes.count()) {
            if (bl) break;
            NSString nSString = new NSString(supportedPboardTypes.objectAtIndex(n4));
            if (nSArray.containsObject(nSString)) {
                bl = this.readSelectionFromPasteboard(nSPasteboard, nSString);
            }
            ++n4;
        }
        return bl;
    }

    boolean readSelectionFromPasteboard(NSPasteboard nSPasteboard, NSString nSString) {
        Object object;
        boolean bl = false;
        Object object2 = null;
        if (nSString.isEqualToString(OS.NSStringPboardType) && (object = nSPasteboard.stringForType(OS.NSStringPboardType)) != null && ((NSString)object).length() > 0) {
            object2 = object;
        }
        if (object2 != null) {
            object = this.getAccessible();
            ((Accessible)object).internal_accessibilitySetValue_forAttribute((id)object2, OS.NSAccessibilitySelectedTextAttribute, -1);
            bl = true;
        }
        return bl;
    }

    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    void reskinChildren(int n) {
        if (this.caret != null) {
            this.caret.reskin(n);
        }
        if (this.ime != null) {
            this.ime.reskin(n);
        }
        super.reskinChildren(n);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Control[] controlArray;
        Control control;
        boolean bl2;
        Rectangle rectangle;
        Rectangle rectangle2;
        boolean bl3;
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n7 = n - n3;
        int n8 = n2 - n4;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (!this.isDrawing()) {
            return;
        }
        NSRect nSRect = this.view.visibleRect();
        if (nSRect.width <= 0.0f || nSRect.height <= 0.0f) {
            return;
        }
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        if ((rectangle2 = new Rectangle(n3, n4, n5, n6)).intersects(rectangle = this.getClientArea())) {
            this.getShell().setScrolling();
            this.update(bl);
        }
        boolean bl5 = bl2 = (control = this.findBackgroundControl()) != null && control.backgroundImage != null;
        if (!bl2) {
            bl2 = this.hasRegion();
        }
        if (!bl2) {
            bl2 = this.isObscured();
        }
        if (bl2) {
            this.redrawWidget(this.view, n3, n4, n5, n6, false);
            this.redrawWidget(this.view, n, n2, n5, n6, false);
        } else {
            boolean bl6;
            controlArray = new NSRect();
            controlArray.x = n3;
            controlArray.y = n4;
            controlArray.width = n5;
            controlArray.height = n6;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            this.view.lockFocus();
            OS.NSCopyBits(0, (NSRect)controlArray, nSPoint);
            this.view.unlockFocus();
            boolean bl7 = bl6 = n + n5 < n3 || n3 + n5 < n || n2 + n6 < n4 || n4 + n6 < n2;
            if (bl6) {
                this.view.setNeedsDisplayInRect((NSRect)controlArray);
            } else {
                int n9;
                if (n7 != 0) {
                    n9 = n - n7;
                    if (n7 < 0) {
                        n9 = n + n5;
                    }
                    controlArray.x = n9;
                    controlArray.width = Math.abs(n7);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (n8 != 0) {
                    n9 = n2 - n8;
                    if (n8 < 0) {
                        n9 = n2 + n6;
                    }
                    controlArray.x = n3;
                    controlArray.y = n9;
                    controlArray.width = n5;
                    controlArray.height = Math.abs(n8);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
            }
            object = new NSRect();
            ((NSRect)object).x = rectangle2.x;
            ((NSRect)object).y = rectangle2.y;
            ((NSRect)object).width = rectangle2.width;
            ((NSRect)object).height = rectangle2.height;
            OS.NSIntersectionRect(nSRect, nSRect, (NSRect)object);
            if (!OS.NSEqualRects(nSRect, (NSRect)object)) {
                if (((NSRect)object).x != nSRect.x) {
                    controlArray.x = ((NSRect)object).x + (float)n7;
                    controlArray.y = ((NSRect)object).y + (float)n8;
                    controlArray.width = nSRect.x - ((NSRect)object).x;
                    controlArray.height = ((NSRect)object).height;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.x + nSRect.width != ((NSRect)object).x + ((NSRect)object).width) {
                    controlArray.x = ((NSRect)object).x + nSRect.width + (float)n7;
                    controlArray.y = ((NSRect)object).y + (float)n8;
                    controlArray.width = ((NSRect)object).width - nSRect.width;
                    controlArray.height = ((NSRect)object).height;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.y != ((NSRect)object).y) {
                    controlArray.x = nSRect.x + (float)n7;
                    controlArray.y = ((NSRect)object).y + (float)n8;
                    controlArray.width = nSRect.width;
                    controlArray.height = nSRect.y - ((NSRect)object).y;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.y + nSRect.height != ((NSRect)object).y + ((NSRect)object).height) {
                    controlArray.x = nSRect.x + (float)n7;
                    controlArray.y = nSRect.y + nSRect.height + (float)n8;
                    controlArray.width = nSRect.width;
                    controlArray.height = ((NSRect)object).y + ((NSRect)object).height - (nSRect.y + nSRect.height);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
            }
        }
        if (bl) {
            controlArray = this._getChildren();
            int n10 = 0;
            while (n10 < controlArray.length) {
                Control control2 = controlArray[n10];
                object = control2.getBounds();
                if (Math.min(n3 + n5, ((Rectangle)object).x + ((Rectangle)object).width) >= Math.max(n3, ((Rectangle)object).x) && Math.min(n4 + n6, ((Rectangle)object).y + ((Rectangle)object).height) >= Math.max(n4, ((Rectangle)object).y)) {
                    control2.setLocation(((Rectangle)object).x + n7, ((Rectangle)object).y + n8);
                }
                ++n10;
            }
        }
        if (bl3) {
            this.caret.setFocus();
        }
    }

    NSRange selectedRange(int n, int n2) {
        if (this.ime != null) {
            return this.ime.selectedRange(n, n2);
        }
        return super.selectedRange(n, n2);
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        if (this.caret != null) {
            NSCursor.setHiddenUntilMouseMoves(true);
        }
        return super.sendKeyEvent(nSEvent, n);
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    void setOpenGLContext(Object object) {
        this.glcontext = (NSOpenGLContext)object;
        NSWindow nSWindow = this.view.window();
        if (this.glcontext != null) {
            nSWindow.setOpaque(false);
        } else {
            nSWindow.setOpaque(this.getShell().region == null);
        }
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    boolean setMarkedText_selectedRange(int n, int n2, int n3, int n4) {
        if (this.ime != null && !this.ime.setMarkedText_selectedRange(n, n2, n3, n4)) {
            return false;
        }
        return super.setMarkedText_selectedRange(n, n2, n3, n4);
    }

    int validAttributesForMarkedText(int n, int n2) {
        if (this.ime != null) {
            return this.ime.validAttributesForMarkedText(n, n2);
        }
        return super.validAttributesForMarkedText(n, n2);
    }

    int validRequestorForSendType(int n, int n2, int n3, int n4) {
        NSArray nSArray;
        Accessible accessible;
        if (n == this.view.id && (accessible = this.getAccessible()) != null && (nSArray = accessible.internal_accessibilityAttributeNames(-1)) != null) {
            NSString nSString;
            id id2;
            boolean bl;
            boolean bl2 = nSArray.containsObject(OS.NSAccessibilitySelectedTextAttribute);
            boolean bl3 = accessible.internal_accessibilityIsAttributeSettable(OS.NSAccessibilitySelectedTextAttribute, -1);
            boolean bl4 = bl = supportedPboardTypes.containsObject(new id(n3)) && supportedPboardTypes.containsObject(new id(n4));
            if (bl2 && bl3 && bl && (id2 = accessible.internal_accessibilityAttributeValue(OS.NSAccessibilitySelectedTextAttribute, -1)) != null && (nSString = new NSString(id2)).length() > 0) {
                return this.view.id;
            }
        }
        return super.validRequestorForSendType(n, n2, n3, n4);
    }

    void updateOpenGLContext(int n, int n2, int n3) {
        if (this.glcontext != null) {
            this.glcontext.update();
        }
    }

    void viewWillMoveToWindow(int n, int n2, int n3) {
        super.viewWillMoveToWindow(n, n2, n3);
        if (this.glcontext != null) {
            new NSWindow(n3).setOpaque(false);
            Shell shell = this.getShell();
            NSWindow nSWindow = shell.window;
            if (nSWindow != null) {
                nSWindow.setOpaque(shell.region == null);
            }
        }
    }

    boolean writeSelectionToPasteboard(int n, int n2, int n3, int n4) {
        NSString nSString;
        boolean bl = false;
        NSPasteboard nSPasteboard = new NSPasteboard(n3);
        NSArray nSArray = new NSArray(n4);
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(2);
        int n5 = 0;
        while (n5 < supportedPboardTypes.count()) {
            nSString = new NSString(supportedPboardTypes.objectAtIndex(n5));
            if (nSArray.containsObject(nSString)) {
                nSMutableArray.addObject(nSString);
            }
            ++n5;
        }
        if (nSMutableArray.count() > 0) {
            nSPasteboard.declareTypes(nSMutableArray, this.view);
            n5 = 0;
            while (n5 < nSMutableArray.count()) {
                nSString = new NSString(nSMutableArray.objectAtIndex(n5));
                if (this.writeSelectionToPasteboard(nSPasteboard, nSString)) {
                    bl = true;
                }
                ++n5;
            }
        }
        return bl;
    }

    boolean writeSelectionToPasteboard(NSPasteboard nSPasteboard, NSString nSString) {
        NSString nSString2;
        Accessible accessible;
        id id2;
        boolean bl = false;
        if (nSString.isEqualToString(OS.NSStringPboardType) && (id2 = (accessible = this.getAccessible()).internal_accessibilityAttributeValue(OS.NSAccessibilitySelectedTextAttribute, -1)) != null && (nSString2 = new NSString(id2)).length() > 0) {
            bl = nSPasteboard.setString(nSString2, OS.NSStringPboardType);
        }
        return bl;
    }
}

