/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd.examples;

import de.wim.outldd.OutlookDD;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;

public class DragDropTest_ModeTempFiles
extends JFrame {
    private static final long serialVersionUID = 1L;

    public DragDropTest_ModeTempFiles() throws Exception {
        this.setDefaultCloseOperation(3);
        this.setBounds(0, 0, 400, 300);
        this.setVisible(true);
        this.setTitle("Example for MODE_TEMP_FILES");
        DropTarget dropTarget = new DropTarget();
        dropTarget.setComponent(this);
        dropTarget.addDropTargetListener(new DropTargetAdapter(){

            public void dragEnter(DropTargetDragEvent dtde) {
                boolean succ = dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
                System.out.println("enter: avail=" + succ);
                super.dragEnter(dtde);
            }

            public void dragOver(DropTargetDragEvent dtde) {
                boolean dropFiles = dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
                System.out.println("over: file list avail=" + dropFiles);
                int action = dtde.getDropAction();
                if (!dropFiles) {
                    action = 0;
                }
                dtde.acceptDrag(action);
                super.dragOver(dtde);
            }

            public void drop(DropTargetDropEvent dtde) {
                try {
                    try {
                        Transferable t = dtde.getTransferable();
                        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            int action = dtde.getDropAction();
                            dtde.acceptDrop(action);
                            List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                            for (Object o : list) {
                                System.out.println("file=" + o);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        dtde.dropComplete(true);
                    }
                }
                finally {
                    dtde.dropComplete(true);
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        OutlookDD.setLogFile(new File("d:\\temp\\outldd\\outldd.log"), true);
        OutlookDD.init(OutlookDD.MODE_TEMP_FILES);
        new DragDropTest_ModeTempFiles();
    }
}

