/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd.examples;

import de.wim.outldd.OutlookDD;
import de.wim.outldd.OutlookData;
import de.wim.outldd.OutlookItem;
import de.wim.outldd.OutlookMsgItem;
import de.wim.outldd.OutlookMsgProperties;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;

public class DragDropTest_ModeMemoryStream
extends JFrame {
    private static final long serialVersionUID = 1L;

    public DragDropTest_ModeMemoryStream() throws Exception {
        this.setDefaultCloseOperation(3);
        this.setBounds(0, 0, 400, 300);
        this.setVisible(true);
        this.setTitle("Example for MODE_MEMORY_STREAM");
        DropTarget dropTarget = new DropTarget();
        dropTarget.setComponent(this);
        dropTarget.addDropTargetListener(new DropTargetAdapter(){

            public void dragEnter(DropTargetDragEvent dtde) {
                boolean dropFiles = dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
                System.out.println("enter: file list avail=" + (dropFiles |= OutlookDD.isDataAvail()));
                super.dragEnter(dtde);
            }

            public void dragOver(DropTargetDragEvent dtde) {
                boolean dropFiles = dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
                System.out.println("over: file list avail=" + (dropFiles |= OutlookDD.isDataAvail()));
                int action = dtde.getDropAction();
                if (!dropFiles) {
                    action = 0;
                }
                dtde.acceptDrag(action);
                super.dragOver(dtde);
            }

            public void drop(DropTargetDropEvent dtde) {
                block13: {
                    try {
                        try {
                            int action = dtde.getDropAction();
                            dtde.acceptDrop(action);
                            Transferable t = dtde.getTransferable();
                            if (OutlookDD.isDataAvail()) {
                                try {
                                    OutlookData outlData = OutlookDD.getData();
                                    List<? extends OutlookItem> items = outlData.getItems();
                                    if (items.size() != 0) {
                                        for (OutlookItem outlookItem : items) {
                                            File file = new File(System.getProperty("java.io.tmpdir"), outlookItem.getFileName());
                                            outlookItem.saveContent(file);
                                            System.out.println("oitem.class=" + outlookItem.getClass().getName() + ", value=" + outlookItem + ", file=" + file);
                                            if (!(outlookItem instanceof OutlookMsgItem)) continue;
                                            OutlookMsgItem msg = (OutlookMsgItem)outlookItem;
                                            OutlookMsgProperties props = msg.getProperties();
                                            System.out.println("from=" + props.getFrom() + ", subject=" + props.getSubject() + ", received=" + props.getReceived());
                                        }
                                    }
                                    break block13;
                                }
                                finally {
                                    OutlookDD.release();
                                }
                            }
                            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                                for (Object o : list) {
                                    System.out.println("file=" + o);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            dtde.dropComplete(true);
                        }
                    }
                    finally {
                        dtde.dropComplete(true);
                    }
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        OutlookDD.setLogFile(new File("d:\\temp\\outldd\\outldd.log"), true);
        OutlookDD.init(OutlookDD.MODE_MEMORY_STREAMS);
        new DragDropTest_ModeMemoryStream();
    }
}

