/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd.examples;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DragDropTest_AppletPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    DragDropTest_AppletPanel() {
        DropTarget dropTarget = new DropTarget();
        dropTarget.setComponent(this);
        try {
            dropTarget.addDropTargetListener(new DropTargetAdapter(){

                public void dragEnter(DropTargetDragEvent dtde) {
                    boolean succ = dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
                    System.out.println("enter: avail=" + succ);
                    super.dragEnter(dtde);
                }

                public void dragOver(DropTargetDragEvent dtde) {
                    boolean dropFiles = dtde.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor);
                    System.out.println("over: file list avail=" + dropFiles);
                    int action = dtde.getDropAction();
                    if (!dropFiles) {
                        action = 0;
                    }
                    if (action == 2) {
                        action = 1;
                    }
                    dtde.acceptDrag(action);
                    super.dragOver(dtde);
                }

                public void drop(DropTargetDropEvent dtde) {
                    try {
                        try {
                            int action = dtde.getDropAction();
                            if (action == 2) {
                                action = 1;
                            }
                            dtde.acceptDrop(action);
                            Transferable t = dtde.getTransferable();
                            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                                for (final Object o : list) {
                                    System.out.println("file=" + o);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            JOptionPane.showMessageDialog(null, "You dropped the file=\n" + o, "Applet", 1);
                                        }
                                    });
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            dtde.dropComplete(true);
                        }
                    }
                    finally {
                        dtde.dropComplete(true);
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }
}

