/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Win32DataInputStream {
    private DataInputStream is;

    public Win32DataInputStream(InputStream is) {
        this.is = new DataInputStream(is);
    }

    public void skip(long n) throws IOException {
        this.is.skip(n);
    }

    public int readBytes(byte[] buf) throws IOException {
        return this.is.read(buf);
    }

    public int readInt() throws IOException {
        int v = this.is.readInt();
        v = this.swapByteOrder(v);
        return v;
    }

    public long readLong() throws IOException {
        long v = this.is.readLong();
        v = this.swapByteOrder(v);
        return v;
    }

    public String readUnicodeString(int max) throws IOException {
        StringBuilder sbuf = new StringBuilder(max);
        int i = 0;
        while (i < max) {
            short v = this.is.readShort();
            if (v != 0) {
                v = this.swapByteOrder(v);
                sbuf.append((char)v);
            }
            ++i;
        }
        return sbuf.toString();
    }

    private short swapByteOrder(short v) {
        short v1 = 0;
        v1 = (short)(v1 | v & 0xFF);
        v1 = (short)(v1 << 8);
        v = (short)(v >> 8);
        v1 = (short)(v1 | v & 0xFF);
        return v1;
    }

    private int swapByteOrder(int v) {
        int v1 = 0;
        v1 |= v & 0xFF;
        v1 <<= 8;
        v1 |= (v >>= 8) & 0xFF;
        v1 <<= 8;
        v1 |= (v >>= 8) & 0xFF;
        v1 <<= 8;
        return v1 |= (v >>= 8) & 0xFF;
    }

    private long swapByteOrder(long v) {
        long v1 = 0L;
        v1 |= v & 0xFFL;
        v1 <<= 8;
        v1 |= (v >>= 8) & 0xFFL;
        v1 <<= 8;
        v1 |= (v >>= 8) & 0xFFL;
        v1 <<= 8;
        v1 |= (v >>= 8) & 0xFFL;
        v1 <<= 8;
        v1 |= (v >>= 8) & 0xFFL;
        v1 <<= 8;
        v1 |= (v >>= 8) & 0xFFL;
        v1 <<= 8;
        v1 |= (v >>= 8) & 0xFFL;
        v1 <<= 8;
        return v1 |= (v >>= 8) & 0xFFL;
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }
}

