/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import de.wim.outldd.FileDescriptor;
import de.wim.outldd.OutlookFileItem;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlookNoteItem
extends OutlookFileItem {
    protected String name;

    public String getName() {
        return this.name;
    }

    protected OutlookNoteItem(String name, int fileIndex, FileDescriptor fdesc) {
        super(fileIndex, fdesc);
        this.name = name.trim();
    }

    protected static ArrayList<OutlookNoteItem> makeItems(String text, ArrayList<FileDescriptor> fdescs) {
        ArrayList<OutlookNoteItem> items = null;
        if (text.startsWith("\t\r\n")) {
            items = new ArrayList<OutlookNoteItem>(fdescs.size());
            StringReader sr = new StringReader(text);
            LineNumberReader lr = new LineNumberReader(sr);
            try {
                String line = lr.readLine();
                int fileIndex = 0;
                while (fileIndex < fdescs.size()) {
                    line = lr.readLine();
                    FileDescriptor fdesc = fdescs.get(fileIndex);
                    items.add(new OutlookNoteItem(line, fileIndex, fdesc));
                    ++fileIndex;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return items;
    }
}

