/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import de.wim.outldd.FileDescriptor;
import de.wim.outldd.OutlookFileItem;
import de.wim.outldd.OutlookMsgProperties;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlookMsgItem
extends OutlookFileItem {
    protected OutlookMsgProperties properties;

    public OutlookMsgProperties getProperties() {
        return this.properties;
    }

    public String toString() {
        return "[" + this.properties + "]";
    }

    protected OutlookMsgItem(String[] propNames, String propLine, int fileIndex, FileDescriptor fdesc) {
        super(fileIndex, fdesc);
        this.readPropertiesFromLine(propNames, propLine);
    }

    protected void readPropertiesFromLine(String[] propNames, String propLine) {
        this.properties = new OutlookMsgProperties();
        int q = -1;
        int i = 0;
        while (i < propNames.length) {
            int p = q + 1;
            String propValue = (q = propLine.indexOf(9, p)) >= 0 ? propLine.substring(p, q) : "";
            this.properties.put(propNames[i], propValue);
            ++i;
        }
    }

    protected static ArrayList<OutlookMsgItem> makeItems(String text, ArrayList<FileDescriptor> fdescs) {
        ArrayList<OutlookMsgItem> items = null;
        if (!text.startsWith("\t") && !text.startsWith("\r\n") && text.indexOf(9) > 0) {
            items = new ArrayList<OutlookMsgItem>(fdescs.size());
            StringReader sr = new StringReader(text);
            LineNumberReader lr = new LineNumberReader(sr);
            try {
                String line = lr.readLine();
                String[] propNames = line.split("\t");
                int fileIndex = 0;
                while (fileIndex < fdescs.size()) {
                    line = lr.readLine();
                    FileDescriptor fdesc = fdescs.get(fileIndex);
                    items.add(new OutlookMsgItem(propNames, line, fileIndex, fdesc));
                    ++fileIndex;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return items;
    }
}

