/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import de.wim.outldd.FileDescriptor;
import de.wim.outldd.OutlookDD;
import de.wim.outldd.OutlookItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlookFileItem
implements OutlookItem {
    protected int fileIndex;
    protected FileDescriptor fdesc;

    @Override
    public String getFileName() {
        return this.fdesc.getName();
    }

    @Override
    public InputStream getContent() throws IOException {
        return OutlookDD.nativeLib.getFileContent(this.fileIndex);
    }

    @Override
    public void saveContent(File file) throws IOException {
        OutlookDD.nativeLib.saveFileContent(this.fileIndex, file);
    }

    protected OutlookFileItem(int fileIndex, FileDescriptor fdesc) {
        this.fileIndex = fileIndex;
        this.fdesc = fdesc;
    }

    protected static ArrayList<OutlookFileItem> makeItems(ArrayList<FileDescriptor> fdescs) {
        ArrayList<OutlookFileItem> items = new ArrayList<OutlookFileItem>(fdescs.size());
        int fileIndex = 0;
        while (fileIndex < fdescs.size()) {
            items.add(new OutlookFileItem(fileIndex, fdescs.get(fileIndex)));
            ++fileIndex;
        }
        return items;
    }
}

