/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import de.wim.outldd.FileDescriptor;
import de.wim.outldd.OutlookContactItem;
import de.wim.outldd.OutlookDD;
import de.wim.outldd.OutlookFileItem;
import de.wim.outldd.OutlookItem;
import de.wim.outldd.OutlookMsgItem;
import de.wim.outldd.OutlookNoteItem;
import de.wim.outldd.Win32DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlookData {
    protected ArrayList<? extends OutlookItem> items;

    public List<? extends OutlookItem> getItems() {
        return this.items;
    }

    protected OutlookData() {
        ArrayList<FileDescriptor> fdescs = this.internalReadFileGroupDescriptor();
        this.items = this.internalMakeItems(fdescs);
    }

    protected ArrayList<FileDescriptor> internalReadFileGroupDescriptor() {
        ArrayList<FileDescriptor> fdescs;
        block22: {
            fdescs = new ArrayList<FileDescriptor>();
            if (OutlookDD.nativeLib != null) {
                InputStream ris = null;
                Win32DataInputStream is = null;
                try {
                    try {
                        ris = OutlookDD.nativeLib.getFileGroupDescriptor();
                        is = new Win32DataInputStream(ris);
                        int nbOfFiles = is.readInt();
                        fdescs.ensureCapacity(nbOfFiles);
                        int i = 0;
                        while (i < nbOfFiles) {
                            FileDescriptor fileDesc = new FileDescriptor();
                            fileDesc.read(is);
                            fdescs.add(fileDesc);
                            ++i;
                        }
                    }
                    catch (IOException ignored) {
                        fdescs = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (ris == null) break block22;
                        try {
                            ris.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (ris != null) {
                        try {
                            ris.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return fdescs;
    }

    protected ArrayList<? extends OutlookItem> internalMakeItems(ArrayList<FileDescriptor> fdescs) {
        ArrayList<OutlookFileItem> items = null;
        if (OutlookDD.nativeLib != null) {
            try {
                String text = OutlookDD.nativeLib.getText();
                if (text != null && text.length() != 0 && (items = OutlookMsgItem.makeItems(text, fdescs)) == null && (items = OutlookContactItem.makeItems(text, fdescs)) == null) {
                    items = OutlookNoteItem.makeItems(text, fdescs);
                }
            }
            catch (Throwable e) {
                System.err.println("OutlookDragDrop error");
                e.printStackTrace(System.err);
            }
            if (items == null) {
                items = OutlookFileItem.makeItems(fdescs);
            }
        }
        return items;
    }
}

