/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import de.wim.outldd.OutlDDNativeLib;
import de.wim.outldd.OutlookData;
import java.io.File;

public class OutlookDD {
    public static int MODE_MEMORY_STREAMS = 1;
    public static int MODE_TEMP_FILES = 2;
    protected static OutlDDNativeLib nativeLib;
    protected static File logFile;
    protected static boolean appendLog;
    protected static File tempDir;

    public static void init(int mode) {
        nativeLib = new OutlDDNativeLib();
        if (logFile != null) {
            nativeLib.setLogFile(logFile, appendLog);
        }
        if (tempDir != null) {
            nativeLib.setTempDir(tempDir);
        }
        nativeLib.enableDragDrop(mode);
    }

    public static void done() {
        if (nativeLib == null) {
            return;
        }
        nativeLib.enableDragDrop(0);
    }

    public static boolean isDataAvail() {
        if (nativeLib == null) {
            return false;
        }
        return nativeLib.isOutlookDataAvail();
    }

    public static OutlookData getData() {
        if (!OutlookDD.isDataAvail()) {
            return null;
        }
        return new OutlookData();
    }

    public static void release() {
        if (nativeLib == null) {
            return;
        }
        nativeLib.releaseOutlookData();
    }

    public static void setLogFile(File file, boolean append) {
        logFile = file;
        appendLog = append;
        if (nativeLib != null) {
            nativeLib.setLogFile(file, append);
        }
    }

    public static void setTempDir(File dir) {
        tempDir = dir;
        if (nativeLib != null) {
            nativeLib.setTempDir(tempDir);
        }
    }

    public static String getLicense(boolean[] rValid) {
        String lic = null;
        rValid[0] = false;
        if (nativeLib != null) {
            lic = nativeLib.getLicense(rValid);
        }
        return lic;
    }
}

