/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import de.wim.outldd.FileDescriptor;
import de.wim.outldd.OutlookFileItem;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlookContactItem
extends OutlookFileItem {
    protected String[] properties;

    public String[] getProperties() {
        return this.properties;
    }

    public String toString() {
        return "[" + this.properties + "]";
    }

    protected OutlookContactItem(String text, int fileIndex, FileDescriptor fdesc) {
        super(fileIndex, fdesc);
        this.properties = text.split("\r\n");
    }

    protected static ArrayList<OutlookContactItem> makeItems(String text, ArrayList<FileDescriptor> fdescs) {
        ArrayList<OutlookContactItem> items = null;
        if (!text.startsWith("\t") && !text.startsWith("\r\n") && text.indexOf(9) < 0) {
            items = new ArrayList<OutlookContactItem>(fdescs.size());
            int q = -1;
            int fileIndex = 0;
            while (fileIndex < fdescs.size()) {
                int p = q + 1;
                String contactText = (q = text.indexOf("\r\n\r\n", p)) >= 0 ? text.substring(p, q) : "";
                OutlookContactItem item = new OutlookContactItem(contactText, fileIndex, fdescs.get(fileIndex));
                items.add(item);
                if (q < 0) {
                    q = text.length() - 1;
                }
                ++fileIndex;
            }
        }
        return items;
    }
}

