/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;

class OutlDDNativeLib {
    private static final String OUTLDD_TEMP_LIBDIR = "de_wim_outldd_libs_2_0_3_0";
    private static final String DEBUG_LIB = null;

    static {
        if (DEBUG_LIB != null) {
            System.loadLibrary(DEBUG_LIB);
        } else if (OutlDDNativeLib.isMsvcAvail()) {
            String subdir = "msvc/" + (OutlDDNativeLib.is64() ? "x64" : "x86");
            OutlDDNativeLib.loadDll(subdir, "msvcr100");
            OutlDDNativeLib.loadDll(subdir, "msvcp100");
            OutlDDNativeLib.loadDll(subdir, "outldd");
        } else {
            boolean x64 = OutlDDNativeLib.is64();
            String subdir = "mingw/" + (x64 ? "x64" : "x86");
            OutlDDNativeLib.loadDll(subdir, "outldd");
        }
    }

    private static boolean is64() {
        String s = System.getProperty("os.arch");
        return s != null && s.indexOf("64") >= 0;
    }

    private static boolean isMsvcAvail() {
        String subdir = "msvc/" + (OutlDDNativeLib.is64() ? "x64" : "x86");
        String resPath = String.valueOf(subdir) + "/outldd.dll";
        URL res = OutlDDNativeLib.class.getResource(resPath);
        return res != null;
    }

    private static void loadDll(String subdir, String lname) throws UnsatisfiedLinkError {
        int retries = 10;
        try {
            String inst = "";
            int i = 1;
            while (i <= 10) {
                try {
                    OutlDDNativeLib.loadDllFromResource(String.valueOf(subdir) + inst, subdir, lname);
                    break;
                }
                catch (UnsatisfiedLinkError e) {
                    if (i == 10) {
                        throw e;
                    }
                    inst = "_" + i;
                    ++i;
                }
            }
        }
        catch (IOException e) {
            System.err.println("OUTLDD: loadDllFromResource failed");
            e.printStackTrace();
            throw new UnsatisfiedLinkError(e.toString());
        }
    }

    private static void loadDllFromResource(String tempSubdir, String packageDir, String lname) throws UnsatisfiedLinkError, IOException {
        String dllName = String.valueOf(lname) + ".dll";
        InputStream is = null;
        try {
            try {
                File dll;
                block36: {
                    String tmpdir = System.getProperty("java.io.tmpdir");
                    File libdir = new File(new File(tmpdir, OUTLDD_TEMP_LIBDIR), tempSubdir);
                    libdir.mkdirs();
                    dll = new File(libdir, dllName);
                    if (!dll.exists()) {
                        String resPath = String.valueOf(packageDir) + "/" + dllName;
                        URL res = OutlDDNativeLib.class.getResource(resPath);
                        if (res == null) {
                            throw new UnsatisfiedLinkError("DLL " + resPath + " not found in JAR");
                        }
                        is = res.openStream();
                        FileOutputStream fos = null;
                        try {
                            try {
                                fos = new FileOutputStream(dll);
                                byte[] buf = new byte[8192];
                                int n = 0;
                                while ((n = is.read(buf)) > 0) {
                                    fos.write(buf, 0, n);
                                }
                            }
                            catch (IOException iOException) {
                                if (is != null) {
                                    try {
                                        is.close();
                                        is = null;
                                    }
                                    catch (IOException iOException2) {
                                        // empty catch block
                                    }
                                }
                                if (fos != null) {
                                    try {
                                        fos.close();
                                        fos = null;
                                    }
                                    catch (IOException iOException3) {}
                                }
                                break block36;
                            }
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                    is = null;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (fos != null) {
                                try {
                                    fos.close();
                                    fos = null;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (is != null) {
                            try {
                                is.close();
                                is = null;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                                fos = null;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                File pdll = dll;
                System.load(pdll.getAbsolutePath());
            }
            catch (IOException e) {
                System.err.println("OUTLDD: load library failed: " + e);
                throw e;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    OutlDDNativeLib() {
        this.getLicense(new boolean[1]);
    }

    String getLicense(boolean[] rValid) {
        boolean succ;
        String lic;
        block24: {
            String licenseProperties = "outldd.license";
            lic = null;
            BufferedReader lr = null;
            try {
                try {
                    URL res = this.getClass().getResource("outldd.license");
                    if (res != null) {
                        BufferedInputStream is = new BufferedInputStream(res.openStream(), 3);
                        ((InputStream)is).mark(4);
                        InputStreamReader rd = null;
                        byte[] bom = new byte[3];
                        int bomlen = ((InputStream)is).read(bom);
                        if (bomlen >= 2 && bom[0] == -1 && bom[1] == -2) {
                            ((InputStream)is).reset();
                            ((InputStream)is).skip(2L);
                            rd = new InputStreamReader((InputStream)is, "UTF-16LE");
                        } else if (bomlen >= 2 && bom[0] == -2 && bom[1] == -1) {
                            ((InputStream)is).reset();
                            ((InputStream)is).skip(2L);
                            rd = new InputStreamReader((InputStream)is, "UTF-16BE");
                        } else if (bomlen >= 3 && bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                            rd = new InputStreamReader((InputStream)is, "UTF-8");
                        } else {
                            ((InputStream)is).reset();
                            rd = new InputStreamReader(is);
                        }
                        lr = new LineNumberReader(rd);
                        lic = ((LineNumberReader)lr).readLine();
                        if (lic == null) {
                            System.err.println("OUTLDD: empty license file outldd.license in outldd.jar.");
                        }
                    } else {
                        String dir = this.getClass().getPackage().getName();
                        dir = dir.replaceAll("[\\.]", "/");
                        String fpath = String.valueOf(dir) + "/" + "outldd.license";
                        System.err.println("OUTLDD: license file not found. Make sure to have a license file \"" + fpath + "\" in outldd.jar.");
                    }
                }
                catch (IOException res) {
                    if (lr != null) {
                        try {
                            lr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (lr != null) {
                    try {
                        lr.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (lr != null) {
                try {
                    lr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (lic != null && !(succ = (rValid[0] = this.checkLicense(lic = lic.trim())))) {
            System.err.println("OUTLDD: license check failed.");
        }
        return lic;
    }

    native boolean enableDragDrop(int var1);

    native void setLogFile(File var1, boolean var2);

    native void setTempDir(File var1);

    native boolean isOutlookDataAvail();

    native void releaseOutlookData();

    native InputStream getFileGroupDescriptor();

    native InputStream getFileContent(int var1) throws IOException;

    native void saveFileContent(int var1, File var2) throws IOException;

    native String getText();

    native boolean checkLicense(String var1);
}

