/*
 * Decompiled with CFR 0.152.
 */
package de.wim.outldd;

import java.io.IOException;
import java.io.InputStream;

public class HGlobalInputStream
extends InputStream {
    private long h;
    private long pos;
    private long markPos;
    private byte[] cache = new byte[100];
    private long cachePos;
    private int cacheLen;

    protected HGlobalInputStream(long h) {
        this.h = h;
    }

    private int cacheIdxOfPos(long pos) {
        int idx = -1;
        if (this.cachePos <= pos && pos < this.cachePos + (long)this.cacheLen) {
            idx = (int)(pos - this.cachePos);
        }
        return idx;
    }

    public int read() throws IOException {
        if (this.h == 0L) {
            throw new IOException("Stream closed");
        }
        int v = -1;
        int cacheIdx = this.cacheIdxOfPos(this.pos);
        if (cacheIdx < 0) {
            this.cacheLen = HGlobalInputStream.get(this.h, this.pos, this.cache, 0, this.cache.length);
            if (this.cacheLen > 0) {
                this.cachePos = this.pos;
                cacheIdx = this.cacheIdxOfPos(this.pos);
                if (cacheIdx >= 0) {
                    v = this.cache[cacheIdx] & 0xFF;
                    ++this.pos;
                }
            }
        } else {
            v = this.cache[cacheIdx] & 0xFF;
            ++this.pos;
        }
        return v;
    }

    public int read(byte[] buf, int offs, int len) throws IOException {
        if (this.h == 0L) {
            throw new IOException("Stream closed");
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offs < 0 || len < 0 || offs + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.cacheLen = 0;
        int n = HGlobalInputStream.get(this.h, this.pos, buf, offs, len);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int available() throws IOException {
        if (this.h == 0L) {
            throw new IOException("Stream closed");
        }
        long s = HGlobalInputStream.size(this.h);
        return (int)(Math.max(s - this.pos, 0L) & 0xFFFFFFFFFFFFFFFFL);
    }

    public void close() throws IOException {
        if (this.h != 0L) {
            HGlobalInputStream.free(this.h);
            this.h = 0L;
        }
    }

    public void mark(int readlimit) {
        this.markPos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        this.pos = this.markPos;
    }

    public long skip(long n) throws IOException {
        long s = HGlobalInputStream.size(this.h);
        if (this.pos + n > s) {
            n = Math.max(s - this.pos, 0L);
        }
        this.pos += n;
        return n;
    }

    private static native int get(long var0, long var2);

    private static native int get(long var0, long var2, byte[] var4, int var5, int var6);

    private static native long size(long var0);

    private static native void free(long var0);
}

