/*
 * Decompiled with CFR 0.152.
 */
package view;

import debug.AppxDebug;
import doc.AppxResource;
import doc.AppxToolkit;
import doc.Globals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import view.AppxMain;

public class UserDialog
extends JFrame
implements ItemListener,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = 5305317786513085432L;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/UserDialog.java,v 1.1.2.39 2013/08/12 15:42:24 pete Exp $";
    protected AppxMain program;
    protected JLabel msg;
    protected JPasswordField password;
    protected JTabbedPane tPane;
    protected JTextField reconid;
    protected JTextField pathname;
    protected JTextField username;
    protected JTextField remotehost;
    protected JTextField portid;
    protected JComboBox inifile;
    protected JCheckBox useSSO;
    JSpinner spnOptionRows;
    JSpinner spnOptionCols;
    protected UserDialog ud;
    private GridBagConstraints c;
    private GridBagLayout locLayout;
    private GridBagLayout remLayout;
    private GridBagLayout optLayout;
    JButton lConn;
    private JButton rConn;
    private JButton oAdv;
    private JPanel bPanel;
    private JPanel locPanel;
    private JPanel remPanel;
    private JPanel optPanel;
    private JButton oAssoc;
    private JSpinner oRows;
    private JSpinner oCols;

    private void showMsg(String msgText, Color msgColor, JComponent focusComp) {
        this.msg.setText(msgText);
        this.msg.setToolTipText(msgText);
        if (msgColor == null) {
            this.msg.setForeground(Color.black);
        } else {
            this.msg.setForeground(msgColor);
        }
        if (focusComp != null) {
            focusComp.requestFocus();
        }
        this.paint(this.getGraphics());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    void addComponent(JPanel pane, Component comp, int x, int y) {
        pane.add(comp);
        this.c.gridx = x;
        this.c.gridy = y;
        this.c.ipadx = 6;
        this.c.insets.top = 2;
        this.c.insets.bottom = 2;
        this.c.fill = 2;
        this.c.anchor = 17;
        ((GridBagLayout)pane.getLayout()).setConstraints(comp, this.c);
    }

    JLabel addComponent(JPanel pane, String str, int x, int y) {
        JLabel l = new JLabel(str);
        l.setFocusable(false);
        this.addComponent(pane, l, x, y);
        return l;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String text = ((JRadioButton)evt.getSource()).getText().toLowerCase();
            if (!AppxToolkit.setLook(text, this)) {
                this.updateStat("Unsupported on this platform");
            } else {
                this.updateStat("");
            }
        }
    }

    public UserDialog(AppxMain program, String mode) {
        super("APPX Client Login");
        AppxToolkit.setLook(Globals.getOptionValueString("guiLook"), this);
        this.program = program;
        this.ud = this;
        if (AppxMain.applet != null) {
            mode = "remote";
        }
        File dir = new File(Globals.getOptionValueString("userClientRoot"));
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ini");
            }
        };
        String[] children1 = dir.list(filter);
        Object[] children = new String[children1.length];
        int i = 0;
        while (i < children1.length) {
            children[i] = children1[i].substring(0, children1[i].length() - 4);
            ++i;
        }
        this.pathname = new JTextField(AppxMain.path != null ? AppxMain.path : Globals.getOptionValueString("lastPath"), 20);
        this.username = new JTextField(AppxMain.user != null ? AppxMain.user : Globals.getOptionValueString("lastUser"), 20);
        this.password = new JPasswordField(AppxMain.pass != null ? AppxMain.pass : "", 20);
        this.remotehost = new JTextField(AppxMain.host != null ? AppxMain.host : Globals.getOptionValueString("lastHost"), 20);
        this.portid = new JTextField(AppxMain.port != 0 ? Integer.toString(AppxMain.port) : Globals.getOptionValueString("lastPort"), 20);
        this.reconid = new JTextField(AppxMain.reconid != 0 ? Integer.toString(AppxMain.reconid) : "", 20);
        this.useSSO = new JCheckBox();
        this.useSSO.setSelected(AppxMain.useSSO != null ? AppxMain.useSSO : Globals.getOptionValueBoolean("lastUseSSO"));
        AutoSelectFocusListener autoSelectFocusListener = new AutoSelectFocusListener();
        this.pathname.addFocusListener(autoSelectFocusListener);
        this.username.addFocusListener(autoSelectFocusListener);
        this.password.addFocusListener(autoSelectFocusListener);
        this.remotehost.addFocusListener(autoSelectFocusListener);
        this.portid.addFocusListener(autoSelectFocusListener);
        this.reconid.addFocusListener(autoSelectFocusListener);
        this.spnOptionRows = new JSpinner(new SpinnerNumberModel());
        this.spnOptionRows.setValue(Globals.getOptionValueInteger("screenRows"));
        ((JSpinner.DefaultEditor)this.spnOptionRows.getEditor()).getTextField().addFocusListener(autoSelectFocusListener);
        this.spnOptionCols = new JSpinner(new SpinnerNumberModel());
        this.spnOptionCols.setValue(Globals.getOptionValueInteger("screenColumns"));
        ((JSpinner.DefaultEditor)this.spnOptionCols.getEditor()).getTextField().addFocusListener(autoSelectFocusListener);
        JComboBox<String> cbxGuiLook = new JComboBox<String>(Globals.getGuiLooks());
        cbxGuiLook.setSelectedItem(Globals.getOptionValueString("guiLook"));
        this.oRows = new JSpinner(new SpinnerNumberModel());
        this.oCols = new JSpinner(new SpinnerNumberModel());
        this.oRows.setValue(Globals.getOptionValueInteger("screenRows"));
        this.oCols.setValue(Globals.getOptionValueInteger("screenColumns"));
        LoginActionListener logAct = new LoginActionListener();
        this.msg = new JLabel(" ");
        this.msg.setFocusable(false);
        this.msg.setForeground(Color.blue);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        JButton canButton = new JButton("Cancel");
        canButton.setMnemonic('C');
        canButton.addActionListener(this);
        this.bPanel = new JPanel();
        this.bPanel.setFocusable(false);
        this.bPanel.setLayout(new BorderLayout());
        this.bPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.bPanel.add("East", canButton);
        this.bPanel.add("Center", this.msg);
        cp.add("South", this.bPanel);
        this.tPane = new JTabbedPane(){
            private static final long serialVersionUID = 7888219297776031894L;

            @Override
            public void doLayout() {
                try {
                    super.doLayout();
                }
                catch (Exception e) {
                    System.err.println("JTabbedPane.layout() exception=" + e);
                }
            }
        };
        this.inifile = new JComboBox(children){
            private static final long serialVersionUID = 3068214666919603642L;

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(UserDialog.this.password.getLocation().x, 6, width, height);
            }
        };
        this.tPane.addChangeListener(this);
        this.remPanel = new JPanel();
        this.remPanel.setFocusable(false);
        this.locPanel = new JPanel();
        this.locPanel.setFocusable(false);
        this.optPanel = new JPanel();
        this.optPanel.setFocusable(false);
        this.c = new GridBagConstraints();
        this.locLayout = new GridBagLayout();
        this.remLayout = new GridBagLayout();
        this.optLayout = new GridBagLayout();
        this.remPanel.setLayout(this.remLayout);
        this.locPanel.setLayout(this.locLayout);
        this.optPanel.setLayout(this.optLayout);
        this.remPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.locPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.optPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel lbPan = new JPanel();
        lbPan.setFocusable(false);
        lbPan.setLayout(new FlowLayout(2));
        this.lConn = new JButton("Connect");
        this.lConn.setMnemonic('o');
        this.lConn.addActionListener(logAct);
        lbPan.add(this.lConn);
        JPanel lPan = new JPanel();
        lPan.setFocusable(false);
        lPan.setLayout(new BorderLayout());
        lPan.add("North", this.locPanel);
        lPan.add("South", lbPan);
        JPanel rbPan = new JPanel();
        rbPan.setFocusable(false);
        rbPan.setLayout(new FlowLayout(2));
        this.rConn = new JButton("Connect");
        this.rConn.setMnemonic('o');
        this.rConn.addActionListener(logAct);
        rbPan.add(this.rConn);
        JPanel rPan = new JPanel();
        rPan.setFocusable(false);
        rPan.setLayout(new BorderLayout());
        rPan.add("North", this.remPanel);
        rPan.add("South", rbPan);
        JPanel obPan = new JPanel();
        obPan.setFocusable(false);
        obPan.setLayout(new FlowLayout(2));
        this.oAdv = new JButton("Advanced...");
        this.oAdv.setMnemonic('a');
        this.oAdv.addActionListener(logAct);
        obPan.add(this.oAdv);
        JPanel oPan = new JPanel();
        oPan.setFocusable(false);
        oPan.setLayout(new BorderLayout());
        oPan.add("North", this.optPanel);
        oPan.add("South", obPan);
        if (mode.equalsIgnoreCase("local") || mode.equalsIgnoreCase("both")) {
            this.tPane.addTab("Local", lPan);
        }
        if (mode.equalsIgnoreCase("remote") || mode.equalsIgnoreCase("both")) {
            this.tPane.addTab("Remote", rPan);
        }
        if (Globals.getOptionValueBoolean("showOptionsTab")) {
            this.tPane.addTab("Options", oPan);
        }
        if (this.tPane.getTabCount() == 3 && Globals.getOptionValueString("lastTab") != null && Globals.getOptionValueString("lastTab").equalsIgnoreCase("remote")) {
            this.tPane.setSelectedIndex(1);
        } else {
            this.tPane.setSelectedIndex(0);
        }
        int locRow = 0;
        JButton browseButton = new JButton("Browse");
        browseButton.setMnemonic('b');
        browseButton.addActionListener(new BrowseActionListener());
        Box browsePanel = new Box(0);
        browsePanel.add(Box.createHorizontalGlue());
        browsePanel.add(browseButton);
        this.addComponent(this.locPanel, "Local Engine", 0, locRow);
        this.addComponent(this.locPanel, this.pathname, 1, locRow++);
        this.addComponent(this.locPanel, browsePanel, 1, locRow++);
        int remRow = 0;
        if (!Globals.getOptionValueBoolean("useSSO")) {
            this.addComponent(this.remPanel, "Login", 0, remRow);
            this.addComponent(this.remPanel, this.username, 1, remRow++);
            this.addComponent(this.remPanel, "Password", 0, remRow);
            this.addComponent(this.remPanel, this.password, 1, remRow++);
        } else {
            this.addComponent(this.remPanel, "Login", 0, remRow);
            JTextField sso = new JTextField("(using desktop credentials)", 20);
            sso.setEnabled(false);
            this.addComponent(this.remPanel, sso, 1, remRow++);
        }
        if (AppxMain.host == null) {
            this.addComponent(this.remPanel, "Server", 0, remRow);
            this.addComponent(this.remPanel, this.remotehost, 1, remRow++);
        }
        if (AppxMain.port == 0) {
            this.portid.setText(Globals.getOptionValueString("lastPort"));
            this.addComponent(this.remPanel, "Server Port", 0, remRow);
            this.addComponent(this.remPanel, this.portid, 1, remRow++);
        }
        if (AppxMain.reconid == 0) {
            this.reconid.setText("");
            this.addComponent(this.remPanel, "Reconnect ID", 0, remRow);
            this.addComponent(this.remPanel, this.reconid, 1, remRow++);
        }
        int optRow = 0;
        this.addComponent(this.optPanel, "Rows    ", 0, optRow);
        this.addComponent(this.optPanel, this.spnOptionRows, 1, optRow);
        this.addComponent(this.optPanel, "                                        ", 2, optRow++);
        this.addComponent(this.optPanel, "Columns    ", 0, optRow);
        this.addComponent(this.optPanel, this.spnOptionCols, 1, optRow);
        this.addComponent(this.optPanel, "                                        ", 2, optRow++);
        this.addComponent(this.optPanel, "GUI Look    ", 0, optRow);
        this.addComponent(this.optPanel, cbxGuiLook, 1, optRow++);
        cp.add("Center", this.tPane);
        this.setLocation(Globals.getOptionValueInteger("loginPositionX") + Globals.getGraphicsConfiguration().getBounds().x, Globals.getOptionValueInteger("loginPositionX") + Globals.getGraphicsConfiguration().getBounds().y);
        this.pack();
        this.pathname.addActionListener(logAct);
        this.username.addActionListener(logAct);
        this.password.addActionListener(logAct);
        this.remotehost.addActionListener(logAct);
        this.portid.addActionListener(logAct);
        this.reconid.addActionListener(logAct);
        cbxGuiLook.addActionListener(logAct);
        this.setVisible(true);
        String title = this.tPane.getTitleAt(this.tPane.getSelectedIndex());
        this.getRootPane().setDefaultButton(this.rConn);
        if (title.equalsIgnoreCase("local")) {
            this.getRootPane().setDefaultButton(this.lConn);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UserDialog.this.lConn.requestFocus();
                    UserDialog.this.pathname.requestFocus();
                }
            });
        } else if (title.equalsIgnoreCase("remote")) {
            this.rConn.requestFocus();
            if (this.username.getText().length() == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UserDialog.this.username.requestFocus();
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UserDialog.this.password.requestFocus();
                    }
                });
            }
        }
        Thread initThread = new Thread(){

            @Override
            public void run() {
                AppxResource.Gfx junk = AppxResource.Gfx.ALIGN_BOTTOM;
            }
        };
        initThread.start();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        String title = this.tPane.getTitleAt(this.tPane.getSelectedIndex());
        if (title.equalsIgnoreCase("local")) {
            this.lConn.requestFocus();
            this.pathname.requestFocus();
            this.getRootPane().setDefaultButton(this.lConn);
        } else if (title.equalsIgnoreCase("remote")) {
            this.rConn.requestFocus();
            if (this.username.getText().length() == 0) {
                this.username.requestFocus();
            } else {
                this.password.requestFocus();
            }
            this.getRootPane().setDefaultButton(this.rConn);
        }
    }

    public void updateStat(String str) {
        this.showMsg(str, Color.blue, null);
    }

    private class AutoSelectFocusListener
    implements FocusListener {
        private AutoSelectFocusListener() {
        }

        @Override
        public void focusGained(final FocusEvent evt) {
            if (evt.getComponent() instanceof JTextComponent) {
                if (evt.getComponent() instanceof JFormattedTextField) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextField)evt.getSource()).selectAll();
                        }
                    });
                } else {
                    JTextComponent comp = (JTextComponent)evt.getComponent();
                    comp.selectAll();
                }
            }
        }

        @Override
        public void focusLost(FocusEvent arg0) {
        }
    }

    private class BrowseActionListener
    implements ActionListener {
        private BrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser chooser = new JFileChooser();
            chooser.rescanCurrentDirectory();
            int retVal = chooser.showDialog(UserDialog.this.ud, "Select");
            if (retVal == 0) {
                File newfile = chooser.getSelectedFile();
                UserDialog.this.pathname.setText(newfile.toString());
                UserDialog.this.pathname.requestFocus();
            }
        }
    }

    private class LoginActionListener
    implements ActionListener {
        private LoginActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            boolean connected = false;
            int portnum = 0;
            int reconnum = 0;
            String title = UserDialog.this.tPane.getTitleAt(UserDialog.this.tPane.getSelectedIndex());
            if (title.equalsIgnoreCase("Options")) {
                Object obj = evt.getSource();
                if (obj instanceof JComboBox) {
                    JComboBox jcb = (JComboBox)obj;
                    String newLook = (String)jcb.getSelectedItem();
                    AppxToolkit.setLook(newLook, UserDialog.this.ud);
                    return;
                }
                Globals.launchEditor();
                return;
            }
            if (UserDialog.this.pathname.getText().length() == 0 && title.equalsIgnoreCase("Local")) {
                UserDialog.this.showMsg("APPX Engine Location required", Color.red, UserDialog.this.pathname);
                return;
            }
            if (UserDialog.this.username.getText().length() == 0 && title.equalsIgnoreCase("Remote") && !Globals.getOptionValueBoolean("useSSO")) {
                UserDialog.this.showMsg("Login value is required", Color.red, UserDialog.this.username);
                return;
            }
            if (UserDialog.this.remotehost.getText().length() == 0 && title.equalsIgnoreCase("Remote")) {
                UserDialog.this.showMsg("Server value is required", Color.red, UserDialog.this.remotehost);
                return;
            }
            if (title.equalsIgnoreCase("Remote")) {
                try {
                    portnum = Integer.parseInt(UserDialog.this.portid.getText());
                }
                catch (NumberFormatException e) {
                    UserDialog.this.showMsg("Invalid Server Port value", Color.red, UserDialog.this.portid);
                    return;
                }
                try {
                    if (UserDialog.this.reconid.getText().length() > 0) {
                        reconnum = Integer.parseInt(UserDialog.this.reconid.getText());
                    }
                }
                catch (NumberFormatException e) {
                    UserDialog.this.showMsg("Invalid Reconnect ID value", Color.red, UserDialog.this.reconid);
                    return;
                }
            }
            if (title.equalsIgnoreCase("Local")) {
                AppxMain.user = UserDialog.this.pathname.getText();
                AppxMain.pass = "none";
                AppxMain.host = "invoke";
                AppxMain.port = 8060;
            } else {
                AppxMain.user = UserDialog.this.username.getText();
                AppxMain.pass = new String(UserDialog.this.password.getPassword());
                AppxMain.host = UserDialog.this.remotehost.getText();
                AppxMain.port = portnum;
                AppxMain.reconid = reconnum;
            }
            Globals.setOptionValue("lastPath", UserDialog.this.pathname.getText());
            Globals.setOptionValue("lastUser", UserDialog.this.username.getText());
            Globals.setOptionValue("lastPassword", UserDialog.this.password.getText());
            Globals.setOptionValue("lastHost", UserDialog.this.remotehost.getText());
            Globals.setOptionValue("lastPort", UserDialog.this.portid.getText());
            Globals.setOptionValue("lastIniFile", (String)UserDialog.this.inifile.getSelectedItem());
            Globals.setOptionValue("lastTab", title);
            Globals.setOptionValue("screenRows", ((Number)UserDialog.this.spnOptionRows.getValue()).intValue());
            Globals.setOptionValue("screenColumns", ((Number)UserDialog.this.spnOptionCols.getValue()).intValue());
            Globals.save(null);
            if (title.equals("Local")) {
                Globals.setOptionValue("enginePath", UserDialog.this.pathname.getText());
                if (AppxDebug.isLoggingEnabled()) {
                    System.err.println("Local Engine Path = " + UserDialog.this.pathname.getText());
                }
            } else {
                Globals.setOptionValue("remoteUser", UserDialog.this.username.getText());
                Globals.setOptionValue("remoteHost", UserDialog.this.remotehost.getText());
                Globals.setOptionValue("remotePort", UserDialog.this.portid.getText());
                if (AppxDebug.isLoggingEnabled()) {
                    System.err.println("Remote Host Name  = " + UserDialog.this.remotehost.getText());
                    System.err.println("Remote Host Port  = " + UserDialog.this.portid.getText());
                    System.err.println("Remote User Login = " + UserDialog.this.username.getText());
                }
            }
            UserDialog.this.updateStat("Attempting Connection...");
            connected = UserDialog.this.program.connect(UserDialog.this.ud);
            if (connected) {
                if (AppxDebug.isLoggingEnabled()) {
                    System.err.println("================================================================================");
                    System.err.println("Session Connected");
                    System.err.println("--------------------------------------------------------------------------------");
                }
                if (title.equals("Local")) {
                    Globals.setOptionValue("enginePath", UserDialog.this.pathname.getText());
                    if (AppxDebug.isLoggingEnabled()) {
                        System.err.println("Local Engine Path = " + UserDialog.this.pathname.getText());
                    }
                } else {
                    Globals.setOptionValue("remoteUser", UserDialog.this.username.getText());
                    Globals.setOptionValue("remoteHost", UserDialog.this.remotehost.getText());
                    Globals.setOptionValue("remotePort", UserDialog.this.portid.getText());
                    if (AppxDebug.isLoggingEnabled()) {
                        System.err.println("Remote Host Name  = " + UserDialog.this.remotehost.getText());
                        System.err.println("Remote Host Port  = " + UserDialog.this.portid.getText());
                        System.err.println("Remote User Login = " + UserDialog.this.username.getText());
                    }
                }
                if (AppxDebug.isLoggingEnabled()) {
                    System.err.println("Client Cache Path = " + Globals.getOptionValueString("cachePath"));
                }
                UserDialog.this.setVisible(false);
                UserDialog.this.remove(UserDialog.this.password);
                UserDialog.this.dispose();
            }
        }
    }
}

