/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxResource;
import doc.Globals;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JToolBar;
import view.CharView;
import view.Display;

class PrintOnScreenPanel
extends JToolBar {
    private static final long serialVersionUID = 4967328152008391500L;
    private ActionListener actHandler;
    private KeyListener keyHandler;
    private ItemListener itmHandler;
    private CharView view;
    private Display display;
    private JCheckBox print;
    private Rectangle bounds;

    private void addToToolBar(String tip, Icon img, int opt) {
        if (img == null) {
            this.addSeparator();
        } else {
            JButton button = new JButton(img);
            button.setMargin(Globals.zeroInsets);
            button.setToolTipText(tip);
            button.addActionListener(this.actHandler);
            button.setActionCommand(Integer.toString(opt));
            button.addKeyListener(this.keyHandler);
            this.add(button);
        }
    }

    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        return new Point(0 - this.view.boxInsets.left, this.display.getSize().height + this.view.boxInsets.bottom - this.getPreferredSize().height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dm = new Dimension(this.display.getSize().width + this.view.boxInsets.left + this.view.boxInsets.right, this.view.boxInsets.bottom - 2);
        if (dm.height > super.getPreferredSize().height) {
            dm.height = super.getPreferredSize().height;
        }
        return dm;
    }

    public boolean getPrintFlag() {
        return this.print.isSelected();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public PrintOnScreenPanel(CharView vw, Display disp) {
        this.setMargin(Globals.zeroInsets);
        this.bounds = new Rectangle(0, 0, 0, 0);
        this.view = vw;
        this.display = disp;
        this.actHandler = this.view;
        this.keyHandler = this.view;
        this.itmHandler = this.view;
        this.makeToolbar();
        this.doLayout();
    }

    private void makeToolbar() {
        this.addKeyListener(this.keyHandler);
        this.addToToolBar("Pan Left Margin", AppxResource.Gfx.PAN_LEFT_MARGIN.icon(), 10002);
        this.addToToolBar("Pan Screen Left", AppxResource.Gfx.PAN_LEFT_SCREEN.icon(), 10009);
        this.addToToolBar("Pan Column Left", AppxResource.Gfx.PAN_LEFT.icon(), 10008);
        this.addToToolBar("Pan Column Right", AppxResource.Gfx.PAN_RIGHT.icon(), 10010);
        this.addToToolBar("Pan Screen Right", AppxResource.Gfx.PAN_RIGHT_SCREEN.icon(), 10011);
        this.addToToolBar("Pan Right Margin", AppxResource.Gfx.PAN_RIGHT_MARGIN.icon(), 10003);
        this.addToToolBar(null, null, 0);
        this.addToToolBar("Scroll Top of Page", AppxResource.Gfx.SCROLL_FIRST_ICON.icon(), 320);
        this.addToToolBar("Scroll Screen Up", AppxResource.Gfx.SCROLL_PREV_ICON.icon(), 322);
        this.addToToolBar("Scroll Line Up", AppxResource.Gfx.SCROLL_DOWN_ICON.icon(), 324);
        this.addToToolBar("Scroll Line Down", AppxResource.Gfx.SCROLL_UP_ICON.icon(), 325);
        this.addToToolBar("Scroll Screen Down", AppxResource.Gfx.SCROLL_NEXT_ICON.icon(), 323);
        this.addToToolBar("Scroll Bottom of Page", AppxResource.Gfx.SCROLL_LAST_ICON.icon(), 321);
        this.addToToolBar(null, null, 0);
        this.addToToolBar("Search", AppxResource.Gfx.SEARCH_ICON.icon(), 257);
        this.addToToolBar(null, null, 0);
        this.print = new JCheckBox("Print?");
        this.print.setHorizontalTextPosition(2);
        this.print.addItemListener(this.itmHandler);
        this.add(this.print);
        this.addToToolBar(null, null, 0);
        JButton close = new JButton("Close");
        close.setToolTipText("Close the Report Viewer");
        close.addActionListener(this.actHandler);
        close.setActionCommand(Integer.toString(274));
        this.add(close);
        this.setFloatable(false);
    }

    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
        this.setBounds(new Rectangle(this.getLocation().x, this.getLocation().y, this.getPreferredSize().width, this.getPreferredSize().height));
        this.doLayout();
    }

    public void setPrintFlag(boolean pFlag) {
        this.print.setSelected(pFlag);
    }
}

