/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxToolkit;
import doc.Document;
import doc.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxControl;
import view.AppxControlCache;
import view.AppxControlUtils;
import view.AppxOval3DBorder;
import view.AppxScaledResource;
import view.CharView;
import view.Display;

public class MenuButton
extends JButton
implements AppxControl,
AppxControlCache,
AppxScaledResource,
AppxAntiAliasControl {
    private static final long serialVersionUID = 2929987026110834893L;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/MenuButton.java,v 1.1.2.29 2013/10/02 18:52:00 pete Exp $";
    public static final int WIDGET_TYPE_BUTTON = 1;
    public static final int WIDGET_TYPE_LABEL = 2;
    public static final int WIDGET_TYPE_PICTURE = 3;
    public Display parent;
    private boolean contentAreaFilled = true;
    private boolean defaultButton = false;
    private int mouseTracker = 0;
    private int widgetType = 1;
    private int imageScale = -1;
    private Rectangle bounds;
    private Rectangle offset;
    private Color disabledBg;
    private Color disabledFg;
    private Color enabledBg;
    private Color enabledFg;
    private Color rolloverBg;
    private Color rolloverFg;
    private String movableCommand = null;
    private Border borderSave;
    private AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();
    private boolean movable = false;
    private boolean moved = false;

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }

    public MenuButton() {
        this.setDefaultCapable(true);
        this.addMouseMotionListener(CharView.view);
        this.addMouseListener(CharView.view);
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    private void drawNumericShortcut(Graphics g) {
        Font font = this.parent.getView().footnoteFont;
        FontMetrics ffm = this.getFontMetrics(font);
        g.setFont(font);
        g.setColor(this.getForeground());
        g.drawString(this.getActionCommand(), this.getPreferredSize().width - ffm.stringWidth(this.getActionCommand()) - 3, this.getPreferredSize().height - ffm.getAscent() + 5);
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    public Color getDisabledBackground() {
        return this.disabledBg;
    }

    public Color getDisabledForeground() {
        return this.disabledFg;
    }

    @Override
    public Insets getInsets() {
        Border b = this.getBorder();
        if (b != null) {
            if (b instanceof UIResource) {
                return b.getBorderInsets(this);
            }
            Insets ins = b.getBorderInsets(this);
            Insets mrg = this.getMargin();
            if (mrg != null) {
                ins.left += mrg.left;
                ins.right += mrg.right;
                ins.top += mrg.top;
                ins.bottom += mrg.bottom;
            }
            return ins;
        }
        return super.getInsets();
    }

    @Override
    public Point getLocation() {
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.bounds.width == 1 && this.bounds.height == 1) {
            return super.getPreferredSize();
        }
        if (AppxToolkit.isWebLook()) {
            return new Dimension(this.bounds.width * CharView.charWidth + this.offset.width - 1, this.bounds.height * CharView.charHeight + this.offset.height - 1);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    public Color getRolloverBackground() {
        return this.rolloverBg;
    }

    public Color getRolloverForeground() {
        return this.rolloverFg;
    }

    public int getWidgetType() {
        return this.widgetType;
    }

    @Override
    public void initControl(Display prnt, int x, int y, int w, int h, boolean ucs) {
        if (this.getModel() != null) {
            this.getModel().setPressed(false);
        }
        this.defaultButton = false;
        this.parent = prnt;
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.bounds = new Rectangle(x, y, w, h);
        this.offset = new Rectangle(0, 0, 0, 0);
        this.setAntiAlias(false);
        this.setMargin(Globals.zeroInsets);
        this.imageScale = -1;
        if (this.parent != null && AppxToolkit.isWebLook()) {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBackground(this.parent.getView().buttonBgColor);
            this.setForeground(this.parent.getView().buttonFgColor);
        }
    }

    @Override
    public boolean isDefaultButton() {
        return this.defaultButton;
    }

    public boolean isFocusTransversable() {
        return true;
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isTouched() {
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.antiAlias.adjustGraphics((Graphics2D)g);
        AppxControlUtils.paintUiComponent(this, g, this.contentAreaFilled);
        super.paintComponent(g);
        try {
            if (Globals.getOptionValueBoolean("showOptionNumbers") && this.getActionCommand() != null && this.getActionCommand().length() > 0 && Integer.parseInt(this.getActionCommand()) < 256) {
                this.drawNumericShortcut(g);
            }
        }
        catch (Exception e) {
            System.err.println("MenuButton.paintComponent() Exception=" + e);
        }
        this.antiAlias.restoreGraphics((Graphics2D)g);
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled() || Document.isLocked() || Document.isGotTimeout()) {
            e.consume();
            return;
        }
        int id = e.getID();
        switch (id) {
            case 501: {
                this.mouseTracker = 0;
                CharView.view.mousePressed(e);
                this.borderSave = this.getBorder();
                if (this.borderSave instanceof BevelBorder) {
                    BevelBorder b = (BevelBorder)this.borderSave;
                    if (b.getBevelType() == 0) {
                        this.setBorder(BorderFactory.createBevelBorder(1, b.getHighlightInnerColor(), b.getHighlightOuterColor(), b.getShadowInnerColor(), b.getShadowOuterColor()));
                        break;
                    }
                    this.borderSave = null;
                    break;
                }
                this.borderSave = null;
                break;
            }
            case 502: {
                this.mouseTracker = 0;
                if (this.borderSave == null) break;
                this.setBorder(this.borderSave);
                this.borderSave = null;
                break;
            }
            case 500: {
                JMenuBar jmb = this.parent.getView().getJMenuBar();
                if (jmb != null && jmb.isSelected()) {
                    e.consume();
                    jmb.setSelected(this.parent.getView());
                    return;
                }
                if (this.mouseTracker != 1) break;
                this.doClick();
                this.mouseTracker = 2;
                break;
            }
            case 505: {
                this.mouseTracker = 0;
                if (this.enabledFg != null) {
                    super.setForeground(this.enabledFg);
                }
                if (this.enabledBg != null) {
                    super.setBackground(this.enabledBg);
                }
                if (this.borderSave == null) break;
                this.setBorder(this.borderSave);
                this.borderSave = null;
                break;
            }
            case 504: {
                this.mouseTracker = 1;
                if (this.isEnabled() && this.rolloverFg != null) {
                    super.setForeground(this.rolloverFg);
                }
                if (!this.isEnabled() || this.rolloverBg == null) break;
                super.setBackground(this.rolloverBg);
            }
        }
        if (this.mouseTracker != 2) {
            if (id != 500 && id != 501 || this.contains(e.getX(), e.getY())) {
                super.processMouseEvent(e);
            }
        } else {
            this.mouseTracker = 0;
        }
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        this.parent.getView().setLostFocusCommand(65535, 65535, null);
        super.fireActionPerformed(event);
    }

    public void setValueAdjustedCommand(String action) {
        this.setActionCommand(action);
    }

    @Override
    public void setActionCommand(String action) {
        if (this.getActionCommand() == null || !this.getActionCommand().equals(action)) {
            super.setActionCommand(action);
        }
    }

    public void setActionCommand2(String s) {
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
    }

    @Override
    public void setBackground(Color c) {
        this.enabledBg = c;
        super.setBackground(c);
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(b);
        if (!Globals.getOptionValueBoolean("showButtonFocus") && b instanceof EmptyBorder) {
            this.setFocusPainted(false);
        }
        if (b instanceof AppxOval3DBorder) {
            this.contentAreaFilled = this.isOpaque();
            super.setOpaque(false);
        }
    }

    @Override
    public void setBorderPainted(boolean painted) {
        if (this.isBorderPainted() != painted) {
            super.setBorderPainted(painted);
        }
        this.setFocusPainted(painted);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellLocation(int x, int y) {
        if (this.bounds != null) {
            this.bounds.x = x + this.parent.getCellBounds().x;
            this.bounds.y = y + this.parent.getCellBounds().y;
        }
    }

    public void setCellSize(int width, int height) {
        if (this.bounds != null) {
            this.bounds.width = width;
            this.bounds.height = height;
        }
    }

    @Override
    public void setContentAreaFilled(boolean filled) {
        if (this.isOpaque() != filled) {
            super.setOpaque(filled);
        }
    }

    public void setDefaultButton(boolean b) {
        this.defaultButton = b;
    }

    public void setDisabledBackground(Color c) {
        this.disabledBg = c;
        if (this.enabledBg == null) {
            this.enabledBg = this.getBackground();
        }
    }

    public void setDisabledForeground(Color c) {
        this.disabledFg = c;
        if (this.enabledFg == null) {
            this.enabledFg = this.getForeground();
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        if (this.isEnabled() != enable) {
            super.setEnabled(enable);
        }
        if (this.isEnabled()) {
            if (this.enabledFg != null) {
                super.setForeground(this.enabledFg);
            }
            if (this.enabledBg != null) {
                super.setBackground(this.enabledBg);
            }
        } else {
            if (this.disabledFg != null) {
                super.setForeground(this.disabledFg);
            }
            if (this.disabledBg != null) {
                super.setBackground(this.disabledBg);
            }
        }
    }

    @Override
    public void setFocusPainted(boolean painted) {
        if (this.isFocusPainted() != painted) {
            super.setFocusPainted(painted);
        }
    }

    public void setFontSize(int s) {
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), f.getStyle(), (int)((double)s * 0.86)));
    }

    @Override
    public void setForeground(Color c) {
        this.enabledFg = c;
        super.setForeground(c);
    }

    @Override
    public void setMargin(Insets ins) {
        if (this.getMargin() != null && !this.getMargin().equals(ins)) {
            super.setMargin(ins);
        } else if (this.getMargin() == null) {
            super.setMargin(ins);
        }
    }

    public void setOffset(int x, int y, int width, int height) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.width = width;
        this.offset.height = height;
    }

    @Override
    public void setOffset(Rectangle rect) {
        if (rect == null) {
            this.setOffset(0, 0, 0, 0);
        } else {
            this.setOffset(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void setOpaque(boolean b) {
        super.setOpaque(b);
        super.setContentAreaFilled(b);
    }

    public void setRolloverBackground(Color c) {
        this.rolloverBg = c;
        if (this.enabledBg == null) {
            this.enabledBg = this.getBackground();
        }
    }

    public void setRolloverForeground(Color c) {
        this.rolloverFg = c;
        if (this.enabledFg == null) {
            this.enabledFg = this.getForeground();
        }
    }

    public void setTilingMode(int tileMode) {
    }

    @Override
    public void setTouched(boolean touch) {
    }

    public void setWallpaperImage(Image str) {
        Thread.dumpStack();
    }

    public void setWidgetType(int type) {
        this.widgetType = type;
    }

    @Override
    public void updateOptions(AppxControlCache options) {
        MenuButton op = (MenuButton)options;
        this.setActionCommand(op.getActionCommand());
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setRolloverBackground(op.getRolloverBackground());
        this.setRolloverForeground(op.getRolloverForeground());
        this.setDisabledBackground(op.getDisabledBackground());
        this.setDisabledForeground(op.getDisabledForeground());
        this.setFont(op.getFont());
        this.setRolloverEnabled(op.isRolloverEnabled());
        this.setRolloverIcon(op.getRolloverIcon());
        this.setDisabledIcon(op.getDisabledIcon());
        this.setRolloverSelectedIcon(op.getRolloverSelectedIcon());
        this.setPressedIcon(op.getPressedIcon());
        this.setSelectedIcon(op.getSelectedIcon());
        this.setIcon(op.getIcon());
        this.setText(op.getText());
        this.setSelected(op.isSelected());
        this.setBorder(op.getBorder());
        this.setBorderPainted(op.isBorderPainted());
        this.setFocusPainted(op.isFocusPainted());
        this.setEnabled(op.isEnabled());
        this.setContentAreaFilled(op.isOpaque());
        this.setHorizontalAlignment(op.getHorizontalAlignment());
        this.setVerticalAlignment(op.getVerticalAlignment());
        this.setHorizontalTextPosition(op.getHorizontalTextPosition());
        this.setVerticalTextPosition(op.getVerticalTextPosition());
        this.setMnemonic(op.getMnemonic());
        this.setMargin(op.getMargin());
        this.setOffset(op.getOffset());
        this.setImageScale(op.getImageScale());
        this.setScaleType(op.getScaleType());
        this.setMovable(op.isMovable());
        this.setMoved(op.isMoved());
        this.getModel().setRollover(false);
    }

    @Override
    public int getImageScale() {
        return this.imageScale;
    }

    @Override
    public int getScaleBaseHeight() {
        if (this.getScaleType() == 1) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm != null) {
                return fm.getAscent() - fm.getDescent();
            }
            return CharView.charHeight;
        }
        return this.getPreferredSize().height;
    }

    @Override
    public int getScaleType() {
        return 1;
    }

    @Override
    public void setScaleType(int type) {
    }

    @Override
    public void setImageScale(int scale) {
        this.imageScale = scale;
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    public boolean isMoved() {
        return this.moved;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    public void setMoved(boolean b) {
        this.moved = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (this.getBackground() != null && this.getBackground().getAlpha() < 255) {
            this.parent.repaint();
        }
        super.repaint(tm, x, y, width, height);
    }

    public void setMovableCommand(String cmd) {
        this.movableCommand = cmd;
    }

    public String getMovableCommand() {
        return this.movableCommand;
    }
}

