/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.text.StringCharacterIterator;
import view.CharView;

public class MaskEngine {
    public static final int texttype = 0;
    public static final int numbtype = 1;
    public static final int datetype = 2;
    public static final int timetype = 3;
    String _mask = "";
    int _maskLength = 0;
    int _datatype = 0;
    int _filterCount = 0;
    int _maskCount = 0;
    int _firstFilterPos = 0;
    int _lastFilterPos = 0;
    int[] _filterPositions;
    int[] _commandCorrections;
    boolean _inRange = true;
    boolean _spaceIgnored = false;
    boolean _includeLiterals = false;
    int _curMaskPos = 0;
    int _nextMaskPos = 0;
    int _curMaskType = 0;
    char _curMaskChar = '\u0000';
    char _lastMaskChar = '\u0000';
    int _commandCorrection = 0;
    int _shiftState = 0;
    char _decimalPoint = (char)46;
    static final int nulltype = 0;
    static final int filtertype = 1;
    static final int literaltype = 2;
    static final int eShiftNul = 0;
    static final int eShiftUpper = 1;
    static final int eShiftLower = 2;
    private boolean debug = false;

    boolean clearSelectedText(int selStart, int selEnd, StringBuffer newData) {
        if (selEnd > selStart) {
            int curMaskPos = this._curMaskPos;
            int nextMaskPos = this._nextMaskPos;
            int curMaskType = this._curMaskType;
            char curMaskChar = this._curMaskChar;
            char lastMaskChar = this._lastMaskChar;
            char decimalPoint = this._decimalPoint;
            int commandCorrection = this._commandCorrection;
            int shiftState = this._shiftState;
            this.setMaskPos(selStart);
            int outpos = selStart;
            char c = this._curMaskChar;
            while (outpos < selEnd && c != '\u0000') {
                if (this._curMaskType == 1) {
                    c = '_';
                }
                newData.setCharAt(outpos++, c);
                c = this.getNextMaskChar();
            }
            this._curMaskPos = curMaskPos;
            this._nextMaskPos = nextMaskPos;
            this._curMaskType = curMaskType;
            this._curMaskChar = curMaskChar;
            this._lastMaskChar = lastMaskChar;
            this._decimalPoint = decimalPoint;
            this._commandCorrection = commandCorrection;
            this._shiftState = shiftState;
            return true;
        }
        return false;
    }

    public String cut(String data, int selStart, int selEnd, StringBuffer newData) {
        newData.append(data);
        this.setMaskPos(selStart);
        this.clearSelectedText(selStart, selEnd, newData);
        return data.substring(selStart, selEnd);
    }

    public int getDatatype() {
        return this._datatype;
    }

    public String getMask() {
        return this._mask;
    }

    public String getMatchedText(String t) {
        if (this.debug) {
            System.out.println("Input text : " + t);
        }
        StringBuffer retString = new StringBuffer();
        if (t != null && t.length() > 0) {
            String mask = this.getMask();
            if (mask.length() > 0) {
                int textCharCounter = 0;
                StringCharacterIterator maskIterator = new StringCharacterIterator(mask);
                do {
                    char textChar = '_';
                    char maskChar = maskIterator.current();
                    if (maskChar == '>') {
                        maskIterator.next();
                        maskChar = maskIterator.current();
                    }
                    if (textCharCounter < t.length()) {
                        textChar = t.charAt(textCharCounter);
                        if (this.isFilter(maskChar)) {
                            if (this.matchFilter(textChar, maskChar) && textChar != ' ') {
                                retString.append(textChar);
                            } else {
                                retString.append('_');
                            }
                        } else if (this.isCommand(maskChar)) {
                            maskIterator.next();
                            if (maskChar == '>') {
                                if (this.matchFilter(textChar, maskIterator.current())) {
                                    retString.append(Character.toUpperCase(textChar));
                                } else {
                                    retString.append('_');
                                }
                            } else if (maskChar == '<') {
                                if (this.matchFilter(textChar, maskIterator.current())) {
                                    retString.append(Character.toLowerCase(textChar));
                                } else {
                                    retString.append('_');
                                }
                            } else {
                                retString.append(maskIterator.current());
                            }
                        } else {
                            retString.append(maskChar);
                        }
                    } else {
                        retString.append('_');
                    }
                    ++textCharCounter;
                } while (maskIterator.next() != '\uffff');
            } else {
                retString.append(t);
            }
        }
        if (this.debug) {
            System.out.println("Output text : " + retString);
        }
        return retString.toString();
    }

    char getNextMaskChar() {
        while (true) {
            if (this._nextMaskPos >= this._maskLength) {
                return '\u0000';
            }
            this._lastMaskChar = this._curMaskChar;
            this._curMaskChar = this._mask.charAt(this._nextMaskPos++);
            if (!this.isCommand()) break;
            ++this._commandCorrection;
            if ('<' == this._curMaskChar) {
                this._shiftState = 2;
                continue;
            }
            if ('>' != this._curMaskChar) continue;
            this._shiftState = 1;
        }
        this._curMaskType = 2;
        if (this._lastMaskChar != '\\' && this.isFilter()) {
            this._curMaskType = 1;
        }
        this._curMaskPos = this._nextMaskPos - 1;
        return this._curMaskChar;
    }

    public int initDisplay(String data, StringBuffer newData) {
        char c;
        if (this._filterCount == 0) {
            newData.append(data);
            return 0;
        }
        int datalen = data.length();
        int inpos = 0;
        boolean zerofill = false;
        boolean dataRightOfDecimal = false;
        boolean maskRightOfDecimal = false;
        this.resetMaskScan();
        int i = 0;
        while ((c = this.getNextMaskChar()) != '\u0000') {
            if (this._curMaskType == 1) {
                char z;
                char c2 = z = zerofill ? (char)'0' : '_';
                if (inpos < datalen) {
                    c = data.charAt(inpos++);
                    if (1 == this._datatype) {
                        if (this._decimalPoint == c) {
                            c = z;
                            dataRightOfDecimal = true;
                            if (maskRightOfDecimal && inpos < datalen) {
                                c = data.charAt(inpos++);
                            }
                        } else if (dataRightOfDecimal && !maskRightOfDecimal) {
                            c = z;
                            --inpos;
                        } else if (!dataRightOfDecimal && maskRightOfDecimal) {
                            c = z;
                            while (inpos < datalen) {
                                if (this._decimalPoint != data.charAt(inpos++)) continue;
                                if (inpos < datalen) {
                                    c = data.charAt(inpos++);
                                }
                                dataRightOfDecimal = true;
                                break;
                            }
                        }
                    }
                } else {
                    c = z;
                }
            } else if (this._curMaskChar == this._decimalPoint && 1 == this._datatype) {
                maskRightOfDecimal = true;
                if (datalen == 0) {
                    zerofill = true;
                    newData.setCharAt(newData.length() - 1, '0');
                } else if (inpos < datalen && data.charAt(inpos) == this._decimalPoint) {
                    ++inpos;
                    dataRightOfDecimal = true;
                }
            }
            newData.append(c);
            ++i;
        }
        if (1 == this._datatype && datalen == 0 && !zerofill && this._maskLength > 0) {
            newData.setCharAt(newData.length() - 1, '0');
        }
        return this._filterPositions[0] - this._commandCorrections[0];
    }

    void init() {
    }

    boolean isCommand(char c) {
        return -1 != "<>\\".indexOf(c);
    }

    boolean isCommand() {
        return this.isCommand(this._curMaskChar);
    }

    boolean isFilter(char c) {
        return -1 != "09#aAL?&C".indexOf(c);
    }

    boolean isFilter() {
        return this.isFilter(this._curMaskChar);
    }

    public boolean isHandledKey(KeyEvent e) {
        if (this._maskLength == 0) {
            return false;
        }
        if (e.getID() == 400) {
            char c = e.getKeyChar();
            return c != '\n';
        }
        char r = e.getKeyChar();
        char k = e.getKeyChar();
        int c = e.getKeyCode();
        if ((short)e.getKeyChar() == -1) {
            k = (char)c;
        }
        if (Character.isISOControl(k)) {
            if (c == CharView.view.getTabSpecialKeyId()) {
                return true;
            }
            switch (c) {
                case 35: 
                case 36: 
                case 37: 
                case 39: {
                    return !e.isShiftDown();
                }
                case 8: 
                case 9: 
                case 127: {
                    return true;
                }
            }
            return false;
        }
        return Character.isLetterOrDigit(r) || Character.isSpaceChar(r);
    }

    public boolean isIncludeLiterals() {
        return this._includeLiterals;
    }

    boolean isMandatory(char c) {
        return -1 != "0LA&".indexOf(c);
    }

    boolean isMandatory() {
        return this.isMandatory(this._curMaskChar);
    }

    boolean isNavKey(int key) {
        switch (key) {
            default: {
                return false;
            }
            case 8: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
        }
        return true;
    }

    public boolean isSpaceIgnored() {
        return this._spaceIgnored;
    }

    public int lastFilterPosition() {
        int rawLastPosition;
        int lastPosition = rawLastPosition = this._filterPositions[this._filterPositions.length - 1];
        int characterIndex = 0;
        while (characterIndex <= rawLastPosition) {
            if (this.isCommand(this.getMask().charAt(characterIndex))) {
                --lastPosition;
            }
            ++characterIndex;
        }
        return lastPosition;
    }

    public MaskEngine(String mask, int datatype) {
        this.init();
        this.setMask(mask);
        this.setDatatype(datatype);
    }

    boolean matchFilter(char key, char maskChar) {
        switch (maskChar) {
            case '0': {
                return Character.isDigit(key);
            }
            case '9': {
                return Character.isDigit(key) || Character.isSpaceChar(key);
            }
            case '#': {
                return Character.isDigit(key) || Character.isSpaceChar(key) || key == '+' || key == '-';
            }
            case '?': 
            case 'L': {
                return Character.isLetter(key);
            }
            case 'A': 
            case 'a': {
                return Character.isLetterOrDigit(key);
            }
            case '&': 
            case 'C': {
                return !Character.isIdentifierIgnorable(key);
            }
        }
        return false;
    }

    boolean matchFilter(char key) {
        return this.matchFilter(key, this._curMaskChar);
    }

    int nextFilterPos() {
        while (this.getNextMaskChar() != '\u0000') {
            if (this._curMaskType != 1) continue;
            return this._curMaskPos - this._commandCorrection;
        }
        return -1;
    }

    public int paste(String data, String pasteData, int pos, StringBuffer newData, int selStart, int selEnd) {
        boolean hasSelection;
        boolean bl = hasSelection = selStart < selEnd;
        if (hasSelection) {
            pos = selStart;
        }
        if (!this.setMaskPos(pos)) {
            return -1;
        }
        StringBuffer sb = new StringBuffer(data);
        int len = pasteData.length();
        KeyEvent e = new KeyEvent(new TextField(), 0, 0L, 0, 0, '\u0000');
        String s = new String(sb.toString());
        int newpos = pos;
        int i = 0;
        while (i < len) {
            char c = pasteData.charAt(i);
            e.setKeyChar(c);
            e.setKeyCode(c);
            sb = new StringBuffer();
            int selstart = 0;
            int selend = 0;
            if (hasSelection && newpos >= selStart && newpos < selEnd) {
                if (i == 0) {
                    selstart = selStart;
                    selend = selEnd;
                } else {
                    selstart = newpos;
                    selend = newpos + 1;
                }
            }
            if ((newpos = this.processKey(e, newpos, s, sb, selstart, selend)) == -1 || newpos == -2) break;
            s = sb.toString();
            ++i;
        }
        newData.append(s);
        return newpos;
    }

    int prevFilterPos() {
        int oldPos = this._curMaskPos;
        this.resetMaskScan();
        int prevFilterPos = -1;
        int prevCommandCorrection = 0;
        while (this.nextFilterPos() != -1) {
            if (this._curMaskPos >= oldPos) {
                if (this._inRange) break;
                return this._curMaskPos - this._commandCorrection;
            }
            prevFilterPos = this._curMaskPos;
            prevCommandCorrection = this._commandCorrection;
        }
        return prevFilterPos - prevCommandCorrection;
    }

    public int processKey(KeyEvent e, int pos, String data, StringBuffer newData, int selStart, int selEnd) {
        newData.append(data);
        int keyCode = e.getKeyCode();
        if (!this.setMaskPos(pos) && !this.isNavKey(keyCode) && selEnd > selStart) {
            pos = selStart;
            this.setMaskPos(pos);
            if (!this.isFilter()) {
                pos = this.nextFilterPos();
            }
        }
        if (!this.setMaskPos(pos) && !this.isNavKey(keyCode)) {
            return -1;
        }
        char key = e.getKeyChar();
        if (key == this._decimalPoint && this._datatype == 1) {
            while (this.getNextMaskChar() != '\u0000') {
                if (this._curMaskChar != this._decimalPoint) continue;
                return this.nextFilterPos();
            }
            return pos;
        }
        if (1 != this._curMaskType) {
            if (pos == 0 && selStart == 0 && selEnd > this._firstFilterPos) {
                pos = this._firstFilterPos;
                this.setMaskPos(pos);
            } else if (!this.isNavKey(keyCode)) {
                if (pos > this._lastFilterPos) {
                    return -1;
                }
                this.nextFilterPos();
                pos = this._curMaskPos - this._commandCorrection;
            }
        }
        switch (keyCode) {
            case 8: {
                if (selStart < selEnd && (pos != selStart || selEnd - selStart > 1)) {
                    this.clearSelectedText(selStart, selEnd, newData);
                    return Math.max(selStart, this._firstFilterPos);
                }
                int newPos = this.prevFilterPos();
                if (pos > 0 && newPos != -1) {
                    newData.setCharAt(newPos, '_');
                }
                return newPos != -1 ? newPos : pos;
            }
            case 127: {
                if (selStart < selEnd) {
                    this.clearSelectedText(selStart, selEnd, newData);
                    return Math.max(selStart, this._firstFilterPos);
                }
                newData.setCharAt(pos, '_');
                return pos;
            }
            case 37: {
                return this.prevFilterPos();
            }
            case 39: {
                return this.nextFilterPos();
            }
            case 36: {
                return this._filterPositions[0] - this._commandCorrections[0];
            }
            case 35: {
                return this._filterPositions[this._filterCount - 1] - this._commandCorrections[this._filterCount - 1];
            }
            case 9: {
                if (this.getNextMaskChar() == '\u0000') break;
                return this.nextFilterPos();
            }
        }
        if (keyCode == CharView.view.getTabSpecialKeyId() && this.getNextMaskChar() != '\u0000') {
            return this.nextFilterPos();
        }
        if (this.matchFilter(key)) {
            this.clearSelectedText(selStart, selEnd, newData);
            if (2 == this._shiftState) {
                key = Character.toLowerCase(key);
            } else if (1 == this._shiftState) {
                key = Character.toUpperCase(key);
            }
            newData.setCharAt(pos, key);
            int newpos = this.nextFilterPos();
            return newpos == -1 ? (this.lastFilterPosition() + 1) * -1 - 3 : newpos;
        }
        return -2;
    }

    void resetMaskScan() {
        this._curMaskPos = 0;
        this._nextMaskPos = 0;
        this._lastMaskChar = '\u0000';
        this._commandCorrection = 0;
        this._curMaskType = 0;
        this._shiftState = 0;
    }

    public void setDatatype(int datatype) {
        this._datatype = datatype;
    }

    public void setIncludeLiterals(boolean includeLiterals) {
        this._includeLiterals = includeLiterals;
    }

    public void setMask(String mask) {
        if (mask.trim().equals("")) {
            return;
        }
        this._mask = mask;
        this._maskLength = mask.length();
        this._filterCount = 0;
        this.resetMaskScan();
        this._maskCount = 0;
        while (this.getNextMaskChar() != '\u0000') {
            if (this._curMaskType == 1) {
                ++this._filterCount;
                this._lastFilterPos = this._curMaskPos;
            }
            if (1 == this._filterCount) {
                this._firstFilterPos = this._curMaskPos;
            }
            ++this._maskCount;
        }
        if (this._maskCount * this._filterCount == 0) {
            return;
        }
        this._filterPositions = new int[this._filterCount];
        this._commandCorrections = new int[this._filterCount];
        this.resetMaskScan();
        int i = 0;
        int j = 0;
        while (i < this._maskCount) {
            this.getNextMaskChar();
            if (this._curMaskType == 1) {
                this._filterPositions[j] = this._curMaskPos;
                this._commandCorrections[j++] = this._commandCorrection;
            }
            ++i;
        }
    }

    boolean setMaskPos(int pos) {
        if (pos < 0) {
            return false;
        }
        this.resetMaskScan();
        this._inRange = true;
        while (pos-- >= 0) {
            if (this.getNextMaskChar() != '\u0000') continue;
            this._inRange = false;
            return false;
        }
        return true;
    }

    public void setSpaceIgnored(boolean spaceIgnored) {
        this._spaceIgnored = spaceIgnored;
    }

    public boolean stripMask(String data, StringBuffer newData) {
        if (this._maskLength == 0) {
            newData.append(data);
            return true;
        }
        this.resetMaskScan();
        boolean retval = true;
        int i = 0;
        while (this.getNextMaskChar() != '\u0000') {
            if (i > data.length() - 1) {
                retval = false;
                break;
            }
            char c = data.charAt(i);
            if (this._curMaskType == 1) {
                if (c != '_') {
                    if (!this._spaceIgnored || c != ' ') {
                        newData.append(c);
                    }
                } else if (this.isMandatory()) {
                    retval = false;
                }
            } else if (this._curMaskChar == this._decimalPoint && this._datatype == 1) {
                newData.append(this._decimalPoint);
            } else if (this._curMaskType == 2 && this._includeLiterals) {
                newData.append(c);
            }
            ++i;
        }
        return retval;
    }

    public MaskEngine() {
        this.init();
    }
}

