/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxToolkit;
import doc.Globals;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedPlainDocument
extends PlainDocument {
    private static final long serialVersionUID = 4417725342435659404L;
    int maxCharacters;
    int charCase;
    public static final int CASE_LOWER = 1;
    public static final int CASE_UPPER = 2;
    public static final int CASE_MIXED = 3;

    public LimitedPlainDocument(int maxChars, boolean upperCase) {
        this(maxChars, upperCase ? 2 : 3);
    }

    public LimitedPlainDocument(int maxChars, int casePref) {
        this.maxCharacters = maxChars;
        this.charCase = casePref;
    }

    public void setUpperCase() {
        this.charCase = 2;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    @Override
    public void insertString(int offs, String strRaw, AttributeSet a) throws BadLocationException {
        byte[] newBytes;
        String string;
        switch (this.charCase) {
            case 1: {
                string = strRaw.toLowerCase();
                break;
            }
            case 2: {
                string = strRaw.toUpperCase();
                break;
            }
            default: {
                string = strRaw;
            }
        }
        String str = string;
        int curLen = super.getText(0, this.getLength()).length();
        int newLen = str.length();
        if (Globals.getOptionValueBoolean("inputByteLengthCheck")) {
            byte[] curBytes = AppxToolkit.stringToBytes(super.getText(0, this.getLength()), 2);
            newBytes = AppxToolkit.stringToBytes(str, 2);
            curLen = curBytes.length;
            newLen = newBytes.length;
        }
        if (curLen + newLen <= this.maxCharacters) {
            super.insertString(offs, str, a);
        } else if (curLen < this.maxCharacters) {
            int off = str.length() - 1;
            while (off >= 0 && curLen + newLen > this.maxCharacters) {
                str = string.substring(0, off);
                if (Globals.getOptionValueBoolean("inputByteLengthCheck")) {
                    newBytes = AppxToolkit.stringToBytes(str, 2);
                    newLen = newBytes.length;
                } else {
                    newLen = str.length();
                }
                --off;
            }
            super.insertString(offs, str, a);
            Toolkit.getDefaultToolkit().beep();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setMaxCharacters(int i) {
        this.maxCharacters = i;
    }
}

