/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.msg.MDisplayMessage;
import doc.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import view.CharView;
import view.JFLabel3D;
import view.JStatusPane;

public class JStatusBar
extends JPanel {
    private static final long serialVersionUID = -7432669217226165717L;
    static final int ALIGN_MASK = 28;
    static final int BORDER_MASK = 3;
    public static final int CENTERED = 8;
    public static final int IN = 2;
    public static final int LEFT = 4;
    public static final int NORMAL = 1;
    public static final int RIGHT = 16;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/JStatusBar.java,v 1.2.2.15 2012/10/29 03:12:59 pete Exp $";
    int barHeight = -1;
    int fillHeight = 0;
    int gap = 3;
    Point location = new Point(0, 0);
    int paneSepWidth = 2;
    Dimension siz;
    int stretchIdx = -1;
    Vector<JStatusPane> vPanes;
    private JFLabel3D compSave;

    public JStatusBar() {
        this(-1);
    }

    public JStatusBar(int barHeight) {
        this.setFocusable(false);
        this.barHeight = barHeight;
        this.vPanes = new Vector();
        super.setLayout(null);
        this.setFont(new Font("Helvetica", 0, 11));
        this.setBackground(Color.lightGray);
    }

    public JComponent add(JComponent comp) {
        return comp;
    }

    public synchronized JComponent add(JComponent comp, int pos) {
        return comp;
    }

    public synchronized JComponent add(String name, JComponent comp) {
        return comp;
    }

    public void addComponent(JComponent component) {
        this.addComponent(component, -1);
    }

    public void addComponent(JComponent component, int width) {
        JStatusPane jsp = new JStatusPane(4, 1, width, component, false);
        super.add((Component)component, -1);
        this.vPanes.addElement(jsp);
    }

    public void addPane(String sText, int style) {
        this.addPane(sText, style, Color.black, -1);
    }

    public void addPane(String sText, int style, Color textColor) {
        this.addPane(sText, style, textColor, -1);
    }

    public void addPane(String sText, int style, Color textColor, int width) {
        int style3d = 0;
        int align = style & 0x1C;
        if (align == 16) {
            style3d = 20;
        } else if (align == 8) {
            style3d = 10;
        } else {
            style3d = 0;
            align = 4;
        }
        int border = style & 3;
        if (border == 2) {
            style3d += 0;
        } else {
            style3d += 3;
            border = 1;
        }
        JFLabel3D l3d = new JFLabel3D(sText, style3d, textColor);
        l3d.setBaseColor(CharView.view.getColor("control"));
        JStatusPane jsp = new JStatusPane(align, border, width, l3d, true);
        jsp.component.setFont(this.getFont());
        super.add((Component)l3d, -1);
        this.vPanes.addElement(jsp);
    }

    public void addPane(Image image, int style, Color textColor, int width) {
        int style3d = 0;
        int align = style & 0x1C;
        if (align == 16) {
            style3d = 20;
        } else if (align == 8) {
            style3d = 10;
        } else {
            style3d = 0;
            align = 4;
        }
        int border = style & 3;
        if (border == 2) {
            style3d += 0;
        } else {
            style3d += 3;
            border = 1;
        }
        JFLabel3D l3d = new JFLabel3D("", style3d, textColor);
        l3d.setImage(image);
        l3d.setBaseColor(CharView.view.getColor("control"));
        JStatusPane jsp = new JStatusPane(align, border, width, l3d, true);
        super.add((Component)l3d, -1);
        this.vPanes.addElement(jsp);
    }

    public void addSeparator(int width) {
        this.addPane("", 1, Color.black, width);
    }

    @Override
    public void doLayout() {
        Dimension dim = this.getSize();
        Dimension min = null;
        JStatusPane jsp = null;
        int s = this.vPanes.size();
        int wid = 0;
        int col = 0;
        int ht = dim.height;
        int x = 0;
        while (x < s && x != this.stretchIdx) {
            jsp = this.vPanes.elementAt(x);
            min = jsp.component.getMinimumSize();
            if (min.height == 0) {
                min.height = ht;
            }
            wid = jsp.width == -1 ? min.width : jsp.width;
            jsp.component.setBounds(col, 2 + this.fillHeight, wid, ht - 2 - this.fillHeight);
            col += wid + this.paneSepWidth;
            ++x;
        }
        int stretchCol = col;
        col = dim.width;
        int y = s - 1;
        while (y >= 0 && y != this.stretchIdx) {
            jsp = this.vPanes.elementAt(y);
            min = jsp.component.getMinimumSize();
            if (min.height == 0) {
                min.height = ht;
            }
            wid = jsp.width == -1 ? min.width : jsp.width;
            jsp.component.setBounds(col - wid, 2 + this.fillHeight, wid, ht - 2 - this.fillHeight);
            col -= wid + this.paneSepWidth;
            --y;
        }
        if (x == this.stretchIdx) {
            jsp = this.vPanes.elementAt(x);
            min = jsp.component.getMinimumSize();
            if (min.height == 0) {
                min.height = ht;
            }
            jsp.component.setBounds(stretchCol, 2 + this.fillHeight, col - stretchCol, ht - 2 - this.fillHeight);
        }
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public int getFillHeight() {
        return this.fillHeight;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public Dimension getMinimumSize() {
        JStatusPane jsp = null;
        int s = this.vPanes.size();
        int wid = 0;
        int ht = 0;
        Dimension min = null;
        int x = 0;
        while (x < s) {
            jsp = this.vPanes.elementAt(x);
            min = jsp.component.getMinimumSize();
            wid = jsp.width == -1 ? (wid += min.width) : (wid += jsp.width);
            if (min.height > ht) {
                ht = min.height;
            }
            wid += this.paneSepWidth;
            ++x;
        }
        wid -= this.paneSepWidth;
        ht = this.barHeight == -1 ? (ht += this.gap) : this.barHeight;
        return new Dimension(0, (ht += this.fillHeight) + 2);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension s = this.siz;
        if (s == null) {
            s = new Dimension(0, 0);
        }
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(s.width, m.width), Math.max(s.height, m.height));
    }

    public synchronized void removePane(int paneIndex) {
        if (paneIndex >= 0 && paneIndex < this.vPanes.size()) {
            JStatusPane jsp = this.vPanes.elementAt(paneIndex);
            this.vPanes.removeElementAt(paneIndex);
            this.remove(jsp.component);
            this.invalidate();
            this.validate();
            this.repaint();
            if (this.stretchIdx == paneIndex) {
                this.stretchIdx = -1;
            }
        }
    }

    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
    }

    public void setCellBounds(int x, int y, int width, int height) {
        this.location = new Point(x, y);
        this.siz = new Dimension(width, height);
    }

    public void setDefaultSeparation(int width) {
        this.paneSepWidth = width;
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void setFillHeight(int fillHeight) {
        this.fillHeight = fillHeight;
    }

    public void setImage(int index, Image image) {
        if (index >= this.vPanes.size()) {
            return;
        }
        JStatusPane jsp = this.vPanes.elementAt(index);
        if (jsp.bInternal) {
            ((JFLabel3D)jsp.component).setImage(image);
        }
    }

    public void setToolTip(int index, String toolText) {
        if (index >= this.vPanes.size()) {
            return;
        }
        JStatusPane jsp = this.vPanes.elementAt(index);
        if (jsp.bInternal) {
            ((JFLabel3D)jsp.component).setToolTipText(toolText);
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public synchronized void setPaneBackground(int paneIndex, Color sColor0, Color sColor1, Color sColor2) {
        if (paneIndex >= 0 && paneIndex < this.vPanes.size()) {
            JStatusPane jsp = this.vPanes.elementAt(paneIndex);
            if (jsp.bInternal) {
                if (sColor0 != null) {
                    ((JFLabel3D)jsp.component).setBackground(sColor0);
                }
                if (sColor1 != null) {
                    ((JFLabel3D)jsp.component).setShadowColor(sColor1);
                }
                if (sColor2 != null) {
                    ((JFLabel3D)jsp.component).setHighlightColor(sColor2);
                }
                jsp.repaint();
            }
        }
    }

    public synchronized void setPaneFont(int paneIndex, Font f) {
        if (paneIndex >= 0 && paneIndex < this.vPanes.size()) {
            JStatusPane jsp = this.vPanes.elementAt(paneIndex);
            jsp.component.setFont(f);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public synchronized void setPaneText(int paneIndex, String sText) {
        if (paneIndex >= 0 && paneIndex < this.vPanes.size()) {
            JStatusPane jsp = this.vPanes.elementAt(paneIndex);
            if (jsp.bInternal) {
                if (paneIndex == 0 && this.compSave != null) {
                    super.remove(jsp.component);
                    jsp.component = this.compSave;
                    super.add((Component)jsp.component, -1);
                    this.compSave = null;
                }
                if (jsp.component instanceof JFLabel3D) {
                    ((JFLabel3D)jsp.component).setText(sText);
                }
                jsp.repaint();
            }
        }
    }

    public synchronized void setPaneText(int paneIndex, Vector<MDisplayMessage> msgs) {
        if (paneIndex >= 0 && paneIndex < this.vPanes.size()) {
            JStatusPane jsp = this.vPanes.elementAt(paneIndex);
            if (jsp.bInternal) {
                if (jsp.component instanceof JFLabel3D) {
                    this.compSave = (JFLabel3D)jsp.component;
                    super.remove(this.compSave);
                }
                JComboBox cb = new JComboBox(msgs){

                    @Override
                    public boolean isFocusable() {
                        return false;
                    }
                };
                if (Globals.getOptionValueInteger("messageComboRows") > 0) {
                    cb.setMaximumRowCount(Globals.getOptionValueInteger("messageComboRows"));
                }
                CustomListCellRenderer cr = new CustomListCellRenderer();
                cr.setOpaque(true);
                cb.setRenderer(cr);
                jsp.component = cb;
                super.add((Component)cb, -1);
                cb.repaint();
                jsp.repaint();
            }
        }
    }

    public synchronized void setPaneText(int paneIndex, String sText, Color fg, Color bg) {
        this.setPaneText(paneIndex, sText, fg, bg, 0);
    }

    public void repaintPane(int paneIndex) {
        if (Globals.getOptionValueBoolean("presentationMode")) {
            return;
        }
        if (paneIndex >= 0 && paneIndex < this.vPanes.size()) {
            JStatusPane jsp = this.vPanes.elementAt(paneIndex);
            if (jsp.bInternal) {
                ((JFLabel3D)jsp.component).paint(jsp.component.getGraphics());
            }
        }
    }

    public synchronized void setPaneText(int paneIndex, String sText, Color fg, Color bg, int pct) {
        if (paneIndex >= 0 && paneIndex < this.vPanes.size()) {
            JStatusPane jsp = this.vPanes.elementAt(paneIndex);
            if (paneIndex == 0 && this.compSave != null) {
                super.remove(jsp.component);
                jsp.component = this.compSave;
                super.add((Component)jsp.component, -1);
                this.compSave = null;
            }
            if (jsp.bInternal && jsp.component instanceof JFLabel3D) {
                ((JFLabel3D)jsp.component).setForeground(fg);
                ((JFLabel3D)jsp.component).setBaseColor(bg);
                ((JFLabel3D)jsp.component).setTextColor(fg);
                ((JFLabel3D)jsp.component).setSliderPct(pct);
            }
        }
        this.setPaneText(paneIndex, sText);
    }

    public void setStretchedPane(int paneIndex) {
        if (paneIndex > -2 && paneIndex < this.vPanes.size()) {
            this.stretchIdx = paneIndex;
        }
    }

    public synchronized void setText(String sText) {
        this.setPaneText(0, sText);
    }

    public void showImage(int index, boolean show) {
        JStatusPane jsp = this.vPanes.elementAt(index);
        if (jsp.bInternal && jsp.component instanceof JFLabel3D) {
            ((JFLabel3D)jsp.component).showImage(show);
        }
    }

    private class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private Color fg = Color.black;
        private Color bg = Color.lightGray;
        private int idx = -1;

        public CustomListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Color getForeground() {
            return this.fg;
        }

        @Override
        public Color getBackground() {
            return this.bg;
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public Border getBorder() {
            if (this.idx == -1 || this.idx == 0) {
                return BorderFactory.createMatteBorder(0, 0, 0, 0, Color.black);
            }
            return BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            MDisplayMessage dm = (MDisplayMessage)value;
            this.idx = index;
            if (index == -1) {
                this.setText(String.valueOf(dm.txt) + " --more--");
            } else {
                this.setText(dm.txt);
            }
            switch (dm.severity) {
                case 0: {
                    this.fg = Color.black;
                    this.bg = Color.green;
                    break;
                }
                case 1: {
                    this.fg = Color.black;
                    this.bg = Color.yellow;
                    break;
                }
                case 2: {
                    this.fg = Color.white;
                    this.bg = Color.red;
                    break;
                }
                case 3: {
                    this.fg = Color.white;
                    this.bg = Color.red;
                    break;
                }
                default: {
                    this.fg = Color.black;
                    this.bg = Color.lightGray;
                }
            }
            return this;
        }
    }
}

