/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.msg.MFld;
import doc.Globals;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.text.StringCharacterIterator;
import javax.swing.FocusManager;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import view.AppxFocusManager;
import view.MaskEngine;

public class JMaskedTextField
extends JTextField {
    private static final long serialVersionUID = 8018869393294569739L;
    public static final int texttype = 0;
    public static final int numbtype = 1;
    public static final int datetype = 2;
    public static final int timetype = 3;
    private Color disabledFg;
    private Color disabledBg;
    private Color enabledFg;
    private Color enabledBg;
    private PlainDocument _myDoc = null;
    private DocumentListener _docListener = null;
    private MaskEngine _maskEngine = new MaskEngine();
    private FocusAdapter _focusListener = null;
    private Document _document = null;
    private boolean _docListenerDisabled = false;
    private boolean _activity = false;
    private boolean _dataComplete = true;
    private boolean _haveFocus = false;
    private boolean _keyPressed = false;
    private int _firstInputPos = 0;
    private MFld dataModel;

    public MFld getFld() {
        return this.dataModel;
    }

    public int getEncodingType() {
        if (this.dataModel == null) {
            return 0;
        }
        return this.dataModel.getEncodingType();
    }

    public void setFld(MFld fld) {
        this.dataModel = fld;
    }

    @Override
    public synchronized void addNotify() {
        if (this._focusListener == null) {
            this._focusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    JMaskedTextField.this.gotFocus(e);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    JMaskedTextField.this.lostFocus(e);
                }
            };
            this.addFocusListener(this._focusListener);
        }
        super.addNotify();
    }

    protected void badLocException() {
        this.getToolkit().beep();
        System.out.println("Bad Location Exception in JMaskedTextField");
    }

    public synchronized void cut(Clipboard clipboard) {
        if (!this.isEditable()) {
            return;
        }
        StringBuffer newData = new StringBuffer();
        int selStart = this.getSelectionStart();
        StringSelection strSelect = new StringSelection(this._maskEngine.cut(this.getText(), selStart, this.getSelectionEnd(), newData));
        this._activity = true;
        clipboard.setContents(strSelect, strSelect);
        super.setText(newData.toString());
        this.setCaretPosition(selStart);
    }

    @Override
    public void cut() {
        if (this.getMask().equals("")) {
            super.cut();
        } else {
            this.cut(Toolkit.getDefaultToolkit().getSystemClipboard());
        }
    }

    protected void docChange(DocumentEvent e) {
        if (this._docListenerDisabled) {
            return;
        }
    }

    protected void docInsert(DocumentEvent e) {
        if (this._docListenerDisabled) {
            return;
        }
        int len = e.getLength();
        String data = "";
        try {
            data = this._document.getText(0, len);
        }
        catch (BadLocationException ex) {
            this.badLocException();
        }
        this.setMaskedText(data);
    }

    protected void docRemove(DocumentEvent e) {
        if (this._docListenerDisabled) {
            return;
        }
        super.setText("");
    }

    public String getCleanText() {
        return super.getText().replace('_', ' ');
    }

    public int getDatatype() {
        return this._maskEngine.getDatatype();
    }

    public Color getDisabledBackground() {
        return this.disabledBg;
    }

    public Color getDisabledForeground() {
        return this.disabledFg;
    }

    public String getMask() {
        return this._maskEngine.getMask();
    }

    protected String getMatchedText(String t) {
        return this._maskEngine.getMatchedText(t);
    }

    private int getNumberOfCaseConvertors() {
        int retInt = 0;
        StringCharacterIterator iter = new StringCharacterIterator(this.getMask());
        while (iter.next() != '\uffff') {
            if (iter.current() != '<' && iter.current() != '>') continue;
            ++retInt;
        }
        return retInt;
    }

    public synchronized String getUnmaskedText() {
        if (this.getMask().equals("")) {
            return this.getText();
        }
        StringBuffer newData = new StringBuffer();
        this._dataComplete = this._maskEngine.stripMask(this.getText(), newData);
        return newData.toString();
    }

    protected void gotFocus(FocusEvent e) {
        this._activity = false;
        this._haveFocus = true;
        try {
            if (this.getText().length() == 0) {
                this.setMaskedText("");
            } else if (this.isEditable() && !this.getMask().equals("") && this.getCaretPosition() <= this._maskEngine.lastFilterPosition()) {
                this.select(this.getCaretPosition() + 1, this.getCaretPosition());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean isDataComplete() {
        if (this.getMask().equals("")) {
            return true;
        }
        if (!this._dataComplete) {
            if (!this._activity) {
                return true;
            }
            this._dataComplete = this._maskEngine.stripMask(this.getText(), new StringBuffer());
        }
        return this._dataComplete;
    }

    public boolean isIncludeLiterals() {
        return this._maskEngine.isIncludeLiterals();
    }

    public boolean isSpaceIgnored() {
        return this._maskEngine.isSpaceIgnored();
    }

    public JMaskedTextField(int numberOfColumns) {
        this("", numberOfColumns);
    }

    public JMaskedTextField(String initialText, int numberOfColumns) {
        this(null, initialText, numberOfColumns);
    }

    public JMaskedTextField(String initialText) {
        this(initialText, 256);
    }

    public JMaskedTextField(Document doc, String initialText, int numberOfColumns) {
        super(doc, initialText, numberOfColumns);
    }

    protected void lostFocus(FocusEvent e) {
        if (this._haveFocus) {
            this._haveFocus = false;
            if (this.isEditable() && this._activity) {
                try {
                    try {
                        this._docListenerDisabled = true;
                        this._document.remove(0, this._document.getLength());
                        this._document.insertString(0, this.getUnmaskedText(), null);
                        this.processFocusEvent(e);
                    }
                    catch (BadLocationException ex) {
                        this.badLocException();
                        this._docListenerDisabled = false;
                    }
                }
                finally {
                    this._docListenerDisabled = false;
                }
            }
        }
    }

    public synchronized void paste(Clipboard clipboard) {
        if (!this.isEditable()) {
            return;
        }
        this._activity = true;
        StringBuffer newData = new StringBuffer();
        String data = "";
        try {
            data = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Globals.validateEncodedString(data, this.getEncodingType())) {
            int pos = this.getCaretPosition();
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            int newpos = this._maskEngine.paste(this.getText(), data, pos, newData, selStart, selEnd);
            if (newpos < 0) {
                this.getToolkit().beep();
                return;
            }
            if (newpos == -2) {
                return;
            }
            super.setText(newData.toString());
            if (newpos >= 0) {
                this.select(newpos + 1, newpos);
            } else {
                this.select(0, 0);
                if ((newpos -= this.getNumberOfCaseConvertors()) != -1) {
                    this.setCaretPosition(newpos + 1000);
                }
            }
        } else {
            this.getToolkit().beep();
        }
    }

    @Override
    public void paste() {
        if (this.getMask().equals("")) {
            super.paste();
        } else {
            this.paste(Toolkit.getDefaultToolkit().getSystemClipboard());
        }
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        if (e.isAltDown()) {
            return;
        }
        this._activity = true;
        switch (e.getID()) {
            case 400: {
                if (this._maskEngine.isHandledKey(e) && this.isEditable()) {
                    this.processKey(e);
                    break;
                }
                super.processComponentKeyEvent(e);
                break;
            }
            case 401: {
                if (this._maskEngine.isHandledKey(e) && this.isEditable()) {
                    e.consume();
                    if (this._keyPressed) {
                        if (!Globals.isISOControl((char)e.getKeyCode())) break;
                        this.processKey(e);
                        break;
                    }
                    this._keyPressed = true;
                    break;
                }
                super.processComponentKeyEvent(e);
                break;
            }
            case 402: {
                this._keyPressed = false;
                if (this._maskEngine.isHandledKey(e) && this.isEditable()) {
                    if (!Globals.isISOControl((char)e.getKeyCode())) break;
                    this.processKey(e);
                    break;
                }
                super.processComponentKeyEvent(e);
            }
        }
    }

    protected void processKey(KeyEvent e) {
        this._activity = true;
        e.consume();
        StringBuffer newData = new StringBuffer("");
        String data = this.getText();
        int selStart = this.getSelectionStart();
        int newpos = this._maskEngine.processKey(e, this.getCaretPosition(), data, newData, selStart, this.getSelectionEnd());
        if (newpos == -1) {
            this.getToolkit().beep();
        } else if (newpos != -2) {
            super.setText(newData.toString());
            if (newpos >= 0) {
                this.setCaretPosition(newpos + 1);
                this.moveCaretPosition(newpos);
            } else {
                this.select(0, 0);
                this.setCaretPosition((newpos + 3) * -1);
                if (Globals.getOptionValueBoolean("autoTabOut")) {
                    FocusManager fm = FocusManager.getCurrentManager();
                    if (fm instanceof AppxFocusManager) {
                        ((AppxFocusManager)fm).focusNextComponentTypeout(e.getComponent());
                    } else {
                        fm.focusNextComponent(e.getComponent());
                    }
                }
            }
        }
    }

    @Override
    public synchronized void removeNotify() {
        if (this._focusListener != null) {
            this.removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        super.removeNotify();
    }

    @Override
    public void setBackground(Color c) {
        this.enabledBg = c;
        super.setBackground(c);
    }

    public void setDatatype(int type) {
        this._maskEngine.setDatatype(type);
    }

    public void setDisabledBackground(Color c) {
        this.disabledBg = c;
        if (this.enabledBg == null) {
            this.enabledBg = this.getBackground();
        }
    }

    public void setDisabledForeground(Color c) {
        this.disabledFg = c;
        if (this.enabledFg == null) {
            this.enabledFg = this.getForeground();
        }
    }

    @Override
    public void setDocument(Document d) {
        if (this._docListener == null) {
            this._docListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    JMaskedTextField.this.docChange(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    JMaskedTextField.this.docRemove(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    JMaskedTextField.this.docInsert(e);
                }
            };
        }
        if (this._document != null) {
            this._document.removeDocumentListener(this._docListener);
        }
        this._document = d;
        this._document.addDocumentListener(this._docListener);
        if (this._myDoc == null) {
            this._myDoc = new PlainDocument();
        }
        super.setDocument(this._myDoc);
    }

    @Override
    public void setEnabled(boolean enable) {
        if (this.isEnabled() != enable) {
            super.setEnabled(enable);
        }
        if (this.isEditable() != enable) {
            super.setEditable(enable);
        }
        if (this.isEnabled()) {
            if (this.enabledFg != null) {
                super.setForeground(this.enabledFg);
            }
            if (this.enabledBg != null) {
                super.setBackground(this.enabledBg);
            }
        } else {
            if (this.disabledFg != null) {
                super.setForeground(this.disabledFg);
            }
            if (this.disabledBg != null) {
                super.setBackground(this.disabledBg);
            }
        }
    }

    @Override
    public void setForeground(Color c) {
        this.enabledFg = c;
        super.setForeground(c);
    }

    public void setIncludeLiterals(boolean includeLiterals) {
        this._maskEngine.setIncludeLiterals(includeLiterals);
    }

    public synchronized void setMaskedText(String t) {
        if (this.getMask().equals("")) {
            super.setText(t);
        } else {
            StringBuffer newData = new StringBuffer();
            this._firstInputPos = this._maskEngine.initDisplay(t, newData);
            super.setText(newData.toString());
            if (this._haveFocus && this.isEditable()) {
                try {
                    this.select(this._firstInputPos + 1, this._firstInputPos);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void setMask(String mask) {
        this._maskEngine.setMask(mask);
        this.setText(this.getText());
    }

    public void setSpaceIgnored(boolean spaceIgnored) {
        this._maskEngine.setSpaceIgnored(spaceIgnored);
    }

    @Override
    public synchronized void setText(String t) {
        if (t != null && t.length() > 0) {
            super.setText(this.getMatchedText(t));
        } else {
            super.setText(t);
        }
    }

    public JMaskedTextField() {
        this("", 0);
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }
}

