/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class JFLabel3D
extends JComponent {
    private static final long serialVersionUID = 4529627182432487795L;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/JFLabel3D.java,v 1.1.2.5 2006/07/24 19:25:53 pete Exp $";
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int BORDERED = 2;
    public static final int NOTBORDERED = 3;
    public static final int GRID_LABEL = 4;
    public static final int LEFT = 0;
    public static final int CENTERED = 10;
    public static final int RIGHT = 20;
    public static final int ZERO = 0;
    public static final int ONE = 1;
    public static final int TWO = 2;
    protected String sLabel3D;
    private int align;
    private int type;
    private Color color1;
    private Color color2;
    private Color color3;
    private Color textColor;
    private Color borderedColor;
    private Image image;
    private boolean paintImage;
    private FontMetrics fm;
    private int xTemp;
    private int yTemp;
    private int indent = 0;
    private int sliderPct = 0;
    private int verticalAdj = 0;

    public int getBorderIndent() {
        return this.indent;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(null) + 2, this.image.getHeight(null) - 1);
        }
        Font f = this.getFont();
        if (f == null) {
            return new Dimension(18, 10);
        }
        this.fm = this.getFontMetrics(f);
        if (this.fm.getDescent() >= this.fm.charWidth('@')) {
            this.verticalAdj = this.fm.getDescent() / 2 * -1;
        }
        return new Dimension(this.fm.stringWidth(this.sLabel3D) + 18, this.fm.getHeight() - 1 + this.verticalAdj);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(null) + 2, this.image.getHeight(null) + 2);
        }
        Dimension m = this.getMinimumSize();
        Dimension s = this.getSize();
        return new Dimension(Math.max(s.width, m.width), Math.max(s.height + this.verticalAdj, m.height));
    }

    public int getStyle() {
        return this.type + this.align;
    }

    public String getText() {
        return this.sLabel3D;
    }

    public JFLabel3D(String sText, int style, int indent) {
        this(sText, style, Color.black, indent);
    }

    public JFLabel3D(String sText, int style, Color color, int indent) {
        this.setFocusable(false);
        this.sLabel3D = sText;
        this.textColor = color;
        this.borderedColor = Color.black;
        this.setBorderIndent(indent, false);
        this.setStyle(style, false);
    }

    public JFLabel3D(String sText, int style, Color color) {
        this(sText, style, color, 0);
    }

    public JFLabel3D(String sText, int style) {
        this(sText, style, Color.black, 0);
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        Rectangle r = this.getBounds();
        Color c = g.getColor();
        if (this.paintImage && this.image != null) {
            int height = this.image.getHeight(null);
            int width = this.image.getWidth(null);
            if (height > r.height) {
                height = r.height;
            }
            if (width > r.width) {
                width = r.width;
            }
            g.drawImage(this.image, this.indent + 1, this.indent + 1, r.width - 2, r.height - 2, this.getBackground(), this);
            if (this.color1 != null) {
                g.clipRect(0, 0, r.width, r.height);
                g.setColor(this.color1);
                g.drawLine(1 + this.indent, this.indent, r.width - 2 - this.indent, this.indent);
                g.setColor(this.color2);
                g.drawLine(0 + this.indent, r.height - 1 - this.indent, r.width - 2 - this.indent, r.height - 1 - this.indent);
                g.setColor(this.color1);
                g.drawLine(this.indent, this.indent, this.indent, r.height - 2 - this.indent);
                g.setColor(this.color2);
                g.drawLine(r.width - 1 - this.indent, this.indent, r.width - 1 - this.indent, r.height - 1 - this.indent);
                g.clipRect(0, 0, r.width, r.height);
            } else if (this.type == 4) {
                g.setColor(Color.black);
                g.drawLine(1, 0, r.width - 1, 0);
                g.drawLine(0, 0, 0, r.height - 1);
                g.drawLine(1, r.height - 1, r.width - 1, r.height - 1);
                g.drawLine(r.width, 0, r.width, r.height);
                g.setColor(Color.white);
                g.drawLine(2, 1, r.width - 3, 1);
                g.drawLine(1, 1, 1, r.height - 3);
                g.clipRect(0, 0, r.width, r.height);
            } else {
                g.setColor(this.getBackground());
                g.drawRect(this.indent, this.indent, r.width - 2 - this.indent, r.height - 1 - this.indent);
                g.clipRect(0, 0, r.width, r.height);
            }
            return;
        }
        if (this.color3 != null) {
            g.setColor(this.color3);
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(1 + this.indent, 1 + this.indent, r.width - 2 - this.indent, r.height - 2 - this.indent);
        if (this.sliderPct > 0) {
            int wdth = (int)((double)r.width * ((double)this.sliderPct * 0.01));
            g.setColor(Color.orange);
            g.fillRect(1 + this.indent, 1 + this.indent, wdth - 2 - this.indent, r.height - 2 - this.indent);
            g.setColor(Color.orange.brighter());
            g.drawLine(2 + this.indent, 1 + this.indent, wdth - 2 - this.indent, 1 + this.indent);
            g.drawLine(1 + this.indent, 1 + this.indent, 1 + this.indent, r.height - 3 - this.indent);
            g.setColor(Color.orange.darker());
            g.drawLine(1 + this.indent, r.height - 2 - this.indent, wdth - 2 - this.indent, r.height - 2 - this.indent);
            g.drawLine(wdth - 2 - this.indent, 1 + this.indent, wdth - 2 - this.indent, r.height - 2 - this.indent);
        }
        if (this.color1 != null) {
            g.clipRect(0, 0, r.width, r.height);
            g.setColor(this.color1);
            g.drawLine(1 + this.indent, this.indent, r.width - 2 - this.indent, this.indent);
            g.setColor(this.color2);
            g.drawLine(0 + this.indent, r.height - 1 - this.indent, r.width - 2 - this.indent, r.height - 1 - this.indent);
            g.setColor(this.color1);
            g.drawLine(this.indent, this.indent, this.indent, r.height - 2 - this.indent);
            g.setColor(this.color2);
            g.drawLine(r.width - 1 - this.indent, this.indent, r.width - 1 - this.indent, r.height - 1 - this.indent);
            g.clipRect(0, 0, r.width, r.height);
            this.yTemp = 1 + this.indent;
        } else {
            if (this.type == 4) {
                g.setColor(Color.black);
                g.drawLine(1, 0, r.width - 1, 0);
                g.drawLine(0, 0, 0, r.height - 1);
                g.drawLine(1, r.height - 1, r.width - 1, r.height - 1);
                g.drawLine(r.width, 0, r.width, r.height);
                g.setColor(Color.white);
                g.drawLine(2, 1, r.width - 3, 1);
                g.drawLine(1, 1, 1, r.height - 3);
                g.clipRect(0, 0, r.width, r.height);
            } else {
                g.setColor(this.getBackground());
                g.drawRect(this.indent, this.indent, r.width - 2 - this.indent, r.height - 1 - this.indent);
                g.clipRect(0, 0, r.width, r.height);
            }
            this.yTemp = 1;
        }
        g.setColor(this.textColor);
        this.fm = this.getFontMetrics(this.getFont());
        if (this.fm.getDescent() >= this.fm.charWidth('@')) {
            this.verticalAdj = this.fm.getDescent() / 2 * -1;
        }
        this.yTemp = (r.height - this.yTemp + (this.fm.getAscent() + this.verticalAdj)) / 2;
        switch (this.align) {
            case 0: {
                if (this.type == 3) {
                    g.drawString(this.sLabel3D, 3 + this.indent, this.yTemp);
                    break;
                }
                g.drawString(this.sLabel3D, 3 + this.indent, this.yTemp);
                break;
            }
            case 20: {
                this.xTemp = r.width - this.fm.stringWidth(this.sLabel3D);
                if (this.type == 3) {
                    g.drawString(this.sLabel3D, this.xTemp - 6, this.yTemp);
                    break;
                }
                g.drawString(this.sLabel3D, this.xTemp - 10, this.yTemp);
                break;
            }
            case 10: {
                this.xTemp = (r.width - this.fm.stringWidth(this.sLabel3D)) / 2;
                if (this.type == 3) {
                    g.drawString(this.sLabel3D, this.xTemp, this.yTemp);
                    break;
                }
                g.drawString(this.sLabel3D, this.xTemp, this.yTemp);
            }
        }
        g.setColor(c);
    }

    public void setBaseColor(Color c) {
        this.color3 = c;
        this.setBackground(c);
    }

    public void setBorderedColor(Color color) {
        this.borderedColor = color;
        if (this.type == 2) {
            this.color1 = color;
            this.color2 = color;
        }
        this.repaint();
    }

    public void setBorderIndent(int indent) {
        this.setBorderIndent(indent, true);
    }

    private void setBorderIndent(int indent, boolean bRepaint) {
        this.indent = indent < 0 ? 0 : (indent > 2 ? 2 : indent);
        if (bRepaint) {
            this.repaint();
        }
    }

    @Override
    public synchronized void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (!this.isValid()) {
            this.repaint();
        }
    }

    public void setHighlightColor(Color c) {
        this.color2 = c;
    }

    public void setImage(Image i) {
        this.image = i;
        this.paintImage = this.image != null;
    }

    public void setShadowColor(Color c) {
        this.color1 = c;
    }

    public void setSliderPct(int pct) {
        this.sliderPct = pct;
    }

    public void setStyle(int style) {
        this.setStyle(style, true);
    }

    private void setStyle(int style, boolean bRepaint) {
        if (style >= 20) {
            this.align = 20;
            this.type = style - 20;
        } else if (style >= 10) {
            this.align = 10;
            this.type = style - 10;
        } else {
            this.align = 0;
            this.type = style;
        }
        switch (this.type) {
            case 0: {
                this.color1 = new Color(127, 127, 127);
                this.color2 = new Color(224, 224, 224);
                break;
            }
            case 2: {
                this.color1 = this.borderedColor;
                this.color2 = this.borderedColor;
                break;
            }
            case 1: {
                this.color1 = Color.white;
                this.color2 = Color.black;
                break;
            }
            default: {
                this.color2 = null;
                this.color1 = null;
            }
        }
        if (bRepaint) {
            this.repaint();
        }
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.repaint();
    }

    public void setText(String sText) {
        this.sLabel3D = sText == null ? new String("") : sText;
        this.sLabel3D.trim();
        this.paintImage = this.sLabel3D.trim().length() == 0;
        this.repaint();
    }

    public void showImage(boolean show) {
        this.paintImage = show;
    }

    public void update2(Graphics g) {
        this.paint(g);
    }

    public JFLabel3D() {
        this("", 3, Color.black, 0);
    }
}

