/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxToolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import view.DayButton;
import view.DaySelectionListener;

public class JDateChooser
extends JComponent
implements ActionListener,
DaySelectionListener {
    private static final long serialVersionUID = 3343960372990690999L;
    public static final int ERROR_OPTION = 0;
    public static final int ACCEPT_OPTION = 2;
    public static final int CANCEL_OPTION = 4;
    private int currentDay;
    private JLabel dateText;
    private Calendar calendar;
    private JButton previousYear;
    private JButton previousMonth;
    private JButton nextMonth;
    private JButton nextYear;
    private JButton okay;
    private JButton cancel;
    private int returnValue;
    private JDialog dialog;
    private JPanel days;
    private byte[] rawDate;

    public void acceptSelection() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okay) {
            this.returnValue = 2;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.acceptSelection();
        }
        if (e.getSource() == this.cancel) {
            this.returnValue = 4;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.cancelSelection();
        }
        if (e.getSource() == this.previousYear) {
            this.calendar.roll(1, false);
            this.updateCalendar(this.calendar);
        }
        if (e.getSource() == this.previousMonth) {
            this.calendar.add(2, -1);
            this.updateCalendar(this.calendar);
        }
        if (e.getSource() == this.nextMonth) {
            this.calendar.add(2, 1);
            this.updateCalendar(this.calendar);
        }
        if (e.getSource() == this.nextYear) {
            this.calendar.roll(1, true);
            this.updateCalendar(this.calendar);
        }
    }

    public void cancelSelection() {
    }

    @Override
    public void daySelected(int d) {
        this.calendar.set(5, d);
        this.updateLabel();
        this.currentDay = d;
    }

    public int getActualMaximum(Calendar cal, int field) {
        int endValue;
        int fieldValue = cal.getLeastMaximum(field);
        if (fieldValue == (endValue = cal.getMaximum(field))) {
            return fieldValue;
        }
        Calendar work = (Calendar)cal.clone();
        work.setLenient(true);
        if (field == 3 || field == 4) {
            work.set(7, cal.getFirstDayOfWeek());
        }
        int result = fieldValue;
        do {
            work.set(field, fieldValue);
            if (work.get(field) != fieldValue) break;
            result = fieldValue++;
        } while (fieldValue <= endValue);
        return result;
    }

    public byte[] getRawDate() {
        int CC = 0;
        int YY = 0;
        int MM = 0;
        int DD = 0;
        int hh = 0;
        int mm = 0;
        int ss = 0;
        int th = 0;
        int year = 0;
        year = this.calendar.get(1);
        MM = this.calendar.get(2) + 1;
        DD = this.calendar.get(5);
        hh = this.calendar.get(11);
        mm = this.calendar.get(12);
        ss = this.calendar.get(13);
        th = (int)((double)this.calendar.get(14) * 0.1);
        YY = year % 100;
        CC = (year - YY) / 100;
        if (this.rawDate[0] != 45) {
            this.setBytes(0, CC);
        }
        if (this.rawDate[2] != 45) {
            this.setBytes(2, YY);
        }
        if (this.rawDate[4] != 45) {
            this.setBytes(4, MM);
        }
        if (this.rawDate[6] != 45) {
            this.setBytes(6, DD);
        }
        if (this.rawDate[8] != 45) {
            this.setBytes(8, hh);
        }
        if (this.rawDate[10] != 45) {
            this.setBytes(10, mm);
        }
        if (this.rawDate[12] != 45) {
            this.setBytes(12, ss);
        }
        if (this.rawDate[14] != 45) {
            this.setBytes(14, th);
        }
        return this.rawDate;
    }

    public Calendar getSelectedDate() {
        return this.calendar;
    }

    public JDateChooser(Calendar c) {
        this.calendar = c;
        this.calendar.setLenient(true);
        this.setup();
    }

    private void setBytes(int offset, int value) {
        this.rawDate[offset + 1] = (byte)(48 + (byte)(value % 10));
        this.rawDate[offset] = (byte)(48 + (value - value % 10) / 10);
    }

    public void setCalendar(Calendar c) {
        this.calendar = c;
        this.calendar.setLenient(true);
        this.updateCalendar(this.calendar);
    }

    public void setRawDate(byte[] raw) {
        this.rawDate = raw;
        GregorianCalendar newC = new GregorianCalendar();
        newC.setLenient(true);
        if (raw != null && Array.getLength(raw) == 16) {
            int CC = 0;
            int YY = 0;
            int MM = 0;
            int DD = 0;
            int hh = 0;
            int mm = 0;
            int ss = 0;
            int th = 0;
            int year = 0;
            year = this.calendar.get(1);
            MM = this.calendar.get(2);
            DD = this.calendar.get(5);
            hh = this.calendar.get(11);
            mm = this.calendar.get(12);
            ss = this.calendar.get(13);
            th = (int)((double)this.calendar.get(14) * 0.1);
            YY = year % 100;
            CC = (year - YY) / 100;
            if (this.rawDate[0] >= 48 && this.rawDate[0] <= 57) {
                CC = Integer.parseInt(AppxToolkit.byteToString(this.rawDate, 0, 2, 1));
            }
            if (this.rawDate[2] >= 48 && this.rawDate[2] <= 57) {
                YY = Integer.parseInt(AppxToolkit.byteToString(this.rawDate, 2, 2, 1));
            }
            if (this.rawDate[4] >= 48 && this.rawDate[4] <= 57) {
                MM = Integer.parseInt(AppxToolkit.byteToString(this.rawDate, 4, 2, 1)) - 1;
            }
            if (this.rawDate[6] >= 48 && this.rawDate[6] <= 57) {
                DD = Integer.parseInt(AppxToolkit.byteToString(this.rawDate, 6, 2, 1));
            }
            if (this.rawDate[8] >= 48 && this.rawDate[8] <= 57) {
                hh = Integer.parseInt(AppxToolkit.byteToString(this.rawDate, 8, 2, 1));
            }
            if (this.rawDate[10] >= 48 && this.rawDate[10] <= 57) {
                mm = Integer.parseInt(AppxToolkit.byteToString(this.rawDate, 10, 2, 1));
            }
            if (this.rawDate[12] >= 48 && this.rawDate[12] <= 57) {
                ss = Integer.parseInt(AppxToolkit.byteToString(this.rawDate, 12, 2, 1));
            }
            if (this.rawDate[14] >= 48 && this.rawDate[14] <= 57) {
                th = Integer.parseInt(AppxToolkit.byteToString(this.rawDate, 14, 2, 1));
            }
            newC.set(CC * 100 + YY, MM, DD, hh, mm, ss);
            newC.set(14, th * 10);
        }
        this.setCalendar(newC);
    }

    private void setup() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel header = new JPanel(g);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 0, 2, 0);
        this.previousYear = (JButton)header.add(new JButton("<<"));
        this.previousYear.addActionListener(this);
        this.previousYear.setToolTipText("Previous Year");
        g.setConstraints(this.previousYear, c);
        this.previousMonth = (JButton)header.add(new JButton("<"));
        this.previousMonth.addActionListener(this);
        this.previousMonth.setToolTipText("Previous Month");
        ++c.gridx;
        g.setConstraints(this.previousMonth, c);
        this.dateText = (JLabel)header.add(new JLabel("", 0));
        this.dateText.setBorder(new EtchedBorder(1));
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        g.setConstraints(this.dateText, c);
        this.nextMonth = (JButton)header.add(new JButton(">"));
        this.nextMonth.addActionListener(this);
        this.nextMonth.setToolTipText("Next Month");
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        g.setConstraints(this.nextMonth, c);
        this.nextYear = (JButton)header.add(new JButton(">>"));
        this.nextYear.addActionListener(this);
        this.nextYear.setToolTipText("Next Year");
        ++c.gridx;
        g.setConstraints(this.nextYear, c);
        this.updateCalendar(this.calendar);
        JPanel buttons = new JPanel(new FlowLayout(2));
        this.okay = (JButton)buttons.add(new JButton("OK"));
        this.okay.addActionListener(this);
        this.cancel = (JButton)buttons.add(new JButton("Cancel"));
        this.cancel.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add("North", header);
        this.add("Center", this.days);
        this.add("South", buttons);
    }

    public int showDialog(Component parent, String title) {
        this.returnValue = 0;
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        this.dialog = new JDialog(frame, title, true);
        this.dialog.getContentPane().add("Center", this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
        return this.returnValue;
    }

    private void updateCalendar(Calendar c) {
        int firstOfWeek;
        if (this.days != null) {
            this.remove(this.days);
        }
        this.currentDay = this.calendar.get(5);
        this.days = new JPanel(new GridLayout(7, 7));
        int dayInt = firstOfWeek = this.calendar.getFirstDayOfWeek();
        int lastLayoutPosition = 0;
        int i = 0;
        while (i < 7) {
            if (dayInt == 2) {
                this.days.add(new JLabel("Mon"));
            }
            if (dayInt == 3) {
                this.days.add(new JLabel("Tue"));
            }
            if (dayInt == 4) {
                this.days.add(new JLabel("Wed"));
            }
            if (dayInt == 5) {
                this.days.add(new JLabel("Thu"));
            }
            if (dayInt == 6) {
                this.days.add(new JLabel("Fri"));
            }
            if (dayInt == 7) {
                this.days.add(new JLabel("Sat"));
            }
            if (dayInt == 1) {
                this.days.add(new JLabel("Sun"));
            }
            if (++dayInt > 7) {
                dayInt = 1;
            }
            ++lastLayoutPosition;
            ++i;
        }
        Calendar setup = (Calendar)this.calendar.clone();
        setup.set(5, 1);
        int first = setup.get(7);
        if (first < firstOfWeek) {
            first += 7;
        }
        int i2 = firstOfWeek;
        while (i2 < first) {
            this.days.add(new JLabel(""));
            ++lastLayoutPosition;
            ++i2;
        }
        setup.set(5, 1);
        i2 = 0;
        while (i2 < this.getActualMaximum(setup, 5)) {
            DayButton button = new DayButton(setup.get(5));
            button.addDaySelectionListener(this);
            if (setup.get(5) == this.currentDay) {
                button.setForeground(Color.red);
            }
            this.days.add(button);
            setup.roll(5, true);
            ++lastLayoutPosition;
            ++i2;
        }
        i2 = lastLayoutPosition;
        while (i2 < 49) {
            this.days.add(new JLabel(""));
            ++i2;
        }
        this.add("Center", this.days);
        this.validate();
        if (this.dialog != null) {
            this.dialog.pack();
        }
        setup = null;
        this.updateLabel();
    }

    private void updateLabel() {
        Date date = this.calendar.getTime();
        this.dateText.setText(DateFormat.getInstance().format(date));
    }

    public JDateChooser() {
        this(Calendar.getInstance());
    }
}

