/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import view.CharView;

public class ImgPanel
extends JComponent {
    private static final long serialVersionUID = -9174061115709886769L;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/ImgPanel.java,v 1.1.2.2 2005/09/23 13:07:27 pete Exp $";
    Applet applet;
    Image image;
    Dimension size;
    Rectangle bounds;
    boolean border;
    boolean allbits;
    String lastURL;
    String msg;
    int counter;

    private void drawField(Graphics g) {
        Dimension ps = this.getPreferredSize();
        int x1 = 0;
        int y1 = 0;
        int x2 = ps.width - 1;
        int y2 = ps.height - 1;
        g.setColor(Color.white);
        g.drawLine(x1, y2, x2, y2);
        g.drawLine(x2, y1, x2, y2);
        g.setColor(Color.gray);
        g.drawLine(x1, y1, x1, --y2);
        g.drawLine(x1, y1, --x2, y1);
        g.setColor(Color.lightGray);
        g.drawLine(++x1, y2, x2, y2);
        g.drawLine(x2, ++y1, x2, y2);
        g.setColor(Color.black);
        g.drawLine(x1, y1, x1, --y2);
        g.drawLine(x1, y1, --x2, y1);
    }

    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        return new Point(this.bounds.x * CharView.charWidth, this.bounds.y * CharView.charHeight + 1);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.bounds.width == 1 && this.bounds.height == 1) {
            return this.size;
        }
        return new Dimension(this.bounds.width * CharView.charWidth, this.bounds.height * CharView.charHeight);
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if ((flags & 0x40) != 0) {
            this.msg = "Load Error!";
            this.repaint();
            return true;
        }
        if ((flags & 0x80) != 0) {
            this.msg = "Abort Error!";
            this.repaint();
            return true;
        }
        if ((flags & 0x20) != 0) {
            this.allbits = true;
            this.showTheImage();
            return true;
        }
        this.allbits = false;
        return true;
    }

    public ImgPanel(Applet ap, String url, int x, int y, int width, int height, boolean bord) {
        this.setVisible(false);
        this.lastURL = "last";
        this.border = bord;
        this.bounds = new Rectangle(x, y, width, height);
        this.applet = ap;
        this.msg = "";
        this.allbits = true;
        this.setSize(0, 0);
        this.size = new Dimension(0, 0);
        this.setURL(ap, url, bord);
    }

    @Override
    public void paint(Graphics g) {
        if ((this.bounds.width != 1 || this.bounds.height != 1) && this.border) {
            this.drawField(g);
        }
        if (!this.allbits || this.image == null) {
            FontMetrics fm = g.getFontMetrics();
            g.drawString(this.msg, 4, 4 + fm.getAscent());
            return;
        }
        if (this.bounds.width == 1 && this.bounds.height == 1 && this.border) {
            if (this.border) {
                g.drawImage(this.image, 2, 2, this);
            } else {
                g.drawImage(this.image, 0, 0, this);
            }
            this.drawField(g);
        } else {
            Dimension dm = this.getPreferredSize();
            if (this.border) {
                g.drawImage(this.image, 2, 2, dm.width - 4, dm.height - 4, this);
            } else {
                g.drawImage(this.image, 0, 0, dm.width, dm.height, this);
            }
        }
    }

    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setURL(Applet ap, String url, boolean bord) {
        if (url == null) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            if (this.lastURL == null || this.lastURL.compareTo(url) != 0) {
                if (ap == null) {
                    if (url.indexOf("://") > 0) {
                        try {
                            this.image = this.getToolkit().getImage(new URL(url));
                        }
                        catch (MalformedURLException e) {
                            System.err.println("loadImage() malformed URL=" + url);
                        }
                    } else {
                        this.image = this.getToolkit().getImage(url);
                    }
                } else {
                    URL codebase = this.applet.getCodeBase();
                    this.image = this.applet.getImage(codebase, url);
                }
                this.lastURL = url;
                this.msg = "Loading";
                this.counter = 0;
                this.allbits = false;
                if (this.prepareImage(this.image, this)) {
                    this.showTheImage();
                }
            } else {
                this.showTheImage();
            }
        }
    }

    private void showTheImage() {
        if (this.bounds.width == 1 && this.bounds.height == 1) {
            this.size = this.border ? new Dimension(this.image.getWidth(null) + 4, this.image.getHeight(null) + 4) : new Dimension(this.image.getWidth(null), this.image.getHeight(null));
            this.setSize(this.size);
        }
        this.allbits = true;
        this.invalidate();
        this.repaint();
    }
}

