/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.IOHandler;
import comm.msg.MGuiEditCmd;
import doc.AppxResource;
import doc.Globals;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import view.AppxBox;
import view.AppxControl;
import view.AppxField;
import view.AppxLine;
import view.CharView;
import view.Display;
import view.DropShadowPanel;

public class ImgEditorPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -6759542878874417149L;
    protected ImgEditorPane self = this;
    protected Display parent = null;
    protected CharView view;
    protected Point mouseDown;
    protected int lastDragHandle = 0;
    protected DragMode dragMode;
    protected GuideBarGroup guideBarGroup;
    protected SelectState selectState = new SelectState();
    protected MGuiEditCmd guiEditCmd = new MGuiEditCmd();
    protected JPopupMenu popupMenu;
    protected JMenuItem popupDel;
    protected JMenuItem popupCut;
    protected JMenuItem popupCopy;
    protected JMenuItem popupPaste;
    protected JMenuItem popupObjProps;
    protected JMenuItem popupWinProps;
    protected JMenuItem popupAlignTop;
    protected JMenuItem popupAlignBottom;
    protected JMenuItem popupAlignLeft;
    protected JMenuItem popupAlignRight;
    protected JMenuItem popupSameSizeVert;
    protected JMenuItem popupSameSizeHorz;
    protected JMenuItem popupSpreadVert;
    protected JMenuItem popupSpreadHorz;
    protected JMenuItem popupNewGuideVert;
    protected JMenuItem popupNewGuideHorz;
    protected JMenuItem popupOptionNumbers;
    protected ButtonGroup toggleGroup;
    protected JToolBar cmdToolbar = null;
    protected JToolBar modeToolbar = null;
    protected JToolBar editToolbar = null;
    protected JToggleButton lassoTool;
    protected JToggleButton buttonTool;
    protected JToggleButton labelTool;
    protected JToggleButton imageTool;
    protected JToggleButton boxTool;
    protected JToggleButton lineTool;
    protected JToggleButton tableTool;
    protected JToggleButton showCtlBtn;
    protected JToggleButton showGridBtn;
    protected JToggleButton showGuiBtn;
    protected JButton cutBtn;
    protected JButton copyBtn;
    protected JButton pasteBtn;
    protected JButton winPropBtn;
    protected JButton propBtn;
    protected JButton alignTopBtn;
    protected JButton alignBotBtn;
    protected JButton alignLeftBtn;
    protected JButton alignRightBtn;
    protected JButton sameVertBtn;
    protected JButton sameHorizBtn;
    protected JButton spreadVertBtn;
    protected JButton spreadHorizBtn;
    protected JToggleButton currentTool;
    protected Hashtable actionNames;
    protected boolean retainSelections = false;
    private Rectangle cellBounds;

    protected void accessServer(int option) {
        this.view.accessServer(option);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option = -1;
        try {
            if (e.getActionCommand() != null) {
                option = Integer.parseInt(e.getActionCommand());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (e.getSource() instanceof JToggleButton) {
            JToggleButton c = (JToggleButton)e.getSource();
            if (option == 20060) {
                if (this.parent != null) {
                    this.parent.getView().showImgEditorControls = c.isSelected();
                    this.accessServer(20013);
                }
            } else if (option == 20106) {
                Globals.setOptionValue("showGridlines", c.isSelected());
                this.accessServer(20013);
            } else if (option == 20101) {
                Globals.setOptionValue("guiInterface", !c.isSelected());
                this.accessServer(20013);
            } else {
                this.selectTool(c);
            }
        } else if (option != -1) {
            this.performAction(option, this.mouseDown);
        }
    }

    protected void adjustOffsets(MGuiEditCmd cmd) {
        int pnro = cmd.posNewRowOffset;
        int pnco = cmd.posNewColOffset;
        int sro = cmd.sizeRowsOffset;
        int sco = cmd.sizeColsOffset;
        cmd.posNewRowOffset = cmd.posNewRowOffset * 100 / CharView.charHeight;
        cmd.posNewColOffset = cmd.posNewColOffset * 100 / CharView.charWidth;
        cmd.sizeRowsOffset = cmd.sizeRowsOffset * 100 / CharView.charHeight;
        cmd.sizeColsOffset = cmd.sizeColsOffset * 100 / CharView.charWidth;
        while (pnro > cmd.posNewRowOffset * CharView.charHeight / 100) {
            ++cmd.posNewRowOffset;
        }
        while (pnro < cmd.posNewRowOffset * CharView.charHeight / 100) {
            --cmd.posNewRowOffset;
        }
        while (pnco > cmd.posNewColOffset * CharView.charWidth / 100) {
            ++cmd.posNewColOffset;
        }
        while (pnco < cmd.posNewColOffset * CharView.charWidth / 100) {
            --cmd.posNewColOffset;
        }
        while (sro > cmd.sizeRowsOffset * CharView.charHeight / 100) {
            ++cmd.sizeRowsOffset;
        }
        while (sro < cmd.sizeRowsOffset * CharView.charHeight / 100) {
            --cmd.sizeRowsOffset;
        }
        while (sco > cmd.sizeColsOffset * CharView.charWidth / 100) {
            ++cmd.sizeColsOffset;
        }
        while (sco < cmd.sizeColsOffset * CharView.charWidth / 100) {
            --cmd.sizeColsOffset;
        }
    }

    protected void applyChanges() {
        int context = 0;
        int count = 0;
        int cmd = this.selectState.getModType();
        while ((context = this.selectState.getNextMod(context, this.guiEditCmd, this)) != -1) {
            this.view.sendGuiEditCmd(this.guiEditCmd);
            ++count;
        }
        if (count != 0) {
            this.retainSelections = true;
            this.selectState.releaseControls();
            this.accessServer(cmd);
        }
    }

    protected void applyTool(Rectangle rect, MGuiEditCmd cmd) {
        this.selectState.hideLasso(this.getGraphics());
        cmd.initData();
        cmd.cmd = 11;
        cmd.subCmd = 104;
        cmd.posNewRow = this.self.y2row(rect.y);
        cmd.posNewCol = this.self.x2col(rect.x);
        cmd.sizeRows = this.self.h2row(rect.height);
        cmd.sizeCols = this.self.w2col(rect.width);
        cmd.posNewRowOffset = rect.y - cmd.posNewRow * CharView.charHeight;
        cmd.posNewColOffset = rect.x - cmd.posNewCol * CharView.charWidth;
        cmd.sizeRowsOffset = rect.height - cmd.sizeRows * CharView.charHeight;
        cmd.sizeColsOffset = rect.width - cmd.sizeCols * CharView.charWidth;
        this.adjustOffsets(cmd);
        if (this.currentTool == this.lineTool) {
            cmd.sizeRows = cmd.sizeRows + (cmd.sizeRows >= 0 ? 1 : -1);
            cmd.sizeCols = cmd.sizeCols + (cmd.sizeCols >= 0 ? 1 : -1);
        }
        this.view.sendGuiEditCmd(this.guiEditCmd);
        if (this.currentTool == this.buttonTool) {
            this.accessServer(76);
        } else if (this.currentTool == this.labelTool) {
            this.accessServer(77);
        } else if (this.currentTool == this.imageTool) {
            this.accessServer(78);
        } else if (this.currentTool == this.boxTool) {
            this.accessServer(79);
        } else if (this.currentTool == this.lineTool) {
            this.accessServer(80);
        } else if (this.currentTool == this.tableTool) {
            this.accessServer(81);
        }
    }

    protected void buildToolbar() {
        this.toggleGroup = new ButtonGroup();
        this.cmdToolbar = this.view.createToolbar("Exit Options");
        this.modeToolbar = this.view.createToolbar("Modes");
        this.editToolbar = this.view.createToolbar("Edit Tools");
        this.cmdToolbar.setMargin(null);
        this.modeToolbar.setMargin(null);
        this.editToolbar.setMargin(null);
        this.view.addSeparator(this.cmdToolbar, false);
        this.view.addToToolBar(this.cmdToolbar, "Save & Exit (ESC)", (Icon)AppxResource.Gfx.SAVE_EXIT.icon(), 274);
        this.view.addToToolBar(this.cmdToolbar, "Cancel (Ctrl+F8)", (Icon)AppxResource.Gfx.CANCEL.icon(), 278);
        this.view.addSeparator(this.modeToolbar, true);
        this.lassoTool = this.view.addToggleToToolBar(this.modeToolbar, this.toggleGroup, "Select a region", (Icon)AppxResource.Gfx.SELECT_REGION.icon(), 20040, (ActionListener)this);
        this.buttonTool = this.view.addToggleToToolBar(this.modeToolbar, this.toggleGroup, "Paint a button", (Icon)AppxResource.Gfx.PAINT_BUTTON.icon(), 20041, (ActionListener)this);
        this.labelTool = this.view.addToggleToToolBar(this.modeToolbar, this.toggleGroup, "Paint a label", (Icon)AppxResource.Gfx.PAINT_LABEL.icon(), 20042, (ActionListener)this);
        this.imageTool = this.view.addToggleToToolBar(this.modeToolbar, this.toggleGroup, "Paint a picture", (Icon)AppxResource.Gfx.PAINT_IMAGE.icon(), 20043, (ActionListener)this);
        this.boxTool = this.view.addToggleToToolBar(this.modeToolbar, this.toggleGroup, "Paint a box", (Icon)AppxResource.Gfx.PAINT_BOX.icon(), 20044, (ActionListener)this);
        if ((double)Float.parseFloat("050402.28") >= 50100.0) {
            this.lineTool = this.view.addToggleToToolBar(this.modeToolbar, this.toggleGroup, "Paint a line", (Icon)AppxResource.Gfx.PAINT_LINE.icon(), 20045, (ActionListener)this);
        }
        if (IOHandler.currentHandler.checkForFeature(0x40000000)) {
            this.tableTool = this.view.addToggleToToolBar(this.modeToolbar, this.toggleGroup, "Paint a table", (Icon)AppxResource.Gfx.PAINT_TABLE.icon(), 20046, (ActionListener)this);
        }
        this.view.addSeparator(this.editToolbar, true);
        this.showCtlBtn = this.view.addToggleToToolBar(this.editToolbar, null, "Show Object Bounds", (Icon)AppxResource.Gfx.SHOW_BOUNDS.icon(), 20060, (ActionListener)this);
        this.showGridBtn = this.view.addToggleToToolBar(this.editToolbar, null, "Show Grid", (Icon)AppxResource.Gfx.SHOW_GRID.icon(), 20106, (ActionListener)this);
        this.showGuiBtn = this.view.addToggleToToolBar(this.editToolbar, null, "Show Character Interface", (Icon)AppxResource.Gfx.SHOW_CHAR_UI.icon(), 20101, (ActionListener)this);
        this.view.addToToolBar(this.editToolbar, "Data Palette", (Icon)AppxResource.Gfx.DATA_PALETTE.icon(), 20061);
        this.cutBtn = this.view.addToToolBar(this.editToolbar, "Cut selection", (Icon)AppxResource.Gfx.CUT.icon(), 20015, (ActionListener)this);
        this.copyBtn = this.view.addToToolBar(this.editToolbar, "Copy selection", (Icon)AppxResource.Gfx.COPY.icon(), 20027, (ActionListener)this);
        this.pasteBtn = this.view.addToToolBar(this.editToolbar, "Paste selection", (Icon)AppxResource.Gfx.PASTE.icon(), 20016, (ActionListener)this);
        this.winPropBtn = this.view.addToToolBar(this.editToolbar, "Edit Window Properties", (Icon)AppxResource.Gfx.WINDOW_PROPERTIES.icon(), 20063, (ActionListener)this);
        this.propBtn = this.view.addToToolBar(this.editToolbar, "Edit Object Properties", (Icon)AppxResource.Gfx.OBJECT_PROPERTIES.icon(), 20062, (ActionListener)this);
        this.alignTopBtn = this.view.addToToolBar(this.editToolbar, "Align Tops", (Icon)AppxResource.Gfx.ALIGN_TOP.icon(), 20064, (ActionListener)this);
        this.alignBotBtn = this.view.addToToolBar(this.editToolbar, "Align Bottoms", (Icon)AppxResource.Gfx.ALIGN_BOTTOM.icon(), 20065, (ActionListener)this);
        this.alignLeftBtn = this.view.addToToolBar(this.editToolbar, "Align Left Sides", (Icon)AppxResource.Gfx.ALIGN_LEFT.icon(), 20066, (ActionListener)this);
        this.alignRightBtn = this.view.addToToolBar(this.editToolbar, "Align Right Sides", (Icon)AppxResource.Gfx.ALIGN_RIGHT.icon(), 20067, (ActionListener)this);
        this.sameVertBtn = this.view.addToToolBar(this.editToolbar, "Make same vertical size", (Icon)AppxResource.Gfx.SAME_SIZE_VERT.icon(), 20068, (ActionListener)this);
        this.sameHorizBtn = this.view.addToToolBar(this.editToolbar, "Make same horizontal size", (Icon)AppxResource.Gfx.SAME_SIZE_HORIZ.icon(), 20069, (ActionListener)this);
        if (Globals.getOptionValueBoolean("newImageEditorTools")) {
            this.spreadVertBtn = this.view.addToToolBar(this.editToolbar, "Spread vertical space", (Icon)AppxResource.Gfx.SPREAD_VERT.icon(), 20073, (ActionListener)this);
            this.spreadHorizBtn = this.view.addToToolBar(this.editToolbar, "Spread horizontal space", (Icon)AppxResource.Gfx.SPREAD_HORIZ.icon(), 20072, (ActionListener)this);
        }
        this.showCtlBtn.setSelected(false);
        this.showGridBtn.setSelected(Globals.getOptionValueBoolean("showGridlines"));
        this.showGuiBtn.setSelected(!Globals.getOptionValueBoolean("guiInterface"));
        this.selectTool(this.lassoTool);
        this.updateToolbar();
    }

    public void clearSavedSelections() {
        this.selectState.clearControls();
    }

    int col2x(int col, boolean lowerRight) {
        if (lowerRight) {
            ++col;
        }
        return col * CharView.charWidth;
    }

    protected JMenuItem createMenuItem(String lbl, char mn, ActionListener act, KeyListener key, int cmd) {
        return this.createMenuItem(lbl, mn, act, key, Integer.toString(cmd));
    }

    protected JMenuItem createMenuItem(String lbl, char mn, ActionListener act, KeyListener key, String cmd) {
        JMenuItem jmi = new JMenuItem(lbl);
        jmi.addActionListener(act);
        jmi.setActionCommand(cmd);
        if (mn != ' ') {
            jmi.setMnemonic(mn);
        }
        if (key != null) {
            jmi.addKeyListener(key);
        }
        return jmi;
    }

    public Rectangle getCellBounds() {
        if (this.cellBounds == null) {
            this.cellBounds = new Rectangle(0, 0, 0, 0);
        }
        return this.cellBounds;
    }

    public int getDragHandle(Point p) {
        int handle = this.selectState.getDragHandle(p);
        if (handle == 0 && this.guideBarGroup != null) {
            handle = this.guideBarGroup.getDragHandle(p);
        }
        return handle;
    }

    @Override
    public Point getLocation() {
        return new Point(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.parent == null) {
            return new Dimension(0, 0);
        }
        return this.parent.getPreferredSize();
    }

    int h2row(int h) {
        return h / CharView.charHeight;
    }

    public void hidePane() {
        this.parent = null;
        this.setCellBounds(0, 0, 0, 0);
        this.selectState.clearAllSelections(null);
        if (this.cmdToolbar != null) {
            this.view.toolBar.remove(this.cmdToolbar);
            this.view.toolBar.remove(this.modeToolbar);
            this.view.toolBar.remove(this.editToolbar);
            if (this.view.defaultToolBar != null) {
                this.view.toolBar.add(this.view.defaultToolBar);
            }
            this.cmdToolbar.setVisible(false);
            this.modeToolbar.setVisible(false);
            this.editToolbar.setVisible(false);
        }
    }

    public boolean isHidden() {
        return this.parent == null;
    }

    public ImgEditorPane(CharView v) {
        this.view = v;
        this.cellBounds = new Rectangle(0, 0, 0, 0);
        this.setBounds(this.cellBounds);
        this.setOpaque(false);
        this.setVisible(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AppxControl ctrl = ImgEditorPane.this.parent.getSelectableObject(e.getPoint());
                    if (ctrl != null) {
                        Rectangle rect = ctrl.getCellBounds();
                        if (rect != null) {
                            ImgEditorPane.this.view.putCursor(rect.x, rect.y);
                            ImgEditorPane.this.accessServer(268);
                        }
                        e.consume();
                    }
                } else if (ImgEditorPane.this.selectState.getItemCount() == 0) {
                    ImgEditorPane.this.view.mouseClicked(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ImgEditorPane.this.selectState.contains(e.getPoint())) {
                    AppxControl ctrl = ImgEditorPane.this.parent.getSelectableObject(e.getPoint());
                    if (ImgEditorPane.this.guideBarGroup == null || ImgEditorPane.this.guideBarGroup.getGuideBar(e.getPoint()) == null) {
                        if (ctrl != null) {
                            ImgEditorPane.this.selectState.addRect(ctrl, e.isControlDown(), ImgEditorPane.this.getGraphics(), null);
                            ImgEditorPane.this.lastDragHandle = 13;
                            ImgEditorPane.this.setCursor(new Cursor(ImgEditorPane.this.lastDragHandle));
                        } else if (!e.isControlDown()) {
                            ImgEditorPane.this.selectState.clearAllSelections(ImgEditorPane.this.getGraphics());
                        }
                    }
                } else if (e.isControlDown()) {
                    ImgEditorPane.this.selectState.removeItem(e.getPoint(), ImgEditorPane.this.getGraphics());
                }
                ImgEditorPane.this.mouseDown = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || (e.getModifiers() & 4) == 4) {
                    JPopupMenu popup = ImgEditorPane.this.makePopup(e.getPoint());
                    ImgEditorPane.this.add(popup);
                    popup.show(ImgEditorPane.this.self, e.getX(), e.getY());
                } else if (ImgEditorPane.this.dragMode == DragMode.SELECTIONS) {
                    ImgEditorPane.this.selectState.restoreItemStates(ImgEditorPane.this.getGraphics());
                    ImgEditorPane.this.applyChanges();
                } else if (ImgEditorPane.this.dragMode == DragMode.GUIDEBARS) {
                    ImgEditorPane.this.guideBarGroup.dropOldBars(ImgEditorPane.this.getGraphics());
                } else if (ImgEditorPane.this.dragMode == DragMode.LASSO) {
                    if (ImgEditorPane.this.currentTool == ImgEditorPane.this.lassoTool) {
                        ImgEditorPane.this.selectState.selectLasso(ImgEditorPane.this.getGraphics());
                    } else {
                        ImgEditorPane.this.applyTool(ImgEditorPane.this.selectState.getLasso(), ImgEditorPane.this.guiEditCmd);
                    }
                }
                ImgEditorPane.this.dragMode = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                String msg = null;
                AppxControl ctrl = ImgEditorPane.this.parent.getSelectableObject(e.getPoint());
                if (ctrl != null && ctrl instanceof AppxLine) {
                    Graphics g = ImgEditorPane.this.getGraphics();
                    g.setColor(Color.black);
                }
                if (ctrl != null && ((JComponent)((Object)ctrl)).getToolTipText() != null) {
                    msg = "x=" + e.getX() / CharView.charWidth + ", y=" + e.getY() / CharView.charHeight + ", " + ((JComponent)((Object)ctrl)).getToolTipText();
                } else {
                    msg = "x=" + e.getX() / CharView.charWidth + ", y=" + e.getY() / CharView.charHeight;
                    if (ImgEditorPane.this.parent.isPrinterAspect()) {
                        msg = String.valueOf(msg) + ", [Lpi=" + ImgEditorPane.this.parent.getPrintRows() + " Cpi=" + ImgEditorPane.this.parent.getPrintCols();
                        msg = ImgEditorPane.this.parent.getFormPrintRows() == 0.0f && ImgEditorPane.this.parent.getFormPrintCols() == 0.0f ? String.valueOf(msg) + " from Preferences]" : String.valueOf(msg) + " from Server Form]";
                    }
                }
                ImgEditorPane.this.parent.getView().setStatusText(msg);
                int handle = ImgEditorPane.this.getDragHandle(e.getPoint());
                if (handle != ImgEditorPane.this.lastDragHandle) {
                    ImgEditorPane.this.lastDragHandle = handle;
                    ImgEditorPane.this.setCursor(new Cursor(handle));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!e.isPopupTrigger() || (e.getModifiers() & 4) == 4) {
                    ImgEditorPane.this.parent.getView().setStatusText("x=" + e.getX() / CharView.charWidth + ", y=" + e.getY() / CharView.charHeight);
                    Point delta = new Point();
                    Point p = e.getPoint();
                    if (ImgEditorPane.this.dragMode == null) {
                        if (ImgEditorPane.this.selectState.contains(ImgEditorPane.this.mouseDown)) {
                            if (ImgEditorPane.this.view.isImageEditorEditable()) {
                                ImgEditorPane.this.dragMode = DragMode.SELECTIONS;
                                ImgEditorPane.this.selectState.saveItemStates();
                            }
                        } else if (ImgEditorPane.this.guideBarGroup != null && ImgEditorPane.this.guideBarGroup.getGuideBar(ImgEditorPane.this.mouseDown) != null) {
                            if (ImgEditorPane.this.view.isImageEditorEditable()) {
                                ImgEditorPane.this.dragMode = DragMode.GUIDEBARS;
                            }
                        } else {
                            ImgEditorPane.this.dragMode = DragMode.LASSO;
                        }
                    }
                    delta.x = p.x - ImgEditorPane.this.mouseDown.x;
                    delta.y = p.y - ImgEditorPane.this.mouseDown.y;
                    if (!(e.isShiftDown() || ImgEditorPane.this.dragMode == DragMode.LASSO && ImgEditorPane.this.currentTool == ImgEditorPane.this.lassoTool)) {
                        delta.x -= delta.x % CharView.charWidth;
                        delta.y -= delta.y % CharView.charHeight;
                    }
                    if (ImgEditorPane.this.dragMode == DragMode.LASSO) {
                        if (ImgEditorPane.this.selectState.isLassoHidden()) {
                            if (ImgEditorPane.this.currentTool == ImgEditorPane.this.lassoTool) {
                                ImgEditorPane.this.selectState.showLasso(ImgEditorPane.this.mouseDown.x, ImgEditorPane.this.mouseDown.y);
                            } else {
                                int x = ImgEditorPane.this.mouseDown.x - ImgEditorPane.this.mouseDown.x % CharView.charWidth;
                                int y = ImgEditorPane.this.mouseDown.y - ImgEditorPane.this.mouseDown.y % CharView.charHeight;
                                ImgEditorPane.this.selectState.showLasso(x, y);
                            }
                        }
                        ImgEditorPane.this.selectState.resizeLasso(delta, ImgEditorPane.this.getGraphics());
                    } else if (ImgEditorPane.this.dragMode == DragMode.GUIDEBARS) {
                        GuideBar bar = ImgEditorPane.this.guideBarGroup.getGuideBar(ImgEditorPane.this.mouseDown);
                        if (bar != null) {
                            bar.deltaPos(delta, ImgEditorPane.this.getGraphics());
                        }
                    } else if (ImgEditorPane.this.dragMode == DragMode.SELECTIONS) {
                        if (ImgEditorPane.this.lastDragHandle == 13) {
                            ImgEditorPane.this.selectState.setBounds(ImgEditorPane.this.getBounds());
                            ImgEditorPane.this.selectState.move(delta, ImgEditorPane.this.getGraphics());
                        } else {
                            ImgEditorPane.this.selectState.resize(delta, ImgEditorPane.this.lastDragHandle, ImgEditorPane.this.getGraphics());
                        }
                    }
                    ImgEditorPane.this.mouseDown.x += delta.x;
                    ImgEditorPane.this.mouseDown.y += delta.y;
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\r' || e.getKeyChar() == '\n') {
                    ImgEditorPane.this.accessServer(304);
                    e.consume();
                    return;
                }
                if (ImgEditorPane.this.selectState.getItemCount() == 0) {
                    return;
                }
                if (e.getKeyCode() == 27 || e.getKeyCode() == 119 || e.getKeyCode() == CharView.view.getEndSpecialKeyId()) {
                    ImgEditorPane.this.selectState.clearAllSelections(ImgEditorPane.this.getGraphics());
                    e.consume();
                    return;
                }
                Point delta = new Point(0, 0);
                ImgEditorPane.this.selectState.setBounds(ImgEditorPane.this.getBounds());
                if (e.isAltDown()) {
                    switch (e.getKeyCode()) {
                        case 38: {
                            ImgEditorPane.this.performAction(20064, null);
                            e.consume();
                            break;
                        }
                        case 37: {
                            ImgEditorPane.this.performAction(20066, null);
                            e.consume();
                            break;
                        }
                        case 40: {
                            ImgEditorPane.this.performAction(20065, null);
                            e.consume();
                            break;
                        }
                        case 39: {
                            ImgEditorPane.this.performAction(20067, null);
                            e.consume();
                            break;
                        }
                        case 61: {
                            ImgEditorPane.this.performAction(20068, null);
                            e.consume();
                            break;
                        }
                        case 92: {
                            ImgEditorPane.this.performAction(20069, null);
                            e.consume();
                        }
                    }
                    return;
                }
                switch (e.getKeyCode()) {
                    case 38: {
                        delta.y = -1;
                        e.consume();
                        break;
                    }
                    case 40: {
                        delta.y = 1;
                        e.consume();
                        break;
                    }
                    case 37: {
                        delta.x = -1;
                        e.consume();
                        break;
                    }
                    case 39: {
                        delta.x = 1;
                        e.consume();
                        break;
                    }
                    case 121: 
                    case 127: {
                        ImgEditorPane.this.performAction(ImgEditorPane.this.view.checkForFeature(Integer.MIN_VALUE) ? 20034 : 20015, null);
                        e.consume();
                        return;
                    }
                }
                if (!e.isShiftDown()) {
                    delta.x *= CharView.charWidth;
                    delta.y *= CharView.charHeight;
                }
                if (delta.x != 0 || delta.y != 0) {
                    ImgEditorPane.this.selectState.move(delta, ImgEditorPane.this.getGraphics());
                    e.consume();
                }
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (ImgEditorPane.this.selectState.getItemCount() != 0) {
                    ImgEditorPane.this.applyChanges();
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (ImgEditorPane.this.selectState.getItemCount() != 0) {
                    e.consume();
                }
            }
        });
    }

    protected JPopupMenu makePopup(Point p) {
        int selectCount = this.selectState.getItemCount();
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu("Options...");
            this.popupDel = this.createMenuItem("Delete", 'd', (ActionListener)this, null, 20034);
            this.popupMenu.add(this.popupDel);
            this.popupCut = this.createMenuItem("Cut", 'x', (ActionListener)this, null, 20015);
            this.popupMenu.add(this.popupCut);
            this.popupCopy = this.createMenuItem("Copy", 'C', (ActionListener)this, null, 20027);
            this.popupMenu.add(this.popupCopy);
            this.popupPaste = this.createMenuItem("Paste", 'P', (ActionListener)this, null, 20016);
            this.popupMenu.add(this.popupPaste);
            this.popupMenu.addSeparator();
            this.popupObjProps = this.createMenuItem("Object Properties", 'r', (ActionListener)this, null, 20062);
            this.popupMenu.add(this.popupObjProps);
            this.popupWinProps = this.createMenuItem("Window Properties", 'r', (ActionListener)this, null, 20063);
            this.popupMenu.add(this.popupWinProps);
            this.popupMenu.addSeparator();
            this.popupAlignTop = this.createMenuItem("Align Tops", 'T', (ActionListener)this, null, 20064);
            this.popupMenu.add(this.popupAlignTop);
            this.popupAlignBottom = this.createMenuItem("Align Bottoms", 'B', (ActionListener)this, null, 20065);
            this.popupMenu.add(this.popupAlignBottom);
            this.popupAlignLeft = this.createMenuItem("Align Left sides", 'L', (ActionListener)this, null, 20066);
            this.popupMenu.add(this.popupAlignLeft);
            this.popupAlignRight = this.createMenuItem("Align Right sides", 'R', (ActionListener)this, null, 20067);
            this.popupMenu.add(this.popupAlignRight);
            this.popupMenu.addSeparator();
            this.popupSameSizeVert = this.createMenuItem("Make same size (vertical)", 'v', (ActionListener)this, null, 20068);
            this.popupMenu.add(this.popupSameSizeVert);
            this.popupSameSizeHorz = this.createMenuItem("Make same size (horizontal)", 'h', (ActionListener)this, null, 20069);
            this.popupMenu.add(this.popupSameSizeHorz);
            if (Globals.getOptionValueBoolean("newImageEditorTools")) {
                this.popupSpreadVert = this.createMenuItem("Spread vertical space", 'e', (ActionListener)this, null, 20073);
                this.popupMenu.add(this.popupSpreadVert);
                this.popupSpreadHorz = this.createMenuItem("Spread horizontal space", 'o', (ActionListener)this, null, 20072);
                this.popupMenu.add(this.popupSpreadHorz);
            }
            this.popupMenu.addSeparator();
            this.popupNewGuideVert = this.createMenuItem("New Vertical Guide", 'v', (ActionListener)this, null, 20070);
            this.popupMenu.add(this.popupNewGuideVert);
            this.popupNewGuideHorz = this.createMenuItem("New Horizontal Guide", 'h', (ActionListener)this, null, 20071);
            this.popupMenu.add(this.popupNewGuideHorz);
            this.popupMenu.addSeparator();
            this.popupOptionNumbers = this.createMenuItem("Toggle Option Numbers", 'N', (ActionListener)CharView.view, null, 20102);
            this.popupMenu.add(this.popupOptionNumbers);
        }
        if (this.view.isImageEditorEditable()) {
            this.popupDel.setEnabled(true);
            this.popupCut.setEnabled(true);
            this.popupPaste.setEnabled(true);
            this.popupAlignTop.setEnabled(true);
            this.popupAlignBottom.setEnabled(true);
            this.popupAlignLeft.setEnabled(true);
            this.popupAlignRight.setEnabled(true);
            this.popupSameSizeVert.setEnabled(true);
            this.popupSameSizeHorz.setEnabled(true);
            this.popupWinProps.setEnabled(true);
            if (Globals.getOptionValueBoolean("newImageEditorTools")) {
                this.popupSpreadVert.setEnabled(true);
                this.popupSpreadHorz.setEnabled(true);
            }
        }
        boolean state = selectCount != 0;
        this.popupDel.setEnabled(state);
        this.popupCut.setEnabled(state);
        this.popupCopy.setEnabled(state);
        this.popupObjProps.setEnabled(selectCount == 1);
        state = selectCount >= 2;
        this.popupAlignTop.setEnabled(state);
        this.popupAlignBottom.setEnabled(state);
        this.popupAlignLeft.setEnabled(state);
        this.popupAlignRight.setEnabled(state);
        this.popupSameSizeVert.setEnabled(state);
        this.popupSameSizeHorz.setEnabled(state);
        state = selectCount > 2;
        if (Globals.getOptionValueBoolean("newImageEditorTools")) {
            this.popupSpreadVert.setEnabled(state);
            this.popupSpreadHorz.setEnabled(state);
        }
        if (!this.view.isImageEditorEditable()) {
            this.popupDel.setEnabled(false);
            this.popupCut.setEnabled(false);
            this.popupPaste.setEnabled(false);
            this.popupAlignTop.setEnabled(false);
            this.popupAlignBottom.setEnabled(false);
            this.popupAlignLeft.setEnabled(false);
            this.popupAlignRight.setEnabled(false);
            this.popupSameSizeVert.setEnabled(false);
            this.popupSameSizeHorz.setEnabled(false);
            this.popupCopy.setEnabled(false);
            this.popupObjProps.setEnabled(false);
            this.popupWinProps.setEnabled(false);
        }
        return this.popupMenu;
    }

    @Override
    public void paint(Graphics g) {
        this.selectState.paint(g);
        if (this.guideBarGroup != null) {
            this.guideBarGroup.paint(g);
        }
    }

    public void performAction(int action, Point p) {
        switch (action) {
            case 20063: {
                this.accessServer(21);
                break;
            }
            case 20062: {
                Rectangle rect;
                AppxControl ctrl;
                if (p == null || (ctrl = this.parent.getSelectableObject(p)) == null || (rect = ctrl.getCellBounds()) == null) break;
                this.view.putCursor(rect.x, rect.y);
                this.accessServer(268);
                break;
            }
            case 20015: {
                this.selectState.cut(this.getGraphics());
                break;
            }
            case 20034: {
                if (this.view.checkForFeature(Integer.MIN_VALUE)) {
                    this.selectState.del(this.getGraphics());
                    break;
                }
                this.selectState.cut(this.getGraphics());
                break;
            }
            case 20027: {
                this.selectState.copy(this.getGraphics());
                break;
            }
            case 20016: {
                this.guiEditCmd.initData();
                this.guiEditCmd.cmd = 11;
                this.guiEditCmd.subCmd = 103;
                this.guiEditCmd.posNewRow = this.y2row(p.y);
                this.guiEditCmd.posNewCol = this.x2col(p.x);
                this.view.sendGuiEditCmd(this.guiEditCmd);
                this.accessServer(63);
                break;
            }
            case 20064: {
                this.selectState.align(1, this.getGraphics());
                break;
            }
            case 20065: {
                this.selectState.align(3, this.getGraphics());
                break;
            }
            case 20066: {
                this.selectState.align(2, this.getGraphics());
                break;
            }
            case 20067: {
                this.selectState.align(4, this.getGraphics());
                break;
            }
            case 20068: {
                this.selectState.sizeAll(1, this.getGraphics());
                break;
            }
            case 20069: {
                this.selectState.sizeAll(0, this.getGraphics());
                break;
            }
            case 20072: {
                this.selectState.spread(0, this.getGraphics());
                break;
            }
            case 20073: {
                this.selectState.spread(1, this.getGraphics());
                break;
            }
            case 20070: {
                Rectangle bounds = this.getBounds();
                if (this.guideBarGroup == null) {
                    this.guideBarGroup = new GuideBarGroup(this);
                }
                int x = p.x - p.x % CharView.charWidth;
                this.guideBarGroup.addBar(this.getGraphics(), x, 0, x, bounds.height);
                break;
            }
            case 20071: {
                Rectangle bounds = this.getBounds();
                if (this.guideBarGroup == null) {
                    this.guideBarGroup = new GuideBarGroup(this);
                }
                int y = p.y - p.y % CharView.charHeight;
                this.guideBarGroup.addBar(this.getGraphics(), 0, y, bounds.width, y);
            }
        }
        this.applyChanges();
    }

    Point point2rc(Point p) {
        Point result = new Point();
        result.x = this.x2col(p.x);
        result.y = this.y2row(p.y);
        return result;
    }

    Point rc2point(Point p, boolean lowerRight) {
        Point result = new Point();
        result.x = this.col2x(p.x, lowerRight);
        result.y = this.row2y(p.y, lowerRight);
        return result;
    }

    int row2y(int row, boolean lowerRight) {
        if (lowerRight) {
            ++row;
        }
        return row * CharView.charHeight;
    }

    protected void selectTool(JToggleButton tool) {
        this.lassoTool.setSelected(tool == this.lassoTool);
        this.buttonTool.setSelected(tool == this.buttonTool);
        this.labelTool.setSelected(tool == this.labelTool);
        this.imageTool.setSelected(tool == this.imageTool);
        this.boxTool.setSelected(tool == this.boxTool);
        if (this.lineTool != null) {
            this.lineTool.setSelected(tool == this.lineTool);
        }
        if (this.tableTool != null) {
            this.tableTool.setSelected(tool == this.tableTool);
        }
        this.currentTool = tool;
    }

    public void sendSelections() {
        this.selectState.sendSelections(this.guiEditCmd, this.view);
    }

    public void setCellBounds(int x, int y, int width, int height) {
        this.cellBounds.x = x;
        this.cellBounds.y = y;
        this.cellBounds.width = width;
        this.cellBounds.height = height;
        if (width == 0 && height == 0) {
            this.setBounds(new Rectangle(0, 0, 0, 0));
        } else {
            this.setBounds(new Rectangle(x * CharView.charWidth, y * CharView.charHeight, width * CharView.charWidth, (height + 1) * CharView.charHeight));
        }
    }

    public void setCellBounds(Rectangle b) {
        this.setCellBounds(b.x, b.y, b.width, b.height);
    }

    public void showPane(Display d, Rectangle bounds, Rectangle cellBounds) {
        if (this.cmdToolbar == null) {
            this.buildToolbar();
        }
        this.parent = d;
        this.setCellBounds(cellBounds);
        if (!this.retainSelections) {
            this.selectState.clearAllSelections(null);
        } else {
            this.selectState.reaquireControls(null);
            this.retainSelections = false;
        }
        if (this.view.defaultToolBar != null) {
            this.view.toolBar.remove(this.view.defaultToolBar);
        }
        this.view.toolBar.add(this.cmdToolbar);
        this.view.toolBar.add(this.modeToolbar);
        this.view.toolBar.add(this.editToolbar);
        this.cmdToolbar.setVisible(true);
        this.modeToolbar.setVisible(true);
        this.editToolbar.setVisible(true);
        this.selectTool(this.lassoTool);
        this.requestFocus();
    }

    protected void updateToolbar() {
        if (this.cmdToolbar == null) {
            return;
        }
        if (this.view.isImageEditorEditable()) {
            this.buttonTool.setEnabled(true);
            this.labelTool.setEnabled(true);
            this.imageTool.setEnabled(true);
            this.boxTool.setEnabled(true);
            if (this.lineTool != null) {
                this.lineTool.setEnabled(true);
            }
            if (this.tableTool != null) {
                this.tableTool.setEnabled(true);
            }
            this.cutBtn.setEnabled(true);
            this.pasteBtn.setEnabled(true);
            this.winPropBtn.setEnabled(true);
            this.alignTopBtn.setEnabled(true);
            this.alignBotBtn.setEnabled(true);
            this.alignLeftBtn.setEnabled(true);
            this.alignRightBtn.setEnabled(true);
            this.sameVertBtn.setEnabled(true);
            this.sameHorizBtn.setEnabled(true);
            if (Globals.getOptionValueBoolean("newImageEditorTools")) {
                this.spreadVertBtn.setEnabled(true);
                this.spreadHorizBtn.setEnabled(true);
            }
        }
        if (this.selectState.getItemCount() == 0) {
            this.pasteBtn.setEnabled(true);
            this.cutBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
            this.propBtn.setEnabled(false);
            this.alignTopBtn.setEnabled(false);
            this.alignBotBtn.setEnabled(false);
            this.alignLeftBtn.setEnabled(false);
            this.alignRightBtn.setEnabled(false);
            this.sameVertBtn.setEnabled(false);
            this.sameHorizBtn.setEnabled(false);
            if (Globals.getOptionValueBoolean("newImageEditorTools")) {
                this.spreadVertBtn.setEnabled(false);
                this.spreadHorizBtn.setEnabled(false);
            }
        } else if (this.selectState.getItemCount() == 1) {
            this.cutBtn.setEnabled(true);
            this.copyBtn.setEnabled(true);
            this.propBtn.setEnabled(true);
            this.pasteBtn.setEnabled(false);
            this.alignTopBtn.setEnabled(false);
            this.alignBotBtn.setEnabled(false);
            this.alignLeftBtn.setEnabled(false);
            this.alignRightBtn.setEnabled(false);
            this.sameVertBtn.setEnabled(false);
            this.sameHorizBtn.setEnabled(false);
            if (Globals.getOptionValueBoolean("newImageEditorTools")) {
                this.spreadVertBtn.setEnabled(false);
                this.spreadHorizBtn.setEnabled(false);
            }
        } else if (this.selectState.getItemCount() == 2) {
            this.alignTopBtn.setEnabled(true);
            this.alignBotBtn.setEnabled(true);
            this.alignLeftBtn.setEnabled(true);
            this.alignRightBtn.setEnabled(true);
            this.sameVertBtn.setEnabled(true);
            this.sameHorizBtn.setEnabled(true);
            if (Globals.getOptionValueBoolean("newImageEditorTools")) {
                this.spreadVertBtn.setEnabled(false);
                this.spreadHorizBtn.setEnabled(false);
            }
            this.cutBtn.setEnabled(true);
            this.copyBtn.setEnabled(true);
            this.pasteBtn.setEnabled(false);
            this.propBtn.setEnabled(false);
        } else {
            this.alignTopBtn.setEnabled(true);
            this.alignBotBtn.setEnabled(true);
            this.alignLeftBtn.setEnabled(true);
            this.alignRightBtn.setEnabled(true);
            this.sameVertBtn.setEnabled(true);
            this.sameHorizBtn.setEnabled(true);
            if (Globals.getOptionValueBoolean("newImageEditorTools")) {
                this.spreadVertBtn.setEnabled(true);
                this.spreadHorizBtn.setEnabled(true);
            }
            this.cutBtn.setEnabled(true);
            this.copyBtn.setEnabled(true);
            this.pasteBtn.setEnabled(false);
            this.propBtn.setEnabled(false);
        }
        if (!this.view.isImageEditorEditable()) {
            this.buttonTool.setEnabled(false);
            this.labelTool.setEnabled(false);
            this.imageTool.setEnabled(false);
            this.boxTool.setEnabled(false);
            if (this.lineTool != null) {
                this.lineTool.setEnabled(false);
            }
            if (this.tableTool != null) {
                this.tableTool.setEnabled(false);
            }
            this.cutBtn.setEnabled(false);
            this.pasteBtn.setEnabled(false);
            this.winPropBtn.setEnabled(false);
            this.alignTopBtn.setEnabled(false);
            this.alignBotBtn.setEnabled(false);
            this.alignLeftBtn.setEnabled(false);
            this.alignRightBtn.setEnabled(false);
            this.sameVertBtn.setEnabled(false);
            this.sameHorizBtn.setEnabled(false);
            if (Globals.getOptionValueBoolean("newImageEditorTools")) {
                this.spreadVertBtn.setEnabled(false);
                this.spreadHorizBtn.setEnabled(false);
            }
        }
    }

    int w2col(int w) {
        return w / CharView.charWidth;
    }

    int x2col(int x) {
        int width = CharView.charWidth;
        return this.parent.adjCellColumn(x / width - 1);
    }

    int y2row(int y) {
        int height = CharView.charHeight;
        return this.parent.adjCellRow(y / height - 1);
    }

    private static enum DragMode {
        SELECTIONS,
        GUIDEBARS,
        LASSO;

    }

    protected class GuideBar {
        protected Point p1;
        protected Point p2;
        protected boolean vert;
        protected Color color = Color.blue;
        protected int verticalFudge = 2;
        protected int horizontalFudge = 3;

        public GuideBar(Graphics g, int x1, int y1, int x2, int y2) {
            this.p1 = new Point(x1, y1);
            this.p2 = new Point(x2, y2);
            this.vert = x1 == x2;
            this.paint(g);
        }

        public int getOrient() {
            if (this.vert) {
                return 1;
            }
            return 0;
        }

        public int getY() {
            if (this.vert) {
                return -1;
            }
            return this.p1.y;
        }

        public int getX() {
            if (this.vert) {
                return this.p1.x;
            }
            return -1;
        }

        public GuideBar(Graphics g, Point p_1, Point p_2) {
            this(g, p_1.x, p_1.y, p_2.x, p_2.y);
        }

        public void paint(Graphics g) {
            g.setXORMode(Color.lightGray);
            g.setColor(this.color);
            g.drawLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
            g.setPaintMode();
        }

        public void deltaPos(Point delta, Graphics g) {
            this.paint(g);
            if (this.vert) {
                this.p1.x += delta.x;
                this.p2.x += delta.x;
            } else {
                this.p1.y += delta.y;
                this.p2.y += delta.y;
            }
            this.paint(g);
        }

        public int getDragHandle(Point p) {
            if (this.vert) {
                if (p.x >= this.p1.x - this.horizontalFudge && p.x <= this.p1.x + this.horizontalFudge) {
                    return 11;
                }
            } else if (p.y >= this.p1.y - this.verticalFudge && p.y <= this.p1.y + this.verticalFudge) {
                return 8;
            }
            return 0;
        }

        public boolean inBounds(Rectangle bounds) {
            return this.vert ? this.p1.x >= 0 && this.p1.x <= bounds.width : this.p1.y >= 0 && this.p1.y <= bounds.height;
        }
    }

    protected class GuideBarGroup {
        protected Vector<GuideBar> guideBars;
        protected ImgEditorPane parent;

        public GuideBarGroup(ImgEditorPane p) {
            this.parent = p;
        }

        public void dropOldBars(Graphics g) {
            if (this.guideBars == null) {
                return;
            }
            int max = this.guideBars.size();
            int i = max - 1;
            while (i >= 0) {
                GuideBar bar = this.guideBars.elementAt(i);
                if (!bar.inBounds(this.parent.getBounds())) {
                    bar.paint(g);
                    this.guideBars.removeElementAt(i);
                }
                --i;
            }
        }

        public void addBar(Graphics g, int x1, int y1, int x2, int y2) {
            if (this.guideBars == null) {
                this.guideBars = new Vector();
            }
            this.guideBars.addElement(new GuideBar(g, x1, y1, x2, y2));
        }

        public void paint(Graphics g) {
            if (this.guideBars == null) {
                return;
            }
            for (GuideBar bar : this.guideBars) {
                bar.paint(g);
            }
        }

        public int getDragHandle(Point p) {
            if (this.guideBars == null) {
                return 0;
            }
            for (GuideBar bar : this.guideBars) {
                int handle = bar.getDragHandle(p);
                if (handle == 0) continue;
                return handle;
            }
            return 0;
        }

        public GuideBar getGuideBar(Point p) {
            if (this.guideBars == null) {
                return null;
            }
            for (GuideBar bar : this.guideBars) {
                if (bar.getDragHandle(p) == 0) continue;
                return bar;
            }
            return null;
        }
    }

    protected class SelectState {
        protected Vector<SaveItem> saveItems = new Vector();
        protected Vector<SelectItem> selectItems = new Vector();
        protected Rectangle bounds = new Rectangle();
        protected Rectangle lasso = new Rectangle();
        protected Rectangle track = new Rectangle();
        protected boolean lassoHidden = true;
        protected boolean greedySelect = false;

        public int getItemCount() {
            return this.selectItems.size();
        }

        public void selectLasso(Graphics g) {
            this.hideLasso(g);
            Enumeration objects = ImgEditorPane.this.parent.getSelectableObjects(this.lasso, this.greedySelect).elements();
            while (objects.hasMoreElements()) {
                this.addRect((AppxControl)objects.nextElement(), true, g, null);
            }
        }

        public Rectangle getLasso() {
            return this.lasso;
        }

        public void hideLasso(Graphics g) {
            if (!this.lassoHidden) {
                this.paintLasso(g);
            }
            this.lassoHidden = true;
        }

        public void showLasso(int x, int y) {
            this.lasso.setLocation(x, y);
            this.lasso.setSize(0, 0);
            this.track.setLocation(x, y);
            this.track.setSize(0, 0);
            this.lassoHidden = false;
            this.greedySelect = false;
        }

        public boolean isLassoHidden() {
            return this.lassoHidden;
        }

        public void paintLasso(Graphics g) {
            g.setXORMode(Color.lightGray);
            if (this.greedySelect) {
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.magenta);
            }
            if (ImgEditorPane.this.currentTool == ImgEditorPane.this.lineTool) {
                g.drawLine(this.lasso.x, this.lasso.y, this.lasso.x + this.lasso.width, this.lasso.y + this.lasso.height);
            } else {
                g.drawRect(this.lasso.x, this.lasso.y, this.lasso.width, this.lasso.height);
            }
        }

        public void resizeLasso(Point delta, Graphics g) {
            if (delta.x != 0 || delta.y != 0) {
                this.paintLasso(g);
                this.greedySelect = false;
                this.track.width += delta.x;
                this.track.height += delta.y;
                if (this.track.width >= 0 || ImgEditorPane.this.currentTool == ImgEditorPane.this.lineTool) {
                    this.lasso.x = this.track.x;
                    this.lasso.width = this.track.width;
                } else {
                    this.greedySelect = true;
                    this.lasso.x = this.track.x + this.track.width;
                    this.lasso.width = this.track.width * -1;
                }
                if (this.track.height >= 0 || ImgEditorPane.this.currentTool == ImgEditorPane.this.lineTool) {
                    this.lasso.y = this.track.y;
                    this.lasso.height = this.track.height;
                } else {
                    this.greedySelect = true;
                    this.lasso.y = this.track.y + this.track.height;
                    this.lasso.height = this.track.height * -1;
                }
                this.paintLasso(g);
            }
        }

        public void clearAllSelections(Graphics g) {
            if (g != null) {
                for (SelectItem deadItem : this.selectItems) {
                    deadItem.paint(g);
                }
            }
            this.selectItems.removeAllElements();
            ImgEditorPane.this.updateToolbar();
        }

        public void saveItemStates() {
            for (SelectItem deadItem : this.selectItems) {
                deadItem.saveState();
            }
        }

        public void restoreItemStates(Graphics g) {
            for (SelectItem deadItem : this.selectItems) {
                deadItem.restoreState(g);
            }
        }

        public void clearControls() {
            this.saveItems.removeAllElements();
        }

        public void releaseControls() {
            for (SelectItem deadItem : this.selectItems) {
                this.saveItems.addElement(new SaveItem(deadItem.getOrigBounds(), deadItem.getCurrentBounds(), deadItem.getState()));
            }
            this.clearAllSelections(null);
        }

        public void reaquireControls(Graphics g) {
            for (SaveItem saveItem : this.saveItems) {
                AppxControl ctl = ImgEditorPane.this.parent.getSelectableObject(saveItem.getCurrentBounds());
                if (ctl == null) {
                    ctl = ImgEditorPane.this.parent.getSelectableObject(saveItem.getOrigBounds());
                }
                if (ctl == null) continue;
                this.addRect(ctl, true, g, saveItem.getState());
            }
            this.saveItems.removeAllElements();
        }

        public void addRect(AppxControl newCtrl, boolean append, Graphics g, SelectionState forceState) {
            SelectionState workState = forceState == null ? SelectionState.LAST : forceState;
            SelectItem item = new SelectItem(newCtrl, workState, ImgEditorPane.this.parent);
            int insertIndex = -1;
            if (append) {
                for (SelectItem oldItem1 : this.selectItems) {
                    if (!oldItem1.getCurrentBounds().equals(item.getCurrentBounds())) continue;
                    return;
                }
                int elem = 0;
                while (elem < this.selectItems.size()) {
                    SelectItem oldItem = this.selectItems.elementAt(elem);
                    if (forceState == null && oldItem.getState() != SelectionState.SELECTED) {
                        if (g != null) {
                            oldItem.paint(g);
                        }
                        oldItem.setState(SelectionState.SELECTED);
                        if (g != null) {
                            oldItem.paint(g);
                        }
                    }
                    if (insertIndex == -1 && (item.getCurrentBounds().y <= oldItem.getCurrentBounds().y || item.getCurrentBounds().y == oldItem.getCurrentBounds().y && item.getCurrentBounds().x <= oldItem.getCurrentBounds().x)) {
                        insertIndex = elem;
                    }
                    ++elem;
                }
            } else {
                this.clearAllSelections(g);
            }
            if (insertIndex == -1) {
                insertIndex = this.selectItems.size();
            }
            this.selectItems.insertElementAt(item, insertIndex);
            if (g != null) {
                item.paint(g);
            }
            ImgEditorPane.this.updateToolbar();
        }

        public void resize(Point delta, int handle, Graphics g) {
            Rectangle selectRect = new Rectangle(0, 0, 0, 0);
            switch (handle) {
                case 6: {
                    selectRect.y += delta.y;
                    selectRect.x += delta.x;
                    selectRect.height -= delta.y;
                    selectRect.width -= delta.x;
                    break;
                }
                case 8: {
                    selectRect.y += delta.y;
                    selectRect.height -= delta.y;
                    break;
                }
                case 7: {
                    selectRect.width += delta.x;
                    selectRect.y += delta.y;
                    selectRect.height -= delta.y;
                    break;
                }
                case 11: {
                    selectRect.width += delta.x;
                    break;
                }
                case 5: {
                    selectRect.width += delta.x;
                    selectRect.height += delta.y;
                    break;
                }
                case 9: {
                    selectRect.height += delta.y;
                    break;
                }
                case 4: {
                    selectRect.x += delta.x;
                    selectRect.width -= delta.x;
                    selectRect.height += delta.y;
                    break;
                }
                case 10: {
                    selectRect.x += delta.x;
                    selectRect.width -= delta.x;
                }
            }
            for (SelectItem item : this.selectItems) {
                item.paint(g);
                item.setState(SelectionState.MOVING);
                item.resize(selectRect);
                item.paint(g);
            }
        }

        public void move(Point delta, Graphics g) {
            for (SelectItem item : this.selectItems) {
                item.paint(g);
                item.setState(SelectionState.MOVING);
                item.move(delta);
                item.paint(g);
            }
        }

        public void sizeAll(int dimension, Graphics g) {
            SelectItem proto = this.getProtoItem();
            if (proto == null) {
                return;
            }
            Dimension dim = new Dimension(proto.getCurrentBounds().getSize());
            for (SelectItem item : this.selectItems) {
                Dimension newDim = item.getCurrentBounds().getSize();
                newDim.width = dim.width - newDim.width;
                newDim.height = dim.height - newDim.height;
                item.paint(g);
                item.resize(newDim, dimension);
                item.paint(g);
            }
        }

        public void cut(Graphics g) {
            for (SelectItem item : this.selectItems) {
                item.paint(g);
                item.cut(true);
                item.paint(g);
            }
        }

        public void del(Graphics g) {
            for (SelectItem item : this.selectItems) {
                item.paint(g);
                item.del(true);
                item.paint(g);
            }
        }

        public void copy(Graphics g) {
            for (SelectItem item : this.selectItems) {
                item.paint(g);
                item.copy(true);
                item.paint(g);
            }
        }

        public SelectItem getProtoItem() {
            SelectItem proto = null;
            int idx = this.selectItems.size() - 1;
            while (proto == null && idx >= 0) {
                SelectItem tempItem = this.selectItems.elementAt(idx);
                if (tempItem.getState() == SelectionState.LAST) {
                    proto = tempItem;
                }
                --idx;
            }
            return proto;
        }

        public void align(int border, Graphics g) {
            SelectItem proto = this.getProtoItem();
            if (proto == null) {
                return;
            }
            Rectangle targetRect = proto.getCurrentBounds();
            Point target = new Point(-1, -1);
            boolean canMove = true;
            switch (border) {
                case 2: {
                    target.x = targetRect.x;
                    break;
                }
                case 4: {
                    target.x = targetRect.x + targetRect.width;
                    break;
                }
                case 1: {
                    target.y = targetRect.y;
                    break;
                }
                case 3: {
                    target.y = targetRect.y + targetRect.height;
                }
            }
            for (SelectItem item : this.selectItems) {
                if (item.canMoveTo(target, border, this.bounds)) continue;
                canMove = false;
            }
            if (canMove) {
                for (SelectItem item : this.selectItems) {
                    item.paint(g);
                    item.moveTo(target, border);
                    item.paint(g);
                }
            }
        }

        public void spread(int border, Graphics g) {
            SelectItem firstItem = null;
            SelectItem lastItem = null;
            SelectItem workItem = null;
            int totalUsed = 0;
            int itemCount = 0;
            int elem = 0;
            while (elem < this.selectItems.size()) {
                workItem = this.selectItems.elementAt(elem);
                ++itemCount;
                if (border == 0) {
                    totalUsed += workItem.getCurrentBounds().getSize().width;
                    if (firstItem == null || firstItem.getCurrentBounds().getX() > workItem.getCurrentBounds().getX()) {
                        firstItem = workItem;
                    }
                    if (lastItem == null || firstItem.getCurrentBounds().getX() < workItem.getCurrentBounds().getX()) {
                        lastItem = workItem;
                    }
                } else {
                    totalUsed += workItem.getCurrentBounds().getSize().height;
                    if (firstItem == null || firstItem.getCurrentBounds().getY() > workItem.getCurrentBounds().getY()) {
                        firstItem = workItem;
                    }
                    if (lastItem == null || firstItem.getCurrentBounds().getY() < workItem.getCurrentBounds().getY()) {
                        lastItem = workItem;
                    }
                }
                ++elem;
            }
            if (firstItem == null || lastItem == null) {
                return;
            }
            int totalSpace = -1;
            int adjustAmount = -1;
            if (border == 0) {
                totalSpace = (int)(lastItem.getCurrentBounds().getX() + (double)lastItem.getCurrentBounds().getSize().width - firstItem.getCurrentBounds().getX());
                adjustAmount = (totalSpace - totalUsed) / (itemCount - 1);
            } else {
                totalSpace = (int)(lastItem.getCurrentBounds().getY() + (double)lastItem.getCurrentBounds().getSize().height - firstItem.getCurrentBounds().getY());
                adjustAmount = (totalSpace - totalUsed) / (itemCount - 1);
            }
            workItem = firstItem;
            Point delta = new Point(0, 0);
            int elem2 = 1;
            while (elem2 < this.selectItems.size() - 1) {
                SelectItem item = this.selectItems.elementAt(elem2);
                item.paint(g);
                delta = item.getCurrentBounds().getLocation();
                if (border == 0) {
                    delta.x = (int)((double)workItem.getCurrentBounds().getLocation().x + workItem.getCurrentBounds().getWidth() + (double)adjustAmount);
                    item.moveTo(delta, 2);
                } else {
                    delta.y = (int)((double)workItem.getCurrentBounds().getLocation().y + workItem.getCurrentBounds().getHeight() + (double)adjustAmount);
                    item.moveTo(delta, 1);
                }
                item.paint(g);
                workItem = item;
                ++elem2;
            }
        }

        public void paint(Graphics g) {
            for (SelectItem item : this.selectItems) {
                item.paint(g);
            }
        }

        public void setBounds(Rectangle newBounds) {
            this.bounds = newBounds;
        }

        public boolean contains(Point p) {
            return this.getDragHandle(p) != 0;
        }

        public int getDragHandle(Point p) {
            int elemCount = this.selectItems.size();
            for (SelectItem item : this.selectItems) {
                int handle = item.getDragHandle(p);
                if (handle == 0) continue;
                if (elemCount == 1) {
                    return handle;
                }
                return 13;
            }
            return 0;
        }

        public void removeItem(Point p, Graphics g) {
            for (SelectItem item : this.selectItems) {
                if (item.getDragHandle(p) == 0) continue;
                this.selectItems.removeElement(item);
                item.paint(g);
                ImgEditorPane.this.updateToolbar();
                return;
            }
        }

        public void sendSelections(MGuiEditCmd cmd, CharView view) {
            for (SelectItem item : this.selectItems) {
                Rectangle cur = item.getCurrentCellBounds();
                Rectangle off = item.getOffset();
                cmd.initData();
                cmd.cmd = 11;
                cmd.subCmd = 104;
                cmd.posNewRow = cur.y;
                cmd.posNewCol = cur.x;
                cmd.sizeRows = cur.height;
                cmd.sizeCols = cur.width;
                cmd.posNewRowOffset = off.y;
                cmd.posNewColOffset = off.x;
                cmd.sizeRowsOffset = off.height;
                cmd.sizeColsOffset = off.width;
                ImgEditorPane.this.adjustOffsets(cmd);
                view.sendGuiEditCmd(cmd);
            }
        }

        public int getModType() {
            int cmd = -1;
            for (SelectItem item : this.selectItems) {
                if (item.getCut()) {
                    cmd = 60;
                } else if (item.getDel()) {
                    cmd = ImgEditorPane.this.view.checkForFeature(Integer.MIN_VALUE) ? 64 : 60;
                } else if (item.getCopied()) {
                    cmd = 61;
                } else if (!item.getOrigBounds().equals(item.getCurrentBounds())) {
                    cmd = 62;
                }
                if (cmd == -1) continue;
                return cmd;
            }
            return cmd;
        }

        public void sortForMove() {
            int max = this.selectItems.size();
            boolean invertList = false;
            for (SelectItem item : this.selectItems) {
                if (item.getOrigCellBounds().equals(item.getCurrentCellBounds()) || item.getCurrentCellBounds().y <= item.getOrigCellBounds().y && (item.getCurrentCellBounds().y < item.getOrigCellBounds().y || item.getCurrentCellBounds().x <= item.getOrigCellBounds().x)) continue;
                invertList = true;
                break;
            }
            if (invertList) {
                Vector<SelectItem> sorted = new Vector<SelectItem>(this.selectItems.size());
                int i = max - 1;
                while (i >= 0) {
                    sorted.addElement(this.selectItems.elementAt(i));
                    --i;
                }
                this.selectItems = sorted;
            }
        }

        public int getNextMod(int context, MGuiEditCmd cmd, ImgEditorPane parent) {
            if (context >= this.selectItems.size()) {
                return -1;
            }
            int elem = context;
            while (elem < this.selectItems.size()) {
                SelectItem item = this.selectItems.elementAt(elem);
                Rectangle orig = item.getOrigCellBounds();
                Rectangle cur = item.getCurrentCellBounds();
                Rectangle offset = item.getOffset();
                if (item.getCut()) {
                    cmd.initData();
                    cmd.cmd = 11;
                    cmd.subCmd = ImgEditorPane.this.view.checkForFeature(Integer.MIN_VALUE) ? 101 : 105;
                    cmd.posNewRow = orig.y;
                    cmd.posNewCol = orig.x;
                    cmd.posNewRowOffset = offset.y;
                    cmd.posNewColOffset = offset.x;
                    cmd.sizeRowsOffset = offset.height;
                    cmd.sizeColsOffset = offset.width;
                    ImgEditorPane.this.adjustOffsets(cmd);
                    item.cut(false);
                    return elem + 1;
                }
                if (item.getDel()) {
                    cmd.initData();
                    cmd.cmd = 11;
                    cmd.subCmd = 105;
                    cmd.posNewRow = orig.y;
                    cmd.posNewCol = orig.x;
                    cmd.posNewRowOffset = offset.y;
                    cmd.posNewColOffset = offset.x;
                    cmd.sizeRowsOffset = offset.height;
                    cmd.sizeColsOffset = offset.width;
                    ImgEditorPane.this.adjustOffsets(cmd);
                    item.del(false);
                    return elem + 1;
                }
                if (item.getCopied()) {
                    cmd.initData();
                    cmd.cmd = 11;
                    cmd.subCmd = 100;
                    cmd.posNewRow = orig.y;
                    cmd.posNewCol = orig.x;
                    cmd.posNewRowOffset = offset.y;
                    cmd.posNewColOffset = offset.x;
                    cmd.sizeRowsOffset = offset.height;
                    cmd.sizeColsOffset = offset.width;
                    ImgEditorPane.this.adjustOffsets(cmd);
                    item.copy(false);
                    return elem + 1;
                }
                if (!item.getOrigBounds().equals(item.getCurrentBounds())) {
                    cmd.initData();
                    cmd.cmd = 11;
                    cmd.subCmd = 102;
                    cmd.posOldRow = orig.y;
                    cmd.posOldCol = orig.x;
                    cmd.posNewRow = cur.y;
                    cmd.posNewCol = cur.x;
                    cmd.sizeRows = cur.height;
                    cmd.sizeCols = cur.width;
                    cmd.posNewRowOffset = offset.y;
                    cmd.posNewColOffset = offset.x;
                    cmd.sizeRowsOffset = offset.height;
                    cmd.sizeColsOffset = offset.width;
                    ImgEditorPane.this.adjustOffsets(cmd);
                    return elem + 1;
                }
                ++elem;
            }
            return -1;
        }

        protected class SaveItem {
            protected Rectangle originalBounds = null;
            protected Rectangle currentBounds = null;
            protected SelectionState selectState = null;

            public SaveItem(Rectangle origin, Rectangle curr, SelectionState state) {
                this.originalBounds = origin;
                this.currentBounds = curr;
                this.selectState = state;
            }

            public Rectangle getOrigBounds() {
                return this.originalBounds;
            }

            public Rectangle getCurrentBounds() {
                return this.currentBounds;
            }

            public SelectionState getState() {
                return this.selectState;
            }

            public String toString() {
                return "saveItem[ orig=" + this.originalBounds + ", curr=" + this.currentBounds + ", state=" + (Object)((Object)this.selectState) + "]";
            }
        }

        protected class SelectItem {
            protected Rectangle origCellBounds = null;
            protected Rectangle origOffs = null;
            protected Rectangle origBounds = null;
            protected Rectangle currCellBounds = null;
            protected Rectangle currOffs = null;
            protected Rectangle currBounds = null;
            protected SelectionState selectState = null;
            protected SelectionState saveState = null;
            protected boolean cut = false;
            protected boolean del = false;
            protected boolean copied = false;
            protected Dimension handleSize = new Dimension(6, 6);
            protected AppxControl control = null;
            protected Display parent = null;

            public SelectItem(AppxControl orig, SelectionState state, Display prnt) {
                this.control = orig;
                this.selectState = state;
                this.parent = prnt;
                if (state == null) {
                    System.err.println("null state");
                }
                this.refresh(new Rectangle(0, 0, 0, 0));
                this.origCellBounds = new Rectangle(this.currCellBounds);
                this.origOffs = new Rectangle(this.currOffs);
                this.origBounds = new Rectangle(this.currBounds);
            }

            protected void refresh(Rectangle delta) {
                Rectangle offsets = new Rectangle(this.control.getOffset());
                Rectangle bounds = new Rectangle(this.control.getCellBounds());
                if (delta.x % CharView.charWidth == 0) {
                    bounds.x += delta.x / CharView.charWidth;
                } else {
                    offsets.x += delta.x;
                    if (Math.abs(offsets.x) > CharView.charWidth) {
                        if (delta.x > 0) {
                            while (offsets.x >= CharView.charWidth && bounds.x < this.parent.getCellBounds().width - 1) {
                                offsets.x -= CharView.charWidth;
                                ++bounds.x;
                            }
                        } else if (delta.x < 0) {
                            while (offsets.x < 0 && bounds.x > 0) {
                                offsets.x += CharView.charWidth;
                                --bounds.x;
                            }
                        }
                    }
                }
                if (delta.y % CharView.charHeight == 0) {
                    bounds.y += delta.y / CharView.charHeight;
                } else {
                    offsets.y += delta.y;
                    if (Math.abs(offsets.y) > CharView.charHeight) {
                        if (delta.y > 0) {
                            while (offsets.y >= CharView.charHeight) {
                                offsets.y -= CharView.charHeight;
                                ++bounds.y;
                            }
                        } else if (delta.y < 0) {
                            while (offsets.y < 0 && bounds.y > 0) {
                                offsets.y += CharView.charHeight;
                                --bounds.y;
                            }
                        }
                    }
                }
                if (delta.width != 0) {
                    offsets.width = offsets.width + (bounds.width >= 0 ? delta.width : delta.width * -1);
                    while (bounds.width != 0 && offsets.width < 0) {
                        bounds.width = bounds.width - (bounds.width >= 0 ? 1 : -1);
                        if (bounds.width == 0) {
                            bounds.width = bounds.width + (delta.width >= 0 ? 1 : -1);
                            offsets.width *= -1;
                            continue;
                        }
                        offsets.width += CharView.charWidth;
                    }
                    while (bounds.width != 0 && offsets.width >= CharView.charWidth) {
                        bounds.width = bounds.width + (bounds.width >= 0 ? 1 : -1);
                        offsets.width -= CharView.charWidth;
                    }
                    if (bounds.width == -1 && offsets.width == 0) {
                        bounds.width = 1;
                    }
                }
                if (delta.height != 0) {
                    offsets.height = offsets.height + (bounds.height >= 0 ? delta.height : delta.height * -1);
                    while (bounds.height != 0 && offsets.height < 0) {
                        bounds.height = bounds.height - (bounds.height >= 0 ? 1 : -1);
                        if (bounds.height == 0) {
                            bounds.height = bounds.height + (delta.height >= 0 ? 1 : -1);
                            offsets.height *= -1;
                            continue;
                        }
                        offsets.height += CharView.charHeight;
                    }
                    while (bounds.height != 0 && offsets.height >= CharView.charHeight) {
                        bounds.height = bounds.height + (bounds.height >= 0 ? 1 : -1);
                        offsets.height -= CharView.charHeight;
                    }
                    if (bounds.height == -1 && offsets.height == 0) {
                        bounds.height = 1;
                    }
                }
                this.control.setCellBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                this.control.setOffset(new Rectangle(offsets.x, offsets.y, offsets.width, offsets.height));
                this.currCellBounds = new Rectangle(this.control.getCellBounds());
                this.currOffs = new Rectangle(this.control.getOffset());
                this.currBounds = this.control instanceof DropShadowPanel ? new Rectangle(((DropShadowPanel)this.control).getChild().getLocation(), ((DropShadowPanel)this.control).getChild().getPreferredSize()) : new Rectangle(this.control.getLocation(), this.control.getPreferredSize());
                this.currBounds.x += this.parent.getInsets().left;
                this.currBounds.y += this.parent.getInsets().top;
                ((JComponent)((Object)this.control)).setBounds(this.control.getLocation().x + this.parent.getInsets().left, this.control.getLocation().y + this.parent.getInsets().top, this.control.getPreferredSize().width, this.control.getPreferredSize().height);
                ((JComponent)((Object)this.control)).repaint();
            }

            protected void refresh_works_with_negative(Rectangle delta) {
                Rectangle offsets = new Rectangle(this.control.getOffset());
                Rectangle bounds = new Rectangle(this.control.getCellBounds());
                if (delta.x % CharView.charWidth == 0) {
                    bounds.x += delta.x / CharView.charWidth;
                } else {
                    offsets.x += delta.x;
                    if (Math.abs(offsets.x) > CharView.charWidth) {
                        if (delta.x > 0) {
                            while (offsets.x >= CharView.charWidth && bounds.x < this.parent.getCellBounds().width - 1) {
                                offsets.x -= CharView.charWidth;
                                ++bounds.x;
                            }
                        } else if (delta.x < 0) {
                            while (offsets.x < 0 && bounds.x > 0) {
                                offsets.x += CharView.charWidth;
                                --bounds.x;
                            }
                        }
                    }
                }
                if (delta.y % CharView.charHeight == 0) {
                    bounds.y += delta.y / CharView.charHeight;
                } else {
                    offsets.y += delta.y;
                    if (Math.abs(offsets.y) > CharView.charHeight) {
                        if (delta.y > 0) {
                            while (offsets.y >= CharView.charHeight) {
                                offsets.y -= CharView.charHeight;
                                ++bounds.y;
                            }
                        } else if (delta.y < 0) {
                            while (offsets.y < 0 && bounds.y > 0) {
                                offsets.y += CharView.charHeight;
                                --bounds.y;
                            }
                        }
                    }
                }
                if (delta.width != 0) {
                    System.err.println("1 offsets.width=" + offsets.width + ", bounds.width=" + bounds.width + ", delta.width=" + delta.width);
                    offsets.width = offsets.width + (bounds.width >= 0 ? delta.width : delta.width * -1);
                    System.err.println("2 offsets.width=" + offsets.width + ", bounds.width=" + bounds.width + ", delta.width=" + delta.width);
                    while (bounds.width != 0 && offsets.width < 0) {
                        bounds.width = bounds.width - (bounds.width >= 0 ? 1 : -1);
                        offsets.width += CharView.charWidth;
                        System.err.println("3 offsets.width=" + offsets.width + ", bounds.width=" + bounds.width + ", delta.width=" + delta.width);
                    }
                    while (bounds.width != 0 && offsets.width >= CharView.charWidth) {
                        bounds.width = bounds.width + (bounds.width >= 0 ? 1 : -1);
                        offsets.width -= CharView.charWidth;
                        System.err.println("4 offsets.width=" + offsets.width + ", bounds.width=" + bounds.width + ", delta.width=" + delta.width);
                    }
                    if (bounds.width == 0) {
                        bounds.width = bounds.width + (delta.width >= 0 ? 1 : -1);
                        offsets.width -= CharView.charWidth;
                        offsets.width *= -1;
                        System.err.println("5 offsets.width=" + offsets.width + ", bounds.width=" + bounds.width + ", delta.width=" + delta.width);
                    }
                    while (bounds.width != 0 && offsets.width < 0) {
                        bounds.width = bounds.width - (bounds.width >= 0 ? 1 : -1);
                        offsets.width += CharView.charWidth;
                        System.err.println("6 offsets.width=" + offsets.width + ", bounds.width=" + bounds.width + ", delta.width=" + delta.width);
                    }
                    while (bounds.width != 0 && offsets.width >= CharView.charWidth) {
                        bounds.width = bounds.width + (bounds.width >= 0 ? 1 : -1);
                        offsets.width -= CharView.charWidth;
                        System.err.println("7 offsets.width=" + offsets.width + ", bounds.width=" + bounds.width + ", delta.width=" + delta.width);
                    }
                    if (bounds.width == -1 && offsets.width > 0 && offsets.width < CharView.charWidth) {
                        bounds.width = 1;
                        offsets.width *= -1;
                        System.err.println("8 offsets.width=" + offsets.width + ", bounds.width=" + bounds.width + ", delta.width=" + delta.width);
                    }
                }
                if (delta.height != 0) {
                    offsets.height = offsets.height + (bounds.height >= 0 ? delta.height : delta.height * -1);
                    while (bounds.height != 0 && offsets.height < 0) {
                        bounds.height = bounds.height - (bounds.height >= 0 ? 1 : -1);
                        offsets.height += CharView.charHeight;
                    }
                    while (bounds.height != 0 && offsets.height >= CharView.charHeight) {
                        bounds.height = bounds.height + (bounds.height >= 0 ? 1 : -1);
                        offsets.height -= CharView.charHeight;
                    }
                    if (bounds.height == 0) {
                        bounds.height = bounds.height + (delta.height >= 0 ? 1 : -1);
                        offsets.height -= CharView.charHeight;
                        offsets.height *= -1;
                    }
                    while (bounds.height != 0 && offsets.height < 0) {
                        bounds.height = bounds.height - (bounds.height >= 0 ? 1 : -1);
                        offsets.height += CharView.charHeight;
                    }
                    while (bounds.height != 0 && offsets.height >= CharView.charHeight) {
                        bounds.height = bounds.height + (bounds.height >= 0 ? 1 : -1);
                        offsets.height -= CharView.charHeight;
                    }
                }
                this.control.setCellBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                this.control.setOffset(new Rectangle(offsets.x, offsets.y, offsets.width, offsets.height));
                this.currCellBounds = new Rectangle(this.control.getCellBounds());
                this.currOffs = new Rectangle(this.control.getOffset());
                this.currBounds = this.control instanceof DropShadowPanel ? new Rectangle(((DropShadowPanel)this.control).getChild().getLocation(), ((DropShadowPanel)this.control).getChild().getPreferredSize()) : new Rectangle(this.control.getLocation(), this.control.getPreferredSize());
                this.currBounds.x += this.parent.getInsets().left;
                this.currBounds.y += this.parent.getInsets().top;
                ((JComponent)((Object)this.control)).setBounds(this.control.getLocation().x + this.parent.getInsets().left, this.control.getLocation().y + this.parent.getInsets().top, this.control.getPreferredSize().width, this.control.getPreferredSize().height);
                ((JComponent)((Object)this.control)).repaint();
            }

            protected void refresh_save(Rectangle delta) {
                Rectangle offsets = new Rectangle(this.control.getOffset());
                Rectangle bounds = new Rectangle(this.control.getCellBounds());
                CharView.view.setStatusText("delta=" + delta);
                System.err.println("");
                System.err.println(" delta=" + delta + ", bounds=" + bounds + ", offset=" + offsets);
                if (delta.x % CharView.charWidth == 0) {
                    bounds.x += delta.x / CharView.charWidth;
                } else {
                    offsets.x += delta.x;
                    if (Math.abs(offsets.x) > CharView.charWidth) {
                        if (delta.x > 0) {
                            while (offsets.x >= CharView.charWidth && bounds.x < this.parent.getCellBounds().width - 1) {
                                offsets.x -= CharView.charWidth;
                                ++bounds.x;
                            }
                        } else if (delta.x < 0) {
                            while (offsets.x < 0 && bounds.x > 0) {
                                offsets.x += CharView.charWidth;
                                --bounds.x;
                            }
                        }
                    }
                }
                if (delta.y % CharView.charHeight == 0) {
                    bounds.y += delta.y / CharView.charHeight;
                } else {
                    offsets.y += delta.y;
                    if (Math.abs(offsets.y) > CharView.charHeight) {
                        if (delta.y > 0) {
                            while (offsets.y >= CharView.charHeight) {
                                offsets.y -= CharView.charHeight;
                                ++bounds.y;
                            }
                        } else if (delta.y < 0) {
                            while (offsets.y < 0 && bounds.y > 0) {
                                offsets.y += CharView.charHeight;
                                --bounds.y;
                            }
                        }
                    }
                }
                if (delta.width % CharView.charWidth == 0) {
                    bounds.width += delta.width / CharView.charWidth;
                } else {
                    offsets.width = offsets.width + (bounds.width >= 0 ? delta.width : delta.width * -1);
                    if (Math.abs(offsets.width) >= CharView.charWidth) {
                        while (bounds.width != 0 && offsets.width < 0) {
                            bounds.width = bounds.width - (bounds.width >= 0 ? 1 : -1);
                            offsets.width += CharView.charWidth;
                        }
                        if (bounds.width == 0 && offsets.width <= CharView.charWidth * -1) {
                            --bounds.width;
                            offsets.width += CharView.charWidth;
                            offsets.width *= -1;
                        }
                        while (bounds.width != 0 && offsets.width < 0) {
                            bounds.width = bounds.width - (bounds.width >= 0 ? 1 : -1);
                            offsets.width += CharView.charWidth;
                        }
                    }
                    if (bounds.width == 0 && offsets.width <= CharView.charWidth * -1) {
                        --bounds.width;
                        offsets.width += CharView.charWidth;
                    }
                }
                if (delta.height % CharView.charHeight == 0) {
                    bounds.height += delta.height / CharView.charHeight;
                } else {
                    offsets.height = offsets.height + (bounds.height >= 0 ? delta.height : delta.height * -1);
                    if (Math.abs(offsets.height) >= CharView.charHeight) {
                        while (offsets.height >= CharView.charHeight) {
                            bounds.height = bounds.height + (bounds.height > 0 ? 1 : -1);
                            offsets.height -= CharView.charHeight;
                        }
                        while (offsets.height <= CharView.charHeight * -1) {
                            bounds.height = bounds.height - (bounds.height > 0 ? 1 : -1);
                            offsets.height += CharView.charHeight;
                        }
                    }
                    if (offsets.height < 0) {
                        bounds.height = bounds.height - (bounds.height >= 0 ? 1 : -1);
                        offsets.height += CharView.charHeight;
                    }
                }
                if (bounds.width == 0) {
                    int n = bounds.width = delta.width < 0 ? -1 : 1;
                }
                if (bounds.height == 0) {
                    bounds.height = delta.height < 0 ? -1 : 1;
                }
                System.err.println("-delta=" + delta + ", bounds=" + bounds + ", offset=" + offsets);
                this.control.setCellBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                this.control.setOffset(new Rectangle(offsets.x, offsets.y, offsets.width, offsets.height));
                this.currCellBounds = new Rectangle(this.control.getCellBounds());
                this.currOffs = new Rectangle(this.control.getOffset());
                this.currBounds = this.control instanceof DropShadowPanel ? new Rectangle(((DropShadowPanel)this.control).getChild().getLocation(), ((DropShadowPanel)this.control).getChild().getPreferredSize()) : new Rectangle(this.control.getLocation(), this.control.getPreferredSize());
                this.currBounds.x += this.parent.getInsets().left;
                this.currBounds.y += this.parent.getInsets().top;
                ((JComponent)((Object)this.control)).setBounds(this.control.getLocation().x + this.parent.getInsets().left, this.control.getLocation().y + this.parent.getInsets().top, this.control.getPreferredSize().width, this.control.getPreferredSize().height);
                ((JComponent)((Object)this.control)).repaint();
            }

            public Rectangle getCurrentBounds() {
                return this.currBounds;
            }

            public Rectangle getOrigBounds() {
                return this.origBounds;
            }

            public Rectangle getOffset() {
                return this.currOffs;
            }

            public Rectangle getCurrentCellBounds() {
                return this.currCellBounds;
            }

            public Rectangle getOrigCellBounds() {
                return this.origCellBounds;
            }

            public void cut(boolean c) {
                this.cut = c;
            }

            public void del(boolean c) {
                this.del = c;
            }

            public void copy(boolean c) {
                this.copied = c;
            }

            public boolean getCopied() {
                return this.copied;
            }

            public boolean getCut() {
                return this.cut;
            }

            public boolean getDel() {
                return this.del;
            }

            public void move(Point delta) {
                this.refresh(new Rectangle(delta.x, delta.y, 0, 0));
            }

            public void resize(Rectangle delta) {
                this.refresh(delta);
            }

            public void resize(Dimension newDim, int dimension) {
                if (dimension == 1) {
                    this.refresh(new Rectangle(0, 0, 0, newDim.height));
                } else {
                    this.refresh(new Rectangle(0, 0, newDim.width, 0));
                }
            }

            public void moveTo(Point p, int border) {
                switch (border) {
                    case 1: {
                        this.refresh(new Rectangle(0, p.y - this.currBounds.y, 0, 0));
                        break;
                    }
                    case 2: {
                        this.refresh(new Rectangle(p.x - this.currBounds.x, 0, 0, 0));
                        break;
                    }
                    case 4: {
                        this.refresh(new Rectangle(p.x - (this.currBounds.x + this.currBounds.width), 0, 0, 0));
                        break;
                    }
                    case 3: {
                        this.refresh(new Rectangle(0, p.y - (this.currBounds.y + this.currBounds.height), 0, 0));
                    }
                }
            }

            public boolean canMoveTo(Point p, int border, Rectangle bounds) {
                Rectangle testRect = new Rectangle(this.currBounds);
                switch (border) {
                    case 1: {
                        testRect.y = p.y;
                        break;
                    }
                    case 2: {
                        testRect.x = p.x;
                        break;
                    }
                    case 4: {
                        testRect.x += p.x - (testRect.x + testRect.width);
                        break;
                    }
                    case 3: {
                        testRect.y += p.y - (testRect.y + testRect.height);
                    }
                }
                if (testRect.x < 0) {
                    return false;
                }
                if (testRect.y < 0) {
                    return false;
                }
                if (testRect.x + testRect.width > bounds.width) {
                    return false;
                }
                return testRect.y + testRect.height <= bounds.height;
            }

            public void saveState() {
                this.saveState = this.selectState;
            }

            public void restoreState(Graphics g) {
                this.paint(g);
                this.selectState = this.saveState;
                this.paint(g);
            }

            public void setState(SelectionState state) {
                this.selectState = state;
            }

            public SelectionState getState() {
                return this.selectState;
            }

            public void paint(Graphics g) {
                this.paint(g, this.currBounds, this.currCellBounds.x, this.currCellBounds.y);
            }

            public void paint(Graphics g, Rectangle rect, int anchorX, int anchorY) {
                AppxControl ctl;
                AppxControl appxControl = ctl = this.control instanceof DropShadowPanel ? ((DropShadowPanel)this.control).getChild() : this.control;
                if (rect != null) {
                    g.setXORMode(Color.lightGray);
                    g.setColor(Color.black);
                    g.fillRect(anchorX * CharView.charWidth + this.parent.getInsets().left, anchorY * CharView.charHeight + this.parent.getInsets().top, 3, 3);
                    if (this.selectState != null) {
                        switch (this.selectState) {
                            case LAST: {
                                g.setColor(Color.blue);
                                break;
                            }
                            case MOVING: {
                                g.setColor(Color.green);
                                break;
                            }
                            default: {
                                g.setColor(Color.red);
                            }
                        }
                    }
                    if (!(ctl instanceof AppxLine)) {
                        g.drawRect(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
                    }
                    if ((ctl == null || !(ctl instanceof AppxField) || ((AppxField)this.control).isResizable()) && ((SelectState)SelectState.this).ImgEditorPane.this.view.isImageEditorEditable()) {
                        if (ctl instanceof AppxLine) {
                            Point beg = ((AppxLine)ctl).getBegPoint();
                            Point end = ((AppxLine)ctl).getEndPoint();
                            g.fillRect(beg.x - 2, beg.y - 3, 7, 7);
                            g.fillRect(end.x - 2, end.y - 3, 7, 7);
                        } else {
                            Rectangle r = ctl == null ? new Rectangle(0, 0, 0, 0) : ctl.getCellBounds();
                            int x = rect.x + rect.width / 2 - this.handleSize.width / 2;
                            int y = rect.y + rect.height / 2 - this.handleSize.height / 2;
                            int top = r.height > 0 ? rect.y - this.handleSize.height : rect.y + rect.height;
                            int bottom = r.height > 0 ? rect.y + rect.height - 1 : rect.y - this.handleSize.height;
                            int left = r.width > 0 ? rect.x - this.handleSize.width : rect.x + rect.width;
                            int right = r.width > 0 ? rect.x + rect.width : rect.x - this.handleSize.width;
                            g.fillRect(x, top, this.handleSize.width, this.handleSize.height);
                            g.fillRect(x, bottom, this.handleSize.width, this.handleSize.height);
                            g.fillRect(left, y, this.handleSize.width, this.handleSize.height);
                            g.fillRect(right, y, this.handleSize.width, this.handleSize.height);
                            g.fillRect(--left, --top, this.handleSize.width + 1, this.handleSize.height + 1);
                            g.fillRect(right, bottom, this.handleSize.width + 1, this.handleSize.height + 1);
                            g.fillRect(left, bottom, this.handleSize.width + 1, this.handleSize.height + 1);
                            g.fillRect(right, top, this.handleSize.width + 1, this.handleSize.height + 1);
                        }
                    }
                    g.setPaintMode();
                }
            }

            public int getDragHandle(Point p) {
                Rectangle selectRect = this.currBounds;
                int x = p.x;
                int y = p.y;
                if ((this.control == null || !(this.control instanceof AppxField) || ((AppxField)this.control).isResizable()) && ((SelectState)SelectState.this).ImgEditorPane.this.view.isImageEditorEditable()) {
                    if (this.control instanceof AppxLine) {
                        Point beg = ((AppxLine)this.control).getBegPoint();
                        Point end = ((AppxLine)this.control).getEndPoint();
                        Rectangle hBox = new Rectangle(beg.x - 2, beg.y - 3, 7, 7);
                        if (hBox.contains(x, y)) {
                            return 6;
                        }
                        hBox.x = end.x - 2;
                        hBox.y = end.y - 3;
                        if (hBox.contains(x, y)) {
                            return 5;
                        }
                    } else {
                        Rectangle rect = new Rectangle();
                        Rectangle r = this.control == null ? new Rectangle(0, 0, 0, 0) : this.control.getCellBounds();
                        int center_x = selectRect.x + selectRect.width / 2 - this.handleSize.width / 2;
                        int center_y = selectRect.y + selectRect.height / 2 - this.handleSize.height / 2;
                        int top = r.height > 0 ? selectRect.y - this.handleSize.height : selectRect.y + selectRect.height;
                        int bottom = r.height > 0 ? selectRect.y + selectRect.height : selectRect.y - this.handleSize.height;
                        int left = r.width > 0 ? selectRect.x - this.handleSize.width : selectRect.x + selectRect.width;
                        int right = r.width > 0 ? selectRect.x + selectRect.width : selectRect.x - this.handleSize.width;
                        --top;
                        rect.x = --left;
                        rect.y = top++;
                        rect.height = this.handleSize.height + 1;
                        rect.width = this.handleSize.width + 1;
                        if (rect.contains(x, y)) {
                            return 6;
                        }
                        rect.x = right;
                        if (rect.contains(x, y)) {
                            return 7;
                        }
                        rect.y = bottom;
                        if (rect.contains(x, y)) {
                            return 5;
                        }
                        rect.x = left++;
                        if (rect.contains(x, y)) {
                            return 4;
                        }
                        rect.height = this.handleSize.height;
                        rect.width = this.handleSize.width;
                        rect.x = center_x;
                        rect.y = top;
                        if (rect.contains(x, y)) {
                            return 8;
                        }
                        rect.x = right;
                        rect.y = center_y;
                        if (rect.contains(x, y)) {
                            return 11;
                        }
                        rect.x = center_x;
                        rect.y = bottom;
                        if (rect.contains(x, y)) {
                            return 9;
                        }
                        rect.x = left;
                        rect.y = center_y;
                        if (rect.contains(x, y)) {
                            return 10;
                        }
                    }
                }
                if (selectRect.contains(x, y) && ((SelectState)SelectState.this).ImgEditorPane.this.view.isImageEditorEditable()) {
                    if (this.control instanceof AppxBox) {
                        Rectangle innerRect = new Rectangle(selectRect.x + 10, selectRect.y + 15, selectRect.width - 20, selectRect.height - 30);
                        if (!innerRect.contains(x, y)) {
                            return 13;
                        }
                    } else if (this.control instanceof AppxLine) {
                        if (((AppxLine)this.control).contains(p)) {
                            return 13;
                        }
                    } else {
                        return 13;
                    }
                }
                return 0;
            }
        }
    }

    private static enum SelectionState {
        SELECTED,
        MOVING,
        LAST;

    }
}

