/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import view.AppxControlItem;
import view.CharView;
import view.Display;
import view.MenuButton;

public class GuiHelpPane
extends JPanel {
    private static final long serialVersionUID = -4892800283176714414L;
    CharView view;
    Display disp;
    Rectangle bounds;
    boolean handCursor = false;
    boolean clicked = false;
    Cursor helpCursor = null;
    Cursor noHelpCursor = null;

    @Override
    public Point getLocation() {
        return new Point(this.disp.getView().boxInsets.left * -1, this.disp.getView().boxInsets.top * -1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.disp.getPreferredSize();
    }

    public void hidePane() {
        this.disp.remove(this);
        this.disp.repaint();
        this.disp = null;
        this.setCursor(new Cursor(0));
    }

    public GuiHelpPane(CharView v) {
        this.helpCursor = Toolkit.getDefaultToolkit().getBestCursorSize((int)32, (int)32).height == 32 ? Toolkit.getDefaultToolkit().createCustomCursor(AppxResource.Gfx.CURSOR_HELP.image(), new Point(6, 7), "helpCursor") : new Cursor(0);
        this.noHelpCursor = new Cursor(12);
        this.view = v;
        this.setOpaque(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Component c = (Component)((Object)GuiHelpPane.this.disp.getSelectableObject(new Point(e.getX(), e.getY())));
                if (c instanceof MenuButton) {
                    MenuButton m = (MenuButton)c;
                    int cmd = 0;
                    try {
                        cmd = Integer.parseInt(m.getActionCommand());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cmd > 0 && cmd < 100) {
                        GuiHelpPane.this.setCursor(GuiHelpPane.this.helpCursor);
                        return;
                    }
                } else if (c instanceof AppxControlItem) {
                    GuiHelpPane.this.setCursor(GuiHelpPane.this.helpCursor);
                    return;
                }
                GuiHelpPane.this.setCursor(GuiHelpPane.this.helpCursor);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GuiHelpPane.this.clicked) {
                    GuiHelpPane.this.hidePane();
                }
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Component c = (Component)((Object)GuiHelpPane.this.disp.getSelectableObject(new Point(e.getX(), e.getY())));
                if (c instanceof MenuButton) {
                    MenuButton m = (MenuButton)c;
                    int cmd = Integer.parseInt(m.getActionCommand());
                    if (cmd > 0 && cmd <= 256) {
                        ActionEvent helpAction = new ActionEvent(this, 1001, "280," + cmd);
                        GuiHelpPane.this.view.actionPerformed(helpAction);
                    }
                } else {
                    int cellR = (e.getY() - GuiHelpPane.this.disp.getInsets().top) / CharView.charHeight;
                    int cellC = (e.getX() - GuiHelpPane.this.disp.getInsets().left) / CharView.charWidth;
                    GuiHelpPane.this.disp.getView().putCursor(cellC, cellR);
                    ActionEvent helpAction = new ActionEvent(this, 1001, "276");
                    GuiHelpPane.this.view.actionPerformed(helpAction);
                }
                GuiHelpPane.this.clicked = true;
                GuiHelpPane.this.hidePane();
            }
        });
    }

    public void showPane(Display d) {
        this.disp = d;
        this.disp.add((Component)this, 0);
        this.disp.doLayout();
        this.view.pack();
        this.disp.repaint();
        this.setCursor(this.noHelpCursor);
        this.clicked = false;
        d.getView().setStatusText("Click the item you would like help on", Color.black, Color.green);
    }
}

