/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    private static GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();

    private GraphicsUtilities() {
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        return new BufferedImage(cm, cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight()), cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return GraphicsUtilities.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return configuration.createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return configuration.createCompatibleImage(width, height);
    }

    public static BufferedImage createTranslucentCompatibleImage(int width, int height) {
        return configuration.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return GraphicsUtilities.toCompatibleImage(image);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        BufferedImage compatibleImage = configuration.createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static BufferedImage createThumbnailFast(BufferedImage image, int newSize) {
        int height;
        int width = image.getWidth();
        if (width > (height = image.getHeight())) {
            float ratio = (float)width / (float)height;
            width = newSize;
            height = (int)((float)newSize / ratio);
        } else {
            float ratio = (float)height / (float)width;
            height = newSize;
            width = (int)((float)newSize / ratio);
        }
        BufferedImage temp = GraphicsUtilities.createCompatibleImage(image, width, height);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        return temp;
    }

    public static BufferedImage createThumbnail(BufferedImage image, int newSize) {
        int width = image.getWidth();
        int height = image.getHeight();
        float ratioWH = (float)width / (float)height;
        float ratioHW = (float)height / (float)width;
        boolean isWidthGreater = width > height;
        BufferedImage thumb = image;
        do {
            if (isWidthGreater) {
                if ((width /= 2) < newSize) {
                    width = newSize;
                }
                height = (int)((float)width / ratioWH);
            } else {
                if ((height /= 2) < newSize) {
                    height = newSize;
                }
                width = (int)((float)height / ratioHW);
            }
            BufferedImage temp = GraphicsUtilities.createCompatibleImage(image, width, height);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (newSize != (isWidthGreater ? width : height));
        return thumb;
    }

    public static BufferedImage createThumbnail(BufferedImage image, int newWidth, int newHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage thumb = image;
        do {
            if (width > newWidth && (width /= 2) < newWidth) {
                width = newWidth;
            }
            if (height > newHeight && (height /= 2) < newHeight) {
                height = newHeight;
            }
            BufferedImage temp = GraphicsUtilities.createCompatibleImage(image, width, height);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g2.dispose();
            thumb = temp;
        } while (width != newWidth || height != newHeight);
        return thumb;
    }
}

