/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxToolkit;
import doc.Globals;
import java.awt.Toolkit;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import view.AppxComboBox;
import view.AppxControl;
import view.AppxFocusManager;
import view.AppxFormatField;
import view.CharView;
import view.Display;

public class FixedLengthPlainDocument
extends PlainDocument {
    private static final long serialVersionUID = 90764861821357572L;
    private int maxLength;
    private boolean upperCaseOnly = false;
    private JComponent parent;
    private Display disp;

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void insertString(int offset, String string, AttributeSet a) throws BadLocationException {
        byte[] newBytes;
        String str = string;
        boolean overflow = false;
        int curLen = ((AppxControl)((Object)this.parent)).getAppxText().length();
        int newLen = string.length();
        if (Globals.getOptionValueBoolean("inputByteLengthCheck")) {
            byte[] curBytes = AppxToolkit.stringToBytes(((AppxControl)((Object)this.parent)).getAppxText(), 2);
            newBytes = AppxToolkit.stringToBytes(string, 2);
            curLen = curBytes.length;
            newLen = newBytes.length;
        }
        ((AppxControl)((Object)this.parent)).setTouched(true);
        if (str != null && curLen + newLen > this.maxLength) {
            overflow = true;
            if (!(this.parent instanceof AppxFormatField)) {
                Toolkit.getDefaultToolkit().beep();
            }
            int off = str.length() - 1;
            while (off >= 0 && curLen + newLen > this.maxLength) {
                str = string.substring(0, off);
                if (Globals.getOptionValueBoolean("inputByteLengthCheck")) {
                    newBytes = AppxToolkit.stringToBytes(str, 2);
                    newLen = newBytes.length;
                } else {
                    newLen = str.length();
                }
                --off;
            }
        }
        if (this.parent instanceof AppxFormatField && !Globals.validateEncodedString(str, ((AppxFormatField)this.parent).getEncodingType())) {
            CharView.view.setStatusText("'" + str + "' is not valid for field encoding");
            return;
        }
        if (str != null && this.isUpperCaseOnly()) {
            String strUpperCase = str.toUpperCase();
            super.insertString(offset, strUpperCase, a);
        } else {
            super.insertString(offset, str, a);
        }
        if (offset + string.length() == this.getMaxLength()) {
            this.parent.transferFocus();
        }
        if (this.parent instanceof AppxComboBox) {
            ((AppxComboBox)this.parent).repaint();
        }
        if (this.disp != null && Globals.getOptionValueBoolean("autoTabOut") && !overflow && str != null && curLen + newLen == this.maxLength) {
            FocusManager fm = FocusManager.getCurrentManager();
            if (fm instanceof AppxFocusManager) {
                if (this.parent instanceof AppxComboBox) {
                    ((AppxFocusManager)fm).focusNextComponentTypeout(((AppxComboBox)this.parent).getEditor().getEditorComponent());
                } else {
                    ((AppxFocusManager)fm).focusNextComponentTypeout(this.parent);
                }
            } else {
                fm.focusNextComponent(this.parent);
            }
        }
    }

    public boolean isUpperCaseOnly() {
        return this.upperCaseOnly;
    }

    public FixedLengthPlainDocument(int len, boolean ucaseOnly, JComponent prnt, Display dspl) {
        this.maxLength = len;
        this.upperCaseOnly = ucaseOnly;
        this.parent = prnt;
        this.disp = dspl;
    }

    public void setMaxLength(int newMaxLength) {
        this.maxLength = newMaxLength;
    }

    public void setUpperCaseOnly(boolean newUpperCaseOnly) {
        this.upperCaseOnly = newUpperCaseOnly;
    }
}

