/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import view.AppxControl;
import view.AppxLine;
import view.CharView;
import view.ShadowFactory;

public class DropShadowPanel
extends JPanel
implements PropertyChangeListener,
AppxControl {
    private static final long serialVersionUID = -7870024995097637798L;
    private AppxControl child;
    private float angle = 45.0f;
    private int distance = 2;
    private int distance_x = 0;
    private int distance_y = 0;
    private int distance_x_abs = 0;
    private int distance_y_abs = 0;
    private BufferedImage shadow = null;
    private ShadowFactory factory = null;
    FlowLayout layOut = null;

    public DropShadowPanel() {
        this(new ShadowFactory(), null);
    }

    public DropShadowPanel(LayoutManager layout) {
        this(new ShadowFactory(), layout);
    }

    public DropShadowPanel(ShadowFactory factory, LayoutManager layout) {
        super(layout);
        this.layOut = (FlowLayout)layout;
        this.computeShadowPosition();
        this.setShadowFactory(factory);
    }

    public ShadowFactory getShadowFactory() {
        return this.factory;
    }

    public void setShadowFactory(ShadowFactory factory) {
        if (factory == null) {
            factory = new ShadowFactory();
        }
        if (factory != this.factory) {
            if (this.factory != null) {
                this.factory.removePropertyChangeListener(this);
            }
            this.factory = factory;
            this.factory.addPropertyChangeListener(this);
            this.shadow = null;
            this.repaint();
        }
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.computeShadowPosition();
        this.repaint();
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
        this.computeShadowPosition();
        this.repaint();
    }

    private void computeShadowPosition() {
        if (this.factory == null) {
            return;
        }
        float factor = this.distance;
        double angleRadians = Math.toRadians(this.angle);
        this.distance_x = (int)(Math.cos(angleRadians) * (double)factor);
        this.distance_y = (int)(Math.sin(angleRadians) * (double)factor);
        this.distance_x_abs = Math.abs(this.distance_x);
        this.distance_y_abs = Math.abs(this.distance_y);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.shadow = null;
        if (this.shadow == null) {
            BufferedImage buffer = new BufferedImage(this.child.getPreferredSize().width, this.child.getPreferredSize().height, 2);
            Graphics2D g2 = buffer.createGraphics();
            ((JComponent)((Object)this.child)).paint(g2);
            this.shadow = this.factory.createShadow(buffer);
            g2.dispose();
        }
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.shadow, this.getBorderSizeX() + this.distance_x - this.factory.getSize(), this.getBorderSizeY() + this.distance_y - this.factory.getSize(), null);
        super.paint(g);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.shadow = null;
        this.repaint();
    }

    public final AppxControl getChild() {
        return this.child;
    }

    private int getBorderSizeX() {
        return this.distance_x_abs + this.factory.getSize() / 2;
    }

    private int getBorderSizeY() {
        return this.distance_y_abs + this.factory.getSize() / 2;
    }

    public final void setChild(AppxControl child) {
        this.child = child;
        this.add((Component)((Object)child));
        ((Component)((Object)child)).setBounds(this.getBorderSizeX(), this.getBorderSizeY(), child.getPreferredSize().width, child.getPreferredSize().height);
    }

    @Override
    public Point getLocation() {
        if (this.child instanceof AppxLine) {
            AppxLine line = (AppxLine)this.child;
            Rectangle bounds = line.getCellBounds();
            Rectangle offset = line.getOffset();
            Insets insets = line.getInsets();
            int x = bounds.width >= 0 ? bounds.x : bounds.x + bounds.width;
            int y = bounds.height >= 0 ? bounds.y : bounds.y + bounds.height;
            int ox = bounds.width >= 0 ? offset.x : offset.x - offset.width;
            int oy = bounds.height >= 0 ? offset.y : offset.y - offset.height;
            return new Point(x * CharView.charWidth + ox - insets.left - this.getBorderSizeX(), y * CharView.charHeight + oy - insets.top - this.getBorderSizeY());
        }
        Point result = new Point(this.child.getCellBounds().x * CharView.charWidth + this.child.getOffset().x - this.getBorderSizeX(), this.child.getCellBounds().y * CharView.charHeight + this.child.getOffset().y - this.getBorderSizeY());
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.child.getPreferredSize().width + this.getBorderSizeX() * 2, this.child.getPreferredSize().height + this.getBorderSizeY() * 2);
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.child.containsCell(x, y);
    }

    @Override
    public String getAppxText() {
        return this.child.getAppxText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.child.getCellBounds();
    }

    @Override
    public Rectangle getOffset() {
        return this.child.getOffset();
    }

    @Override
    public boolean isTouched() {
        return this.child.isTouched();
    }

    @Override
    public void setAppxText(String txt) {
        this.child.setAppxText(txt);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.child.setCellBounds(x, y, width, height);
    }

    @Override
    public void setOffset(Rectangle r) {
        this.child.setOffset(r);
    }

    @Override
    public void setTouched(boolean t) {
        this.child.setTouched(t);
    }

    @Override
    public void setMargin(Insets insets) {
        this.child.setMargin(insets);
    }

    @Override
    public boolean isMovable() {
        return this.child.isMovable();
    }

    @Override
    public void setMovable(boolean b) {
        this.child.setMovable(b);
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.child.setOffsetLocation(x, y);
    }
}

