/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.msg.MApp;
import comm.msg.MField;
import comm.msg.MFile;
import doc.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import view.CharView;

public class DataPalette
extends JFrame
implements TreeExpansionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1775706872902320360L;
    protected DataPalette dp = this;
    protected JTree jt;
    protected CharView view;
    private DefaultMutableTreeNode rootNode;
    protected DefaultMutableTreeNode lastNode;
    private JToggleButton[] tools;
    protected boolean dragInProgress = false;
    public static final int NODE_ROOT = 0;
    public static final int NODE_APPLICATION = 1;
    public static final int NODE_FILE = 2;
    public static final int NODE_WORK = 3;
    public static final int NODE_FIELD = 4;
    public static final int NODE_VERSION = 5;

    public void loadAppList(Vector<MApp> appList) {
        for (MApp app : appList) {
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(new AppxNode(app.getAp(), 1));
            DefaultMutableTreeNode tnw = new DefaultMutableTreeNode(new AppxNode("Work Fields", 3));
            tnw.add(new DefaultMutableTreeNode(new AppxNode("loading...", 2)));
            tn.add(tnw);
            this.rootNode.add(tn);
        }
        this.jt.expandRow(0);
    }

    public void loadFieldList(Vector<MField> fieldList) {
        DefaultTreeModel model = (DefaultTreeModel)this.jt.getModel();
        int[] list = new int[fieldList.size()];
        this.lastNode.remove(0);
        int i = 0;
        while (i < fieldList.size()) {
            list[i] = i;
            MField field = fieldList.elementAt(i);
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(new AppxNode(field.getFieldname(), field.getDesc(), 4, field.getType()));
            this.lastNode.insert(tn, this.lastNode.getChildCount());
            ++i;
        }
        model.reload(this.lastNode);
    }

    public void loadFileList(Vector<MFile> fileList) {
        DefaultTreeModel model = (DefaultTreeModel)this.jt.getModel();
        int[] list = new int[fileList.size()];
        int i = 0;
        while (i < fileList.size()) {
            list[i] = i + 1;
            MFile file = fileList.elementAt(i);
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(new AppxNode(file.getFilename(), 2, file.getType()));
            tn.add(new DefaultMutableTreeNode(new AppxNode("loading...", 2)));
            this.lastNode.insert(tn, this.lastNode.getChildCount());
            ++i;
        }
        model.nodesWereInserted(this.lastNode, list);
    }

    public DataPalette(CharView v, String title) {
        super(title, Globals.getGraphicsConfiguration());
        this.view = v;
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.rootNode = new DefaultMutableTreeNode(new AppxNode("APPX Data Objects", 0));
        JScrollPane js = new JScrollPane();
        this.jt = new JTree(this.rootNode);
        this.jt.addTreeExpansionListener(new ExpansionListener());
        final TreeCellRenderer oldRenderer = this.jt.getCellRenderer();
        TreeCellRenderer r = new TreeCellRenderer(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = oldRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (!(c instanceof JLabel)) return c;
                JLabel l = (JLabel)c;
                Object o = ((DefaultMutableTreeNode)value).getUserObject();
                if (!(o instanceof AppxNode)) return c;
                AppxNode an = (AppxNode)o;
                switch (an.getType()) {
                    case 2: {
                        switch (an.getDataType()) {
                            case 0: {
                                if (DataPalette.this.view.fileNoneIcon == null) break;
                                l.setIcon(DataPalette.this.view.fileNoneIcon);
                                break;
                            }
                            case 1: {
                                if (DataPalette.this.view.fileDiskIcon == null) break;
                                l.setIcon(DataPalette.this.view.fileDiskIcon);
                                break;
                            }
                            case 2: {
                                if (DataPalette.this.view.fileMemIcon == null) break;
                                l.setIcon(DataPalette.this.view.fileMemIcon);
                                break;
                            }
                        }
                    }
                    case 4: {
                        switch (an.getDataType()) {
                            case 9: {
                                if (DataPalette.this.view.alphaIcon == null) return c;
                                l.setIcon(DataPalette.this.view.alphaIcon);
                                break;
                            }
                            case 10: {
                                if (DataPalette.this.view.numericIcon == null) return c;
                                l.setIcon(DataPalette.this.view.numericIcon);
                                break;
                            }
                            case 11: {
                                if (DataPalette.this.view.dateIcon == null) return c;
                                l.setIcon(DataPalette.this.view.dateIcon);
                                break;
                            }
                        }
                        return c;
                    }
                }
                return c;
            }
        };
        this.jt.setCellRenderer(r);
        MouseMotionAdapter mml = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point p = DataPalette.this.jt.getLocationOnScreen();
                if (DataPalette.this.view.dropOk(p.x + e.getX(), p.y + e.getY())) {
                    DataPalette.this.dragInProgress = true;
                    DataPalette.this.jt.setCursor(Cursor.getPredefinedCursor(1));
                } else {
                    DataPalette.this.jt.setCursor(Cursor.getPredefinedCursor(3));
                    DataPalette.this.dragInProgress = false;
                }
            }
        };
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DataPalette.this.jt.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = DataPalette.this.jt.getLocationOnScreen();
                String s = null;
                String desc = null;
                DataPalette.this.jt.setCursor(Cursor.getPredefinedCursor(0));
                if (DataPalette.this.dragInProgress) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)DataPalette.this.jt.getSelectionPath().getLastPathComponent();
                    AppxNode node = (AppxNode)treeNode.getUserObject();
                    DataPalette.this.dragInProgress = false;
                    switch (node.getType()) {
                        case 0: 
                        case 3: 
                        case 5: {
                            break;
                        }
                        case 1: {
                            s = new String("#2" + node.toString());
                            break;
                        }
                        case 2: {
                            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode.getParent();
                            AppxNode parent = (AppxNode)parentNode.getUserObject();
                            s = new String("#3" + parent.toString() + node.toString());
                            break;
                        }
                        case 4: {
                            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode.getParent();
                            DefaultMutableTreeNode grandParentNode = (DefaultMutableTreeNode)parentNode.getParent();
                            AppxNode parent = (AppxNode)parentNode.getUserObject();
                            AppxNode grandParent = (AppxNode)grandParentNode.getUserObject();
                            s = parent.getType() == 3 ? new String("#4" + grandParent.toString() + "        " + node.toString()) : new String("#4" + grandParent.toString() + parent.toString() + node.toString());
                        }
                    }
                    if (s != null) {
                        if ((e.getModifiers() & 4) == 4 && desc != null) {
                            DataPalette.this.view.pasteString(p.x + e.getX(), p.y + e.getY(), desc, true);
                        }
                        DataPalette.this.view.stringDrop(p.x + e.getX(), p.y + e.getY(), s);
                    }
                }
            }
        };
        this.jt.addMouseListener(ml);
        this.jt.addMouseMotionListener(mml);
        js.getViewport().add(this.jt);
        cp.add((Component)js, "Center");
        Dimension screenSize = Globals.getGraphicsConfiguration().getBounds().getSize();
        this.pack();
        this.setBounds(screenSize.width - 250, 0, 250, (int)((double)screenSize.height * 0.9));
        this.view.getAppList(this);
    }

    public DataPalette(CharView view) {
        this(view, "APPX Data Palette");
    }

    public void setTool(int tool) {
        this.tools[tool].setSelected(true);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    private class AppxNode {
        private String text;
        private String desc;
        private int type;
        private int dataType;
        private boolean alreadyFilled = false;

        public AppxNode(String txt, String dsc, int nodeType, int dType) {
            this.text = txt;
            this.desc = dsc;
            this.type = nodeType;
            this.dataType = dType;
        }

        public AppxNode(String txt, int nodeType, int dType) {
            this(txt, null, nodeType, dType);
        }

        public AppxNode(String txt, int nodeType) {
            this(txt, null, nodeType, 0);
        }

        public String toString() {
            return this.text;
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean isAlreadyFilled() {
            return this.alreadyFilled;
        }

        public void setAlreadyFilled(boolean state) {
            this.alreadyFilled = state;
        }
    }

    private class ExpansionListener
    implements TreeExpansionListener {
        private ExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
            DataPalette.this.lastNode = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
            AppxNode node = (AppxNode)DataPalette.this.lastNode.getUserObject();
            if (!node.isAlreadyFilled()) {
                node.setAlreadyFilled(true);
                switch (node.getType()) {
                    case 1: {
                        DataPalette.this.view.getFileList(DataPalette.this.dp, node.toString());
                        break;
                    }
                    case 2: {
                        AppxNode parent = (AppxNode)((DefaultMutableTreeNode)DataPalette.this.lastNode.getParent()).getUserObject();
                        DataPalette.this.view.getFieldList(DataPalette.this.dp, parent.toString(), node.toString());
                        break;
                    }
                    case 3: {
                        AppxNode parent = (AppxNode)((DefaultMutableTreeNode)DataPalette.this.lastNode.getParent()).getUserObject();
                        DataPalette.this.view.getFieldList(DataPalette.this.dp, parent.toString(), "        ");
                    }
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
        }
    }
}

