/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxExtension;
import doc.Document;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import view.CharView;
import view.Display;

public class AppxTokenScan
implements AppxExtension,
FocusListener,
KeyListener {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/AppxTokenScan.java,v 1.1.2.11 2011/12/12 23:15:56 pete Exp $";
    protected AppxTokenScan tscan = this;
    int myHandle;
    private int selectedIndex = -1;
    private DefaultListModel model = new DefaultListModel();
    private Display parent;
    Document document;
    JList list;
    private JScrollPane pane;
    private Rectangle appxBounds;
    private Rectangle field;
    private String originalValue;
    private Vector<String> items = new Vector();

    public void addListItem(String item) {
        this.items.addElement(item);
        this.model.addElement(item);
        if (this.originalValue.equals(item.trim())) {
            this.selectedIndex = this.model.getSize() - 1;
        }
    }

    @Override
    public void cleanup() {
        if (this.list != null) {
            this.list.removeFocusListener(this);
            this.pane.setVisible(false);
            this.parent.remove(this.pane);
        }
        this.document.setUserObjectHasFocus(false);
    }

    public void finalize() {
    }

    @Override
    public void focusGained(FocusEvent evt) {
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.document.fireObjectEvent(this.myHandle, this.list.getSelectedIndex() + 1);
    }

    public Rectangle getCellBounds() {
        return this.appxBounds;
    }

    @Override
    public int getHandle() {
        return this.myHandle;
    }

    public Point getLocation() {
        Point lc = new Point(this.appxBounds.x * CharView.charWidth - 2, this.appxBounds.y * CharView.charHeight + 2);
        return lc;
    }

    public Dimension getPreferredSize() {
        Dimension dim;
        Dimension dimension = dim = this.list == null ? new Dimension(0, 0) : this.list.getPreferredSize();
        if (this.appxBounds.width * CharView.charWidth + 4 > dim.width) {
            dim.width = this.appxBounds.width * CharView.charWidth + 2;
        }
        dim.height = CharView.charHeight * this.appxBounds.height;
        return dim;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex + 1;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void itemStateChanged(ItemEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            evt.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 27 || evt.getKeyCode() == CharView.view.getEndSpecialKeyId() || evt.getKeyCode() == 119) {
            this.document.fireObjectEvent(this.myHandle, this.list.getSelectedIndex() + 1);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    public void setCellBounds(int x, int y, int width, int height) {
        this.appxBounds = new Rectangle(x, y, width, height);
    }

    @Override
    public void setDocument(Document doc) {
        this.document = doc;
        Point cursor = this.document.lookupScanCursor();
        this.parent = this.document.lookupDisplay(cursor);
        this.field = this.document.lookupScanField();
        if (this.field != null) {
            this.setCellBounds(this.field.x, this.field.y + 1, this.field.width, 8);
        }
        this.originalValue = this.document.lookupScreenText(this.field.y + 1, this.field.x + 1, this.field.width - 2).trim();
    }

    @Override
    public void setHandle(int handle) {
        this.myHandle = handle;
    }

    public void showTheList() {
        this.document.setUserObjectHasFocus(this, true);
        this.list = new JList(this.model){
            private static final long serialVersionUID = 8987362998838819633L;

            @Override
            public Font getFont() {
                return CharView.view.footerFont;
            }
        };
        this.list.setSelectionMode(0);
        if (this.selectedIndex != -1) {
            this.list.setSelectedIndex(this.selectedIndex);
        }
        this.pane = new JScrollPane(this.list){
            private static final long serialVersionUID = 8787650694475221549L;

            @Override
            public Point getLocation() {
                return AppxTokenScan.this.tscan.getLocation();
            }
        };
        this.pane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.parent.add((Component)this.pane, 0);
        this.appxBounds.height = this.items.size();
        if (this.appxBounds.height < 3) {
            this.appxBounds.height = 3;
        }
        Rectangle parBounds = this.parent.getCellBounds();
        if (this.appxBounds.y + this.appxBounds.height > parBounds.height) {
            this.appxBounds.height = parBounds.height - this.appxBounds.y + 1;
        }
        this.list.setFixedCellWidth(this.getPreferredSize().width);
        this.list.setVisibleRowCount(this.appxBounds.height);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = AppxTokenScan.this.list.locationToIndex(e.getPoint());
                AppxTokenScan.this.document.fireObjectEvent(AppxTokenScan.this.myHandle, index + 1);
            }
        };
        this.list.addMouseListener(mouseListener);
        this.list.addKeyListener(this);
        this.pane.addKeyListener(this);
        this.pane.addFocusListener(this);
        this.list.addFocusListener(this);
        this.document.setStatusText("");
        this.parent.getView().getContentPane().setCursor(Cursor.getPredefinedCursor(0));
        this.parent.refresh();
        this.list.requestFocus();
    }
}

