/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxScaledResource;
import view.CharView;
import view.Display;

public class AppxTitlebar
extends JPanel
implements AppxScaledResource,
AppxAntiAliasControl {
    private static final long serialVersionUID = 159807767539389159L;
    public static final int CLOSE_BUTTON = 1;
    public static final int CHECK_BUTTON = 2;
    public static final int HELP_BUTTON = 3;
    protected Display display;
    private JLabel title;
    private JButton closeButton;
    private JButton okButton;
    private JButton helpButton;
    private JLabel titleIcon;
    private int imageScale = -1;
    private AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public void cleanup() {
        this.closeButton.setVisible(true);
        this.okButton.setVisible(true);
        this.helpButton.setVisible(true);
        this.setHorizontalAlignment(2);
        this.setIcon(null);
        this.setText(null);
        this.setOpaque(false);
        this.setAntiAlias(true);
    }

    public JButton getHelpButton() {
        if (this.isVisible() && this.helpButton.isVisible()) {
            return this.helpButton;
        }
        return null;
    }

    @Override
    public Point getLocation() {
        Insets bord = this.display.getBorder().getBorderInsets(this.display);
        return new Point(2 + bord.left - this.display.getInsets().left, 2 + bord.top - this.display.getInsets().top);
    }

    public JButton getOkButton() {
        if (this.isVisible() && this.okButton.isVisible()) {
            return this.okButton;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets bord = this.display.getBorder().getBorderInsets(this.display);
        Dimension dim = super.getPreferredSize();
        if (dim.height < CharView.charHeight) {
            dim.height = CharView.charHeight;
        }
        return new Dimension(this.display.getPreferredSize().width - 4 - bord.left - bord.right, CharView.charHeight);
    }

    public String getText() {
        if (this.title != null) {
            return this.title.getText();
        }
        return null;
    }

    public void initTitlebar() {
        this.titleIcon = new JLabel(){
            private static final long serialVersionUID = -1355426169371361607L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width + CharView.charWidth, super.getPreferredSize().height);
            }
        };
        this.titleIcon.setFocusable(false);
        this.titleIcon.setHorizontalAlignment(0);
        this.title = new JLabel();
        this.title.setFocusable(false);
        this.closeButton = new NoFocusButton(1);
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(this.display.getView());
        this.closeButton.addKeyListener(this.display.getView());
        this.closeButton.setActionCommand("274");
        this.okButton = new NoFocusButton(2);
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(this.display.getView());
        this.okButton.addKeyListener(this.display.getView());
        this.okButton.setActionCommand("304");
        this.helpButton = new NoFocusButton(3);
        this.helpButton.setFocusPainted(false);
        this.helpButton.addActionListener(this.display.getView());
        this.helpButton.addKeyListener(this.display.getView());
        this.helpButton.setActionCommand("20033");
        JPanel buttonPane = new JPanel();
        buttonPane.setFocusable(false);
        FlowLayout flow = new FlowLayout();
        flow.setHgap(0);
        flow.setVgap(0);
        buttonPane.setOpaque(false);
        buttonPane.setLayout(flow);
        buttonPane.setBorder(null);
        JLabel fillerLabel = new JLabel(" ");
        fillerLabel.setFocusable(false);
        buttonPane.add(this.helpButton);
        buttonPane.add(fillerLabel);
        buttonPane.add(this.okButton);
        buttonPane.add(this.closeButton);
        if (!(this.okButton.isOpaque() || this.helpButton.isOpaque() || this.closeButton.isOpaque())) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)buttonPane, "East");
        this.add((Component)this.titleIcon, "West");
        this.add((Component)this.title, "Center");
    }

    public AppxTitlebar(Display disp) {
        this.setFocusable(false);
        this.display = disp;
    }

    public void setButtonBackground(Color c) {
        this.closeButton.setBackground(c);
        this.okButton.setBackground(c);
        this.helpButton.setBackground(c);
    }

    public void setButtonBorder(Border b) {
        this.closeButton.setBorder(b);
        this.okButton.setBorder(b);
        this.helpButton.setBorder(b);
    }

    public void setButtonForeground(Color c) {
        this.closeButton.setForeground(c);
        this.okButton.setForeground(c);
        this.helpButton.setForeground(c);
    }

    public void setCloseable(boolean b) {
        this.closeButton.setVisible(b);
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        this.closeButton.setEnabled(en);
        this.okButton.setEnabled(en);
        this.helpButton.setEnabled(en);
    }

    @Override
    public void setFont(Font font) {
        if (this.title != null) {
            this.title.setFont(font);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.setOpaque(true);
    }

    @Override
    public void setForeground(Color fg) {
        if (this.title != null) {
            this.title.setForeground(fg);
        }
    }

    public void setHelpable(boolean b) {
        this.helpButton.setVisible(b);
    }

    public void setHorizontalAlignment(int a) {
        if (this.title != null) {
            this.title.setHorizontalAlignment(a);
        }
    }

    public void setHorizontalTextPosition(int a) {
        if (this.title != null) {
            this.title.setHorizontalTextPosition(a);
        }
    }

    public Icon getIcon() {
        if (this.titleIcon != null) {
            return this.titleIcon.getIcon();
        }
        return null;
    }

    public void setIcon(Icon icon) {
        if (this.titleIcon != null) {
            this.titleIcon.setIcon(icon);
        }
    }

    public void setOKable(boolean b) {
        this.okButton.setVisible(b);
    }

    public void setText(String text) {
        if (this.title != null) {
            this.title.setText(text);
        }
        if (text == null || text.length() == 0) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
        }
    }

    public void setVerticalAlignment(int a) {
        if (this.title != null) {
            this.title.setVerticalAlignment(a);
        }
    }

    public void setVerticalTextPosition(int a) {
        if (this.title != null) {
            this.title.setVerticalTextPosition(a);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public int getImageScale() {
        return this.imageScale;
    }

    @Override
    public int getScaleBaseHeight() {
        if (this.getScaleType() == 1) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm != null) {
                return fm.getAscent() - fm.getDescent();
            }
            return CharView.charHeight;
        }
        return this.getPreferredSize().height;
    }

    @Override
    public int getScaleType() {
        return 1;
    }

    @Override
    public void setScaleType(int type) {
    }

    @Override
    public void setImageScale(int scale) {
        this.imageScale = scale;
    }

    private class NoFocusButton
    extends JButton {
        private static final long serialVersionUID = 3278103153240788076L;
        private int type = 0;
        private int vista = -1;

        public NoFocusButton(int iconType) {
            this.type = iconType;
            this.setFocusable(this.isFocusable());
        }

        @Override
        public boolean isFocusable() {
            return this.type != 3;
        }

        @Override
        public void paintComponent(Graphics g) {
            Point center;
            Dimension prefSize;
            super.paintComponent(g);
            if (this.type == 1) {
                prefSize = this.getPreferredSize();
                center = new Point(prefSize.width / 2 + 1, prefSize.height / 2 - 0);
                --center.x;
                --center.y;
                if (this.isEnabled()) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color.white);
                    g.drawLine(center.x - 3, center.y - 2, center.x + 3, center.y + 4);
                    g.drawLine(center.x - 2, center.y - 2, center.x + 4, center.y + 4);
                    g.drawLine(center.x - 3, center.y + 4, center.x + 3, center.y - 2);
                    g.drawLine(center.x - 2, center.y + 4, center.x + 4, center.y - 2);
                    g.setColor(Color.gray);
                }
                g.drawLine(center.x - 4, center.y - 3, center.x + 2, center.y + 3);
                g.drawLine(center.x - 3, center.y - 3, center.x + 3, center.y + 3);
                g.drawLine(center.x - 4, center.y + 3, center.x + 2, center.y - 3);
                g.drawLine(center.x - 3, center.y + 3, center.x + 3, center.y - 3);
            }
            if (this.type == 2) {
                prefSize = this.getPreferredSize();
                center = new Point(prefSize.width / 2 + 1, prefSize.height / 2 - 0);
                --center.x;
                --center.y;
                if (this.isEnabled()) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color.white);
                    g.drawLine(center.x - 3, center.y + 1, center.x - 1, center.y + 3);
                    g.drawLine(center.x - 3, center.y + 2, center.x - 1, center.y + 4);
                    g.drawLine(center.x - 1, center.y + 3, center.x + 4, center.y - 2);
                    g.drawLine(center.x - 1, center.y + 4, center.x + 4, center.y - 1);
                    g.setColor(Color.gray);
                }
                g.drawLine(center.x - 4, center.y - 0, center.x - 2, center.y + 2);
                g.drawLine(center.x - 4, center.y + 1, center.x - 2, center.y + 3);
                g.drawLine(center.x - 2, center.y + 2, center.x + 3, center.y - 3);
                g.drawLine(center.x - 2, center.y + 3, center.x + 3, center.y - 2);
            }
            if (this.type == 3) {
                prefSize = this.getPreferredSize();
                center = new Point(prefSize.width / 2 + 1, prefSize.height / 2 - 0);
                --center.x;
                --center.y;
                if (this.isEnabled()) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color.white);
                    g.drawLine(center.x - 2, center.y - 3, center.x + 2, center.y - 3);
                    g.drawLine(center.x - 3, center.y - 2, center.x - 2, center.y - 2);
                    g.drawLine(center.x + 2, center.y - 2, center.x + 3, center.y - 2);
                    g.drawLine(center.x - 3, center.y - 1, center.x - 2, center.y - 1);
                    g.drawLine(center.x + 2, center.y - 1, center.x + 3, center.y - 1);
                    g.drawLine(center.x + 1, center.y - 0, center.x + 2, center.y - 0);
                    g.drawLine(center.x - 0, center.y + 1, center.x + 1, center.y + 1);
                    g.drawLine(center.x - 0, center.y + 2, center.x + 1, center.y + 2);
                    g.drawLine(center.x - 0, center.y + 4, center.x + 1, center.y + 4);
                    g.drawLine(center.x - 0, center.y + 5, center.x + 1, center.y + 5);
                    g.setColor(Color.gray);
                }
                g.drawLine(center.x - 3, center.y - 4, center.x + 1, center.y - 4);
                g.drawLine(center.x - 4, center.y - 3, center.x - 3, center.y - 3);
                g.drawLine(center.x + 1, center.y - 3, center.x + 2, center.y - 3);
                g.drawLine(center.x - 4, center.y - 2, center.x - 3, center.y - 2);
                g.drawLine(center.x + 1, center.y - 2, center.x + 2, center.y - 2);
                g.drawLine(center.x + 0, center.y - 1, center.x + 1, center.y - 1);
                g.drawLine(center.x - 1, center.y - 0, center.x + 0, center.y - 0);
                g.drawLine(center.x - 1, center.y + 1, center.x + 0, center.y + 1);
                g.drawLine(center.x - 1, center.y + 3, center.x + 0, center.y + 3);
                g.drawLine(center.x - 1, center.y + 4, center.x + 0, center.y + 4);
            }
        }

        @Override
        public boolean isOpaque() {
            if (this.vista == -1) {
                this.vista = this.getUI() instanceof WindowsButtonUI && System.getProperty("swing.noxp") == null ? 1 : 0;
            }
            return this.vista == 0;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.vista == 1) {
                return new Dimension(CharView.charHeight - 3, CharView.charHeight - 3);
            }
            return new Dimension(CharView.charHeight - 4, CharView.charHeight - 4);
        }
    }
}

