/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.msg.MFld;
import doc.AppxToolkit;
import doc.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import view.AppxAquaTextFieldBorder;
import view.AppxControl;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.CharView;
import view.Display;
import view.ImageEditorBorder;
import view.LimitedPlainDocument;

public class AppxTextArea
extends JScrollPane
implements ActionListener,
AppxControl,
AppxControlItem,
FocusListener,
KeyListener,
DocumentListener {
    private static final long serialVersionUID = -6066270189758613058L;
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    private Color backgroundSave = null;
    Rectangle bounds;
    int maxSize;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    Display parent;
    private boolean resizable = true;
    JTextArea text;
    private boolean touched = false;
    private boolean hasfocus = false;
    private boolean upperCase = false;
    MFld dataModel = null;
    private int gotFocusCommand = 65535;
    private int lostFocusCommand = 65535;
    private int valueAdjustedCommand = 65535;
    private Timer valueTimer = new Timer(Globals.getOptionValueInteger("valueChangedTimer"), this);
    private int focusOffset;
    private static Insets fixedInsets = new Insets(1, 0, 0, 0);
    private boolean movable = false;
    private Color pushedBg;

    public void setFocusOffset(int i) {
        this.focusOffset = i;
    }

    public MFld getFld() {
        return this.dataModel;
    }

    public void setFld(MFld fld) {
        this.dataModel = fld;
    }

    public int getEncodingType() {
        if (this.dataModel == null) {
            return 0;
        }
        return this.dataModel.getEncodingType();
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.text != null) {
            this.text.addMouseListener(l);
        }
    }

    public AppxTextArea(Display disp, int rows, int cols, boolean ucs) {
        this.parent = disp;
        this.maxSize = rows * cols;
        this.upperCase = ucs;
        this.hasfocus = false;
        this.getTextWidget();
        if (this.upperCase) {
            ((LimitedPlainDocument)this.text.getDocument()).setUpperCase();
        }
        this.text.setRows(rows);
        this.text.setColumns(cols);
        this.setViewportView(this.text);
        this.setFocusable(false);
        this.getViewport().setFocusable(false);
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.setBorder(new AppxAquaTextFieldBorder());
        } else {
            this.setBorder(UIManager.getBorder("TextField.border"));
        }
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setFont(this.parent.getStdFont());
        this.text.addFocusListener(this);
        this.text.addKeyListener(this);
        this.text.getDocument().addDocumentListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
    }

    public AppxTextArea(Display disp, int x, int y, int width, int height, boolean ucs) {
        this(disp, height, width, ucs);
        this.setCellBounds(x, y, width, height);
    }

    @Override
    public boolean hasFocus() {
        return this.hasfocus;
    }

    @Override
    public void setBorder(Border b) {
        this.setViewportBorder(b);
    }

    @Override
    public Border getBorder() {
        return this.getViewportBorder();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.valueAdjustedCommand != 65535) {
            this.valueTimer.stop();
            CharView.view.lastOffset = this.text.getCaretPosition();
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxTextArea.this, 1001, "" + AppxTextArea.this.valueAdjustedCommand, 0);
                    AppxTextArea.this.parent.getView().bufferAppxEvent(e);
                }
            });
        }
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.valueTimer.stop();
        if (this.gotFocusCommand != 65535 && doc.Document.isLocked()) {
            return;
        }
        this.hasfocus = true;
        if (this.getGraphics() != null) {
            this.paintBorder(this.getGraphics());
        }
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.repaint();
        } else if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isFocusable()) {
            this.setBorder(new ImageEditorBorder());
            this.repaint();
        }
        if (!this.parent.getView().isWindowActive() || this.parent.getView().isJustGotFocus()) {
            return;
        }
        AppxControlUtils.focusGained(this.parent, this);
        this.parent.getView().putCursor(this.bounds.x, this.bounds.y);
        this.getTextWidget();
        int len = this.getText().length();
        if (this.focusOffset > 0) {
            if (this.focusOffset > len) {
                String tmpStr = this.getAppxText();
                while (len < this.focusOffset) {
                    ++len;
                    tmpStr = String.valueOf(tmpStr) + " ";
                }
                this.setAppxText(tmpStr);
            }
            this.text.setCaretPosition(this.focusOffset);
            this.focusOffset = 0;
        } else if (Globals.getOptionValueBoolean("autoSelect") && CharView.view.lastOption != 333) {
            this.text.setCaretPosition(len);
            this.text.moveCaretPosition(0);
        } else if (CharView.view.lastOption == 333 && CharView.view.lastOffset >= 0 && this.getText().length() > CharView.view.lastOffset) {
            this.text.setCaretPosition(CharView.view.lastOffset);
        } else {
            this.text.setSelectionStart(len);
            this.text.setSelectionEnd(len);
        }
        if (this.gotFocusCommand != 65535 && CharView.view.readyForInput) {
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxTextArea.this, 1001, "" + AppxTextArea.this.gotFocusCommand, 0);
                    AppxTextArea.this.parent.getView().bufferAppxEvent(e);
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.hasfocus = false;
        AppxControlUtils.focusLost(this.parent, this);
        if (this.getGraphics() != null) {
            this.paintBorder(this.getGraphics());
        }
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.repaint();
        } else if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isFocusable()) {
            this.setBorder(BorderFactory.createLineBorder(Color.white));
            this.repaint();
        }
        if (this.lostFocusCommand != 65535 && CharView.view.readyForInput && this.parent.getView().isWindowActive()) {
            this.parent.getView().setLostFocusCommand(this.lostFocusCommand, 65535, this);
        }
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Font getFont() {
        this.getTextWidget();
        return this.text.getFont();
    }

    @Override
    public Insets getInsets() {
        return fixedInsets;
    }

    @Override
    public Point getLocation() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth - 2 + this.offset.x, this.bounds.y * CharView.charHeight + 3 + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Dimension(this.bounds.width * CharView.charWidth + 4 + this.offset.width - 1, this.bounds.height * CharView.charHeight - 2 + this.offset.height - 1);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    protected String getPropertyPrefix() {
        return "TextArea";
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    public String getText() {
        this.getTextWidget();
        if (this.parent.getView().checkForFeature(0x200000)) {
            return this.text.getText();
        }
        return this.text.getText().replace('\n', '\u00b6');
    }

    public JTextArea getTextWidget() {
        if (this.text == null) {
            this.text = new JTextArea(new LimitedPlainDocument(this.maxSize, this.upperCase)){
                private static final long serialVersionUID = 1750238306395475856L;

                @Override
                public void replaceSelection(String content) {
                    if (Globals.validateEncodedString(content, AppxTextArea.this.getEncodingType())) {
                        super.replaceSelection(content);
                    }
                }

                public void keyPressed(KeyEvent evt) {
                    System.err.println("text.keyPressed()=" + evt);
                }

                public void keyReleased(KeyEvent evt) {
                    System.err.println("text.keyReleased()=" + evt);
                }

                public void keyTyped(KeyEvent evt) {
                    System.err.println("text.keyTyped()=" + evt);
                }
            };
            this.text.addFocusListener(this);
            super.setOpaque(true);
            super.setBackground(this.text.getBackground());
            this.getViewport().setOpaque(true);
            this.getViewport().setBackground(this.text.getBackground());
        }
        return this.text;
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public boolean isFocusable() {
        return this.text.isFocusable();
    }

    @Override
    public void requestFocus() {
        this.text.requestFocus();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 0) {
            AppxControlUtils.keyFix(evt);
        }
        if (evt.getKeyCode() == 34 || evt.getKeyCode() == 33) {
            return;
        }
        if (evt.getKeyCode() == 10) {
            if (!Globals.getOptionValueBoolean("textReverseEnterKey")) {
                if (evt.isControlDown()) {
                    evt.setModifiers(evt.getModifiers() & 0xFFFFFFFD);
                } else if (evt.isShiftDown()) {
                    evt.setModifiers(evt.getModifiers() & 0xFFFFFFFE);
                } else {
                    if (this.parent.defaultButton != null) {
                        this.parent.defaultButton.doClick();
                    } else {
                        this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, "304"));
                    }
                    evt.consume();
                }
            } else if (evt.isControlDown() || evt.isShiftDown()) {
                if (this.parent.defaultButton != null) {
                    this.parent.defaultButton.doClick();
                } else {
                    this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, "304"));
                }
                evt.consume();
            }
        } else {
            AppxControlUtils.keyPressed(evt, this.parent);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 0) {
            AppxControlUtils.keyFix(evt);
        }
        if (evt.getKeyCode() == 34 || evt.getKeyCode() == 33) {
            return;
        }
        if (evt.getKeyCode() == 9 && evt.isShiftDown()) {
            this.transferFocusBackward();
            evt.consume();
            return;
        }
        if (evt.getKeyCode() == 9 && !evt.isShiftDown()) {
            this.transferFocus();
            evt.consume();
            return;
        }
        AppxControlUtils.keyReleased(evt, this.parent);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 9) {
            evt.consume();
            return;
        }
        if (evt.getKeyCode() == 34 || evt.getKeyCode() == 33) {
            return;
        }
        if (AppxControlUtils.keyTyped(evt, this.parent)) {
            if (!Globals.getOptionValueBoolean("textReverseEnterKey")) {
                if (evt.getKeyCode() == 10 && evt.isControlDown()) {
                    evt.setModifiers(evt.getModifiers() & 0xFFFFFFFD);
                } else if (evt.getKeyCode() == 10 && evt.isShiftDown()) {
                    evt.setModifiers(evt.getModifiers() & 0xFFFFFFFE);
                } else if (evt.getKeyCode() == 10) {
                    evt.consume();
                }
            } else if (evt.getKeyCode() == 10 && (evt.isControlDown() || evt.isShiftDown())) {
                evt.consume();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
        this.text.setCaretPosition(0);
    }

    @Override
    public void setBackground(Color color) {
        this.getTextWidget();
        this.text.setBackground(color);
        super.setBackground(color);
        this.getViewport().setBackground(this.text.getBackground());
    }

    public void setBorderPainted(boolean painted) {
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellLocation(int x, int y) {
        if (this.bounds != null) {
            this.bounds.x = x + this.parent.getCellBounds().x;
            this.bounds.y = y + this.parent.getCellBounds().y;
        }
    }

    public void setCellSize(int width, int height) {
        if (this.bounds != null) {
            this.bounds.width = width;
            this.bounds.height = height;
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (b != this.isEnabled()) {
            super.setEnabled(b);
            if (!b) {
                this.backgroundSave = this.getBackground();
                if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
                    this.setBackground((Color)UIManager.get("Panel.background"));
                } else {
                    this.setBackground((Color)UIManager.get("ComboBox.disabledBackground"));
                }
            } else {
                this.setBackground(this.backgroundSave);
                this.backgroundSave = null;
            }
        }
        this.getTextWidget();
        this.text.setEnabled(b);
    }

    @Override
    public void setFont(Font f) {
        this.getTextWidget();
        this.text.setFont(f);
    }

    public void setFontSize(int s) {
    }

    @Override
    public void setForeground(Color color) {
        this.getTextWidget();
        this.text.setForeground(color);
        this.text.setDisabledTextColor(color);
    }

    public void setMaxLen(int max) {
        this.maxSize = max;
        Document doc = this.getTextWidget().getDocument();
        if (doc instanceof LimitedPlainDocument) {
            ((LimitedPlainDocument)doc).setMaxCharacters(max);
        }
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    @Override
    public void setOpaque(boolean b) {
        this.getTextWidget();
        this.text.setOpaque(b);
        super.setOpaque(b);
        this.getViewport().setOpaque(b);
    }

    public void setResizable(boolean b) {
        this.resizable = b;
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    public void setText(String txt) {
        this.getTextWidget();
        if (txt != null) {
            if (this.parent.getView().checkForFeature(0x200000)) {
                this.text.setText(txt);
            } else {
                this.text.setText(txt.replace('\u00b6', '\n'));
            }
        }
        this.setTouched(false);
    }

    @Override
    public void setToolTipText(String s) {
        this.getTextWidget();
        this.text.setToolTipText(s);
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.parent.isScreenLocked()) {
            return;
        }
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
        if (this.touched && this.valueAdjustedCommand != 65535) {
            this.valueTimer.setDelay(Globals.getOptionValueInteger("valueChangedTimer"));
            this.valueTimer.setInitialDelay(Globals.getOptionValueInteger("valueChangedTimer"));
            this.valueTimer.restart();
        } else {
            this.valueTimer.stop();
        }
    }

    public void updateOptions(AppxControl options) {
        AppxTextArea op = (AppxTextArea)options;
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setFont(op.getFont());
        this.setText(op.getText());
        this.setBorder(op.getBorder());
        this.setEnabled(op.isEnabled());
        this.setTabable(op.getTabable());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.getTextWidget().updateUI();
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    public void setHorizontalAlignment(int a) {
    }

    public void setVerticalAlignment(int a) {
    }

    public void setGotFocusCommand(int s) {
        this.gotFocusCommand = s;
    }

    public void setGotFocusCommand(String s) {
        this.gotFocusCommand = Integer.parseInt(s);
    }

    public int getGotFocusCommand() {
        return this.gotFocusCommand;
    }

    public void setLostFocusCommand(int s) {
        this.lostFocusCommand = s;
    }

    public void setLostFocusCommand(String s) {
        this.lostFocusCommand = Integer.parseInt(s);
    }

    public int getLostFocusCommand() {
        return this.lostFocusCommand;
    }

    public void setValueAdjustedCommand(int s) {
        this.valueAdjustedCommand = s;
    }

    public void setValueAdjustedCommand(String s) {
        this.valueAdjustedCommand = Integer.parseInt(s);
    }

    public int getValueAdjustedCommand() {
        return this.valueAdjustedCommand;
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = this.getTextWidget().getBackground();
            this.getTextWidget().setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            this.getTextWidget().setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

