/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.text.Collator;
import java.util.Comparator;
import javax.swing.DefaultRowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableStringConverter;
import view.AppxTableModel;

public class AppxTableRowSorter<M extends TableModel>
extends DefaultRowSorter<M, Integer> {
    private static final Comparator COMPARABLE_COMPARATOR = new ComparableComparator();
    private M tableModel;
    private TableStringConverter stringConverter;

    public AppxTableRowSorter() {
        this(null);
    }

    public AppxTableRowSorter(M model) {
        this.setModel(model);
    }

    public void setStringConverter(TableStringConverter stringConverter) {
        this.stringConverter = stringConverter;
    }

    public TableStringConverter getStringConverter() {
        return this.stringConverter;
    }

    public void setModel(M model) {
        this.tableModel = model;
        this.setModelWrapper(new TableRowSorterModelWrapper());
    }

    @Override
    public Comparator<?> getComparator(int column) {
        Comparator<?> comparator = super.getComparator(column);
        if (comparator != null) {
            return comparator;
        }
        Class<?> columnClass = ((TableModel)this.getModel()).getColumnClass(column);
        if (columnClass == String.class) {
            return Collator.getInstance();
        }
        if (Comparable.class.isAssignableFrom(columnClass)) {
            return COMPARABLE_COMPARATOR;
        }
        return Collator.getInstance();
    }

    @Override
    protected boolean useToString(int column) {
        Comparator<?> comparator = super.getComparator(column);
        if (comparator != null) {
            return false;
        }
        Class<?> columnClass = ((TableModel)this.getModel()).getColumnClass(column);
        if (columnClass == String.class) {
            return false;
        }
        return !Comparable.class.isAssignableFrom(columnClass);
    }

    private static class ComparableComparator
    implements Comparator {
        private ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }

    private class TableRowSorterModelWrapper
    extends DefaultRowSorter.ModelWrapper<M, Integer> {
        private TableRowSorterModelWrapper() {
        }

        @Override
        public M getModel() {
            return AppxTableRowSorter.this.tableModel;
        }

        @Override
        public int getColumnCount() {
            return AppxTableRowSorter.this.tableModel == null ? 0 : AppxTableRowSorter.this.tableModel.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return AppxTableRowSorter.this.tableModel == null ? 0 : AppxTableRowSorter.this.tableModel.getRowCount();
        }

        @Override
        public Integer getIdentifier(int index) {
            return index;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (AppxTableRowSorter.this.tableModel instanceof AppxTableModel) {
                return ((AppxTableModel)AppxTableRowSorter.this.tableModel).getSortValueAt(row, column);
            }
            return AppxTableRowSorter.this.tableModel.getValueAt(row, column);
        }

        @Override
        public String getStringValueAt(int row, int column) {
            TableStringConverter converter = AppxTableRowSorter.this.getStringConverter();
            if (converter != null) {
                String value = converter.toString(AppxTableRowSorter.this.tableModel, row, column);
                if (value != null) {
                    return value;
                }
                return "";
            }
            Object o = this.getValueAt(row, column);
            if (o == null) {
                return "";
            }
            String string = o.toString();
            if (string == null) {
                return "";
            }
            return string;
        }
    }
}

