/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import sun.swing.table.DefaultTableCellHeaderRenderer;
import view.AppxControl;
import view.AppxControlUtils;
import view.AppxTableModel;
import view.AppxTableRowSorter;
import view.CharView;
import view.Display;

public class AppxTable
extends JScrollPane
implements AppxControl,
ActionListener,
KeyListener {
    private static final long serialVersionUID = 2707515165036431793L;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private JScrollPane me = this;
    int pcbId = 0;
    int fillCol = 0;
    Rectangle bounds;
    Display parent;
    int colCount;
    int rowCount;
    boolean isDragging = false;
    boolean enabled = true;
    String[] colName = null;
    boolean[] colEdit = null;
    int[] colPos = null;
    int[] colWidth = null;
    int[] colSize = null;
    Class[] colClass = null;
    Object[] fieldData;
    Object[] fieldSort;
    String[] fieldKey;
    boolean[] fieldSel;
    String action = null;
    String action2 = null;
    int multiClickInterval = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval") == null ? 500 : (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
    Timer timer = new Timer(this.multiClickInterval, this);
    private String widgetId = null;
    private boolean createHeadings = false;
    private String frameImageKey = null;
    private int hashSig = 0;
    private boolean showGrid = true;
    AbstractTableModel dataModel;
    JTable table;
    private boolean touched = false;

    public void setShowGrid(boolean b) {
        this.showGrid = b;
    }

    public String getFrameImageKey() {
        return this.frameImageKey;
    }

    public void setFrameImageKey(String frameImageKey) {
        this.frameImageKey = frameImageKey;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        if (this.table != null) {
            this.table.setEnabled(b);
        }
    }

    public AppxTable(Display disp, int x, int y, int width, int height) {
        super(20, 30);
        this.parent = disp;
        this.setCellBounds(x, y - 1, width, height + 1);
    }

    public void setWidgetId(String s) {
        this.widgetId = s;
    }

    public String getWidgetId() {
        if (this.widgetId == null) {
            return "t-r" + this.bounds.y + "c" + this.bounds.x + "h" + this.bounds.height + "w" + this.bounds.width;
        }
        return this.widgetId;
    }

    public ArrayList<String> getSelectedKeys() {
        ArrayList<String> al = new ArrayList<String>();
        if (this.table != null && this.rowCount > 0 && this.table.getSelectedRows().length > 0) {
            int[] rows = this.table.getSelectedRows();
            int i = 0;
            while (i < rows.length) {
                al.add(this.fieldKey[this.table.convertRowIndexToModel(rows[i])]);
                ++i;
            }
        }
        return al;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.enabled) {
            this.timer.stop();
            this.singleClick();
        }
    }

    public void setActionCommand(String a) {
        this.action = a;
    }

    public void setActionCommand2(String a) {
        this.action2 = a;
    }

    public void initTable(int rows, int cols) {
        this.fillCol = 0;
        this.colCount = 0;
        this.rowCount = 0;
        this.colName = new String[cols];
        this.colEdit = new boolean[cols];
        this.colClass = new Class[cols];
        this.colPos = new int[cols];
        this.colSize = new int[cols];
        this.colWidth = new int[cols];
        this.fieldData = new Object[rows];
        this.fieldSort = new Object[rows];
        this.fieldKey = new String[rows];
        this.fieldSel = new boolean[rows];
    }

    public void addAppxColumn(int pos, int size, int width, String name, Class cl, boolean edit) {
        this.colName[this.colCount] = name.trim();
        this.colClass[this.colCount] = cl;
        this.colPos[this.colCount] = pos;
        this.colSize[this.colCount] = size;
        this.colWidth[this.colCount] = width;
        this.colEdit[this.colCount] = edit;
        ++this.colCount;
    }

    public void addAppxRow(boolean sel, String key, Object[] fields, Object[] fieldsSort) {
        this.fieldSel[this.rowCount] = sel;
        this.fieldKey[this.rowCount] = key;
        this.fieldData[this.rowCount] = fields;
        this.fieldSort[this.rowCount] = fieldsSort;
        ++this.rowCount;
    }

    private void fireActionOption() {
        ActionEvent e = new ActionEvent(this, 1001, this.getActionCommand(), 0);
        this.parent.getView().bufferAppxEvent(e);
    }

    private void fireActionOption2() {
        ActionEvent e = new ActionEvent(this, 1001, this.getActionCommand2(), 0);
        this.parent.getView().bufferAppxEvent(e);
    }

    private String getActionCommand() {
        return this.action;
    }

    private String getActionCommand2() {
        return this.action2;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.table != null) {
            this.table.setForeground(c);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.table != null) {
            this.table.setFont(f);
            this.table.setRowHeight(this.getFont().getSize() + this.parent.getStdFont().getSize() / 2);
            Font hf = this.table.getTableHeader().getFont();
            this.table.getTableHeader().setFont(new Font(hf.getName(), hf.getStyle(), f.getSize()));
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.table != null) {
            JScrollPane scrollPane;
            JViewport viewport;
            Container gp;
            this.table.setBackground(c);
            Container p = this.table.getParent();
            if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane && ((viewport = (scrollPane = (JScrollPane)gp).getViewport()) == null || viewport.getView() != this)) {
                return;
            }
            this.viewport.setBackground(this.getBackground());
        }
    }

    public void buildTable() {
        this.dataModel = new AppxTableModel(){
            private static final long serialVersionUID = 6674568574768126966L;

            @Override
            public int getColumnCount() {
                return AppxTable.this.colCount;
            }

            @Override
            public int getRowCount() {
                return AppxTable.this.rowCount;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return AppxTable.this.colClass[columnIndex];
            }

            @Override
            public Class<?> getAppxColumnClass(int columnIndex) {
                return AppxTable.this.colClass[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return AppxTable.this.colEdit[col];
            }

            @Override
            public void setValueAt(Object val, int row, int col) {
                Object[] fields = (Object[])AppxTable.this.fieldData[row];
                fields[col] = val;
            }

            @Override
            public Object getValueAt(int row, int col) {
                try {
                    Object[] fields = (Object[])AppxTable.this.fieldData[row];
                    return fields[col];
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public Object getSortValueAt(int row, int col) {
                Object result = null;
                try {
                    Object[] fields = (Object[])AppxTable.this.fieldSort[row];
                    if (fields == null || fields[col] == null) {
                        fields = (Object[])AppxTable.this.fieldData[row];
                    }
                    result = fields[col];
                }
                catch (Exception e) {
                    System.err.println("getSortValueAt() exception=" + e);
                    return null;
                }
                return result;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return AppxTable.this.colName[columnIndex];
            }

            public boolean getColumnEdit(int columnIndex) {
                return AppxTable.this.colEdit[columnIndex];
            }
        };
        DefaultTableColumnModel colModel = new DefaultTableColumnModel();
        colModel.setColumnSelectionAllowed(false);
        int i = 0;
        while (i < this.colCount) {
            DefaultTableCellHeaderRenderer cellRenderer = new DefaultTableCellHeaderRenderer();
            if (this.colClass[i].equals(Integer.class) || this.colClass[i].equals(Date.class) || this.colClass[i].equals(Float.class)) {
                cellRenderer.setHorizontalAlignment(4);
            } else {
                cellRenderer.setHorizontalAlignment(2);
            }
            TableColumn col = new TableColumn(i);
            col.setHeaderValue(this.dataModel.getColumnName(i));
            colModel.addColumn(col);
            col.setHeaderRenderer(cellRenderer);
            col.setPreferredWidth(this.colWidth[i] * CharView.charWidth);
            ++i;
        }
        this.table = new JTable(){
            int counter = 0;
            DefaultTableCellRenderer renderRJ = new DefaultTableCellRenderer();
            public JPanel headerPanel = new JPanel(new BorderLayout());

            @Override
            public void doLayout() {
                ++this.counter;
                super.doLayout();
                if (AppxTable.this.fillCol > 0) {
                    this.sizeColumnsToFitAppx2();
                }
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                Class<?> cl;
                if (this.dataModel instanceof AppxTableModel && ((cl = ((AppxTableModel)this.dataModel).getAppxColumnClass(column)).equals(Integer.class) || cl.equals(Date.class) || cl.equals(Float.class))) {
                    this.renderRJ.setHorizontalAlignment(4);
                    return this.renderRJ;
                }
                return super.getCellRenderer(row, column);
            }

            public void sizeColumnsToFitAppx() {
                if (AppxTable.this.fillCol > 0) {
                    TableColumnModel cm = this.getColumnModel();
                    TableColumn tc = null;
                    int cols = cm.getColumnCount();
                    int fill = AppxTable.this.fillCol;
                    int colsWidth = 0;
                    int i = 0;
                    while (i < cols) {
                        tc = cm.getColumn(i);
                        colsWidth += tc.getWidth();
                        ++i;
                    }
                    int viewWidth = AppxTable.this.me.getViewport().getWidth();
                    int colWidth = this.getColumnModel().getColumn(fill - 1).getWidth();
                    int newWidth = colWidth + (viewWidth - colsWidth);
                    if (newWidth > 0 && newWidth != colWidth) {
                        this.getColumnModel().getColumn(fill - 1).setPreferredWidth(newWidth);
                        this.getColumnModel().getColumn(fill - 1).setWidth(newWidth);
                    }
                }
            }

            public void sizeColumnsToFitAppx2() {
                if (AppxTable.this.fillCol > 0) {
                    TableColumnModel cm = this.getColumnModel();
                    TableColumn tc = null;
                    int cols = cm.getColumnCount();
                    int fill = AppxTable.this.fillCol;
                    int colsWidth = 0;
                    int i = 0;
                    while (i < cols) {
                        tc = cm.getColumn(i);
                        colsWidth += tc.getWidth();
                        ++i;
                    }
                    int viewWidth = AppxTable.this.me.getViewport().getWidth();
                    int delta = viewWidth - colsWidth;
                    int colWidth = this.getColumnModel().getColumn(fill - 1).getWidth();
                    if (delta != 0) {
                        this.getColumnModel().getColumn(fill - 1).setPreferredWidth(colWidth + delta);
                        this.getColumnModel().getColumn(fill - 1).setWidth(colWidth + delta);
                    }
                }
            }

            public void sizeColumnsToFitAppx3() {
                if (AppxTable.this.fillCol > 0) {
                    int colWidth2;
                    TableColumnModel cm = this.getColumnModel();
                    TableColumn tc = null;
                    int cols = cm.getColumnCount();
                    int fill = AppxTable.this.fillCol;
                    int colsWidth = 0;
                    int i = 0;
                    while (i < cols) {
                        tc = cm.getColumn(i);
                        colsWidth += tc.getWidth();
                        ++i;
                    }
                    int viewWidth = AppxTable.this.me.getViewport().getWidth();
                    int delta = viewWidth - colsWidth;
                    int each = delta / 2;
                    int colWidth = this.getColumnModel().getColumn(fill - 1).getWidth();
                    each = (int)((double)colWidth / (double)(colWidth + (colWidth2 = this.getColumnModel().getColumn(fill).getWidth())) * (double)delta);
                    if (each != 0) {
                        this.getColumnModel().getColumn(fill - 1).setPreferredWidth(colWidth + each);
                        this.getColumnModel().getColumn(fill - 1).setWidth(colWidth + each);
                        delta -= each;
                    }
                    if (delta != 0) {
                        this.getColumnModel().getColumn(fill).setPreferredWidth(colWidth + delta);
                        this.getColumnModel().getColumn(fill).setWidth(colWidth + delta);
                    }
                }
            }

            public void sizeColumnsToFit2(int i) {
                if (AppxTable.this.fillCol > 0) {
                    int colWidth = this.getColumnModel().getColumn(AppxTable.this.fillCol - 1).getWidth();
                    int tableWidth = this.getTableHeader().getWidth();
                    int viewWidth = AppxTable.this.me.getViewport().getWidth();
                    int newWidth = colWidth + (viewWidth - tableWidth);
                    System.err.println("colWidth=" + colWidth + ", tableWidth=" + tableWidth + ", viewWidth=" + viewWidth + ", newWidth=" + newWidth);
                    if (newWidth > 0 && newWidth != colWidth) {
                        this.getColumnModel().getColumn(AppxTable.this.fillCol - 1).setPreferredWidth(newWidth);
                    }
                }
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }

            @Override
            protected void configureEnclosingScrollPane() {
                Container gp;
                super.configureEnclosingScrollPane();
                JLabel dummyColumn = new JLabel(){

                    @Override
                    public Border getBorder() {
                        return UIManager.getBorder("TableHeader.cellBorder");
                    }
                };
                this.headerPanel.removeAll();
                this.headerPanel.add((Component)this.getTableHeader(), "West");
                this.headerPanel.add((Component)dummyColumn, "Center");
                Container p = this.getParent();
                if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)gp;
                    JViewport viewport = scrollPane.getViewport();
                    if (viewport == null || viewport.getView() != this) {
                        return;
                    }
                    scrollPane.setColumnHeaderView(this.headerPanel);
                }
                AppxTable.this.viewport.setBackground(this.getBackground());
            }

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (AppxTable.this.enabled) {
                    super.changeSelection(rowIndex, columnIndex, toggle, extend);
                }
            }
        };
        this.table.setEnabled(this.enabled);
        this.table.setBackground(this.getBackground());
        this.table.setForeground(this.getForeground());
        this.table.setFont(this.getFont());
        if (!this.showGrid) {
            this.table.setShowGrid(false);
            this.table.setIntercellSpacing(new Dimension(0, 0));
        }
        Font f = this.table.getTableHeader().getFont();
        this.table.getTableHeader().setFont(new Font(f.getName(), f.getStyle(), this.getFont().getSize()));
        this.table.setAutoResizeMode(0);
        this.table.setModel(this.dataModel);
        this.table.setColumnModel(colModel);
        this.table.setRowHeight(this.getFont().getSize() + this.parent.getStdFont().getSize() / 2);
        this.setViewportView(this.table);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoCreateRowSorter(false);
        AppxTableRowSorter<AbstractTableModel> sorter = new AppxTableRowSorter<AbstractTableModel>(this.dataModel);
        this.table.setRowSorter(sorter);
        this.table.addKeyListener(this);
        if (!this.createHeadings) {
            this.table.setTableHeader(null);
        }
        this.table.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int firstSel = -1;
                        int[] tmp = (this).AppxTable.this.table.getSelectedRows();
                        if (tmp.length == 0) {
                            return;
                        }
                        int i = 0;
                        while (i < tmp.length) {
                            int ii = tmp[i];
                            if (firstSel == -1 || firstSel > ii) {
                                firstSel = ii;
                            }
                            ++i;
                        }
                        if (firstSel >= 0) {
                            AppxTable.this.scrollToVisible((this).AppxTable.this.table, firstSel, 0);
                        }
                    }
                });
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (doc.Document.isLocked() | doc.Document.isGotTimeout()) {
                    e.consume();
                    return;
                }
                AppxTable.this.isDragging = true;
                super.mouseDragged(e);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){
            int row;

            @Override
            public void mousePressed(MouseEvent e) {
                if (doc.Document.isLocked() | doc.Document.isGotTimeout()) {
                    e.consume();
                    return;
                }
                super.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (doc.Document.isLocked() | doc.Document.isGotTimeout()) {
                    e.consume();
                    return;
                }
                super.mouseReleased(e);
                if (AppxTable.this.enabled && AppxTable.this.isDragging) {
                    AppxTable.this.timer.stop();
                    AppxTable.this.singleClick();
                }
                AppxTable.this.isDragging = false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (doc.Document.isLocked() | doc.Document.isGotTimeout()) {
                    e.consume();
                    return;
                }
                if (e.getClickCount() > 2) {
                    return;
                }
                if (AppxTable.this.enabled) {
                    if (AppxTable.this.timer.isRunning() && this.row == AppxTable.this.table.getSelectedRow()) {
                        AppxTable.this.timer.stop();
                        AppxTable.this.doubleClick();
                    } else {
                        this.row = AppxTable.this.table.getSelectedRow();
                        AppxTable.this.timer.restart();
                    }
                }
            }
        });
        int firstSel = -1;
        int i2 = 0;
        while (i2 < this.fieldSel.length) {
            if (this.fieldSel[i2]) {
                int ii = this.table.convertRowIndexToView(i2);
                this.table.getSelectionModel().addSelectionInterval(ii, ii);
                if (firstSel == -1 || firstSel > ii) {
                    firstSel = ii;
                }
            }
            ++i2;
        }
        if (firstSel >= 0) {
            this.scrollToVisible(this.table, firstSel, 0);
        }
        JLabel rend = (JLabel)((Object)this.table.getDefaultRenderer(String.class));
        rend.setVerticalAlignment(1);
    }

    public void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle cRect = table.getCellRect(rowIndex, vColIndex, true);
        Rectangle vRect = viewport.getViewRect();
        if (vRect.height == 0) {
            Dimension d = this.getPreferredSize();
            vRect.height = d.height - cRect.height;
            vRect.width = d.width;
        }
        if (cRect.y <= vRect.y || cRect.y + cRect.height > vRect.y + vRect.height) {
            cRect.setLocation(cRect.x - vRect.x, cRect.y - vRect.y);
            viewport.scrollRectToVisible(cRect);
        }
    }

    public void singleClick() {
        if (this.enabled) {
            this.timer.stop();
            this.fireActionOption();
        }
    }

    public void doubleClick() {
        if (this.enabled) {
            this.timer.stop();
            this.fireActionOption2();
        }
    }

    public void focusGained(FocusEvent evt) {
    }

    public void focusLost(FocusEvent evt) {
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        return new Point(this.bounds.x * CharView.charWidth - 2, this.bounds.y * CharView.charHeight + 2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.bounds.width * CharView.charWidth + 4, this.bounds.height * CharView.charHeight);
    }

    public String getText() {
        return null;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setText(String txt) {
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return false;
    }

    @Override
    public String getAppxText() {
        return null;
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    public void setExtraData(String s) {
        this.setAppxText(s);
    }

    public static String getTestData() {
        String result = "30\u00024\u00024\u00011\u00024\u00024\u0002?\u0002java.lang.Boolean\u0002true\u00012\u000210\u000210\u0002Key\u0002java.lang.Integer\u0002false\u00013\u000215\u000215\u0002Name\u0002java.lang.String\u0002true\u00014\u000260\u000260\u0002Description\u0002java.lang.String\u0002true\u000101\u0002false\u0002false\u000210\u0002Demetrius\u0002viverra. Maecenas iaculis aliquet diam. Sed diam lorem, auctor quis\u000102\u0002false\u0002false\u000220\u0002Dylan\u0002Donec est. Nunc ullamcorper, velit\u000103\u0002true\u0002false\u000230\u0002Vera\u0002venenatis vel, faucibus id, libero. Donec consectetuer mauris id\u000104\u0002false\u0002false\u000240\u0002Rudyard\u0002risus, at fringilla purus mauris a nunc. In at pede.\u000105\u0002true\u0002false\u000250\u0002Sebastian\u0002ut, pellentesque eget, dictum placerat, augue. Sed\u000106\u0002false\u0002false\u000260\u0002Cameran\u0002vel, faucibus id, libero. Donec consectetuer mauris\u000107\u0002false\u0002false\u000270\u0002Colette\u0002arcu. Vestibulum ante ipsum primis in faucibus orci luctus\u000108\u0002false\u0002false\u000280\u0002Winter\u0002luctus felis purus ac tellus. Suspendisse sed dolor.\u000109\u0002false\u0002false\u000290\u0002Gary\u0002eu odio tristique pharetra. Quisque ac libero nec\u00010A\u0002false\u0002false\u0002100\u0002Amanda\u0002eget varius ultrices, mauris ipsum porta\u00010B\u0002false\u0002false\u0002110\u0002Raya\u0002Quisque imperdiet, erat nonummy ultricies ornare, elit\u00010C\u0002false\u0002false\u0002120\u0002Callum\u0002eu tempor erat neque non quam. Pellentesque habitant morbi\u00010D\u0002false\u0002false\u0002130\u0002Shana\u0002luctus. Curabitur egestas nunc sed libero. Proin sed turpis\u00010E\u0002false\u0002false\u0002140\u0002Jerome\u0002ante, iaculis nec, eleifend non, dapibus rutrum, justo.\u00010F\u0002false\u0002false\u0002150\u0002Elliott\u0002consectetuer ipsum nunc id enim. Curabitur massa.\u000110\u0002false\u0002false\u0002160\u0002Kessie\u0002Nullam velit dui, semper et, lacinia vitae, sodales\u000111\u0002false\u0002false\u0002170\u0002Cathleen\u0002rhoncus id, mollis nec, cursus a, enim. Suspendisse aliquet,\u000112\u0002false\u0002false\u0002180\u0002Henry\u0002Etiam laoreet, libero et tristique pellentesque, tellus sem mollis\u000113\u0002false\u0002false\u0002190\u0002Tate\u0002et magnis dis parturient montes,\u000114\u0002false\u0002false\u0002200\u0002Dalton\u0002nec mauris blandit mattis. Cras\u000115\u0002false\u0002false\u0002210\u0002Aquila\u0002erat semper rutrum. Fusce dolor quam, elementum at, egestas a,\u000116\u0002false\u0002false\u0002220\u0002Sonya\u0002Duis a mi fringilla mi\u000117\u0002false\u0002false\u0002230\u0002Noelani\u0002mattis semper, dui lectus rutrum urna, nec luctus felis purus\u000118\u0002false\u0002false\u0002240\u0002Derek\u0002et arcu imperdiet ullamcorper. Duis at\u000119\u0002false\u0002false\u0002250\u0002Richard\u0002diam. Sed diam lorem, auctor quis, tristique ac,\u00011A\u0002false\u0002false\u0002260\u0002Nola\u0002sit amet metus. Aliquam erat\u00011B\u0002false\u0002false\u0002270\u0002Anjolie\u0002Etiam imperdiet dictum magna. Ut tincidunt orci\u00011C\u0002false\u0002false\u0002280\u0002Christian\u0002Morbi vehicula. Pellentesque tincidunt tempus risus. Donec egestas. Duis\u00011D\u0002false\u0002false\u0002290\u0002Zahir\u0002sit amet massa. Quisque porttitor eros nec tellus.\u00011E\u0002false\u0002false\u0002300\u0002Fatima\u0002ac, eleifend vitae, erat. Vivamus nisi. Mauris nulla. Integer urna.";
        return result;
    }

    @Override
    public void setAppxText(String txt) {
        String[] rawRows = txt.split("\u0001");
        String[] header = rawRows[0].split("\u0002");
        this.initTable(Integer.parseInt(header[0]), Integer.parseInt(header[1]));
        if (header.length > 2) {
            this.fillCol = Integer.parseInt(header[2]);
        }
        this.createHeadings = false;
        int i = 0;
        while (i < this.colClass.length) {
            String[] colDef = rawRows[1 + i].split("\u0002");
            if (colDef[3].trim().length() > 0 && !colDef[3].trim().endsWith("_")) {
                this.createHeadings = true;
            }
            try {
                this.addAppxColumn(Integer.parseInt(colDef[0]), Integer.parseInt(colDef[1]), Integer.parseInt(colDef[2]), colDef[3], Class.forName(colDef[4]), Boolean.parseBoolean(colDef[5]));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < this.fieldData.length) {
            String[] rowDef = rawRows[1 + this.colCount + i].split("\u0002");
            Object[] obj = new Object[this.colCount];
            Object[] objSort = new Object[this.colCount];
            String key = rowDef[0];
            boolean sel = Boolean.parseBoolean(rowDef[1]);
            int j = 0;
            while (j < this.colCount) {
                String str;
                int loc;
                String[] cellDef = rowDef[j + 2].split("\u0003");
                if (cellDef[0].length() >= 6 && cellDef[0].substring(0, 5).toLowerCase().startsWith("<html")) {
                    StringReader stringReader = new StringReader(cellDef[0]);
                    HTMLEditorKit htmlKit = new HTMLEditorKit();
                    HTMLDocument htmlDoc = (HTMLDocument)htmlKit.createDefaultDocument();
                    try {
                        htmlKit.read(stringReader, (Document)htmlDoc, 0);
                        obj[j] = this.convertToObj(j, cellDef[0]);
                    }
                    catch (Exception e) {
                        obj[j] = "<html>" + this.convertToObj(j, Jsoup.clean((String)cellDef[0], (Whitelist)Whitelist.relaxed()).toString());
                    }
                    objSort[j] = Jsoup.parse((String)((String)obj[j])).select("body").text();
                } else {
                    obj[j] = this.convertToObj(j, cellDef[0]);
                    objSort[j] = cellDef.length > 1 ? this.convertToObj(j, cellDef[1]) : null;
                }
                if (obj[j] instanceof String && (loc = (str = (String)obj[j]).toLowerCase().indexOf("<title")) > 0) {
                    obj[j] = String.valueOf(str.substring(0, loc + 2)) + str.substring(loc + 3);
                    str = (String)obj[j];
                    loc = str.toLowerCase().indexOf("/title>");
                    if (loc > 0) {
                        obj[j] = String.valueOf(str.substring(0, loc + 2)) + str.substring(loc + 3);
                    }
                }
                ++j;
            }
            this.addAppxRow(sel, key, obj, objSort);
            ++i;
        }
        if (this.table == null) {
            this.buildTable();
        } else {
            if (this.dataModel != null) {
                this.dataModel.fireTableDataChanged();
            }
            this.table.clearSelection();
            int firstSel = -1;
            int i2 = 0;
            while (i2 < this.fieldSel.length) {
                if (this.fieldSel[i2]) {
                    int ii = this.table.convertRowIndexToView(i2);
                    this.table.getSelectionModel().addSelectionInterval(ii, ii);
                    if (firstSel == -1 || firstSel > ii) {
                        firstSel = ii;
                    }
                }
                ++i2;
            }
            if (firstSel >= 0) {
                this.scrollToVisible(this.table, firstSel, 0);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        this.syncHeadings();
        try {
            super.paint(g);
        }
        catch (ClassCastException ex) {
            System.err.println("AppxTable ClassCastException=" + ex);
        }
    }

    public void syncHeadings() {
        JViewport colHead = this.getColumnHeader();
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (colHead != null) {
            Point p = colHead.getViewPosition();
            p.x = ltr ? this.viewport.getViewPosition().x : Math.max(0, this.viewport.getViewPosition().x);
            p.y = 0;
            colHead.setViewPosition(p);
        }
    }

    private Object convertToObj(int col, String val) {
        try {
            if (this.colClass[col] == String.class) {
                return val.replaceAll("\\s+$", "");
            }
            if (this.colClass[col] == Integer.class) {
                return Integer.parseInt(val.trim());
            }
            if (this.colClass[col] == Timestamp.class) {
                return Timestamp.parse(val);
            }
            if (this.colClass[col] == Float.class) {
                return Float.valueOf(Float.parseFloat(val.trim()));
            }
            if (this.colClass[col] == Boolean.class) {
                if (CharView.view.isLogYes((byte)val.charAt(0))) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
        }
        catch (Exception ex) {
            System.err.println("convertToObj() exception=" + ex);
        }
        return val;
    }

    @Override
    public void setMargin(Insets insets) {
    }

    @Override
    public boolean isMovable() {
        return false;
    }

    @Override
    public void setMovable(boolean b) {
    }

    public void setFontSize(int s) {
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), f.getStyle(), s));
    }

    public void setCellSize(int a, int b) {
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
        }
        if (this.enabled && AppxControlUtils.keyPressed(evt, this.parent) && evt.getKeyCode() == 27) {
            this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, Integer.toString(274)));
            evt.consume();
            if (evt.getKeyCode() == 10) {
                if (this.parent.defaultButton != null) {
                    this.parent.defaultButton.doClick();
                } else {
                    this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, "304"));
                }
                evt.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
        }
        if (this.enabled) {
            AppxControlUtils.keyReleased(evt, this.parent);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
        }
        if (this.enabled && AppxControlUtils.keyTyped(evt, this.parent)) {
            this.setTouched(true);
        }
    }

    public void setPcbId(int id) {
        this.pcbId = id;
    }

    public void setHashSig(int sig) {
        this.hashSig = sig;
    }

    public int getPcbId() {
        return this.pcbId;
    }

    public int getHashSig() {
        return this.hashSig;
    }

    public void setDisabledForeground(Color c) {
    }
}

