/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import view.AppxControl;
import view.AppxControlUtils;
import view.AppxScrollerEditor;
import view.AppxScrollerPanel;
import view.CharView;
import view.Display;

public class AppxScroller
extends JPanel
implements AppxControl,
ActionListener,
FocusListener,
KeyListener {
    private static final long serialVersionUID = 6476340095277648349L;
    Rectangle bounds;
    Display parent;
    private boolean touched = false;
    private Rectangle offset = AppxControlUtils.nullOffset;
    private Vector columnnames;
    private Vector vectordata;
    private JTable jtable;
    private JScrollPane jscrollpane;
    private DefaultTableModel tablemodel;
    private boolean movable = false;

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public void focusGained(FocusEvent evt) {
        System.err.println("focusGained=" + evt);
    }

    @Override
    public void focusLost(FocusEvent evt) {
        System.err.println("focusLost=" + evt);
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        return new Point(this.bounds.x * CharView.charWidth - 3, this.bounds.y * CharView.charHeight + 2);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.bounds.width * CharView.charWidth + 6, this.bounds.height * CharView.charHeight);
    }

    public String getText() {
        return null;
    }

    public boolean isFocusTransversable() {
        return true;
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && !evt.isControlDown()) {
            this.parent.getView().bufferAppxEvent(evt);
            evt.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '`') {
            this.parent.getView().bufferAppxEvent(evt);
            evt.consume();
        } else if (this.parent.getView().seqIdx > 0 && evt.getKeyChar() >= '0' && evt.getKeyChar() <= '9') {
            this.parent.getView().bufferAppxEvent(evt);
            evt.consume();
        } else {
            this.parent.getView().clearOptionBuffer();
        }
    }

    public AppxScroller(Display disp, int x, int y, int width, int height) {
        this.parent = disp;
        this.setCellBounds(x, y, width, height);
        this.columnnames = new Vector();
        this.columnnames.addElement(new String("column"));
        this.vectordata = new Vector();
        Vector row = new Vector();
        this.tablemodel = new DefaultTableModel(this.vectordata, this.columnnames);
        this.jtable = new JTable(this.tablemodel);
        this.jtable.setDefaultRenderer(AppxScrollerPanel.class, new AppxScrollerEditor());
        this.jtable.setDefaultRenderer(AppxScrollerPanel.class, new AppxScrollerEditor());
        this.jscrollpane = new JScrollPane(this.jtable);
        this.add(this.jscrollpane);
        this.setOpaque(true);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    public void setText(String s) {
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }
}

