/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import view.AppxControl;
import view.AppxControlItem;
import view.AppxControlUtils;
import view.CharView;
import view.Display;

public class AppxScrollbar
extends JScrollBar
implements AppxControl,
AppxControlItem,
AdjustmentListener {
    private static final long serialVersionUID = 7050746743571225617L;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/AppxScrollbar.java,v 1.1.2.9 2013/10/30 01:16:13 pete Exp $";
    private Display parent;
    private Rectangle bounds;
    private boolean active;
    private String actionCommand;
    private boolean spaceSaverMode;
    private boolean touched = false;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    boolean setTextCalled = false;
    private Color pushedBg;

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public void setOrientation(int i) {
        super.setOrientation(i);
    }

    public void setFontSize(int i) {
    }

    @Override
    public Point getLocation() {
        if (this.parent == null) {
            return new Point(this.bounds.x * CharView.charWidth + (this.bounds.width * CharView.charWidth - super.getPreferredSize().width) + 3, this.bounds.y * CharView.charHeight + 1);
        }
        if (this.getOrientation() == 0) {
            return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + (this.bounds.height * CharView.charHeight - super.getPreferredSize().height) + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + (this.bounds.width * CharView.charWidth - super.getPreferredSize().width) + 8 + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.parent == null) {
            return new Dimension(super.getPreferredSize().width, this.bounds.height * CharView.charHeight - 1 + 2);
        }
        if (this.getOrientation() == 0) {
            return new Dimension(this.bounds.width * CharView.charWidth + this.offset.width, super.getPreferredSize().height);
        }
        return new Dimension(super.getPreferredSize().width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    public AppxScrollbar(Display disp, int len) {
        this.parent = disp;
        this.setCellBounds(0, 0, len, 1);
        this.addAdjustmentListener(this);
        this.setUnitIncrement(1);
    }

    public AppxScrollbar(Display disp, int x, int y, int width, int height) {
        this(disp, width);
        this.setCellBounds(x, y, width, height);
    }

    public AppxScrollbar(int x, int y, int w, int h) {
        super(1);
        this.setValues(3, 4, 0, 10);
        this.bounds = new Rectangle(x, y, w, h);
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public boolean isSpaceSaverMode() {
        if (!Globals.getOptionValueBoolean("dockingScrollbar")) {
            return false;
        }
        return this.spaceSaverMode;
    }

    public void setActive(boolean act) {
        this.active = act;
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        Display parent = this.parent == null ? (Display)this.getParent() : this.parent;
        this.bounds = new Rectangle(x, y, width, height);
        this.setBounds(this.getLocation().x + parent.getInsets().left, this.getLocation().y + parent.getInsets().top, this.getPreferredSize().width, this.getPreferredSize().height);
    }

    public void setSpaceSaverMode(boolean mode) {
        this.spaceSaverMode = mode;
    }

    public AppxScrollbar() {
        this(0, 0, 0, 0);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public int getTabable() {
        return 0;
    }

    public void setCellSize(int width, int height) {
        if (this.bounds != null) {
            this.bounds.width = width;
            this.bounds.height = height;
        }
    }

    @Override
    public void setMaximum(int i) {
        super.setMaximum(i);
    }

    @Override
    public void setMinimum(int i) {
        super.setMinimum(i);
    }

    public void setMajorTickSpacing(int size) {
        this.setVisibleAmount(size);
    }

    public void setMinorTickSpacing(int size) {
        this.setBlockIncrement(size);
    }

    @Override
    public void setTabable(int tab) {
    }

    @Override
    public void setTabable(boolean tab) {
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void setAppxText(String txt) {
        this.setText(txt);
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    @Override
    public void setTouched(boolean t) {
        this.touched = t;
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public boolean isMovable() {
        return false;
    }

    @Override
    public void setMovable(boolean b) {
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public String getAppxValueAdjustedCommand() {
        return this.getActionCommand();
    }

    public void setActionCommand(String cmd) {
        this.actionCommand = cmd;
    }

    public void setAppxValueAdjustedCommand(String cmd) {
        this.setActionCommand(cmd);
    }

    public String getText() {
        return "" + this.getValue();
    }

    public void setText(String str) {
        this.setTextCalled = true;
        if (str == null || str.length() == 0) {
            this.setValue(0);
        } else {
            Float fl = new Float(str);
            int vl = fl.intValue();
            this.setValue(vl);
        }
        this.setTextCalled = false;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (this.setTextCalled) {
            return;
        }
        if (!this.parent.isScreenLocked()) {
            this.setTouched(true);
            if (this.getValueIsAdjusting()) {
                this.parent.getView().setStatusText("" + this.getValue());
            } else {
                this.parent.getView().setStatusText("new value = " + this.getValue());
                if (this.actionCommand != null) {
                    this.removeAdjustmentListener(this);
                    ActionEvent e = new ActionEvent(this, 1001, this.getActionCommand(), 0);
                    this.parent.getView().bufferAppxEvent(e);
                }
            }
        }
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

