/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxResource;
import doc.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import view.CharView;
import view.Display;

public class AppxScrollNav
extends JPanel {
    private static final long serialVersionUID = 73967256171218123L;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/Attic/AppxScrollNav.java,v 1.1.2.8 2007/12/11 19:31:31 pete Exp $";
    private Rectangle bounds;
    private boolean active;
    private boolean spaceSaverMode;

    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        return new Point(this.bounds.x * CharView.charWidth + (this.bounds.width * CharView.charWidth - super.getPreferredSize().width) + 3, this.bounds.y * CharView.charHeight + 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.bounds.height * CharView.charHeight - 1 + 2);
    }

    public AppxScrollNav(int x, int y, int w, int h) {
        this();
        this.bounds = new Rectangle(x, y, w, h);
        this.active = false;
    }

    private JButton genButton(Icon img, int action, boolean lockSize) {
        boolean lock = lockSize;
        JButton btn = new JButton(img, lock){
            private static final long serialVersionUID = -79635865757945709L;
            private boolean lockSz;
            {
                this.lockSz = bl;
            }

            @Override
            public Dimension getPreferredSize() {
                int sizeFactor = 16;
                if (this.lockSz) {
                    return new Dimension(sizeFactor, sizeFactor);
                }
                return new Dimension(sizeFactor, super.getPreferredSize().height);
            }
        };
        btn.setActionCommand("" + action);
        btn.addActionListener(CharView.view);
        btn.setIconTextGap(0);
        btn.setMargin(Globals.zeroInsets);
        return btn;
    }

    public AppxScrollNav() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(3, 1));
        topPanel.add(this.genButton(AppxResource.Gfx.SCROLL_FIRST_ICON.icon(), 320, true));
        topPanel.add(this.genButton(AppxResource.Gfx.SCROLL_PREV_ICON.icon(), 322, true));
        topPanel.add(this.genButton(AppxResource.Gfx.SCROLL_DOWN_ICON.icon(), 325, true));
        JPanel botPanel = new JPanel();
        botPanel.setLayout(new GridLayout(3, 1));
        botPanel.add(this.genButton(AppxResource.Gfx.SCROLL_UP_ICON.icon(), 324, true));
        botPanel.add(this.genButton(AppxResource.Gfx.SCROLL_NEXT_ICON.icon(), 323, true));
        botPanel.add(this.genButton(AppxResource.Gfx.SCROLL_LAST_ICON.icon(), 321, true));
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)botPanel, "South");
        this.add((Component)this.genButton(AppxResource.Gfx.SEARCH_ICON.icon(), 21003, false), "Center");
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public boolean isSpaceSaverMode() {
        if (!Globals.getOptionValueBoolean("dockingScrollbar")) {
            return false;
        }
        return this.spaceSaverMode;
    }

    public void setActive(boolean act) {
        this.active = act;
    }

    public void setCellBounds(int x, int y, int width, int height) {
        Display parent = (Display)this.getParent();
        this.bounds = new Rectangle(x, y, width, height);
        this.setBounds(this.getLocation().x + parent.getInsets().left, this.getLocation().y + parent.getInsets().top, this.getPreferredSize().width, this.getPreferredSize().height);
    }

    public void setSpaceSaverMode(boolean mode) {
        this.spaceSaverMode = mode;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }
}

