/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import view.AppxControl;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.CharView;
import view.Display;

public class AppxRtfArea
extends JScrollPane
implements AppxControl,
AppxControlItem,
FocusListener {
    private static final long serialVersionUID = -865905726632016602L;
    Rectangle bounds;
    Display parent;
    int maxSize;
    JEditorPane text;
    private boolean touched;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    private boolean movable = false;
    private Color pushedBg;

    public void actionPerformed(ActionEvent actionevent) {
    }

    @Override
    public void addScanButton(boolean flag) {
    }

    @Override
    public boolean containsCell(int i, int j) {
        return this.bounds.contains(new Point(i, j));
    }

    @Override
    public void focusGained(FocusEvent e) {
        AppxControlUtils.focusGained(this.parent);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        return new Point(this.bounds.x * CharView.charWidth, this.bounds.y * CharView.charHeight);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.bounds.width * CharView.charWidth + 5, this.bounds.height * CharView.charHeight);
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    public String getText() {
        if (this.text == null) {
            return null;
        }
        return this.text.getText().replace('\n', '\u00b6');
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    public void keyPressed(KeyEvent keyevent) {
    }

    public void keyReleased(KeyEvent keyevent) {
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public AppxRtfArea(Display display, int i, int j, int k, int l) {
        this(display, l, k);
        this.setCellBounds(i, j, k, l);
    }

    public AppxRtfArea(Display display, int i, int j) {
        this.setTouched(false);
        this.offset = AppxControlUtils.nullOffset;
        this.text = new JEditorPane("text/rtf", "");
        this.text.setEditable(false);
        this.setViewportView(this.text);
        this.setViewportBorder(null);
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.parent = display;
        this.maxSize = i * j;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void setAppxText(String s) {
        this.setText(s);
        this.text.setCaretPosition(0);
    }

    @Override
    public void setBackground(Color color) {
        if (this.text != null) {
            this.text.setBackground(color);
            return;
        }
        super.setBackground(color);
    }

    @Override
    public void setCellBounds(int i, int j, int k, int l) {
        this.bounds = new Rectangle(i, j, k, l);
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void setForeground(Color color) {
        if (this.text != null) {
            this.text.setForeground(color);
            return;
        }
        super.setForeground(color);
    }

    public void setMaxLen(int i) {
        this.maxSize = i;
    }

    @Override
    public void setOffset(Rectangle rectangle) {
        this.offset = rectangle;
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    public void setText(String s) {
        if (s != null) {
            if (s.indexOf("://") > 0) {
                try {
                    this.text.setPage(s);
                    return;
                }
                catch (Exception exception) {
                    System.err.println("RTF Exception = " + exception);
                    return;
                }
            }
            this.text.setText(s.replace('\u00b6', '\n'));
        }
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
    }

    public void updateOptions(AppxControl appxcontrol) {
        AppxRtfArea appxrtfarea = (AppxRtfArea)appxcontrol;
        this.setToolTipText(appxrtfarea.getToolTipText());
        this.setBackground(appxrtfarea.getBackground());
        this.setForeground(appxrtfarea.getForeground());
        this.setFont(appxrtfarea.getFont());
        this.setText(appxrtfarea.getText());
        this.setBorder(appxrtfarea.getBorder());
        this.setEnabled(appxrtfarea.isEnabled());
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

