/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxToolkit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JProgressBar;
import view.AppxControl;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.CharView;
import view.Display;

public class AppxProgressBar
extends JProgressBar
implements AppxControl,
AppxControlItem,
FocusListener,
KeyListener {
    private static final long serialVersionUID = -273995604410013596L;
    Rectangle bounds;
    Display parent;
    private boolean touched = false;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    private boolean movable = false;
    private Color pushedBg;

    @Override
    public void addScanButton(boolean scan) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.parent.getView().currentComponent = this;
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.repaint();
        }
        if (!this.parent.isScreenLocked()) {
            this.parent.getView().putCursor(this.getCellBounds().x, this.getCellBounds().y);
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.parent.getView().currentComponent = null;
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.repaint();
        }
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth - 2 + this.offset.x, this.bounds.y * CharView.charHeight + 3 + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Dimension(this.bounds.width * CharView.charWidth + 4 + this.offset.width, this.bounds.height * CharView.charHeight - 2 + this.offset.height);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width, this.bounds.height * CharView.charHeight + 0 + this.offset.height);
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    public String getText() {
        return "" + this.getValue();
    }

    @Override
    public boolean isFocusable() {
        return this.appxControlItemObj.isFocusable(this.isEnabled() ? super.isFocusable() : false);
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        AppxControlUtils.keyPressed(evt, this.parent);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        AppxControlUtils.keyReleased(evt, this.parent);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        AppxControlUtils.keyTyped(evt, this.parent);
    }

    public AppxProgressBar(Display disp, int x, int y, int width, int height) {
        this(disp, width);
        this.setCellBounds(x, y, width, height);
    }

    public AppxProgressBar(Display disp, int len) {
        this.parent = disp;
        this.setCellBounds(0, 0, len, 1);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellLocation(int x, int y) {
        if (this.bounds != null) {
            this.bounds.x = x + this.parent.getCellBounds().x;
            this.bounds.y = y + this.parent.getCellBounds().y;
        }
    }

    public void setCellSize(int width, int height) {
        if (this.bounds != null) {
            this.bounds.width = width;
            this.bounds.height = height;
        }
    }

    public void setFontSize(int s) {
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    public void setText(String str) {
        if (str == null || str.length() == 0) {
            this.setValue(0);
        } else {
            this.setValue(new Float(str).intValue());
        }
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

