/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.msg.MFld;
import doc.AppxToolkit;
import doc.Document;
import doc.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import view.AppxAquaTextFieldBorder;
import view.AppxControl;
import view.AppxControlCache;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.CharView;
import view.Display;
import view.FixedLengthPlainDocument;

public class AppxPassword
extends JPasswordField
implements ActionListener,
ComboBoxEditor,
AppxControl,
AppxControlCache,
AppxControlItem,
FocusListener,
KeyListener,
DocumentListener {
    private static final long serialVersionUID = -1570683780498768685L;
    Rectangle bounds;
    Display parent;
    private boolean touched = false;
    private int maxLen;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private MFld dataModel = null;
    private int focusOffset;
    private int gotFocusCommand = 65535;
    private int lostFocusCommand = 65535;
    private int valueAdjustedCommand = 65535;
    private Timer valueTimer = new Timer(Globals.getOptionValueInteger("valueChangedTimer"), this);
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    private boolean movable = false;
    private Color pushedBg;

    public void setFocusOffset(int i) {
        this.focusOffset = i;
    }

    @Override
    public void replaceSelection(String content) {
        if (Globals.validateEncodedString(content, this.getEncodingType())) {
            super.replaceSelection(content);
        }
    }

    public MFld getFld() {
        return this.dataModel;
    }

    public void setFld(MFld fld) {
        this.dataModel = fld;
    }

    public int getEncodingType() {
        if (this.dataModel == null) {
            return 0;
        }
        return this.dataModel.getEncodingType();
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.valueTimer.stop();
        if (this.gotFocusCommand != 65535 && Document.isLocked()) {
            return;
        }
        AppxControlUtils.focusGained(this.parent);
        this.parent.getView().currentComponent = this;
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.repaint();
        }
        if (!(this.parent.isScreenLocked() || this.parent.getCursorPos().x >= this.getCellBounds().x && this.parent.getCursorPos().x < this.getCellBounds().x + this.getCellBounds().width && this.parent.getCursorPos().y >= this.getCellBounds().y && this.parent.getCursorPos().y < this.getCellBounds().y + this.getCellBounds().height)) {
            this.parent.getView().putCursor(this.getCellBounds().x, this.getCellBounds().y);
        }
        int len = this.getText().length();
        if (this.focusOffset > 0) {
            if (this.focusOffset > len) {
                String tmpStr = this.getAppxText();
                while (len < this.focusOffset) {
                    ++len;
                    tmpStr = String.valueOf(tmpStr) + " ";
                }
                this.setAppxText(tmpStr);
            }
            this.setCaretPosition(this.focusOffset);
            this.focusOffset = 0;
        } else if (Globals.getOptionValueBoolean("autoSelect") && CharView.view.lastOption != 333) {
            this.setCaretPosition(len);
            this.moveCaretPosition(0);
        } else if (CharView.view.lastOption == 333 && CharView.view.lastOffset >= 0 && this.getText().length() > CharView.view.lastOffset) {
            this.setCaretPosition(CharView.view.lastOffset);
        } else {
            this.setSelectionStart(len);
            this.setSelectionEnd(len);
        }
        if (this.gotFocusCommand != 65535 && CharView.view.readyForInput) {
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxPassword.this, 1001, "" + AppxPassword.this.gotFocusCommand, 0);
                    AppxPassword.this.parent.getView().bufferAppxEvent(e);
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.parent.getView().currentComponent = null;
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.repaint();
        }
        this.setSelectionStart(0);
        this.setSelectionEnd(0);
        if (this.lostFocusCommand != 65535 && CharView.view.readyForInput && this.parent.getView().isWindowActive()) {
            this.parent.getView().setLostFocusCommand(this.lostFocusCommand, 65535, this);
        }
    }

    @Override
    public String getAppxText() {
        return new String(this.getPassword());
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getItem() {
        return this.getPassword();
    }

    @Override
    public Point getLocation() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth - 2 + this.offset.x, this.bounds.y * CharView.charHeight + 3 + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Dimension(this.bounds.width * CharView.charWidth + 4 + this.offset.width - 1, this.bounds.height * CharView.charHeight - 2 + this.offset.height - 1);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width, this.bounds.height * CharView.charHeight + 0 + this.offset.height);
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    public void setFontSize(int size) {
    }

    @Override
    public void initControl(Display disp, int x, int y, int w, int h, boolean ucs) {
        this.setDocument(new FixedLengthPlainDocument(w, ucs, this, disp));
        this.getDocument().addDocumentListener(this);
        this.offset = new Rectangle(0, 0, 0, 0);
        this.maxLen = w;
        this.parent = disp;
        this.setCellBounds(x, y, w, h);
        this.setOpaque(true);
        this.setFont(this.parent.getStdFont());
        this.pushedBg = null;
        this.gotFocusCommand = 65535;
        this.lostFocusCommand = 65535;
        this.valueAdjustedCommand = 65535;
        this.valueTimer.stop();
        if (AppxToolkit.isWebLook()) {
            this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        }
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.setBorder(new AppxAquaTextFieldBorder());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public boolean isFocusable() {
        return this.appxControlItemObj.isFocusable(this.isEnabled() ? super.isFocusable() : false);
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (!Globals.getOptionValueBoolean("guiInterface") && evt.getKeyCode() == 39) {
            if (this.getCaretPosition() == this.maxLen) {
                this.parent.getView().putCursor(this.getCellBounds().x + this.getCaretPosition(), this.getCellBounds().y, true);
                evt.consume();
            }
        } else if (!Globals.getOptionValueBoolean("guiInterface") && evt.getKeyCode() == 37) {
            if (this.getCaretPosition() == 0) {
                this.parent.getView().putCursor(this.getCellBounds().x + this.getCaretPosition() - 1, this.getCellBounds().y, true);
                evt.consume();
            }
        } else if (evt.getKeyCode() == 10) {
            JButton jb = this.parent.getView().getDefaultButton();
            if (jb != null) {
                jb.doClick();
            } else {
                this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, "304"));
            }
            evt.consume();
        } else {
            if (!Globals.getOptionValueBoolean("guiInterface")) {
                this.parent.getView().putCursor(this.getCellBounds().x + this.getCaretPosition(), this.getCellBounds().y);
            }
            if (AppxControlUtils.keyPressed(evt, this.parent) && evt.getKeyCode() == 39 && this.getCaretPosition() == this.getPassword().length) {
                this.setSelectionStart(this.getPassword().length);
                this.setSelectionEnd(this.getPassword().length);
                evt.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        AppxControlUtils.keyReleased(evt, this.parent);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        AppxControlUtils.keyTyped(evt, this.parent);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
        this.setCaretPosition(0);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            this.setText(anObject.toString());
        } else {
            this.setText("");
        }
    }

    public void setMaxLen(int len) {
        this.maxLen = len;
        ((FixedLengthPlainDocument)this.getDocument()).setMaxLength(len);
    }

    public void setOffset(int x, int y, int width, int height) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.width = width;
        this.offset.height = height;
    }

    @Override
    public void setOffset(Rectangle rect) {
        if (rect == null) {
            this.setOffset(0, 0, 0, 0);
        } else {
            this.setOffset(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
        if (this.touched && this.valueAdjustedCommand != 65535) {
            this.valueTimer.setDelay(Globals.getOptionValueInteger("valueChangedTimer"));
            this.valueTimer.setInitialDelay(Globals.getOptionValueInteger("valueChangedTimer"));
            this.valueTimer.restart();
        } else {
            this.valueTimer.stop();
        }
    }

    public void setUpperCaseOnly(boolean ucs) {
        ((FixedLengthPlainDocument)this.getDocument()).setUpperCaseOnly(ucs);
    }

    @Override
    public void updateOptions(AppxControlCache options) {
        AppxPassword op = (AppxPassword)options;
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setFont(op.getFont());
        this.setText(new String(op.getPassword()));
        this.setBorder(op.getBorder());
        this.setEnabled(op.isEnabled());
        this.setOpaque(op.isOpaque());
        this.setHorizontalAlignment(op.getHorizontalAlignment());
        this.setMargin(op.getMargin());
        this.setOffset(op.getOffset());
        this.setTouched(op.isTouched());
        this.setMovable(op.isMovable());
    }

    public AppxPassword() {
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (!b && UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.setBackground(UIManager.getColor("Panel.background"));
        }
    }

    public void setGotFocusCommand(int s) {
        this.gotFocusCommand = s;
    }

    public void setGotFocusCommand(String s) {
        this.gotFocusCommand = Integer.parseInt(s);
    }

    public int getGotFocusCommand() {
        return this.gotFocusCommand;
    }

    public void setLostFocusCommand(int s) {
        this.lostFocusCommand = s;
    }

    public void setLostFocusCommand(String s) {
        this.lostFocusCommand = Integer.parseInt(s);
    }

    public int getLostFocusCommand() {
        return this.lostFocusCommand;
    }

    public void setValueAdjustedCommand(int s) {
        this.valueAdjustedCommand = s;
    }

    public void setValueAdjustedCommand(String s) {
        this.valueAdjustedCommand = Integer.parseInt(s);
    }

    public int getValueAdjustedCommand() {
        return this.valueAdjustedCommand;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.valueAdjustedCommand != 65535) {
            CharView.view.lastOffset = this.getCaretPosition();
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxPassword.this, 1001, "" + AppxPassword.this.valueAdjustedCommand, 0);
                    AppxPassword.this.parent.getView().bufferAppxEvent(e);
                }
            });
        }
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

