/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxBorder;
import view.CharView;

public class AppxOval3DBorder
implements AppxBorder,
AppxAntiAliasControl {
    protected int m_w;
    protected int m_h;
    protected Color m_lightInner;
    protected Color m_darkInner;
    protected Color m_lightOuter;
    protected Color m_darkOuter;
    protected int m_type;
    private AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();
    protected boolean debugBorder = false;
    protected Color[] debugColor = new Color[17];

    private void setDebugColors() {
        int hue = 0;
        int i = 0;
        while (i < 17) {
            this.debugColor[i] = new Color(hue, 255 - hue, 127);
            hue += 15;
            ++i;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Test");
        JPanel p = new JPanel(){
            private static final long serialVersionUID = 1505606119165499779L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, 300);
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                AppxOval3DBorder b = new AppxOval3DBorder(0, Color.gray.brighter());
                b.fillBackground(g, 0, 0, 100, 100, Color.red);
            }
        };
        f.getContentPane().add(p);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    private int xlateArc(int arc) {
        return arc * CharView.charHeight / 2 / 100;
    }

    public static int defaultArc() {
        return 100;
    }

    public AppxOval3DBorder(int type, Color color) {
        this(type, color, color.darker());
    }

    public AppxOval3DBorder(int type, Color highlight, Color shadow) {
        this(type, AppxOval3DBorder.defaultArc(), highlight, highlight.brighter(), shadow.darker(), shadow);
    }

    public AppxOval3DBorder(int type, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        this(type, AppxOval3DBorder.defaultArc(), highlightOuter, highlightInner, shadowOuter, shadowInner);
    }

    public AppxOval3DBorder(int type, int radius, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        this(type, radius, radius, highlightOuter, highlightInner, shadowOuter, shadowInner);
    }

    public AppxOval3DBorder(int type, int arcWidth, int arcHeight, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        this.m_type = type;
        this.m_w = arcWidth;
        this.m_h = arcHeight;
        this.m_lightOuter = highlightOuter;
        this.m_lightInner = highlightInner;
        this.m_darkOuter = shadowOuter;
        this.m_darkInner = shadowInner;
        this.setDebugColors();
    }

    public void setArc(int arc) {
        this.setArcWidth(arc);
        this.setArcHeight(arc);
    }

    public void setArc(int arc_w, int arc_h) {
        this.setArcWidth(arc_w);
        this.setArcHeight(arc_h);
    }

    public void setArcHeight(int arc) {
        this.m_h = arc;
    }

    public void setArcWidth(int arc) {
        this.m_w = arc;
    }

    public int getArcWidth() {
        return this.m_w;
    }

    public int getArcHeight() {
        return this.m_h;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        AbstractButton btn;
        ButtonModel model;
        --w;
        --h;
        boolean raised = false;
        if (this.m_type == 0) {
            raised = true;
        }
        if (c instanceof AbstractButton && ((model = (btn = (AbstractButton)c).getModel()).isArmed() && model.isPressed() || model.isSelected())) {
            boolean bl = raised = !raised;
        }
        if (raised) {
            this.drawBorder(g, x, y, w, h, this.m_lightOuter, this.m_lightInner, this.m_darkOuter, this.m_darkInner);
        } else {
            this.drawBorder(g, x, y, w, h, this.m_darkInner, this.m_darkOuter, this.m_lightOuter, this.m_lightInner);
        }
    }

    @Override
    public void fillBackground(Graphics g, int x, int y, int w, int h, Color bg) {
        Graphics2D g2 = (Graphics2D)g;
        this.antiAlias.adjustGraphics(g2);
        int rw = this.xlateArc(this.m_w);
        int rh = this.xlateArc(this.m_h);
        g2.setColor(bg);
        g2.fillRoundRect(x + 1, y + 1, w - 2, h - 2, rw * 2, rh * 2);
        this.antiAlias.restoreGraphics(g2);
    }

    private void drawBorder(Graphics g, int x, int y, int w, int h, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        Graphics2D g2 = (Graphics2D)g;
        this.antiAlias.adjustGraphics(g2);
        int rw = this.xlateArc(this.m_w);
        int rh = this.xlateArc(this.m_h);
        g2.setColor(highlightOuter);
        g2.drawArc(x, y, rw * 2, rh * 2, 90, 90);
        g2.drawArc(x + w - rw * 2, y, rw * 2, rh * 2, 0, 90);
        g2.setColor(shadowOuter);
        g2.drawArc(x + w - rw * 2, y + h - rh * 2, rw * 2, rh * 2, 270, 90);
        g2.drawArc(x, y + h - rh * 2, rw * 2, rh * 2, 180, 90);
        g2.setColor(highlightInner);
        g2.drawArc(x + 1, y + 1, rw * 2 - 3, rh * 2 - 3, 90, 90);
        g2.drawArc(x + w - rw * 2 + 2, y + 1, rw * 2 - 3, rh * 2 - 3, 0, 90);
        g2.setColor(shadowInner);
        g2.drawArc(x + w - rw * 2 + 2, y + h - rh * 2 + 2, rw * 2 - 3, rh * 2 - 3, 270, 90);
        g2.drawArc(x + 1, y + h - rh * 2 + 2, rw * 2 - 3, rh * 2 - 3, 180, 90);
        g2.setColor(highlightOuter);
        g2.drawLine(x + rw, y, x + w - rw, y);
        g2.drawLine(x, y + rh, x, y + h - rh - 1);
        g2.setColor(shadowOuter);
        g2.drawLine(x + rw, y + h, x + w - rw, y + h);
        g2.drawLine(x + w, y + rh + 1, x + w, y + h - rh);
        g2.setColor(highlightInner);
        g2.drawLine(x + rw, y + 1, x + w - rw, y + 1);
        g2.drawLine(x + 1, y + rh, x + 1, y + h - rh);
        g2.setColor(shadowInner);
        g2.drawLine(x + rw, y + h - 1, x + w - rw, y + h - 1);
        g2.drawLine(x + w - 1, y + rh, x + w - 1, y + h - rh);
        this.antiAlias.restoreGraphics(g2);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.xlateArc(this.m_h) / 3, this.xlateArc(this.m_w) / 3, this.xlateArc(this.m_h) / 3, this.xlateArc(this.m_w) / 3);
    }

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }
}

