/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.IOHandler;
import debug.AppxDebug;
import doc.AppxResource;
import doc.AppxToolkit;
import doc.Document;
import doc.Globals;
import doc.LocalPrint;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.zip.ZipException;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import start.Appx;
import sun.misc.BASE64Decoder;
import view.CharView;
import view.UserDialog;

public class AppxMain
implements Runnable {
    private static String startAP = null;
    private static String startDB = null;
    private static String startPR = null;
    private static String startTY = null;
    protected static JApplet applet;
    protected static boolean webstart;
    protected static int cols;
    protected static String host;
    protected static String mode;
    protected static String pass;
    protected static String path;
    protected static int port;
    protected static int reconid;
    protected static Boolean useSSO;
    protected static int rows;
    protected static String user;
    public static AppxMain appxmain;
    public static Hashtable<String, String> params;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/AppxMain.java,v 1.2.2.45 2014/08/14 13:57:40 pete Exp $";
    private Document docmnt;
    private IOHandler io;
    private Thread t;
    private ThreadGroup tGroup;
    private CharView view;

    static {
        cols = 80;
        host = null;
        mode = null;
        pass = null;
        path = null;
        port = 0;
        reconid = 0;
        useSSO = null;
        rows = 21;
        user = null;
        appxmain = null;
    }

    public static String getParameter(String name) {
        return params.get(name);
    }

    public static void putParameter(String name, String value) {
        params.put(name, value);
    }

    public AppxMain() {
        appxmain = this;
        webstart = System.getProperty("jnlpx.home") != null;
    }

    public AppxMain(JApplet app) {
        appxmain = this;
        applet = app;
        webstart = System.getProperty("jnlpx.home") != null;
    }

    public boolean connect(UserDialog ud) {
        if (port == 0) {
            port = 8060;
        }
        this.io = new IOHandler(null, null, 0);
        String retMsg = this.io.connect(host, port, user, pass, startAP, startDB, startTY, startPR, false, ud, reconid);
        this.getStarted();
        AppxToolkit.setLook(Globals.getOptionValueString("guiLook"), this.view);
        if (retMsg != null) {
            if (ud == null) {
                JOptionPane.showMessageDialog(null, "Appx Client: " + retMsg);
                System.exit(0);
            } else {
                ud.updateStat(retMsg);
            }
            this.io = null;
            this.view = null;
            this.docmnt = null;
            return false;
        }
        if (!Globals.getOptionValueBoolean("newTypeaheadCode") && this.t == null) {
            this.t = new Thread(this.tGroup, this, "CommHandler");
            this.t.setPriority(1);
            this.t.start();
        }
        CharView.view.setTitle(Globals.getOptionValueString("windowTitle", true, false));
        if (applet == null) {
            this.view.requestFocus();
            this.view.repaint();
        } else {
            applet.requestFocus();
            applet.repaint();
        }
        if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
            this.io.serverLoop();
        }
        return true;
    }

    public void getStarted() {
        String splash;
        String basemode;
        String tmpFontName;
        rows = Globals.getOptionValueInteger("screenRows");
        cols = Globals.getOptionValueInteger("screenColumns");
        this.docmnt = new Document(cols, rows);
        if (AppxDebug.isLoggingEnabled()) {
            System.err.println("================================================================================");
            System.err.println("Dump of Native OS Installed Fonts");
            System.err.println("================================================================================");
            String[] stringArray = Globals.getFontList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String font = stringArray[n2];
                System.err.println(font);
                ++n2;
            }
        }
        if ((tmpFontName = Globals.getOptionValueString("baseFontName")) != null) {
            if (tmpFontName.equals("fixed")) {
                tmpFontName = LocalPrint.getDefaultInputFontName();
            } else if (tmpFontName.equals("prop")) {
                tmpFontName = LocalPrint.getDefaultInputFontName();
            }
        } else {
            tmpFontName = LocalPrint.getDefaultInputFontName();
        }
        this.view = new CharView(this.docmnt, applet, webstart, Globals.getOptionValueBoolean("embedApplet"), tmpFontName, Globals.getOptionValueString("themeName"), this);
        this.view.setStatusSSL(Globals.getCurrentCertificate());
        if (Globals.isWindowsOS() && Globals.getOptionValueBoolean("ie11fix") == Boolean.TRUE) {
            String xul;
            if (this.view.applet == null && !this.view.webstartEnabled) {
                xul = String.valueOf(Globals.getOptionValueString("clientHome")) + File.separatorChar + "xulrunner";
            } else {
                xul = String.valueOf(Globals.getOptionValueString("userClientRoot")) + File.separatorChar + "xulrunner";
                File xulDir = new File(xul);
                if (!xulDir.exists()) {
                    String xulZip = String.valueOf(Globals.getOptionValueString("userClientRoot")) + File.separatorChar + "xulrunner.zip";
                    AppxToolkit.copyURL(CharView.view.getClass().getResource("/xulrunner.zip"), new File(xulZip));
                    try {
                        AppxToolkit.extractFolder(xulZip, xul);
                    }
                    catch (ZipException e) {
                        System.err.println("xulrunner zip file exception=" + e);
                    }
                    catch (IOException e) {
                        System.err.println("xulrunner zip file I/O exception=" + e);
                    }
                }
            }
            if (new File(String.valueOf(xul) + File.separatorChar + "javaxpcom.jar").exists()) {
                System.err.println("using xulrunner");
                System.setProperty("nativeswing.webbrowser.xulrunner.home", xul);
                System.setProperty("nativeswing.webbrowser.runtime", "xulrunner");
            } else {
                System.err.println("load of xulrunner failed");
            }
        }
        if (this.io == null) {
            this.io = new IOHandler(this.docmnt, this.view, 0);
        } else {
            this.io.setDocument(this.docmnt);
            this.io.setView(this.view);
        }
        if (Globals.getOptionValueBoolean("showDateScans")) {
            System.err.println("Enabling Date Chooser");
            this.docmnt.addForceFeature(16384);
        }
        if (Globals.getOptionValueString("scalingQuality").equals("high")) {
            this.view.setImageScaleQuality(2);
        }
        if ((basemode = Globals.getOptionValueString("baseTilingMode")) != null) {
            this.view.setBaseMode(basemode);
        }
        if ((splash = Globals.getOptionValueString("startupWallpaper")) != null) {
            this.view.setSplash(splash);
        } else {
            this.view.mainBox.setTileImage(AppxResource.Gfx.SPLASH_IMAGE.image(), false);
        }
        String smode = Globals.getOptionValueString("startupWallMode");
        if (smode != null) {
            this.view.setSplashMode(smode);
        }
        this.view.clearTiles();
        int count = 1;
        String tileName = Globals.getOptionValueString("baseWallpaper" + count);
        if (tileName == null) {
            tileName = String.valueOf(this.view.theme) + "tile" + count + ".jpg";
        }
        while (this.view.addTile(tileName)) {
            if ((tileName = Globals.getOptionValueString("baseWallpaper" + ++count)) != null) continue;
            tileName = String.valueOf(this.view.theme) + "tile" + count + ".jpg";
        }
        this.view.setColorStdFg(Globals.getOptionValueString("colorStdFg"));
        this.view.setColorStdBg(Globals.getOptionValueString("colorStdBg"));
        this.view.setColorBoldFg(Globals.getOptionValueString("colorBoldFg"));
        this.view.setColorEditBg(Globals.getOptionValueString("colorEditBg"));
        this.view.setColorFrameFg(Globals.getOptionValueString("colorFrameFg"));
        this.view.setColorFrameBg(Globals.getOptionValueString("colorFrameBg"));
        this.view.setColorButtonFg(Globals.getOptionValueString("colorButtonFg"));
        this.view.setColorButtonBg(Globals.getOptionValueString("colorButtonBg"));
        this.view.setColorWindowBg(Globals.getOptionValueString("colorWindowBg"));
        this.view.setColorAppletBg(Globals.getOptionValueString("colorAppletBg"));
        this.view.setShellCmd(Globals.getOptionValueString("commandShell"));
        this.view.setOptKey(Globals.getOptionValueString("mapOptionKey"));
        this.view.setTabKey(Globals.getOptionValueString("mapTabKey"));
        this.view.setEndKey(Globals.getOptionValueString("mapEndKey"));
        Thread.currentThread();
    }

    public void getStartedFirst(JApplet app) {
        Globals.updateDebugMask();
        applet = app;
        port = Globals.getOptionValueInteger("remotePort");
        host = Globals.getOptionValueString("remoteHost");
        user = Globals.getOptionValueString("remoteUser");
        pass = Globals.getOptionValueString("remotePassword");
        mode = Globals.getOptionValueString("connectMode");
        reconid = Globals.getOptionValueInteger("reconnectId");
        if (pass != null) {
            if (pass.length() > 4 && pass.startsWith("++") && pass.endsWith("++")) {
                String newPass;
                String rawPass = pass.substring(2, pass.length() - 2);
                try {
                    newPass = new String(new BASE64Decoder().decodeBuffer(rawPass));
                }
                catch (IOException e) {
                    newPass = "decodeError";
                    e.printStackTrace();
                }
                pass = newPass;
            }
            Globals.setOptionValue("lastPassword", pass);
        }
        if (Globals.getOptionValueBoolean("useSSO")) {
            user = "none";
            pass = "none";
        }
        path = Globals.getOptionValueString("enginePath");
        if (Globals.getOptionValueString("connectMode").equals("local")) {
            user = path;
            pass = "any";
            host = "invoke";
            port = 8060;
        }
        startAP = Globals.getOptionValueString("runApplication");
        startDB = Globals.getOptionValueString("runDatabase");
        startTY = Globals.getOptionValueString("runProcessType");
        startPR = Globals.getOptionValueString("runProcess");
    }

    public String getStatusText() {
        return this.view != null ? this.view.getStatusText() : new String("");
    }

    @Override
    public void run() {
        Thread.currentThread();
        this.io.serverLoop();
        Globals.save(null);
        this.view.setVisible(false);
        AppxDebug.stopSystemLog();
        if (applet == null) {
            this.view = null;
            System.exit(0);
        } else {
            this.view = null;
            applet.stop();
            Appx.connected = false;
        }
    }

    public void start() {
        if (this.io == null || !this.io.connected()) {
            this.tGroup = Thread.currentThread().getThreadGroup();
            if (user == null || pass == null || mode == null || mode.equalsIgnoreCase("both")) {
                new UserDialog(this, Globals.getOptionValueString("connectMode"));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AppxMain.this.connect(null);
                    }
                });
            }
        }
    }

    public void cleanup() {
        Globals.save(null);
        this.view.setVisible(false);
        AppxDebug.stopSystemLog();
        if (applet == null) {
            this.view = null;
            System.exit(0);
        } else {
            this.view = null;
            applet.stop();
            Appx.connected = false;
        }
    }
}

