/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import view.AppxControl;
import view.AppxControlCache;
import view.CharView;
import view.Display;

public class AppxLine
extends JComponent
implements AppxControl,
AppxControlCache {
    private static final long serialVersionUID = 8009300950938386489L;
    private static final boolean DEBUG_BOUNDS = false;
    private Display parent;
    private Point lineBeg = new Point(0, 0);
    private Point lineEnd = new Point(0, 0);
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private Point point = new Point(0, 0);
    private boolean movable = false;
    private int unitBase = -1;
    private String unitBaseStr = null;
    private float lineWeight = -1.0f;
    private int lineWeightPct = -1;
    private float[] pattern = null;
    private String patternStr = null;
    private int patternOffsetPct = 0;
    private int endcapType = 1;
    private Color lineColor = Color.black;

    @Override
    public void initControl(Display disp, int x, int y, int width, int height, boolean ucs) {
        this.parent = disp;
        this.setOpaque(false);
        this.setCellBounds(x, y, width, height);
        this.setOffset(0, 0, 0, 0);
        this.setUnitBase(null);
        this.setLineWeight(-1);
        this.setStrokePattern(null);
        this.setStrokePatternOffset(0);
        this.setEndcapType(-1);
        this.addMouseListener(CharView.view);
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public void updateOptions(AppxControlCache options) {
        AppxLine op = (AppxLine)options;
        this.setOpaque(op.isOpaque());
        this.setToolTipText(op.getToolTipText());
        this.setOffset(op.getOffset());
        this.setMovable(op.isMovable());
        this.setLineColor(op.getLineColor());
        this.setUnitBase(op.getUnitBaseString());
        this.setLineWeight(op.getLineWeightPercent());
        this.setStrokePattern(op.getStrokePatternPercent());
        this.setStrokePatternOffset(op.getStrokePatternOffsetPercent());
        this.setEndcapType(op.getEndcapType());
    }

    @Override
    public boolean contains(Point p) {
        Point beg = this.getBegPoint();
        Point end = this.getEndPoint();
        if (p.x < Math.min(beg.x, end.x) - this.getInsets().left / 2 || p.x > Math.max(beg.x, end.x) + this.getInsets().right / 2 || p.y < Math.min(beg.y, end.y) - this.getInsets().top / 2 || p.y > Math.max(beg.y, end.y) + this.getInsets().bottom / 2) {
            return false;
        }
        int newX = p.x;
        float slope = (float)(end.y - beg.y) / (float)(end.x - beg.x);
        float b = (float)beg.y - slope * (float)beg.x;
        int newY = (int)(slope * (float)p.x + b);
        Rectangle newRect = new Rectangle(newX - 5, newY - 5, 10, 10);
        if (newRect.contains(p)) {
            return true;
        }
        slope = (float)(end.x - beg.x) / (float)(end.y - beg.y);
        b = (float)beg.x - slope * (float)beg.y;
        float nx = slope * (float)p.y + b;
        newX = (int)nx;
        newY = p.y;
        newRect = new Rectangle(newX - 5, newY - 5, 10, 10);
        return newRect.contains(p);
    }

    public Point getBegPoint() {
        Point loc = this.getLocation();
        this.computeLinePoints(this.lineBeg, null);
        this.lineBeg.x += loc.x + this.parent.getInsets().left;
        this.lineBeg.y += loc.y + this.parent.getInsets().top;
        return this.lineBeg;
    }

    public Point getEndPoint() {
        Point loc = this.getLocation();
        this.computeLinePoints(null, this.lineEnd);
        this.lineEnd.x += loc.x + this.parent.getInsets().left;
        this.lineEnd.y += loc.y + this.parent.getInsets().top;
        return this.lineEnd;
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    public void computeLinePoints(Point beg, Point end) {
        Insets insets = this.getInsets();
        Dimension dim = this.getPreferredSize();
        if (beg != null) {
            int n = this.bounds.width > 0 ? (this.bounds.width == 1 && this.offset.width < 0 ? insets.left - this.offset.width : insets.left) : (beg.x = dim.width - insets.right);
            int n2 = this.bounds.height > 0 ? (this.bounds.height == 1 && this.offset.height < 0 ? insets.top - this.offset.height : insets.top) : (beg.y = dim.height - insets.bottom);
        }
        if (end != null) {
            int n = this.bounds.width > 0 ? (this.bounds.width == 1 && this.offset.width < 0 ? insets.left : dim.width - insets.right) : (end.x = insets.left);
            end.y = this.bounds.height > 0 ? (this.bounds.height == 1 && this.offset.height < 0 ? insets.top : dim.height - insets.bottom) : insets.top;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Point beg = new Point(0, 0);
        Point end = new Point(0, 0);
        this.computeLinePoints(beg, end);
        Line2D.Float ln = new Line2D.Float(beg.x, beg.y, end.x, end.y);
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        BasicStroke bs = this.getStrokePattern() == null ? new BasicStroke(this.getLineWeight(), this.getEndcap(), 2) : new BasicStroke(this.getLineWeight(), this.getEndcap(), 2, 10.0f, this.getStrokePattern(), this.getStrokePatternOffset());
        g2.setRenderingHints(rh);
        g2.setStroke(bs);
        g2.setColor(this.getLineColor());
        g2.draw(ln);
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public void setCellBounds(int x, int y, int w, int h) {
        this.bounds.x = x;
        this.bounds.y = y;
        this.bounds.width = w;
        this.bounds.height = h;
    }

    public void setOffset(int x, int y, int w, int h) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.width = w;
        this.offset.height = h;
    }

    @Override
    public void setOffset(Rectangle rect) {
        this.setOffset(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public boolean containsCell(int x, int y) {
        this.point.x = 0;
        this.point.y = y;
        return this.bounds.contains(this.point);
    }

    @Override
    public Point getLocation() {
        int ox;
        int y;
        Insets insets = this.getInsets();
        int x = this.bounds.width > 0 ? this.bounds.x : this.bounds.x + this.bounds.width + 1;
        int n = y = this.bounds.height > 0 ? this.bounds.y : this.bounds.y + this.bounds.height + 1;
        int n2 = this.bounds.width > 0 ? (this.bounds.width == 1 && this.offset.width < 0 ? this.offset.x + this.offset.width : this.offset.x) : (ox = this.offset.x - this.offset.width);
        int oy = this.bounds.height > 0 ? (this.bounds.height == 1 && this.offset.height < 0 ? this.offset.y + this.offset.height : this.offset.y) : this.offset.y - this.offset.height;
        return new Point(x * CharView.charWidth + ox - insets.left, y * CharView.charHeight + oy - insets.top);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int ow = this.bounds.width == 1 && this.offset.width < 0 ? this.offset.width * -1 : this.offset.width;
        int oh = this.bounds.height == 1 && this.offset.height < 0 ? this.offset.height * -1 : this.offset.height;
        return new Dimension(Math.abs(this.bounds.width) * CharView.charWidth + ow + insets.left + insets.right - CharView.charWidth, Math.abs(this.bounds.height) * CharView.charHeight + oh + insets.top + insets.bottom - CharView.charHeight);
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.getLineWeightWhole() + 1, this.getLineWeightWhole() + 1, this.getLineWeightWhole() + 1, this.getLineWeightWhole() + 1);
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    public void setUnitBase(String s) {
        this.unitBaseStr = s;
        this.unitBase = -1;
    }

    private String getUnitBaseString() {
        return this.unitBaseStr;
    }

    private int getUnitBase() {
        if (this.unitBaseStr == null || this.unitBaseStr.length() == 0) {
            return CharView.charHeight;
        }
        if (this.unitBase < 0) {
            this.unitBase = this.unitBaseStr.equalsIgnoreCase("w") ? CharView.charWidth : (this.unitBaseStr.equalsIgnoreCase("h") ? CharView.charHeight : Integer.parseInt(this.unitBaseStr));
        }
        return this.unitBase < 0 ? 1 : this.unitBase;
    }

    public void setLineWeight(int i) {
        this.lineWeightPct = i;
        this.lineWeight = -1.0f;
    }

    private int getLineWeightPercent() {
        return this.lineWeightPct;
    }

    private int getLineWeightWhole() {
        return (int)this.getLineWeight();
    }

    private int getLineWeightHalfOne() {
        return this.getLineWeightWhole() / 2;
    }

    private int getLineWeightHalfTwo() {
        return this.getLineWeightWhole() - this.getLineWeightHalfOne();
    }

    private float getLineWeight() {
        if (this.lineWeightPct < 0) {
            this.lineWeight = 0.32f * (float)this.getUnitBase();
        }
        if (this.lineWeight < 0.0f) {
            this.lineWeight = (float)this.lineWeightPct / 100.0f * (float)this.getUnitBase();
        }
        if (this.lineWeight < 1.0f) {
            this.lineWeight = 1.0f;
        }
        return this.lineWeight;
    }

    public void setStrokePattern(String s) {
        this.patternStr = s;
        this.pattern = null;
    }

    private String getStrokePatternPercent() {
        return this.patternStr;
    }

    private float[] getStrokePattern() {
        if (this.patternStr == null || this.patternStr.length() == 0) {
            return null;
        }
        if (this.pattern == null) {
            String[] values = this.patternStr.split(",");
            this.pattern = new float[values.length];
            int i = 0;
            while (i < values.length) {
                this.pattern[i] = Float.parseFloat(values[i]) * (float)this.getLineWeightWhole();
                ++i;
            }
        }
        return this.pattern;
    }

    public void setStrokePatternOffset(int i) {
        this.patternOffsetPct = i;
    }

    private int getStrokePatternOffsetPercent() {
        return this.patternOffsetPct;
    }

    private float getStrokePatternOffset() {
        return this.patternOffsetPct * this.getLineWeightWhole();
    }

    public void setEndcapType(int cap) {
        this.endcapType = cap;
    }

    private int getEndcapType() {
        return this.endcapType;
    }

    private int getEndcap() {
        switch (this.endcapType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    public void setLineColor(Color c) {
        this.lineColor = c;
    }

    private Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public void setAppxText(String txt) {
    }

    @Override
    public String getAppxText() {
        return null;
    }

    public void setText(String s) {
    }

    @Override
    public void setTouched(boolean t) {
    }

    @Override
    public boolean isTouched() {
        return false;
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public Border getBorder() {
        return null;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public void setFontSize(int i) {
    }

    @Override
    public void setMargin(Insets i) {
    }

    public void setCellSize(int i1, int i2) {
    }
}

