/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxToolkit;
import doc.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxControl;
import view.AppxControlCache;
import view.AppxControlUtils;
import view.AppxOval3DBorder;
import view.AppxScaledResource;
import view.CharView;
import view.Display;

public class AppxLabel
extends JLabel
implements AppxControl,
AppxControlCache,
AppxScaledResource,
AppxAntiAliasControl {
    private static final long serialVersionUID = 1011117147069001950L;
    private Rectangle bounds;
    private Rectangle offset;
    private Display parent;
    private boolean contentAreaFilled = false;
    private int tilingMode;
    private int imageScale = -1;
    private int scaleType = 1;
    private int mouseListenerCount = 0;
    private AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();
    private static AppxLabelMouseListener alml = new AppxLabelMouseListener();
    private boolean movable = false;

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth - 2 + this.offset.x, this.bounds.y * CharView.charHeight + 3 + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Dimension(this.bounds.width * CharView.charWidth + 4 + this.offset.width, this.bounds.height * CharView.charHeight - 2 + this.offset.height);
        }
        if (this.parent.isImageEditor() && Globals.getOptionValueBoolean("editorForceSize")) {
            Dimension prefSize = super.getPreferredSize();
            Dimension appxSize = new Dimension(this.bounds.width * CharView.charWidth + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
            Dimension realSize = new Dimension(Math.max(prefSize.width, appxSize.width), Math.max(prefSize.height, appxSize.height));
            return realSize;
        }
        return new Dimension(this.bounds.width * CharView.charWidth + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    public int getTilingMode() {
        return this.tilingMode;
    }

    @Override
    public void initControl(Display disp, int x, int y, int width, int height, boolean ucs) {
        this.parent = disp;
        this.setCellBounds(x, y, width, height);
        this.offset = new Rectangle(0, 0, 0, 0);
        this.tilingMode = 0;
        this.imageScale = -1;
        this.scaleType = 1;
        this.setAntiAlias(false);
        this.setMovable(false);
    }

    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean isTouched() {
        return false;
    }

    public AppxLabel(Display disp) {
        this();
        this.parent = disp;
        this.offset = new Rectangle(0, 0, 0, 0);
        this.setFocusable(false);
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellLocation(int x, int y) {
        if (this.bounds != null) {
            this.bounds.x = x + this.parent.getCellBounds().x;
            this.bounds.y = y + this.parent.getCellBounds().y;
        }
    }

    public void setCellSize(int width, int height) {
        if (this.bounds != null) {
            this.bounds.width = width;
            this.bounds.height = height;
        }
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        this.setIcon(icon);
    }

    @Override
    public void setEnabled(boolean b) {
    }

    public void setFontSize(int s) {
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), f.getStyle(), s));
    }

    public void setOffset(int x, int y, int width, int height) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.width = width;
        this.offset.height = height;
    }

    @Override
    public void setOffset(Rectangle rect) {
        if (rect == null) {
            this.setOffset(0, 0, 0, 0);
        } else {
            this.setOffset(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setResizable(boolean b) {
    }

    public void setTilingMode(int tileMode) {
        this.tilingMode = tileMode;
    }

    @Override
    public void setTouched(boolean newTouched) {
    }

    public void setWallpaperImage(Image i) {
        this.setIcon(new ImageIcon(i));
    }

    @Override
    public void updateOptions(AppxControlCache options) {
        AppxLabel op = (AppxLabel)options;
        this.setOpaque(op.isOpaque());
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setFont(op.getFont());
        this.setDisabledIcon(op.getDisabledIcon());
        this.setIcon(op.getIcon());
        this.setText(op.getText());
        this.setBorder(op.getBorder());
        this.setEnabled(op.isEnabled());
        this.setHorizontalAlignment(op.getHorizontalAlignment());
        this.setVerticalAlignment(op.getVerticalAlignment());
        this.setHorizontalTextPosition(op.getHorizontalTextPosition());
        this.setVerticalTextPosition(op.getVerticalTextPosition());
        this.setOffset(op.getOffset());
        this.setMovable(op.isMovable());
    }

    public void updateOptions(AppxControl options) {
        AppxLabel op = (AppxLabel)options;
        this.setOpaque(op.isOpaque());
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setFont(op.getFont());
        this.setDisabledIcon(op.getDisabledIcon());
        this.setIcon(op.getIcon());
        this.setText(op.getText());
        this.setBorder(op.getBorder());
        this.setEnabled(op.isEnabled());
        this.setHorizontalAlignment(op.getHorizontalAlignment());
        this.setVerticalAlignment(op.getVerticalAlignment());
        this.setHorizontalTextPosition(op.getHorizontalTextPosition());
        this.setVerticalTextPosition(op.getVerticalTextPosition());
        this.setOffset(op.getOffset());
        this.setImageScale(op.getImageScale());
        this.setScaleType(op.getScaleType());
        this.setMovable(op.isMovable());
    }

    public AppxLabel() {
        this.addMouseListener(CharView.view);
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public int getImageScale() {
        return this.imageScale;
    }

    @Override
    public int getScaleBaseHeight() {
        if (this.getScaleType() == 1) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm != null) {
                return fm.getAscent() - fm.getDescent();
            }
            return CharView.charHeight;
        }
        return this.getPreferredSize().height;
    }

    @Override
    public int getScaleType() {
        return this.scaleType;
    }

    @Override
    public void setScaleType(int type) {
        this.scaleType = type;
    }

    @Override
    public void setImageScale(int scale) {
        this.imageScale = scale;
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.antiAlias.adjustGraphics((Graphics2D)g);
        AppxControlUtils.paintUiComponent(this, g, this.contentAreaFilled);
        super.paintComponent(g);
        this.antiAlias.restoreGraphics((Graphics2D)g);
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(b);
        if (b instanceof AppxOval3DBorder) {
            this.contentAreaFilled = this.isOpaque();
            super.setOpaque(false);
        }
    }

    public void setContentAreaFilled(boolean filled) {
        if (this.isOpaque() != filled) {
            super.setOpaque(filled);
        }
    }

    @Override
    public void setOpaque(boolean b) {
        super.setOpaque(b);
        this.contentAreaFilled = b;
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        if (b && !this.movable) {
            if (this.mouseListenerCount == 0) {
                this.addMouseListener(alml);
                this.addMouseMotionListener(CharView.view);
                ++this.mouseListenerCount;
            }
        } else if (!b && this.movable && this.mouseListenerCount > 0) {
            this.removeMouseListener(alml);
            this.removeMouseMotionListener(CharView.view);
            --this.mouseListenerCount;
        }
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    public void setDisabledBackground(Color c) {
    }

    public void setDisabledForeground(Color c) {
    }

    public void setActionCommand2(String s) {
    }

    public void setActionCommand(String action) {
    }

    private static class AppxLabelMouseListener
    extends MouseAdapter {
        private AppxLabelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CharView.view.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            CharView.view.mouseReleased(e);
        }
    }
}

