/*
 * Decompiled with CFR 0.152.
 */
package view;

import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorAdapter;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorDirtyStateEvent;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorListener;
import chrriis.dj.nativeswing.swtimpl.components.JFlashPlayer;
import chrriis.dj.nativeswing.swtimpl.components.JHTMLEditor;
import chrriis.dj.nativeswing.swtimpl.components.JSyntaxHighlighter;
import chrriis.dj.nativeswing.swtimpl.components.JVLCPlayer;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.win32.JWMediaPlayer;
import doc.AppxResource;
import doc.Globals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import view.AppxControl;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.CharView;
import view.Display;
import view.HTMLTracker;

public class AppxHtmlControl
extends JPanel
implements AppxControl,
AppxControlItem,
FocusListener,
KeyListener {
    private static final long serialVersionUID = 2686899945799131653L;
    Display parent = null;
    private NSPanelComponent ctrl = null;
    private NSPanelComponent ctrl2 = null;
    private String text = null;
    private String type = null;
    private String editorConfig = null;
    private JPanel editorPanel = null;
    private int editorMode = -1;
    JPanel rightPanel = null;
    private Rectangle bounds;
    private boolean movable = false;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private boolean touched = false;
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    private Color pushedBg;

    private void launchHTMLeditor() {
        final JHTMLEditor popupCtrl = this.createEditorFull();
        JPanel popupCtrlPanel = null;
        JPanel popupBtnPanel = null;
        JButton popupOkButton = null;
        JButton popupCancelButton = null;
        final JDialog popupDialog = new JDialog();
        HTMLTracker popupOkTracker = null;
        HTMLTracker popupCancelTracker = null;
        JPanel popupFooterPanel = null;
        int popH = Globals.getOptionValueInteger("editorHeight");
        int popW = Globals.getOptionValueInteger("editorWidth");
        popupCtrl.setHTMLContent(((JHTMLEditor)this.ctrl).getHTMLContent());
        if (popupCtrlPanel == null) {
            popupCtrlPanel = new JPanel(new BorderLayout());
            popupCtrlPanel.setPreferredSize(new Dimension(popW, popH));
            popupCtrlPanel.add((Component)popupCtrl, "Center");
            popupBtnPanel = new JPanel(new FlowLayout(2));
            popupOkButton = new JButton(AppxResource.Gfx.DIA_OK_ICON.icon());
            popupCancelButton = new JButton(AppxResource.Gfx.DIA_CAN_ICON.icon());
            popupDialog.setModal(false);
            popupOkTracker = new HTMLTracker(popupDialog){

                @Override
                public void actionPerformed(ActionEvent e) {
                    popupDialog.setVisible(false);
                    popupDialog.dispatchEvent(new WindowEvent(popupDialog, 201));
                    ((JHTMLEditor)AppxHtmlControl.this.ctrl).setHTMLContent(popupCtrl.getHTMLContent());
                }
            };
            popupCancelTracker = new HTMLTracker(popupDialog){

                @Override
                public void actionPerformed(ActionEvent e) {
                    popupDialog.setVisible(false);
                    popupDialog.dispatchEvent(new WindowEvent(popupDialog, 201));
                }
            };
            popupOkButton.addActionListener(popupOkTracker);
            popupCancelButton.addActionListener(popupCancelTracker);
            popupBtnPanel.add(popupOkButton);
            popupBtnPanel.add(popupCancelButton);
            popupFooterPanel = new JPanel(new BorderLayout());
            popupFooterPanel.add((Component)popupBtnPanel, "East");
            popupCtrlPanel.add((Component)popupFooterPanel, "South");
            popupDialog.add(popupCtrlPanel);
            popupDialog.pack();
        }
        Rectangle rect = CharView.view.getBounds();
        Point loc = CharView.view.getLocation();
        loc.x += (rect.width - popW) / 2;
        loc.y += (rect.height - popH) / 2;
        if (loc.x < 0) {
            loc.x = 0;
        }
        if (loc.y < 0) {
            loc.y = 0;
        }
        popupDialog.setLocation(loc);
        popupDialog.setVisible(true);
        if (popupOkTracker.isSaved()) {
            boolean ed = this.isEnabled();
            this.editorPanel.remove((Component)this.ctrl);
            this.ctrl = this.createEditor(ed);
            this.ctrl.getNativeComponent().addKeyListener((KeyListener)this);
            this.editorPanel.add((Component)this.ctrl, "Center");
            ((JHTMLEditor)this.ctrl).setHTMLContent(popupCtrl.getHTMLContent());
        }
    }

    public AppxHtmlControl(Display disp, int rows, int cols) {
        super(new BorderLayout());
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.setOpaque(true);
        this.add((Component)this.editorPanel, "Center");
        super.setBorder(BorderFactory.createEmptyBorder());
        super.setOpaque(false);
        this.parent = disp;
    }

    @Override
    public void setOpaque(boolean b) {
        if (this.ctrl == null) {
            return;
        }
        this.ctrl.setOpaque(b);
    }

    @Override
    public void setBackground(Color c) {
        if (this.ctrl == null) {
            return;
        }
        this.ctrl.setBackground(c);
    }

    @Override
    public void setBorder(Border border) {
        if (this.editorPanel == null) {
            return;
        }
        this.editorPanel.setBorder(border);
    }

    @Override
    public Border getBorder() {
        return BorderFactory.createEmptyBorder();
    }

    public AppxHtmlControl(Display disp, int x, int y, int width, int height, String wHtmlViewerType) {
        this(disp, x, y, width, height, wHtmlViewerType, null);
    }

    public AppxHtmlControl(Display disp, int x, int y, int width, int height, String wHtmlViewerType, String config) {
        this(disp, height, width);
        this.type = wHtmlViewerType.toLowerCase();
        this.editorConfig = CharView.view.getEditorConfig(config);
        this.setCellBounds(x, y, width, height);
        this.setEnabled(true);
        if (this.type.contains("autoedit")) {
            this.type = (float)height < Globals.getOptionValueFloat("editorFullMinRows") ? "inline" : "edit";
        }
        this.editorMode = 1;
        if (this.type.contains("code")) {
            this.ctrl = this.createSyntaxHighlighter();
        } else if (this.type.contains("edit")) {
            this.ctrl = this.createEditorFull();
        } else if (this.type.contains("inline")) {
            this.ctrl = this.createEditor(true);
            this.editorMode = 0;
        } else if (this.type.contains("readonly")) {
            this.ctrl = this.createEditor(false);
            this.editorMode = -1;
        } else {
            this.ctrl = this.type.contains("flash") ? this.createFlashPlayer() : (this.type.contains("media") ? this.createMediaPlayer() : (this.type.contains("vlc") ? this.createVLCPlayer() : this.createBrowser()));
        }
        this.ctrl.getNativeComponent().addKeyListener((KeyListener)this);
        this.editorPanel.add((Component)this.ctrl, "Center");
        if (this.ctrl instanceof JHTMLEditor && this.editorMode == 0) {
            JButton jb = new JButton(AppxResource.Gfx.HTMLEDIT_ICON.icon());
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppxHtmlControl.this.launchHTMLeditor();
                }
            });
            jb.setActionCommand("edit");
            jb.setBorder(BorderFactory.createEmptyBorder());
            jb.setMargin(new Insets(0, 0, 0, 0));
            jb.setOpaque(false);
            this.rightPanel = new JPanel(new BorderLayout());
            this.rightPanel.add((Component)jb, "North");
            this.rightPanel.setOpaque(false);
            super.add((Component)this.rightPanel, "East");
        }
        this.setBorder(UIManager.getBorder("TextField.border"));
    }

    @Override
    public void requestFocus() {
        this.ctrl.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        return this.ctrl.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.ctrl.requestFocusInWindow();
    }

    @Override
    public boolean requestDefaultFocus() {
        return this.ctrl.requestDefaultFocus();
    }

    public void runFinalize() {
        try {
            this.finalize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.ctrl.disposeNativePeer();
    }

    private JWebBrowser createBrowser() {
        JWebBrowser jwb = new JWebBrowser(new NSOption[0]){

            public void paintImmediately(int x, int y, int w, int h) {
                if (!AppxHtmlControl.this.parent.isScreenLocked()) {
                    super.paintImmediately(x, y, w, h);
                }
            }
        };
        if (this.type.contains("browse")) {
            jwb.setBarsVisible(true);
        } else {
            jwb.setBarsVisible(false);
        }
        jwb.setMenuBarVisible(false);
        jwb.addWebBrowserListener((WebBrowserListener)new WebBrowserAdapter(){

            public void locationChanging(WebBrowserNavigationEvent e) {
                int c;
                super.locationChanging(e);
                String url = e.getNewResourceLocation();
                int n = c = url.startsWith("about:") ? 6 : 0;
                if (Character.isDigit(url.charAt(c))) {
                    e.consume();
                    CharView.view.accessServer(Integer.parseInt(url.substring(c)));
                }
            }

            public void locationChanged(WebBrowserNavigationEvent evt) {
                super.locationChanged(evt);
                AppxHtmlControl.this.setTouched(true);
            }
        });
        return jwb;
    }

    private JHTMLEditor createEditorFull() {
        JHTMLEditor.HTMLEditorImplementation hei = null;
        NSOption nso = null;
        hei = JHTMLEditor.HTMLEditorImplementation.CKEditor;
        HashMap<String, String> optionMap = new HashMap<String, String>();
        boolean loadConfig = true;
        if (this.editorConfig == null) {
            optionMap.put("skin", "'v2'");
            optionMap.put("toolbar", "[  ['Font','FontSize'],['TextColor','BGColor','Bold','Italic','-','Source'],  ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','-',  'NumberedList','BulletedList','-','Outdent','Indent'],  ['Cut','Copy','Paste','-','Undo','Redo','-','Link','Table','HorizontalRule']]");
        } else {
            this.loadConfigFile(optionMap, this.editorConfig, true);
        }
        nso = JHTMLEditor.CKEditorOptions.setOptions(optionMap);
        JHTMLEditor jhe = new JHTMLEditor(hei, new NSOption[]{nso}){

            public void paintImmediately(int x, int y, int w, int h) {
                if (!AppxHtmlControl.this.parent.isScreenLocked()) {
                    super.paintImmediately(x, y, w, h);
                }
            }
        };
        jhe.addHTMLEditorListener((HTMLEditorListener)new HTMLEditorAdapter(){

            public void notifyDirtyStateChanged(HTMLEditorDirtyStateEvent e) {
                AppxHtmlControl.this.setTouched(true);
            }
        });
        return jhe;
    }

    private JHTMLEditor createEditor(boolean ed) {
        JHTMLEditor.HTMLEditorImplementation hei = null;
        NSOption nso = null;
        hei = JHTMLEditor.HTMLEditorImplementation.CKEditor;
        HashMap<String, String> optionMap = new HashMap<String, String>();
        boolean loadConfig = true;
        if (this.editorConfig == null) {
            optionMap.put("skin", "'v2'");
            optionMap.put("bodyClass", "'zzzz'");
            optionMap.put("resize_enabled", "false");
            optionMap.put("autoParagraph", "false");
            optionMap.put("toolbar", "");
        } else {
            this.loadConfigFile(optionMap, this.editorConfig, ed);
        }
        optionMap.put("removePlugins", "'elementspath,toolbar'");
        if (!ed) {
            optionMap.put("readOnly", "true");
        }
        nso = JHTMLEditor.CKEditorOptions.setOptions(optionMap);
        JHTMLEditor jhe = new JHTMLEditor(hei, new NSOption[]{nso}){

            public void paintImmediately(int x, int y, int w, int h) {
                if (!AppxHtmlControl.this.parent.isScreenLocked()) {
                    super.paintImmediately(x, y, w, h);
                }
            }
        };
        jhe.addHTMLEditorListener((HTMLEditorListener)new HTMLEditorAdapter(){

            public void notifyDirtyStateChanged(HTMLEditorDirtyStateEvent e) {
                AppxHtmlControl.this.setTouched(true);
            }
        });
        return jhe;
    }

    public void setEnabledX(boolean e) {
        if (this.ctrl instanceof JHTMLEditor) {
            JHTMLEditor jHTMLEditor = (JHTMLEditor)this.ctrl;
        }
    }

    public void setEditorConfig(String config) {
    }

    private boolean loadConfigFile(Map<String, String> map, String path, boolean ed) {
        BufferedReader br;
        if (path == null) {
            return false;
        }
        try {
            br = new BufferedReader(new FileReader(path));
        }
        catch (Exception e) {
            return false;
        }
        String keyword = "";
        String value = "";
        int colon = 0;
        char lastChar = '\u0000';
        boolean comment = false;
        String line = null;
        do {
            try {
                line = br.readLine();
                if (line == null || line.length() < 1) continue;
                line = line.trim();
                System.err.println(line);
                if (!comment && line.matches(".*[/][*].*")) {
                    if (line.matches(".*[*][/].*")) continue;
                    comment = true;
                    continue;
                }
                if (comment && line.matches(".*[*][/].*")) {
                    comment = false;
                    continue;
                }
                if (comment || (lastChar = line.charAt(line.length() - 1)) != ':' && lastChar != ',' && lastChar != '+') continue;
                line = line.substring(0, line.length() - 1).trim();
                if (keyword.length() == 0) {
                    colon = line.indexOf(":");
                    if (colon < 0) {
                        if (lastChar != ':') continue;
                        keyword = line;
                        continue;
                    }
                    keyword = line.substring(0, colon).trim();
                    line = line.substring(colon + 1).trim();
                }
                value = String.valueOf(value) + line;
                if (lastChar != ',') continue;
                if (value.toLowerCase().indexOf("$(") >= 0) {
                    value = Globals.expandAppxString(value, true);
                    File junkfile = new File(value.replace("'", "").replace("\"", ""));
                    String junkpath = WebServer.getDefaultWebServer().getResourcePathURL(junkfile.getParent().replace('\\', '/'), junkfile.getName());
                    value = "'" + junkpath.replace("%2F", "/").replace("%3A", ":") + "'";
                }
                if (keyword.toLowerCase().contains("toolbar") && !ed) {
                    value = "";
                }
                System.err.println("keyword=[" + keyword + "], value=[" + value + "]");
                map.put(keyword, value);
                keyword = "";
                value = "";
            }
            catch (Exception e) {
                line = null;
            }
        } while (line != null);
        if (keyword.length() > 0) {
            if (keyword.equalsIgnoreCase("toolbar") && !ed) {
                value = "";
            }
            map.put(keyword, value);
        }
        return true;
    }

    private JFlashPlayer createFlashPlayer() {
        return new JFlashPlayer(new NSOption[0]){

            public void paintImmediately(int x, int y, int w, int h) {
                if (!AppxHtmlControl.this.parent.isScreenLocked()) {
                    super.paintImmediately(x, y, w, h);
                }
            }
        };
    }

    private JWMediaPlayer createMediaPlayer() {
        JWMediaPlayer jmp = new JWMediaPlayer(new NSOption[0]){

            public void paintImmediately(int x, int y, int w, int h) {
                if (!AppxHtmlControl.this.parent.isScreenLocked()) {
                    super.paintImmediately(x, y, w, h);
                }
            }
        };
        jmp.setControlBarVisible(true);
        return jmp;
    }

    private JSyntaxHighlighter createSyntaxHighlighter() {
        return new JSyntaxHighlighter(new NSOption[0]){

            public void paintImmediately(int x, int y, int w, int h) {
                if (!AppxHtmlControl.this.parent.isScreenLocked()) {
                    super.paintImmediately(x, y, w, h);
                }
            }
        };
    }

    private JVLCPlayer createVLCPlayer() {
        JVLCPlayer jvp = new JVLCPlayer(new NSOption[0]){

            public void paintImmediately(int x, int y, int w, int h) {
                if (!AppxHtmlControl.this.parent.isScreenLocked()) {
                    super.paintImmediately(x, y, w, h);
                }
            }
        };
        jvp.setControlBarVisible(true);
        return jvp;
    }

    @Override
    public Point getLocation() {
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.ctrl != null && this.ctrl instanceof JHTMLEditor && this.rightPanel != null) {
            return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width + this.rightPanel.getPreferredSize().width, this.bounds.height * CharView.charHeight + this.offset.height);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    public String getText() {
        if (this.ctrl instanceof JWebBrowser) {
            this.text = ((JWebBrowser)this.ctrl).getResourceLocation();
            if (this.text == null || this.text.equals("about:blank") || !this.type.contains("browse")) {
                this.text = ((JWebBrowser)this.ctrl).getHTMLContent();
            }
        } else if (this.ctrl instanceof JHTMLEditor) {
            this.text = ((JHTMLEditor)this.ctrl).getHTMLContent();
        }
        return this.text;
    }

    public boolean isEnabledX() {
        return true;
    }

    @Override
    public boolean isFocusable() {
        return this.isEnabled();
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    public void setCellSize(int w, int h) {
        this.bounds.width = w;
        this.bounds.height = h;
    }

    public void setFontSize(int s) {
    }

    public void setText(String txt) {
        this.text = txt;
        if (txt != null) {
            try {
                if (this.ctrl instanceof JWebBrowser && (txt.startsWith("http://") || txt.startsWith("file://"))) {
                    ((JWebBrowser)this.ctrl).navigate(txt);
                } else if (this.ctrl instanceof JFlashPlayer) {
                    ((JFlashPlayer)this.ctrl).load(txt);
                } else if (this.ctrl instanceof JWMediaPlayer) {
                    ((JWMediaPlayer)this.ctrl).load(txt);
                } else if (this.ctrl instanceof JSyntaxHighlighter) {
                    JSyntaxHighlighter.ContentLanguage cl = JSyntaxHighlighter.ContentLanguage.Java;
                    if (this.type.contains("cpp")) {
                        cl = JSyntaxHighlighter.ContentLanguage.Cpp;
                    } else if (this.type.contains("csharp")) {
                        cl = JSyntaxHighlighter.ContentLanguage.CSharp;
                    } else if (this.type.contains("css")) {
                        cl = JSyntaxHighlighter.ContentLanguage.CSS;
                    } else if (this.type.contains("delphi")) {
                        cl = JSyntaxHighlighter.ContentLanguage.Delphi;
                    } else if (this.type.contains("htm")) {
                        cl = JSyntaxHighlighter.ContentLanguage.HTML;
                    } else if (this.type.contains("javascript") || this.type.contains("js")) {
                        cl = JSyntaxHighlighter.ContentLanguage.Javascript;
                    } else if (this.type.contains("php")) {
                        cl = JSyntaxHighlighter.ContentLanguage.PHP;
                    } else if (this.type.contains("python") || this.type.contains("py")) {
                        cl = JSyntaxHighlighter.ContentLanguage.Python;
                    } else if (this.type.contains("ruby")) {
                        cl = JSyntaxHighlighter.ContentLanguage.Ruby;
                    } else if (this.type.contains("sql")) {
                        cl = JSyntaxHighlighter.ContentLanguage.SQL;
                    } else if (this.type.contains("vb")) {
                        cl = JSyntaxHighlighter.ContentLanguage.VB;
                    } else if (this.type.contains("xml")) {
                        cl = JSyntaxHighlighter.ContentLanguage.XML;
                    }
                    ((JSyntaxHighlighter)this.ctrl).setContent(txt, cl);
                } else if (this.ctrl instanceof JVLCPlayer) {
                    ((JVLCPlayer)this.ctrl).load(txt);
                } else if (this.ctrl instanceof JWebBrowser) {
                    ((JWebBrowser)this.ctrl).setHTMLContent(txt);
                } else if (this.ctrl instanceof JHTMLEditor) {
                    ((JHTMLEditor)this.ctrl).setHTMLContent(txt);
                }
            }
            catch (Exception e) {
                System.err.println("HTML Exception = " + e);
            }
        }
    }

    public void updateOptions(AppxControl ac) {
        AppxHtmlControl ahc = (AppxHtmlControl)ac;
        this.setBackground(ahc.getBackground());
        this.setBorder(ahc.getBorder());
        this.setEnabled(ahc.isEnabled());
        this.setFont(ahc.getFont());
        this.setForeground(ahc.getForeground());
        this.setText(ahc.getText());
        this.setToolTipText(ahc.getToolTipText());
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void setAppxText(String txt) {
        this.setText(txt);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.ctrl.requestFocus();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        AppxControlUtils.keyPressed(e, this.parent);
        if (CharView.view.seqIdx > 0) {
            e.consume();
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        AppxControlUtils.keyReleased(e, this.parent);
        if (CharView.view.seqIdx > 0) {
            e.consume();
            return;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        AppxControlUtils.keyTyped(e, this.parent);
        if (CharView.view.seqIdx > 0) {
            e.consume();
            return;
        }
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

