/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.Globals;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxControl;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.CharView;
import view.Display;

public class AppxHtmlArea
extends JScrollPane
implements AppxControl,
AppxControlItem,
FocusListener,
AppxAntiAliasControl,
KeyListener {
    private static final long serialVersionUID = -2192216651117625497L;
    private Rectangle bounds;
    Display parent;
    private JEditorPane text;
    private boolean touched = false;
    private static Hashtable<String, Object> imageCache;
    protected AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    private boolean movable = false;
    private Color pushedBg;

    public void actionPerformed(ActionEvent evt) {
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    public JEditorPane getEditorPane() {
        return this.text;
    }

    @Override
    public void focusGained(FocusEvent e) {
        AppxControlUtils.focusGained(this.parent);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    public void setActionCommand2(String s) {
    }

    public String getText() {
        if (this.text == null) {
            return null;
        }
        if (this.parent.getView().checkForFeature(0x200000)) {
            return this.text.getText();
        }
        return this.text.getText().replace('\n', '\u00b6');
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        AppxControlUtils.keyPressed(evt, this.parent);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        AppxControlUtils.keyReleased(evt, this.parent);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        AppxControlUtils.keyTyped(evt, this.parent);
    }

    public AppxHtmlArea(Display disp, int x, int y, int width, int height) {
        this(disp, height, width);
        this.setCellBounds(x, y, width, height);
    }

    public AppxHtmlArea(Display disp, int rows, int cols) {
        this.text = new JEditorPane("text/html", ""){
            private static final long serialVersionUID = -1557700225276842340L;

            @Override
            public void paintComponent(Graphics g) {
                AppxHtmlArea.this.antiAlias.adjustGraphics((Graphics2D)g);
                super.paintComponent(g);
                AppxHtmlArea.this.antiAlias.restoreGraphics((Graphics2D)g);
            }

            @Override
            public void paintImmediately(int x, int y, int w, int h) {
                if (!AppxHtmlArea.this.parent.isScreenLocked()) {
                    super.paintImmediately(x, y, w, h);
                }
            }
        };
        if (Globals.getOptionValueBoolean("cacheHtmlImages")) {
            HTMLDocument doc = (HTMLDocument)this.text.getDocument();
            if (imageCache == null) {
                imageCache = new Hashtable<String, Object>(){
                    private static final long serialVersionUID = -7223551054102034273L;

                    @Override
                    public synchronized Object get(Object key) {
                        String urlString = key.toString();
                        Image newImage = (Image)super.get(urlString);
                        if (newImage == null) {
                            newImage = Toolkit.getDefaultToolkit().createImage((URL)key);
                            if (newImage != null) {
                                ImageIcon ii = new ImageIcon();
                                ii.setImage(newImage);
                            }
                            this.put(urlString, newImage);
                            return newImage;
                        }
                        return newImage;
                    }
                };
            }
            doc.putProperty("imageCache", imageCache);
        }
        this.text.setBorder(null);
        this.text.setEditable(false);
        this.setViewportView(this.text);
        this.setViewportBorder(null);
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.parent = disp;
        this.text.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AppxHtmlArea.this.parent.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.text.setCursor(new Cursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AppxHtmlArea.this.parent.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.addMouseMotionListener(CharView.view);
        this.text.addKeyListener(this);
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
        this.text.setCaretPosition(0);
    }

    @Override
    public void setBackground(Color color) {
        if (this.text != null) {
            this.text.setBackground(color);
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellSize(int w, int h) {
        this.bounds.width = w;
        this.bounds.height = h;
    }

    @Override
    public void setFont(Font f) {
    }

    public void setFontSize(int s) {
    }

    @Override
    public void setForeground(Color color) {
        if (this.text != null) {
            this.text.setForeground(color);
        } else {
            super.setForeground(color);
        }
    }

    public void setMaxLen(int max) {
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    public void setText(String txt) {
        if (txt != null) {
            if (txt.startsWith("http://") || txt.startsWith("file://")) {
                try {
                    this.text.setPage(txt);
                }
                catch (Exception e) {
                    System.err.println("HTML Exception = " + e);
                }
            } else if (this.parent.getView().checkForFeature(0x200000)) {
                this.text.setText(txt);
            } else {
                this.text.setText(txt.replace('\u00b6', '\n'));
            }
        }
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
    }

    public void updateOptions(AppxControl options) {
        AppxHtmlArea op = (AppxHtmlArea)options;
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setFont(op.getFont());
        this.setText(op.getText());
        this.setBorder(op.getBorder());
        this.setEnabled(op.isEnabled());
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

